/*****************************************************************************
 * Copyright (c) 2019, 2023 CEA LIST and others.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *  Vincent Lorenzo (CEA LIST) vincent.lorenzo@cea.fr - Initial API and implementation
 *  Vincent Lorenzo (CEA LIST) vincent.lorenzo@cea.fr - Bug 568480
 *****************************************************************************/

package org.eclipse.papyrus.model2doc.emf.template2structure.internal.generator;

import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.model2doc.emf.documentstructure.TextDocument;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.DocumentTemplate;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.TextDocumentTemplate;
import org.eclipse.papyrus.model2doc.emf.template2structure.generator.AbstractDocumentStructureGenerator;
import org.eclipse.papyrus.model2doc.emf.template2structure.generator.ITemplate2StructureGenerator;

/**
 * The default {@link TextDocument} generator for a {@link TextDocumentTemplate}
 */
public class DefaultTextDocumentStructureGenerator extends AbstractDocumentStructureGenerator implements ITemplate2StructureGenerator {

	/**
	 * The generator ID
	 */
	private static final String GENERATOR_ID = "TextDocumentStructureGenerator.default"; //$NON-NLS-1$

	/**
	 *
	 * Constructor.
	 *
	 */
	public DefaultTextDocumentStructureGenerator() {
		super();
	}

	/**
	 * @see org.eclipse.papyrus.model2doc.emf.template2structure.generator.ITemplate2StructureGenerator#handles(org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.DocumentTemplate)
	 *
	 * @param docTemplate
	 * @return
	 */
	@Override
	public boolean handles(final DocumentTemplate docTemplate) {
		// we must not check the generator id in this method.
		// We just need to check the type of TextDocumentTemplate
		return docTemplate instanceof TextDocumentTemplate;
	}

	/**
	 * @see org.eclipse.papyrus.model2doc.emf.template2structure.generator.ITemplate2StructureGenerator#getGeneratorId()
	 *
	 * @return
	 */
	@Override
	public String getGeneratorId() {
		return GENERATOR_ID;
	}

	/**
	 * @see org.eclipse.papyrus.model2doc.emf.template2structure.generator.ITemplate2StructureGenerator#getDescription()
	 *
	 * @return
	 */
	@Override
	public String getDescription() {
		return NLS.bind("This generator converts a {0} into a {1} from the current user model.", TextDocumentTemplate.class.getName(), TextDocument.class.getName()); //$NON-NLS-1$
	}

	/**
	 * @see org.eclipse.papyrus.model2doc.emf.template2structure.generator.ITemplate2StructureGenerator#getLabel()
	 *
	 * @return
	 */
	@Override
	public String getEditorLabel() {
		return "Text Structure - Default Generator"; //$NON-NLS-1$
	}

}
