/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.odt.internal.util;

import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextField;
import com.sun.star.text.XTextRange;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import org.eclipse.papyrus.model2doc.odt.Activator;
import org.eclipse.papyrus.model2doc.odt.internal.editor.ODTEditor;

public class PageNumberUtils {
    public static final String TEXTFIELD_PAGE_NUMBER = "com.sun.star.text.textfield.PageNumber";
    public static final String TEXTFIELD_PAGE_COUNT = "com.sun.star.text.textfield.PageCount";
    public static final String NUMBERING_TYPE = "NumberingType";

    private PageNumberUtils() {
    }

    public static final void addPageNumberOnTotalPages(XTextCursor xTextCursor, ODTEditor odtEditor) {
        PageNumberUtils.addPageNumberOnTotalPages(xTextCursor, odtEditor, "page: ");
    }

    public static final void addPageNumberOnTotalPages(XTextCursor xTextCursor, ODTEditor odtEditor, String pageFieldLabel) {
        XMultiServiceFactory xMultiServiceFactory = odtEditor.getXMultiServiceFactory();
        try {
            Object textFieldPageNumber = xMultiServiceFactory.createInstance(TEXTFIELD_PAGE_NUMBER);
            XTextField f = (XTextField)UnoRuntime.queryInterface(XTextField.class, (Object)textFieldPageNumber);
            XPropertySet textFieldSetExpressionPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)f);
            textFieldSetExpressionPropertySet.setPropertyValue(NUMBERING_TYPE, (Object)4);
            if (pageFieldLabel != null) {
                xTextCursor.getText().insertString((XTextRange)xTextCursor, pageFieldLabel, false);
            }
            xTextCursor.getText().insertTextContent((XTextRange)xTextCursor, (XTextContent)f, false);
            Object textFieldPageCount = xMultiServiceFactory.createInstance(TEXTFIELD_PAGE_COUNT);
            XTextField pageCount = (XTextField)UnoRuntime.queryInterface(XTextField.class, (Object)textFieldPageCount);
            XPropertySet pageCountExpressionPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)pageCount);
            pageCountExpressionPropertySet.setPropertyValue(NUMBERING_TYPE, (Object)4);
            xTextCursor.getText().insertString((XTextRange)xTextCursor, "/", false);
            xTextCursor.getText().insertTextContent((XTextRange)xTextCursor, (XTextContent)pageCount, false);
        }
        catch (PropertyVetoException | UnknownPropertyException | IllegalArgumentException | WrappedTargetException e) {
            Activator.log.error(e);
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
    }
}

