/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.core.ant;

import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Java;
import org.eclipse.emf.mwe.core.WorkflowRunner;
import org.eclipse.emf.mwe.internal.core.ant.Parameter;

public class WorkflowAntTask
extends Java {
    private String file;
    private final List<Parameter> params = new ArrayList<Parameter>();

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public void execute() throws BuildException {
        this.log("Adding param: " + this.getFile());
        super.createArg().setValue(this.getFile());
        for (Parameter param : this.params) {
            if (param == null) continue;
            String paramString = param.getName() + "=" + param.getValue();
            super.createArg().setValue("-p");
            super.createArg().setValue(paramString);
            this.log("Adding param: -p " + paramString);
        }
        this.log("Adding param: --ant");
        super.createArg().setValue("--ant");
        super.setFailonerror(true);
        super.setClassname(WorkflowRunner.class.getName());
        try {
            super.execute();
        }
        catch (BuildException ex) {
            if (ex.getCause() != null) {
                ex.getCause().printStackTrace();
            }
            String message = "workflow failed: " + String.valueOf(ex.getMessage());
            if (ex.getCause() != null) {
                message = message + " cause: " + String.valueOf(ex.getCause().getMessage());
            }
            throw new BuildException(message, (Throwable)ex);
        }
    }

    public Object createParam() {
        Parameter param = new Parameter();
        this.params.add(param);
        return param;
    }
}

