/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.m2m.internal.qvt.oml.QvtMessage;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalParserUtil;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.compiler.BlackboxUnitResolver;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompilerOptions;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QVTEvaluationOptions;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtModule;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.TransformationUtil;
import org.eclipse.m2m.internal.qvt.oml.runtime.resource.QvtCompilationErrorException;
import org.eclipse.m2m.internal.qvt.oml.runtime.resource.UnparsingQVTOVisitor;
import org.eclipse.m2m.internal.qvt.oml.runtime.util.Messages;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QvtOperationalResourceImpl
extends XMIResourceImpl {
    public QvtOperationalResourceImpl(URI uri) {
        super(uri);
    }

    public void load(Map<?, ?> options) throws IOException {
        if (!this.isLoaded()) {
            this.isLoading = true;
            if (this.errors != null) {
                this.errors.clear();
            }
            if (this.warnings != null) {
                this.warnings.clear();
            }
            try {
                try {
                    URI normalizedUri = this.getURIConverter().normalize(this.getURI());
                    EPackage.Registry packageRegistry = this.getResourceSet() != null ? this.getResourceSet().getPackageRegistry() : EPackage.Registry.INSTANCE;
                    QvtModule qvtModule = TransformationUtil.getQvtModule(normalizedUri, packageRegistry);
                    QvtCompilerOptions qvtOptions = new QvtCompilerOptions();
                    qvtOptions.setModuleWithErrorAllowed(true);
                    qvtModule.setQvtCompilerOptions(qvtOptions);
                    CompiledUnit unit = qvtModule.getUnit();
                    this.fillCompilationDiagnostic(unit, normalizedUri);
                    if (unit.getModules().isEmpty()) {
                        throw new IOException(NLS.bind((String)Messages.QvtResource_moduleCompilationErrors, (Object)normalizedUri, (Object)unit.getProblems()));
                    }
                    this.getContents().addAll((Collection)unit.getModules());
                    if (this.getResourceSet() != null) {
                        HashSet allUnits = new HashSet();
                        QvtOperationalParserUtil.collectAllImports((CompiledUnit)unit, allUnits);
                        for (CompiledUnit nextUnit : allUnits) {
                            Resource resource;
                            URI nextUri = nextUnit.getURI();
                            if (BlackboxUnitResolver.isBlackboxUnitURI((URI)nextUri) || (resource = this.getResourceSet().getResource(nextUri, false)) != null) continue;
                            this.getResourceSet().getResources().add((Object)QvtOperationalResourceImpl.confineInResource(nextUnit));
                        }
                    }
                }
                catch (MdaException e) {
                    throw new Resource.IOWrappedException((Exception)((Object)e));
                }
            }
            finally {
                this.isLoading = false;
                Notification notification = this.setLoaded(true);
                if (notification != null) {
                    this.eNotify(notification);
                }
                this.setModified(false);
            }
        }
    }

    private static Resource confineInResource(CompiledUnit unit) {
        QvtOperationalResourceImpl rs = new QvtOperationalResourceImpl(unit.getURI());
        rs.getContents().addAll((Collection)unit.getModules());
        rs.fillCompilationDiagnostic(unit, unit.getURI());
        rs.setLoaded(true);
        rs.setModified(false);
        return rs;
    }

    private void fillCompilationDiagnostic(CompiledUnit unit, URI uri) {
        this.warnings = this.getWarnings();
        for (QvtMessage msg : unit.getWarnings()) {
            this.warnings.add((Object)new Diagnostic(msg.getMessage(), uri.toString(), msg.getLineNum()));
        }
        for (QvtMessage msg : unit.getErrors()) {
            this.warnings.add((Object)new QvtCompilationErrorException(msg, uri.toString(), msg.getLineNum()));
        }
    }

    public void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void doLoad(InputSource inputSource, Map<?, ?> options) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void doLoad(Node node, Map<?, ?> options) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void save(Map<?, ?> options) throws IOException {
        if (!this.isUnparseEnabled(options)) {
            return;
        }
        super.save(options);
    }

    public void doSave(OutputStream outputStream, Map<?, ?> options) throws IOException {
        this.doSave(new OutputStreamWriter(outputStream), options);
    }

    public void doSave(Writer writer, Map<?, ?> options) throws IOException {
        UnparsingQVTOVisitor unparsingVisitor = new UnparsingQVTOVisitor();
        EList contents = this.getContents();
        BasicEList modules = new BasicEList();
        for (EObject eObject : contents) {
            Module module = (Module)eObject;
            modules.add((Object)module);
        }
        unparsingVisitor.unparseModules((EList<Module>)modules);
        for (String string : unparsingVisitor.getLines()) {
            if (string == null) continue;
            writer.write(string);
            writer.write(System.getProperty("line.separator"));
        }
        writer.flush();
    }

    public boolean isModified() {
        return false;
    }

    public boolean isTrackingModification() {
        return false;
    }

    private boolean isUnparseEnabled(Map<?, ?> options) {
        return options.get(QVTEvaluationOptions.FLAG_QVTO_UNPARSE_ENABLED) != Boolean.FALSE;
    }

    private static class Diagnostic
    implements Resource.Diagnostic {
        private final String myMessage;
        private final String myLocation;
        private final int myLine;

        Diagnostic(String message, String location, int line) {
            this.myMessage = message;
            this.myLocation = location;
            this.myLine = line;
        }

        public String getMessage() {
            return this.myMessage;
        }

        public String getLocation() {
            return this.myLocation;
        }

        public int getColumn() {
            return 0;
        }

        public int getLine() {
            return this.myLine;
        }
    }
}

