/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.m2m.internal.qvt.oml.compiler.BlackboxUnitResolver;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.Activator;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.QvtEditor;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks.AbstractHyperlink;
import org.eclipse.m2m.internal.qvt.oml.emf.util.URIUtils;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class QvtFileHyperlink
extends AbstractHyperlink {
    private final URI myDestinationURI;
    private final IRegion myDestinationRevealRegion;
    private final IRegion myDestinationSelectRegion;
    private final String myDestinationElement;

    public QvtFileHyperlink(IRegion hyperlinkRegion, URI destinationURI, IRegion destinationRevealRegion, IRegion destinationSelectRegion) {
        super(hyperlinkRegion);
        if (destinationURI == null) {
            throw new IllegalArgumentException();
        }
        this.myDestinationURI = destinationURI;
        this.myDestinationRevealRegion = destinationRevealRegion;
        this.myDestinationSelectRegion = destinationSelectRegion;
        this.myDestinationElement = null;
    }

    public QvtFileHyperlink(IRegion hyperlinkRegion, URI destinationURI, String destinationElement) {
        super(hyperlinkRegion);
        if (destinationURI == null) {
            throw new IllegalArgumentException();
        }
        this.myDestinationURI = destinationURI;
        this.myDestinationRevealRegion = null;
        this.myDestinationSelectRegion = null;
        this.myDestinationElement = destinationElement;
    }

    public void open() {
        try {
            IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (activeWorkbenchWindow == null) {
                return;
            }
            IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
            if (activePage == null) {
                return;
            }
            activePage.getNavigationHistory().markLocation(activePage.getActiveEditor());
            IFile file = URIUtils.getFile((URI)this.myDestinationURI);
            if (file == null) {
                if (BlackboxUnitResolver.isBlackboxUnitURI((URI)this.myDestinationURI)) {
                    FileEditorInput editorInput = (FileEditorInput)activePage.getActiveEditor().getEditorInput();
                    Status navigateToJavaElement = new Status(1, "org.eclipse.m2m.qvt.oml.editor.ui", 500, "", null);
                    IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler((IStatus)navigateToJavaElement);
                    if (handler != null) {
                        try {
                            handler.handleStatus((IStatus)navigateToJavaElement, (Object)new Object[]{editorInput.getURI(), this.myDestinationURI.segment(0), this.myDestinationElement});
                        }
                        catch (CoreException e) {
                            Activator.log(e.getStatus());
                        }
                    }
                }
                return;
            }
            FileEditorInput fileEditorInput = new FileEditorInput(file);
            QvtEditor newEditor = (QvtEditor)activePage.openEditor((IEditorInput)fileEditorInput, "org.eclipse.m2m.qvt.oml.editor.ui.QvtEditor", true);
            ISourceViewer viewer = newEditor.getSourceViewerOpened();
            if (viewer == null || viewer.getTextWidget().isDisposed()) {
                return;
            }
            if (this.myDestinationRevealRegion != null) {
                viewer.revealRange(this.myDestinationRevealRegion.getOffset(), this.myDestinationRevealRegion.getLength());
            }
            if (this.myDestinationSelectRegion != null) {
                viewer.setSelectedRange(this.myDestinationSelectRegion.getOffset(), this.myDestinationSelectRegion.getLength());
            }
            activePage.getNavigationHistory().markLocation(activePage.getActiveEditor());
        }
        catch (PartInitException partInitException) {
            // empty catch block
        }
    }
}

