/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.jdt.runtime.blackbox;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.m2m.internal.qvt.oml.QvtPlugin;
import org.eclipse.m2m.internal.qvt.oml.blackbox.AbstractCompilationUnitDescriptor;
import org.eclipse.m2m.internal.qvt.oml.blackbox.ResolutionContext;
import org.eclipse.m2m.internal.qvt.oml.blackbox.java.JavaBlackboxProvider;
import org.eclipse.m2m.internal.qvt.oml.emf.util.URIUtils;
import org.eclipse.m2m.internal.qvt.oml.jdt.runtime.blackbox.JdtModuleHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdtBlackboxProvider
extends JavaBlackboxProvider {
    public static final String URI_BLACKBOX_JDT_QUERY = "jdt";

    public Collection<? extends AbstractCompilationUnitDescriptor> getModuleDescriptors(ResolutionContext resolutionContext) {
        IProject project = this.getProject(resolutionContext);
        if (project == null) {
            return Collections.emptyList();
        }
        ArrayList<IProject> projects = new ArrayList<IProject>();
        projects.add(project);
        try {
            projects.addAll(Arrays.asList(project.getReferencedProjects()));
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        ArrayList<AbstractCompilationUnitDescriptor> descriptors = new ArrayList<AbstractCompilationUnitDescriptor>();
        for (IProject p : projects) {
            List<String> classes = this.getAllClasses(p);
            for (String qualifiedName : classes) {
                AbstractCompilationUnitDescriptor jdtUnitDescriptor = this.getJdtUnitDescriptor(p, qualifiedName);
                if (jdtUnitDescriptor == null) continue;
                descriptors.add(jdtUnitDescriptor);
            }
        }
        return descriptors;
    }

    public AbstractCompilationUnitDescriptor getModuleDescriptor(String qualifiedName, ResolutionContext resolutionContext) {
        IProject project = this.getProject(resolutionContext);
        if (project == null) {
            return null;
        }
        return this.getJdtUnitDescriptor(project, qualifiedName);
    }

    private AbstractCompilationUnitDescriptor getJdtUnitDescriptor(IProject project, String qualifiedName) {
        URLClassLoader loader = null;
        try {
            final IJavaProject javaProject = JavaCore.create((IProject)project);
            IPath projectRelativeOutputPath = javaProject.getOutputLocation().removeFirstSegments(1);
            IPath outputPath = project.getLocation().append(projectRelativeOutputPath);
            URL outputUrl = outputPath.addTrailingSeparator().toFile().toURI().toURL();
            loader = new URLClassLoader(new URL[]{outputUrl}, ((Object)((Object)this)).getClass().getClassLoader());
            Class<?> moduleJavaClass = loader.loadClass(qualifiedName);
            JdtDescriptor jdtDescriptor = new JdtDescriptor(this, qualifiedName, moduleJavaClass){

                protected String getFragment() {
                    return javaProject.getElementName();
                }
            };
            return jdtDescriptor;
        }
        catch (JavaModelException javaProject) {
        }
        catch (MalformedURLException e) {
            QvtPlugin.error((Throwable)e);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        finally {
            try {
                if (loader != null) {
                    loader.close();
                }
            }
            catch (IOException e) {
                QvtPlugin.error((Throwable)e);
            }
        }
        return null;
    }

    private IProject getProject(ResolutionContext resolutionContext) {
        IResource resource = URIUtils.getResource((URI)resolutionContext.getURI());
        if (resource == null || !resource.exists()) {
            return null;
        }
        return resource.getProject();
    }

    private List<String> getAllClasses(IProject project) {
        final ArrayList<String> classes = new ArrayList<String>();
        try {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IResource folder = ResourcesPlugin.getWorkspace().getRoot().findMember(javaProject.getOutputLocation());
            final String folderPath = folder.getFullPath().toString();
            folder.accept(new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy proxy) throws CoreException {
                    if (proxy.getType() == 2) {
                        return true;
                    }
                    if (proxy.getType() == 1 && proxy.getName().endsWith(".class")) {
                        String filePath = proxy.requestFullPath().toString();
                        if ((filePath = filePath.substring(0, filePath.length() - 6)).startsWith(folderPath)) {
                            filePath = filePath.substring(folderPath.length() + 1);
                        }
                        classes.add(filePath.replace('/', '.'));
                    }
                    return false;
                }
            }, 0);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return classes;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JdtDescriptor
    extends JavaBlackboxProvider.JavaUnitDescriptor {
        private final Class<?> fModuleJavaClass;
        private volatile int hashCode;

        public JdtDescriptor(String unitQualifiedName, Class<?> moduleJavaClass) {
            super((JavaBlackboxProvider)JdtBlackboxProvider.this, unitQualifiedName);
            this.addModuleHandle(new JdtModuleHandle(unitQualifiedName, moduleJavaClass));
            this.fModuleJavaClass = moduleJavaClass;
        }

        protected String getUnitQuery() {
            return JdtBlackboxProvider.URI_BLACKBOX_JDT_QUERY;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof JdtDescriptor)) {
                return false;
            }
            JdtDescriptor other = (JdtDescriptor)((Object)obj);
            return this.getQualifiedName().equals(other.getQualifiedName()) && this.fModuleJavaClass.getName().equals(other.fModuleJavaClass.getName());
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                result = 17;
                result = 31 * result + this.getQualifiedName().hashCode();
                this.hashCode = result = 31 * result + this.fModuleJavaClass.getName().hashCode();
            }
            return result;
        }
    }
}

