/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.qvt.oml.debug.core.launch;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.m2m.internal.qvt.oml.common.launch.StreamsProxy;
import org.eclipse.m2m.internal.qvt.oml.common.launch.TargetUriData;
import org.eclipse.m2m.internal.qvt.oml.emf.util.urimap.MetamodelURIMappingHelper;
import org.eclipse.m2m.internal.qvt.oml.runtime.launch.QvtLaunchConfigurationDelegate;
import org.eclipse.m2m.internal.qvt.oml.runtime.launch.QvtLaunchUtil;
import org.eclipse.m2m.qvt.oml.ExecutionContext;
import org.eclipse.m2m.qvt.oml.ExecutionContextImpl;
import org.eclipse.m2m.qvt.oml.debug.core.QVTODebugCore;
import org.eclipse.m2m.qvt.oml.debug.core.QVTODebugTarget;
import org.eclipse.m2m.qvt.oml.debug.core.QVTODebugUtil;
import org.eclipse.m2m.qvt.oml.debug.core.QVTOVirtualProcess;
import org.eclipse.m2m.qvt.oml.debug.core.app.DebugRunnerFactory;
import org.eclipse.m2m.qvt.oml.debug.core.app.DebugTransformationRunner;
import org.eclipse.m2m.qvt.oml.debug.core.launch.SourceModificationListener;
import org.eclipse.m2m.qvt.oml.debug.core.vm.DebuggableExecutorAdapter;
import org.eclipse.m2m.qvt.oml.debug.core.vm.QVTOVirtualMachine;
import org.eclipse.m2m.qvt.oml.util.Log;
import org.eclipse.m2m.qvt.oml.util.WriterLog;

public class QVTODebugConfiguration
extends QvtLaunchConfigurationDelegate {
    public static final IStatus MODIFIED_SOURCE_STATUS = QVTODebugCore.createError("", 300, null);

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        ExecutionContextImpl context = this.createExecutionContext(configuration);
        StreamsProxy streamsProxy = new StreamsProxy();
        context.setLog((Log)new WriterLog(streamsProxy.getOutputWriter(), true));
        DebugTransformationRunner runner = this.createRunner(configuration);
        runner.setErrorLog(new PrintWriter(streamsProxy.getErrWriter(), true));
        Diagnostic initDiagnostic = runner.initialize();
        if (initDiagnostic.getSeverity() == 4) {
            throw new CoreException(BasicDiagnostic.toIStatus((Diagnostic)initDiagnostic));
        }
        DebuggableExecutorAdapter executable = runner.createDebugableAdapter((ExecutionContext)context);
        QVTOVirtualMachine vm = new QVTOVirtualMachine(executable);
        QVTOVirtualProcess process = new QVTOVirtualProcess(launch, vm);
        process.setStreamsProxy((IStreamsProxy)streamsProxy);
        List<IFile> transformationWsFile = QVTODebugUtil.toFiles(runner.getTransformationURI());
        if (!transformationWsFile.isEmpty()) {
            this.addSourceModificationListener(transformationWsFile.get(0), (ITerminate)process);
        }
        QVTODebugTarget debugTarget = new QVTODebugTarget(process, vm);
        launch.addDebugTarget((IDebugTarget)debugTarget);
    }

    private ExecutionContextImpl createExecutionContext(ILaunchConfiguration configuration) {
        ExecutionContextImpl context = new ExecutionContextImpl();
        Map configProperties = QvtLaunchUtil.loadConfigurationProperties((ILaunchConfiguration)configuration);
        for (String name : configProperties.keySet()) {
            Object value = configProperties.get(name);
            context.setConfigProperty(name, value);
        }
        return context;
    }

    private DebugTransformationRunner createRunner(ILaunchConfiguration configuration) throws CoreException {
        String moduleUri;
        DebugRunnerFactory runnerFactory = new DebugRunnerFactory();
        runnerFactory.transformationURI = moduleUri = QvtLaunchUtil.getTransformationURI((ILaunchConfiguration)configuration);
        runnerFactory.packageRegistry = this.createPackageRegistry(moduleUri);
        ArrayList<String> modelURIs = new ArrayList<String>();
        for (TargetUriData uriData : QvtLaunchUtil.getTargetUris((ILaunchConfiguration)configuration)) {
            modelURIs.add(uriData.getUriString());
        }
        runnerFactory.modelParamURI = modelURIs;
        String traceFileURI = QvtLaunchUtil.getTraceFileURI((ILaunchConfiguration)configuration);
        boolean shouldGenerateTraceFile = QvtLaunchUtil.shouldGenerateTraceFile((ILaunchConfiguration)configuration);
        if (traceFileURI != null && traceFileURI.trim().length() != 0 && shouldGenerateTraceFile) {
            runnerFactory.traceFileURI = traceFileURI;
        }
        try {
            return runnerFactory.createRunner();
        }
        catch (DiagnosticException e) {
            throw new CoreException(BasicDiagnostic.toIStatus((Diagnostic)e.getDiagnostic()));
        }
    }

    private void addSourceModificationListener(final IFile unitFile, final ITerminate terminate) {
        final SourceModificationListener listener = new SourceModificationListener(unitFile, terminate);
        unitFile.getProject().getWorkspace().addResourceChangeListener((IResourceChangeListener)listener, 1);
        DebugPlugin.getDefault().addDebugEventListener(new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] events) {
                int i = 0;
                while (i < events.length) {
                    DebugEvent event = events[i];
                    if (event.getKind() == 8 && event.getSource().equals(terminate)) {
                        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                        unitFile.getProject().getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener);
                    }
                    ++i;
                }
            }
        });
    }

    private EPackage.Registry createPackageRegistry(String transformationURIStr) {
        URI transformationURI = URI.createURI((String)transformationURIStr);
        try {
            IFile file;
            if (transformationURI.isPlatformResource() && (file = QVTODebugUtil.toFile(transformationURI)) != null && file.exists()) {
                return MetamodelURIMappingHelper.mappingsToEPackageRegistry((IProject)file.getProject(), (ResourceSet)new ResourceSetImpl());
            }
        }
        catch (Exception e) {
            QVTODebugCore.log(e);
        }
        return new EPackageRegistryImpl(EPackage.Registry.INSTANCE);
    }
}

