/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ui.wizards.project;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.eclipse.m2m.internal.qvt.oml.ui.QVTUIPlugin;
import org.eclipse.m2m.internal.qvt.oml.ui.wizards.project.Messages;
import org.eclipse.m2m.internal.qvt.oml.ui.wizards.project.NewProjectData;
import org.eclipse.m2m.internal.qvt.oml.ui.wizards.project.PluginClassCodeGenerator;
import org.eclipse.pde.core.plugin.IPluginReference;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NewProjectCreationOperation
extends WorkspaceModifyOperation {
    private static final String BUNDLE_EXEC_ENV = "J2SE-1.5";
    private static final String BUILD_FILENAME_DESCRIPTOR = "build.properties";
    private static final IPath REQUIRED_PLUGINS_CONTAINER_PATH = new Path("org.eclipse.pde.core.requiredPlugins");
    private static final String PLUGIN_NATURE = "org.eclipse.pde.PluginNature";
    private static Map<String, Integer> fSeverityTable = null;
    private static final int SEVERITY_ERROR = 3;
    private static final int SEVERITY_WARNING = 2;
    private static final int SEVERITY_IGNORE = 1;
    private PluginClassCodeGenerator fGenerator;
    private NewProjectData fData;
    private IProject fProjectHandle;

    public NewProjectCreationOperation(IProject projectHandle, NewProjectData projectData) {
        if (projectHandle == null || projectData == null) {
            throw new IllegalArgumentException();
        }
        this.fData = projectData;
        this.fProjectHandle = projectHandle;
    }

    protected void createContents(IProgressMonitor monitor, IProject project) throws CoreException, InterruptedException {
    }

    private void createBuildProperties(IProject project, IProgressMonitor monitor) throws CoreException {
        IFile buildProperties = project.getFile(BUILD_FILENAME_DESCRIPTOR);
        StringWriter contents = new StringWriter();
        PrintWriter wr = new PrintWriter((Writer)contents, true);
        if (this.fData.isCreateJava()) {
            IPath sourceFolder = this.asBinIncludesFolder(this.createJavaFolder(this.fData.getSourceFolderName(), monitor));
            IPath outFolder = this.asBinIncludesFolder(this.createJavaFolder(this.fData.getOutFolderName(), monitor));
            wr.append("source.. = ").println(sourceFolder.toString());
            wr.append("output.. = ").println(outFolder.toString());
        }
        char[] alignChars = new char[15];
        Arrays.fill(alignChars, ' ');
        String indent = new String(alignChars);
        wr.print("bin.includes = META-INF/");
        if (this.fData.isCreateJava()) {
            wr.println(",\\");
            wr.append(indent).append('.');
        }
        IContainer qvtContainer = this.createJavaFolder(this.fData.getQVTSourceFolderName(), monitor);
        IPath qvtFolder = this.asBinIncludesFolder(qvtContainer);
        if (!this.fProjectHandle.equals((Object)qvtContainer) || !this.fData.isCreateJava()) {
            wr.println(",\\");
            wr.append(indent).append(qvtFolder.toString());
        }
        wr.println();
        wr.flush();
        InputStream is = this.createContentStreamForNewFile(buildProperties, contents.getBuffer().toString());
        buildProperties.create(is, false, monitor);
    }

    private void createManifest(IFolder metaFolder, IProgressMonitor monitor) throws CoreException {
        IFile manifest = metaFolder.getFile("MANIFEST.MF");
        StringWriter contents = new StringWriter();
        PrintWriter wr = new PrintWriter((Writer)contents, true);
        wr.println("Manifest-Version: 1.0");
        wr.println("Bundle-ManifestVersion: 2");
        wr.append("Bundle-Name: ").println(this.fData.getName());
        wr.append("Bundle-SymbolicName: ").println(this.fData.getID());
        wr.append("Bundle-Version: ").println(this.fData.getVersion());
        wr.append("Bundle-Vendor: ").println(this.fData.getProviderName());
        IPluginReference[] dependencies = this.getDependencies();
        if (dependencies.length > 0) {
            wr.append("Require-Bundle:");
            int i = 0;
            IPluginReference[] iPluginReferenceArray = dependencies;
            int n = dependencies.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginReference pluginReference = iPluginReferenceArray[n2];
                if (i++ > 0) {
                    wr.println(',');
                }
                wr.append(' ');
                wr.append(pluginReference.getId());
                ++n2;
            }
            wr.println();
        }
        if (this.fData.isCreateJava() && NewProjectCreationOperation.getEEnv(BUNDLE_EXEC_ENV) != null) {
            wr.append("Bundle-RequiredExecutionEnvironment: ").println(BUNDLE_EXEC_ENV);
        }
        wr.flush();
        InputStream is = this.createContentStreamForNewFile(manifest, contents.getBuffer().toString());
        manifest.create(is, false, monitor);
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.NewProjectCreationOperation_createQVTProjectTask, (int)2);
        this.createProject((IProgressMonitor)progress.newChild(1));
        this.createContents((IProgressMonitor)progress.newChild(1), this.fProjectHandle);
        monitor.done();
    }

    private void generateTopLevelPluginClass(IProgressMonitor monitor) throws CoreException {
        this.fGenerator.generate(monitor);
        monitor.done();
    }

    private IPluginReference[] getDependencies() {
        if (this.fGenerator == null) {
            return new IPluginReference[0];
        }
        return this.fGenerator.getDependencies();
    }

    private void setupJava(IProject project, boolean pde, IProgressMonitor monitor) throws CoreException, JavaModelException {
        this.addNatureToProject(project, "org.eclipse.jdt.core.javanature", monitor);
        IContainer srcContainer = this.createJavaFolder(this.fData.getSourceFolderName(), monitor);
        IContainer binContainer = this.createJavaFolder(this.fData.getOutFolderName(), monitor);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        javaProject.setOutputLocation(binContainer.getFullPath(), monitor);
        monitor.subTask(Messages.NewProjectCreationOperation_SetClassPathTask);
        IClasspathEntry[] entries = new IClasspathEntry[pde ? 3 : 1];
        if (pde) {
            String executionEnvironment = BUNDLE_EXEC_ENV;
            NewProjectCreationOperation.setComplianceOptions(javaProject, executionEnvironment, true);
            entries[0] = NewProjectCreationOperation.createJREEntry(executionEnvironment);
            entries[1] = NewProjectCreationOperation.createContainerEntry();
        }
        entries[entries.length - 1] = JavaCore.newSourceEntry((IPath)srcContainer.getFullPath());
        javaProject.setRawClasspath(entries, monitor);
        if (this.fData.isDoGenerateClass()) {
            this.generateTopLevelPluginClass((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        monitor.worked(1);
    }

    private void createProject(IProgressMonitor monitor) throws CoreException, JavaModelException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)7);
        URI location = URIUtil.toURI((IPath)this.fData.getLocation());
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProjectDescription description = workspace.newProjectDescription(this.fProjectHandle.getName());
        if (location != null && ResourcesPlugin.getWorkspace().getRoot().getLocationURI().equals(location)) {
            location = null;
        }
        description.setLocationURI(location);
        if (!this.fProjectHandle.exists()) {
            this.fProjectHandle.create(description, (IProgressMonitor)subMonitor.newChild(1));
        }
        subMonitor.setWorkRemaining(6);
        if (subMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.fProjectHandle.open(128, (IProgressMonitor)subMonitor.newChild(1));
        if (this.fData.isPlugin()) {
            this.addNatureToProject(this.fProjectHandle, PLUGIN_NATURE, (IProgressMonitor)subMonitor.newChild(1));
            this.fGenerator = new PluginClassCodeGenerator(this.fProjectHandle, this.fData);
            if (this.fData.isCreateJava()) {
                this.setupJava(this.fProjectHandle, true, (IProgressMonitor)subMonitor.newChild(1));
            }
            subMonitor.setWorkRemaining(3);
            IFolder metaFolder = this.fProjectHandle.getFolder("META-INF");
            metaFolder.create(true, true, (IProgressMonitor)subMonitor.newChild(1));
            this.createManifest(metaFolder, (IProgressMonitor)subMonitor.newChild(1));
            this.createBuildProperties(this.fProjectHandle, (IProgressMonitor)subMonitor.newChild(1));
        } else if (this.fData.isCreateJava()) {
            subMonitor.setWorkRemaining(1);
            this.setupJava(this.fProjectHandle, false, (IProgressMonitor)subMonitor.newChild(1));
        }
    }

    private void addNatureToProject(IProject proj, String natureId, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = proj.getDescription();
        String[] prevNatures = description.getNatureIds();
        String[] newNatures = new String[prevNatures.length + 1];
        System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
        newNatures[prevNatures.length] = natureId;
        description.setNatureIds(newNatures);
        proj.setDescription(description, monitor);
    }

    private static IClasspathEntry createJREEntry(String ee) {
        return JavaCore.newContainerEntry((IPath)NewProjectCreationOperation.getEEPath(ee));
    }

    private static IPath getEEPath(String ee) {
        IExecutionEnvironment env;
        IPath path = null;
        if (ee != null && (env = NewProjectCreationOperation.getEEnv(ee)) != null) {
            path = JavaRuntime.newJREContainerPath((IExecutionEnvironment)env);
        }
        if (path == null) {
            path = JavaRuntime.newDefaultJREContainerPath();
        }
        return path;
    }

    private static IExecutionEnvironment getEEnv(String ee) {
        if (ee != null) {
            IExecutionEnvironmentsManager manager = JavaRuntime.getExecutionEnvironmentsManager();
            return manager.getEnvironment(ee);
        }
        return null;
    }

    private static IClasspathEntry createContainerEntry() {
        return JavaCore.newContainerEntry((IPath)REQUIRED_PLUGINS_CONTAINER_PATH);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void setComplianceOptions(IJavaProject project, String eeId, boolean overrideExisting) {
        Map projectMap = project.getOptions(false);
        IExecutionEnvironment ee = null;
        Map options = null;
        if (eeId != null && (ee = JavaRuntime.getExecutionEnvironmentsManager().getEnvironment(eeId)) != null) {
            options = ee.getComplianceOptions();
        }
        if (options == null) {
            if (!overrideExisting || projectMap.size() <= 0) return;
            projectMap.remove("org.eclipse.jdt.core.compiler.compliance");
            projectMap.remove("org.eclipse.jdt.core.compiler.source");
            projectMap.remove("org.eclipse.jdt.core.compiler.codegen.targetPlatform");
            projectMap.remove("org.eclipse.jdt.core.compiler.problem.assertIdentifier");
            projectMap.remove("org.eclipse.jdt.core.compiler.problem.enumIdentifier");
        } else {
            String compliance = (String)options.get("org.eclipse.jdt.core.compiler.compliance");
            for (Map.Entry entry : options.entrySet()) {
                String option = (String)entry.getKey();
                String value = (String)entry.getValue();
                if ("1.3".equals(compliance) || "1.4".equals(compliance)) {
                    if ("org.eclipse.jdt.core.compiler.problem.assertIdentifier".equals(option) || "org.eclipse.jdt.core.compiler.problem.enumIdentifier".equals(option)) {
                        NewProjectCreationOperation.setMinimumCompliance(projectMap, option, value, overrideExisting);
                        continue;
                    }
                    NewProjectCreationOperation.setCompliance(projectMap, option, value, overrideExisting);
                    continue;
                }
                NewProjectCreationOperation.setCompliance(projectMap, option, value, overrideExisting);
            }
        }
        project.setOptions(projectMap);
    }

    private static void setMinimumCompliance(Map<String, String> map, String key, String minimumValue, boolean override) {
        if (minimumValue != null && (override || !map.containsKey(key))) {
            int minimum;
            String currentValue;
            if (fSeverityTable == null) {
                fSeverityTable = new HashMap<String, Integer>(3);
                fSeverityTable.put("ignore", new Integer(1));
                fSeverityTable.put("warning", new Integer(2));
                fSeverityTable.put("error", new Integer(3));
            }
            int current = (currentValue = map.get(key)) != null && fSeverityTable.containsKey(currentValue) ? fSeverityTable.get(currentValue) : 0;
            int n = minimum = minimumValue != null && fSeverityTable.containsKey(minimumValue) ? fSeverityTable.get(minimumValue) : 0;
            if (current < minimum) {
                map.put(key, minimumValue);
            }
        }
    }

    private static void setCompliance(Map<String, String> map, String key, String value, boolean override) {
        if (value != null && (override || !map.containsKey(key))) {
            map.put(key, value);
        }
    }

    private InputStream createContentStreamForNewFile(IFile fileHandle, String contents) {
        byte[] bytes;
        String charset = null;
        try {
            charset = fileHandle.getProject().getDefaultCharset();
        }
        catch (CoreException e) {
            QVTUIPlugin.log(e.getStatus());
        }
        if (charset == null) {
            charset = ResourcesPlugin.getEncoding();
        }
        try {
            bytes = contents.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            bytes = contents.getBytes();
        }
        return new ByteArrayInputStream(bytes);
    }

    private IPath asBinIncludesFolder(IContainer container) {
        if (container.equals((Object)this.fProjectHandle)) {
            return new Path(".");
        }
        IPath result = container.getProjectRelativePath();
        while (result.hasTrailingSeparator()) {
            result = result.removeTrailingSeparator();
        }
        return result.addTrailingSeparator();
    }

    private IContainer createJavaFolder(String folderName, IProgressMonitor monitor) throws CoreException {
        if (folderName == null || folderName.trim().length() == 0) {
            return this.fProjectHandle;
        }
        IFolder folder = this.fProjectHandle.getFolder(folderName);
        if (!folder.exists()) {
            folder.create(true, true, monitor);
        }
        return folder;
    }
}

