/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.project;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.m2m.internal.qvt.oml.compiler.BlackboxUnitResolver;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompositeUnitResolver;
import org.eclipse.m2m.internal.qvt.oml.compiler.DelegatingUnitResolver;
import org.eclipse.m2m.internal.qvt.oml.compiler.ResolverUtils;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitContents;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitProxy;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitResolver;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.DeployedImportResolver;
import org.osgi.framework.Bundle;

public class PlatformPluginUnitResolver
extends DelegatingUnitResolver {
    private Bundle fBundle;
    private List<IPath> fSrcContainers;

    public PlatformPluginUnitResolver(Bundle bundle) {
        this(bundle, new IPath[]{new Path("/")});
    }

    public PlatformPluginUnitResolver(Bundle bundle, IPath ... sourceContainers) {
        if (bundle == null) {
            throw new IllegalArgumentException("null bundle");
        }
        if (sourceContainers == null) {
            throw new IllegalArgumentException("null source containter");
        }
        List<IPath> containers = Arrays.asList(sourceContainers);
        if (containers.contains(null)) {
            throw new IllegalArgumentException("null source containter");
        }
        this.fBundle = bundle;
        this.fSrcContainers = new ArrayList<IPath>(containers);
    }

    public UnitProxy doResolveUnit(String qualifiedName) {
        IPath unitNsRelativePath = ResolverUtils.toNamespaceRelativePath((String)qualifiedName).addFileExtension("qvto");
        Iterator<IPath> iterator = this.fSrcContainers.iterator();
        if (iterator.hasNext()) {
            IPath nextContainer = iterator.next();
            IPath unitBundleRelativePath = nextContainer.append(unitNsRelativePath);
            URL unitURL = this.fBundle.getEntry(unitBundleRelativePath.toString());
            if (unitURL == null) {
                return null;
            }
            IPath unitAbsolutePath = new Path(this.fBundle.getSymbolicName()).append(unitBundleRelativePath);
            URI unitURI = URI.createPlatformPluginURI((String)unitAbsolutePath.toString(), (boolean)false);
            String[] segments = ResolverUtils.getNameSegments((String)qualifiedName);
            String namespace = null;
            if (segments.length > 1) {
                namespace = ResolverUtils.toQualifiedName((String[])segments, (int)0, (int)(segments.length - 2));
            }
            String name = segments[segments.length - 1];
            return new BundleUnit(namespace, name, unitURI, unitURL);
        }
        return null;
    }

    public static void setupResolver(PlatformPluginUnitResolver resolver, boolean useBlackbox, boolean useDeployed) {
        if (useBlackbox && !useDeployed) {
            resolver.setParent((UnitResolver)BlackboxUnitResolver.DEFAULT);
        } else if (useBlackbox && useDeployed) {
            resolver.setParent((UnitResolver)new CompositeUnitResolver(new UnitResolver[]{DeployedImportResolver.INSTANCE, BlackboxUnitResolver.DEFAULT}));
        }
    }

    public static UnitProxy getUnit(URI uri) {
        if (!uri.isPlatformPlugin() || uri.segmentCount() < 2) {
            return null;
        }
        String bundleId = uri.segment(1);
        Bundle bundle = Platform.getBundle((String)bundleId);
        if (bundle == null) {
            return null;
        }
        Path path = new Path(uri.toPlatformString(true));
        IPath pluginRelativePath = path.removeFirstSegments(1).removeFileExtension();
        PlatformPluginUnitResolver resolver = new PlatformPluginUnitResolver(bundle);
        PlatformPluginUnitResolver.setupResolver(resolver, true, true);
        return resolver.resolveUnit(ResolverUtils.toQualifiedName((IPath)pluginRelativePath));
    }

    private final class BundleUnit
    extends UnitProxy {
        private final URL url;

        private BundleUnit(String namespace, String unitName, URI unitURI, URL unitURL) {
            super(namespace, unitName, unitURI);
            this.url = unitURL;
        }

        public int getContentType() {
            return 0;
        }

        public UnitContents getContents() throws IOException {
            return new UnitContents.CSTContents(){

                public Reader getContents() throws IOException {
                    URLConnection connection = BundleUnit.this.url.openConnection();
                    String charset = connection.getContentEncoding();
                    if (charset == null) {
                        charset = "UTF-8";
                    }
                    return new InputStreamReader(connection.getInputStream(), charset);
                }
            };
        }

        public UnitResolver getResolver() {
            return PlatformPluginUnitResolver.this;
        }
    }
}

