/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateTranslator;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.DocumentUtils;

public class QvtTemplateContext
extends DocumentTemplateContext {
    public QvtTemplateContext(TemplateContextType type, IDocument document, int offset, int length) {
        super(type, document, offset, length);
    }

    public TemplateBuffer evaluate(Template template) throws BadLocationException, TemplateException {
        if (!this.canEvaluate(template)) {
            return null;
        }
        TemplateTranslator translator = new TemplateTranslator();
        TemplateBuffer buffer = translator.translate(this.getUpdatedPattern(template.getPattern(), !this.isReadOnly()));
        this.getContextType().resolve(buffer, (TemplateContext)this);
        return buffer;
    }

    private String getUpdatedPattern(String pattern, boolean updateIndentation) throws BadLocationException {
        IDocument document = this.getDocument();
        int offset = this.getCompletionOffset();
        IRegion info = DocumentUtils.getLineInformationOfOffset(document, offset);
        String whiteSpace = DocumentUtils.getStartingWhiteSpace(document, info.getOffset(), offset);
        String validLineDelimeter = this.getValidLineDelimeter(document);
        DefaultLineTracker tracker = new DefaultLineTracker();
        tracker.set(pattern);
        int numberOfLines = tracker.getNumberOfLines();
        if (numberOfLines == 1) {
            return pattern;
        }
        StringBuilder newPattern = new StringBuilder();
        int i = 0;
        while (i < numberOfLines) {
            if (updateIndentation && i > 0) {
                newPattern.append(whiteSpace);
            }
            IRegion region = tracker.getLineInformation(i);
            String line = pattern.substring(region.getOffset(), region.getOffset() + region.getLength());
            newPattern.append(line);
            if (i < numberOfLines - 1) {
                newPattern.append(validLineDelimeter);
            }
            ++i;
        }
        return newPattern.toString();
    }

    private String getValidLineDelimeter(IDocument document) {
        String delimeter = null;
        int i = 0;
        int lineCount = document.getNumberOfLines();
        while (i < lineCount && delimeter == null) {
            try {
                delimeter = document.getLineDelimiter(i);
            }
            catch (BadLocationException badLocationException) {}
            ++i;
        }
        if (delimeter == null) {
            delimeter = document.getLegalLineDelimiters()[0];
        }
        return delimeter;
    }
}

