/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.launch;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.m2m.internal.qvt.oml.ast.env.ModelExtentContents;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.common.io.CFile;
import org.eclipse.m2m.internal.qvt.oml.common.io.eclipse.EclipseFile;
import org.eclipse.m2m.internal.qvt.oml.common.launch.BaseProcess;
import org.eclipse.m2m.internal.qvt.oml.common.launch.SafeRunner;
import org.eclipse.m2m.internal.qvt.oml.common.launch.TargetUriData;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfException;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.Logger;
import org.eclipse.m2m.internal.qvt.oml.emf.util.StatusUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.URIUtils;
import org.eclipse.m2m.internal.qvt.oml.emf.util.WorkspaceUtils;
import org.eclipse.m2m.internal.qvt.oml.library.Context;
import org.eclipse.m2m.internal.qvt.oml.library.IConfiguration;
import org.eclipse.m2m.internal.qvt.oml.library.IContext;
import org.eclipse.m2m.internal.qvt.oml.runtime.generator.TraceSerializer;
import org.eclipse.m2m.internal.qvt.oml.runtime.generator.TransformationRunner;
import org.eclipse.m2m.internal.qvt.oml.runtime.launch.Messages;
import org.eclipse.m2m.internal.qvt.oml.runtime.launch.QvtLaunchUtil;
import org.eclipse.m2m.internal.qvt.oml.runtime.launch.QvtValidator;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtModule;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtTransformation;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.TransformationUtil;
import org.eclipse.m2m.internal.qvt.oml.runtime.util.MiscUtil;
import org.eclipse.m2m.internal.qvt.oml.trace.Trace;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QvtLaunchConfigurationDelegateBase
extends LaunchConfigurationDelegate {
    protected IProject[] getProjectsForProblemSearch(ILaunchConfiguration configuration, String mode) throws CoreException {
        IFile moduleFile = QvtLaunchConfigurationDelegateBase.getModuleFile(configuration);
        if (moduleFile == null || !moduleFile.exists()) {
            return new IProject[0];
        }
        return new IProject[]{moduleFile.getProject()};
    }

    protected static QvtModule getQvtModule(ILaunchConfiguration configuration) throws CoreException {
        String moduleName = configuration.getAttribute("org.eclipse.m2m.qvt.oml.interpreter.module", "");
        try {
            return TransformationUtil.getQvtModule(EmfUtil.makeUri((String)moduleName));
        }
        catch (MdaException e) {
            IStatus errorStatus = MiscUtil.makeErrorStatus(e.getMessage());
            throw new CoreException(errorStatus);
        }
    }

    protected static IFile getModuleFile(ILaunchConfiguration configuration) throws CoreException {
        String moduleFileName = configuration.getAttribute("org.eclipse.m2m.qvt.oml.interpreter.module", "");
        URI moduleUri = URI.createURI((String)moduleFileName);
        IFile moduleFile = WorkspaceUtils.getWorkspaceFile((URI)moduleUri);
        return moduleFile;
    }

    public static IStatus validate(QvtTransformation transformation, ILaunchConfiguration configuration) throws CoreException {
        List<TargetUriData> targetUris = QvtLaunchUtil.getTargetUris(configuration);
        String traceFile = configuration.getAttribute("org.eclipse.m2m.qvt.oml.interpreter.traceFile", "");
        boolean useTraceFile = configuration.getAttribute("org.eclipse.m2m.qvt.oml.interpreter.useTraceFile", false);
        try {
            return QvtValidator.validateTransformation(transformation, targetUris, traceFile, useTraceFile);
        }
        catch (MdaException ex) {
            throw new CoreException(StatusUtil.makeErrorStatus((String)ex.getMessage(), (Exception)((Object)ex)));
        }
    }

    public static BaseProcess.IRunnable getSafeRunnable(QvtTransformation transformation, BaseProcess.IRunnable r) throws CoreException {
        return SafeRunner.getSafeRunnable((BaseProcess.IRunnable)r);
    }

    public static void doLaunch(QvtTransformation transformation, ILaunchConfiguration configuration, IContext context) throws Exception {
        ArrayList<EObject> inObjects = new ArrayList<EObject>();
        ArrayList<TargetUriData> targetData = new ArrayList<TargetUriData>();
        List<TargetUriData> targetUris = QvtLaunchUtil.getTargetUris(configuration);
        Iterator<TargetUriData> itrTargetData = targetUris.iterator();
        for (QvtTransformation.TransformationParameter transfParam : transformation.getParameters()) {
            if (!itrTargetData.hasNext()) {
                throw new MdaException(NLS.bind((String)Messages.QvtValidator_EmptyInputTransfParam, (Object)transfParam.getName()));
            }
            TargetUriData nextUri = itrTargetData.next();
            if (transfParam.getDirectionKind() == QvtTransformation.TransformationParameter.DirectionKind.IN || transfParam.getDirectionKind() == QvtTransformation.TransformationParameter.DirectionKind.INOUT) {
                URI inUri = QvtLaunchConfigurationDelegateBase.toUri(nextUri.getUriString());
                EObject inObj = transformation.loadInput(inUri);
                inObjects.add(inObj);
            }
            if (transfParam.getDirectionKind() != QvtTransformation.TransformationParameter.DirectionKind.OUT && transfParam.getDirectionKind() != QvtTransformation.TransformationParameter.DirectionKind.INOUT) continue;
            targetData.add(nextUri);
        }
        IConfiguration qvtConfiguration = QvtLaunchUtil.getConfiguration(configuration);
        boolean saveTrace = configuration.getAttribute("org.eclipse.m2m.qvt.oml.interpreter.useTraceFile", false);
        String traceFileName = saveTrace ? configuration.getAttribute("org.eclipse.m2m.qvt.oml.interpreter.traceFile", "") : null;
        QvtLaunchConfigurationDelegateBase.doLaunch(transformation, inObjects, targetData, qvtConfiguration, traceFileName, context);
    }

    public static List<URI> doLaunch(QvtTransformation transformation, List<EObject> inObjs, List<TargetUriData> targetData, IConfiguration configuration, String traceFileName) throws Exception {
        return QvtLaunchConfigurationDelegateBase.doLaunch(transformation, inObjs, targetData, configuration, traceFileName, (IContext)new Context(configuration));
    }

    public static void doLaunch(QvtTransformation transformation, List<EObject> inObjs, IConfiguration configuration, List<ModelExtentContents> outExtents, List<EObject> outMainParams, List<Trace> outTraces, List<String> outConsole) throws MdaException {
        IStatus status = QvtValidator.validateTransformation(transformation, inObjs);
        if (status.getSeverity() > 2) {
            throw new MdaException(status);
        }
        Context context = new Context(configuration);
        try {
            StringWriter consoleLogger = new StringWriter();
            context.put("@out_print_writer", (Object)new PrintWriter(consoleLogger));
            context.launch();
            TransformationRunner.In in = new TransformationRunner.In(inObjs.toArray(new EObject[inObjs.size()]), (IContext)context);
            TransformationRunner.Out out = transformation.run(in);
            outExtents.addAll(out.getExtents());
            for (Object outValue : out.getOutParamValues()) {
                if (outValue instanceof EObject) {
                    outMainParams.add((EObject)outValue);
                    continue;
                }
                outMainParams.add(null);
            }
            if (out.getTrace() != null) {
                outTraces.add(out.getTrace());
            }
            outConsole.add(consoleLogger.getBuffer().toString());
        }
        finally {
            context.release();
        }
    }

    private static List<URI> doLaunch(QvtTransformation transformation, List<EObject> inObjs, List<TargetUriData> targetData, IConfiguration configuration, String traceFileName, IContext context) throws Exception {
        context.launch();
        TransformationRunner.In in = new TransformationRunner.In(inObjs.toArray(new EObject[inObjs.size()]), context);
        TransformationRunner.Out out = transformation.run(in);
        ResourceSet resSet = null;
        for (EObject inEObject : inObjs) {
            if (inEObject.eResource() != null && (resSet = inEObject.eResource().getResourceSet()) != null) break;
        }
        if (resSet == null) {
            resSet = EmfUtil.getOutputResourceSet();
        }
        Iterator<ModelExtentContents> itrExtent = out.getExtents().iterator();
        for (TargetUriData outData : targetData) {
            if (!itrExtent.hasNext()) continue;
            QvtLaunchConfigurationDelegateBase.confineInResource(itrExtent.next(), outData, resSet);
        }
        itrExtent = out.getExtents().iterator();
        for (TargetUriData outUriData : targetData) {
            if (!itrExtent.hasNext()) {
                throw new MdaException("Imcomplete transformation results");
            }
            QvtLaunchConfigurationDelegateBase.saveTransformationResult(itrExtent.next(), outUriData, resSet);
        }
        ArrayList<URI> result = new ArrayList<URI>(out.getOutParamValues().size());
        for (Object outValue : out.getOutParamValues()) {
            if (outValue instanceof EObject) {
                result.add(EcoreUtil.getURI((EObject)((EObject)outValue)));
                continue;
            }
            result.add(null);
        }
        if (traceFileName != null && out.getTrace() != null) {
            IFile traceFile;
            URI traceUri = EmfUtil.makeUri((String)traceFileName);
            IFile iFile = traceFile = traceUri != null ? WorkspaceUtils.getWorkspaceFile((URI)traceUri) : null;
            if (traceFile != null) {
                TraceSerializer traceSerializer = new TraceSerializer(out.getTrace());
                traceSerializer.saveTraceModel((CFile)new EclipseFile(traceFile));
                traceSerializer.markUnboundObjects(traceFile);
            }
        }
        context.release();
        return result;
    }

    private static void saveTransformationResult(ModelExtentContents extent, TargetUriData targetData, ResourceSet resSet) throws MdaException {
        URI outUri = QvtLaunchConfigurationDelegateBase.toUri(targetData.getUriString());
        switch (targetData.getTargetType()) {
            case NEW_MODEL: {
                try {
                    Resource outExtent = resSet.getResource(outUri, false);
                    EmfUtil.saveModel((Resource)outExtent, (URI)outUri, (Map)EmfUtil.DEFAULT_SAVE_OPTIONS);
                    break;
                }
                catch (EmfException e) {
                    throw new MdaException((Throwable)e);
                }
            }
            case EXISTING_CONTAINER: {
                EObject container = EmfUtil.loadModel((URI)outUri, (ResourceSet)resSet);
                if (container == null) {
                    throw new MdaException("No object at " + outUri);
                }
                EStructuralFeature feature = container.eClass().getEStructuralFeature(targetData.getFeature());
                if (!(feature instanceof EReference)) {
                    throw new MdaException("Reference " + targetData.getFeature() + " not found in " + container);
                }
                for (EObject out : extent.getAllRootElements()) {
                    EReference ref = (EReference)feature;
                    if (!ref.isMany()) {
                        container.eSet((EStructuralFeature)ref, (Object)out);
                        continue;
                    }
                    EList value = (EList)container.eGet(feature);
                    if (targetData.isClearContents()) {
                        value.clear();
                    }
                    try {
                        value.add((Object)out);
                    }
                    catch (RuntimeException runtimeException) {
                        throw new MdaException(NLS.bind((String)Messages.QvtLaunchConfigurationDelegateBase_FeatureSetFailure, (Object)EmfUtil.getFullName((EClassifier)out.eClass()), (Object)targetData.getFeature()));
                    }
                }
                try {
                    QvtLaunchConfigurationDelegateBase.saveResource(container);
                    break;
                }
                catch (IOException e) {
                    throw new MdaException(e.getMessage(), (Throwable)e);
                }
            }
            case INPLACE: {
                throw new MdaException("Inplace run configuration type is not supported");
            }
        }
        URIUtils.refresh((URI)outUri);
    }

    private static void confineInResource(ModelExtentContents extent, TargetUriData targetData, ResourceSet resSet) throws MdaException {
        URI outUri = QvtLaunchConfigurationDelegateBase.toUri(targetData.getUriString());
        switch (targetData.getTargetType()) {
            case NEW_MODEL: {
                Resource outExtent = resSet.getResource(outUri, false);
                if (outExtent == null) {
                    outExtent = EmfUtil.createResource((URI)outUri, (ResourceSet)resSet);
                } else {
                    outExtent.getContents().clear();
                }
                outExtent.getContents().addAll((Collection)extent.getAllRootElements());
                resSet.getResources().add((Object)outExtent);
            }
        }
    }

    private static void saveResource(EObject obj) throws IOException {
        Resource resource = obj.eResource();
        if (resource == null) {
            Logger.getLogger().warning("Object has no resource: " + obj);
            return;
        }
        resource.save(EmfUtil.DEFAULT_SAVE_OPTIONS);
    }

    private static URI toUri(String uriString) throws MdaException {
        URI uri = URI.createURI((String)uriString);
        if (uri == null) {
            throw new MdaException(NLS.bind((String)Messages.QvtLauncherTab_InvalidUri, (Object)uriString));
        }
        return uri;
    }
}

