/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.xtext.qvtcore.tests;

import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.internal.utilities.OCLInternal;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.qvtd.pivot.qvtcore.utilities.QVTcore;
import org.eclipse.qvtd.xtext.qvtbase.tests.AbstractTestQVT;
import org.eclipse.qvtd.xtext.qvtbase.tests.LoadTestCase;
import org.eclipse.qvtd.xtext.qvtbase.tests.utilities.TestsXMLUtil;
import org.eclipse.qvtd.xtext.qvtbase.tests.utilities.XtextCompilerUtil;
import org.eclipse.xtext.resource.XtextResource;

public class QVTcSerializeTests
extends LoadTestCase {
    protected @NonNull OCLInternal createOCL() {
        return QVTcore.newInstance((ProjectManager)this.getTestProjectManager(), null);
    }

    protected void doSerializeRoundTripFromAS(@NonNull URI pivotURI) throws Exception {
        this.doSerializeRoundTripFromAS(pivotURI, this.getURIWithExtension(pivotURI, "ref.qvtcas"));
    }

    protected void doSerializeRoundTripFromAS(@NonNull URI pivotURI, @NonNull URI referenceURI) throws Exception {
        URI serializedInputURI = this.getTestURIWithExtension(pivotURI, "serialized.qvtc");
        URI serializedPivotURI = this.getTestURIWithExtension(pivotURI, "serialized.qvtcas");
        ProjectManager projectManager = this.getTestProjectManager();
        QVTcore ocl1 = QVTcore.newInstance((ProjectManager)projectManager);
        QVTcore ocl2 = QVTcore.newInstance((ProjectManager)projectManager);
        Resource asResource1 = ocl1.getMetamodelManager().getASResourceSet().getResource(pivotURI, true);
        this.doSerialize(pivotURI, serializedInputURI, referenceURI, null, true, true, null);
        Resource asResource3 = this.doLoad_Concrete((OCL)ocl2, serializedInputURI, serializedPivotURI, NO_MESSAGES);
        ((Model)asResource3.getContents().get(0)).setExternalURI(((Model)asResource1.getContents().get(0)).getExternalURI());
        QVTcSerializeTests.assertSameModel((Resource)asResource1, (Resource)asResource3);
        ocl1.dispose();
        ocl2.dispose();
    }

    protected void doSerializeRoundTripFromCS(@NonNull URI inputURI) throws Exception {
        this.doSerializeRoundTripFromCS(inputURI, this.getURIWithExtension(inputURI, "ref.qvtcas"));
    }

    protected void doSerializeRoundTripFromCS(@NonNull URI inputURI, @NonNull URI referenceURI) throws Exception {
        URI pivotURI = this.getTestURIWithExtension(inputURI, "qvtcas");
        URI serializedInputURI = this.getTestURIWithExtension(inputURI, "serialized.qvtc");
        URI serializedPivotURI = this.getTestURIWithExtension(inputURI, "serialized.qvtcas");
        ProjectManager projectManager = this.getTestProjectManager();
        QVTcore ocl1 = QVTcore.newInstance((ProjectManager)projectManager);
        QVTcore ocl2 = QVTcore.newInstance((ProjectManager)projectManager);
        Resource asResource1 = this.doLoad_Concrete((OCL)ocl1, inputURI, pivotURI, NO_MESSAGES);
        this.doSerialize(pivotURI, serializedInputURI, referenceURI, null, true, true, null);
        Resource asResource3 = this.doLoad_Concrete((OCL)ocl2, serializedInputURI, serializedPivotURI, NO_MESSAGES);
        ((Model)asResource3.getContents().get(0)).setExternalURI(((Model)asResource1.getContents().get(0)).getExternalURI());
        TestsXMLUtil.resetTransients((Resource)asResource1);
        TestsXMLUtil.resetTransients((Resource)asResource3);
        QVTcSerializeTests.assertSameModel((Resource)asResource1, (Resource)asResource3);
        ocl1.dispose();
        ocl2.dispose();
    }

    public XtextResource doSerialize(@NonNull URI inputURI, @NonNull URI serializedInputURI, @NonNull URI referenceURI, @Nullable Map<String, Object> options, boolean doCompare, boolean validateSaved, @NonNull String @Nullable [] messages) throws Exception {
        QVTcore ocl = QVTcore.newInstance((ProjectManager)this.getTestProjectManager());
        try {
            ASResource asResource = AbstractTestQVT.loadQVTiAS((OCL)ocl, (URI)inputURI);
            QVTcSerializeTests.assertNoResourceErrors((String)"Normalisation failed", (Resource)asResource);
            QVTcSerializeTests.assertValidationDiagnostics((String)"Pivot validation errors", (Resource)asResource, (String[])messages);
            ResourceSet resourceSet = ocl.getResourceSet();
            XtextResource xtextResource = AbstractTestQVT.as2cs((OCL)ocl, (ResourceSet)resourceSet, (ASResource)asResource, (URI)serializedInputURI, (String)"org.eclipse.qvtd.xtext.qvtcore");
            resourceSet.getResources().clear();
            XtextResource xtextResource2 = xtextResource;
            return xtextResource2;
        }
        finally {
            ocl.dispose();
            ocl = null;
        }
    }

    public void setUp() throws Exception {
        XtextCompilerUtil.doQVTcoreSetup();
        super.setUp();
    }

    public void testQVTcSerialize_Class2RDBMS() throws Exception {
        this.doSerializeRoundTripFromCS(this.getModelsURI("Class2RDBMS/Class2RDBMS.qvtc"));
    }

    public void testQVTcSerialize_HSV2HSL() throws Exception {
        this.doSerializeRoundTripFromCS(this.getModelsURI("hsv2hsl/HSV2HSL.qvtc"));
    }

    public void testQVTcSerialize_platformResource_BaseCS2AS() throws Exception {
        this.doSerializeRoundTripFromCS(this.getModelsURI("platformResource/org.eclipse.ocl.xtext.base/model/BaseCS2AS.qvtm.qvtc"));
    }
}

