/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.doc.minioclcs.xtext.tx;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.qvtd.doc.minioclcs.xtext.tx.Execution;
import org.eclipse.qvtd.doc.minioclcs.xtext.tx.ExecutionVisitor;
import org.eclipse.qvtd.doc.minioclcs.xtext.tx.Invocation;
import org.eclipse.qvtd.doc.minioclcs.xtext.tx.SlotState;

public abstract class AbstractSlotState
implements SlotState {
    @Override
    public <R> R accept(@NonNull ExecutionVisitor<R> visitor) {
        return visitor.visitSlotState(this);
    }

    public static abstract class Incremental
    extends AbstractSlotState
    implements SlotState.Incremental {
        public static final @NonNull List<@NonNull Execution.Incremental> EMPTY_EXECUTIONS_LIST = Collections.emptyList();
        public static final @NonNull List< @NonNull Invocation.Incremental> EMPTY_INVOCATIONS_LIST = Collections.emptyList();
        private Set< @NonNull Invocation.Incremental> sources = null;
        private Set<@NonNull Execution.Incremental> targets = null;

        @Override
        public void addSourceInternal( @NonNull Invocation.Incremental invocation) {
            if (this.sources == null) {
                this.sources = new HashSet<Invocation.Incremental>();
            }
            this.sources.add(invocation);
        }

        @Override
        public void addTargetInternal(@NonNull Execution.Incremental invocation) {
            if (this.targets == null) {
                this.targets = new HashSet<Execution.Incremental>();
            }
            this.targets.add(invocation);
        }

        @Override
        public @NonNull Iterable< @NonNull Invocation.Incremental> getSources() {
            return this.sources != null ? this.sources : EMPTY_INVOCATIONS_LIST;
        }

        @Override
        public @NonNull Iterable<@NonNull Execution.Incremental> getTargets() {
            return this.targets != null ? this.targets : EMPTY_EXECUTIONS_LIST;
        }

        protected void revokeTargets() {
            for (Execution.Incremental target : this.getTargets()) {
                target.revoke();
            }
        }
    }
}

