/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.merger;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.merger.Correlator;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.merger.EdgeMerger;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.merger.NodeMerger;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.MappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.RuleRegion;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

abstract class RegionMerger {
    protected final @NonNull ScheduleManager scheduleManager;
    private final @NonNull List<@NonNull MappingRegion> originalRegions = new ArrayList<MappingRegion>();
    protected final @NonNull Map<@NonNull Node, @NonNull NodeMerger> originalNode2nodeMerger = new HashMap<Node, NodeMerger>();
    private final @NonNull Map<@NonNull Edge, @NonNull EdgeMerger> originalEdge2edgeMerger = new HashMap<Edge, EdgeMerger>();
    private final @NonNull Map<@NonNull CompleteClass, @NonNull List<@NonNull NodeMerger>> completeClass2nodeMergers = new HashMap<CompleteClass, List<NodeMerger>>();
    private Set<@NonNull Edge> debugPrunedEdges = null;

    protected RegionMerger(@NonNull ScheduleManager scheduleManager, @NonNull MappingRegion primaryRegion) {
        this.scheduleManager = scheduleManager;
        this.originalRegions.add(primaryRegion);
        for (Node primaryNode : QVTscheduleUtil.getOwnedNodes((Region)primaryRegion)) {
            new NodeMerger(this, primaryNode);
        }
        for (Edge primaryEdge : QVTscheduleUtil.getOwnedEdges((Region)primaryRegion)) {
            if (primaryEdge.isSecondary()) continue;
            new EdgeMerger(this, primaryEdge);
        }
    }

    private void addPrunedEdge(@NonNull Edge prunedEdge) {
        Set<@NonNull Edge> debugPrunedEdges2 = this.debugPrunedEdges;
        if (debugPrunedEdges2 == null) {
            debugPrunedEdges2 = this.debugPrunedEdges = new HashSet<Edge>();
        }
        boolean wasAdded = debugPrunedEdges2.add(prunedEdge);
        assert (wasAdded);
    }

    protected void addSecondaryEdge(@NonNull Edge secondaryEdge) {
        NodeMerger targetNodeMerger;
        NodeMerger sourceNodeMerger = this.getNodeMerger(secondaryEdge.getEdgeSource());
        if (sourceNodeMerger != (targetNodeMerger = this.getNodeMerger(secondaryEdge.getEdgeTarget()))) {
            boolean isMerged = false;
            for (EdgeMerger edgeMerger : sourceNodeMerger.getOutgoingEdgeMergers(targetNodeMerger)) {
                if (edgeMerger.sameEdge(secondaryEdge) == null) continue;
                edgeMerger.addOriginalEdge(secondaryEdge);
                isMerged = true;
                break;
            }
            if (!isMerged) {
                new EdgeMerger(this, secondaryEdge);
            }
        } else {
            this.addPrunedEdge(secondaryEdge);
        }
    }

    public void addSecondaryRegion(@NonNull MappingRegion secondaryRegion, @NonNull Correlator correlator) {
        assert (correlator.getRegionMerger() == this);
        Map<@NonNull Node, @NonNull NodeMerger> node2nodeMerger = correlator.getNode2NodeMerger();
        assert (!this.originalRegions.contains(secondaryRegion));
        this.originalRegions.add(secondaryRegion);
        for (Node secondaryNode : QVTscheduleUtil.getOwnedNodes((Region)secondaryRegion)) {
            NodeMerger nodeMerger = node2nodeMerger.get(secondaryNode);
            if (nodeMerger != null) {
                nodeMerger.addOriginalNode(secondaryNode);
                continue;
            }
            new NodeMerger(this, secondaryNode);
        }
        for (Edge secondaryEdge : QVTscheduleUtil.getOwnedEdges((Region)secondaryRegion)) {
            if (secondaryEdge.isSecondary()) continue;
            this.addSecondaryEdge(secondaryEdge);
        }
    }

    public void check(@NonNull MappingRegion mergedRegion) {
        for (Region region : this.originalRegions) {
            this.checkNodes(mergedRegion, region);
        }
        for (Region region : this.originalRegions) {
            this.checkEdges(mergedRegion, region);
        }
    }

    protected void checkEdges(@NonNull MappingRegion mergedRegion, @NonNull Region originalRegion) {
        for (Edge originalEdge : QVTscheduleUtil.getOwnedEdges((Region)originalRegion)) {
            assert (originalEdge.getOwningRegion() == originalRegion);
            if (originalEdge.isRecursion() || originalEdge.isSecondary()) continue;
            EdgeMerger edgeMerger = this.originalEdge2edgeMerger.get(originalEdge);
            if (edgeMerger != null) {
                assert (Iterables.contains(edgeMerger.getOriginalEdges(), (Object)originalEdge));
                assert (edgeMerger.getMergedEdge().getOwningRegion() == mergedRegion);
                continue;
            }
            assert (this.debugPrunedEdges.contains(originalEdge));
        }
    }

    protected void checkNodes(@NonNull MappingRegion mergedRegion, @NonNull Region originalRegion) {
        for (Node originalNode : QVTscheduleUtil.getOwnedNodes((Region)originalRegion)) {
            assert (originalNode.getOwningRegion() == originalRegion);
            Node nodeMerger = this.getNodeMerger(originalNode).getMergedNode();
            assert (nodeMerger.getOwningRegion() == mergedRegion);
        }
    }

    public @NonNull MappingRegion create() {
        @NonNull String mergedName = this.createMergedName();
        MappingRegion mergedRegion = this.createMergedRegion(mergedName);
        this.createMergedNodes(mergedRegion);
        this.createMergedEdges();
        return mergedRegion;
    }

    protected @NonNull String createMergedName() {
        ArrayList<@NonNull String> names = new ArrayList<String>();
        for (MappingRegion originalRegion : this.originalRegions) {
            names.add(originalRegion.getName().replace("\u00bb\\n", "\u00bb "));
        }
        Collections.sort(names);
        StringBuilder s = new StringBuilder();
        for (String name : names) {
            if (s.length() > 0) {
                s.append("\\n");
            }
            s.append(name);
        }
        return s.toString();
    }

    protected void createMergedEdges() {
        for (EdgeMerger edgeMerger : new HashSet<EdgeMerger>(this.originalEdge2edgeMerger.values())) {
            Node sourceNodeMerger = this.getNodeMerger(edgeMerger.getOriginalSource()).getMergedNode();
            Node targetNodeMerger = this.getNodeMerger(edgeMerger.getOriginalTarget()).getMergedNode();
            edgeMerger.createMergedEdge(sourceNodeMerger, targetNodeMerger);
        }
    }

    protected void createMergedNodes(@NonNull MappingRegion mergedRegion) {
        for (NodeMerger nodeMerger : new HashSet<NodeMerger>(this.originalNode2nodeMerger.values())) {
            nodeMerger.createMergedNode(mergedRegion);
        }
    }

    protected abstract @NonNull MappingRegion createMergedRegion(@NonNull String var1);

    protected @Nullable EdgeMerger getEdgeMerger(@NonNull Edge originalEdge) {
        return this.originalEdge2edgeMerger.get(originalEdge);
    }

    protected @NonNull NodeMerger getNodeMerger(@NonNull Node originalNode) {
        return (NodeMerger)ClassUtil.nonNullState((Object)this.originalNode2nodeMerger.get(originalNode));
    }

    public @NonNull Map<@NonNull Node, @NonNull NodeMerger> getExtraNode2NodeMerger(@NonNull Map<@NonNull Node, @NonNull Node> extraNode2existingNode) {
        HashMap<@NonNull Node, @NonNull NodeMerger> node2nodeMerger = new HashMap<Node, NodeMerger>();
        for (Node extraNode : extraNode2existingNode.keySet()) {
            Node existingNode = extraNode2existingNode.get(extraNode);
            assert (existingNode != null);
            NodeMerger nodeMerger = this.originalNode2nodeMerger.get(existingNode);
            assert (nodeMerger != null);
            NodeMerger oldNodeMerger = node2nodeMerger.put(extraNode, nodeMerger);
            assert (oldNodeMerger == null || oldNodeMerger == nodeMerger);
        }
        return node2nodeMerger;
    }

    public @Nullable List<@NonNull NodeMerger> getNodeMergers(@NonNull CompleteClass completeClass) {
        return this.completeClass2nodeMergers.get(completeClass);
    }

    protected @NonNull List<@NonNull MappingRegion> getOriginalRegions() {
        return this.originalRegions;
    }

    public @NonNull MappingRegion getPrimaryRegion() {
        return this.originalRegions.get(0);
    }

    public boolean isAbstract() {
        MappingRegion primaryRegion = this.getPrimaryRegion();
        return primaryRegion instanceof RuleRegion && ((RuleRegion)primaryRegion).getReferredRule().isIsAbstract();
    }

    protected void mapOriginalEdge(@NonNull Edge originalEdge, @NonNull EdgeMerger edgeMerger) {
        EdgeMerger originalMergedEdge = this.originalEdge2edgeMerger.put(originalEdge, edgeMerger);
        assert (originalMergedEdge == null);
    }

    protected void mapOriginalNode(@NonNull Node originalNode, @NonNull NodeMerger nodeMerger) {
        NodeMerger originalMergedNode = this.originalNode2nodeMerger.put(originalNode, nodeMerger);
        assert (originalMergedNode == null);
        CompleteClass completeClass = originalNode.getCompleteClass();
        List<@NonNull NodeMerger> nodeMergers = this.completeClass2nodeMergers.get(completeClass);
        if (nodeMergers == null) {
            nodeMergers = new ArrayList<NodeMerger>();
            this.completeClass2nodeMergers.put(completeClass, nodeMergers);
        }
        if (!nodeMergers.contains(nodeMerger)) {
            nodeMergers.add(nodeMerger);
        }
    }

    public void prune() {
        ArrayList<@NonNull EdgeMerger> foldableEdgeMergers = new ArrayList<EdgeMerger>();
        for (NodeMerger nodeMerger : new HashSet<NodeMerger>(this.originalNode2nodeMerger.values())) {
            nodeMerger.gatherFoldableEdges(foldableEdgeMergers);
        }
        for (EdgeMerger foldableEdgeMerger : foldableEdgeMergers) {
            NodeMerger sourceNodeMerger = foldableEdgeMerger.getSource();
            NodeMerger targetNodeMerger = foldableEdgeMerger.getTarget();
            sourceNodeMerger.destroy();
            for (Node originalNode : sourceNodeMerger.getOriginalNodes()) {
                targetNodeMerger.addOriginalNode(originalNode);
                for (Edge originalEdge : QVTscheduleUtil.getIncomingEdges((Node)originalNode)) {
                    this.addSecondaryEdge(originalEdge);
                }
                for (Edge originalEdge : QVTscheduleUtil.getOutgoingEdges((Node)originalNode)) {
                    this.addSecondaryEdge(originalEdge);
                }
            }
        }
    }

    public String toString() {
        return this.createMergedName();
    }

    protected void unmapOriginalEdge(@NonNull Edge originalEdge, @NonNull EdgeMerger edgeMerger) {
        EdgeMerger originalEdgeMerger = this.originalEdge2edgeMerger.remove(originalEdge);
        assert (originalEdgeMerger == edgeMerger);
    }

    protected void unmapOriginalNode(@NonNull Node originalNode, @NonNull NodeMerger nodeMerger) {
        NodeMerger originalNodeMerger = this.originalNode2nodeMerger.remove(originalNode);
        assert (originalNodeMerger == nodeMerger);
    }
}

