/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.editor.ui.imp;

import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import lpg.runtime.ErrorToken;
import lpg.runtime.IPrsStream;
import lpg.runtime.IToken;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.imp.core.ErrorHandler;
import org.eclipse.imp.editor.ModelTreeNode;
import org.eclipse.imp.parser.ISourcePositionLocator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.lpg.AbstractLexer;
import org.eclipse.ocl.lpg.AbstractParser;
import org.eclipse.ocl.lpg.DerivedPrsStream;
import org.eclipse.qvt.declarative.editor.ui.imp.CommonParseController;
import org.eclipse.qvt.declarative.editor.ui.imp.ICommonKeyword;
import org.eclipse.qvt.declarative.editor.ui.imp.ICommonParseController;
import org.eclipse.qvt.declarative.editor.ui.imp.ICommonParseResult;
import org.eclipse.qvt.declarative.parser.environment.ICSTFileEnvironment;
import org.eclipse.qvt.declarative.parser.environment.ICSTRootEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonParseResult
implements ICommonParseResult {
    protected final CommonParseController parseController;
    protected final ICSTFileEnvironment fileEnvironment;
    protected ICSTRootEnvironment rootEnvironment;
    private CSTNode cst = null;
    private Resource ast = null;

    public CommonParseResult(CommonParseController parseController, ICSTFileEnvironment fileEnvironment) {
        this.parseController = parseController;
        this.fileEnvironment = fileEnvironment;
    }

    @Override
    public Resource getAST() {
        return this.ast;
    }

    @Override
    public Object getASTNode(Object object) {
        if (object instanceof ModelTreeNode) {
            object = ((ModelTreeNode)object).getASTNode();
        }
        if (object instanceof CSTNode) {
            object = ((CSTNode)object).getAst();
        }
        return object;
    }

    @Override
    public Object getASTorCSTNode(Object object) {
        if (object instanceof ModelTreeNode) {
            object = ((ModelTreeNode)object).getASTNode();
        }
        return object;
    }

    @Override
    public CSTNode getCST() {
        return this.cst;
    }

    @Override
    public CSTNode getCSTNode(Object object) {
        if (object instanceof ModelTreeNode) {
            object = ((ModelTreeNode)object).getASTNode();
        }
        return this.getRootEnvironment().getASTMapping(object);
    }

    public ICSTFileEnvironment getFileEnvironment() {
        return this.fileEnvironment;
    }

    @Override
    public String getTextRange(int start, int length) {
        return new String(this.getLexer().getILexStream().getInputChars(), start, length);
    }

    protected int[] getKeywordKinds() {
        return this.getLexer().getKeywordKinds();
    }

    @Override
    public List<ICommonKeyword> getKeywords() {
        return this.parseController.getKeywords();
    }

    public AbstractLexer getLexer() {
        return this.getParser().getLexer();
    }

    @Override
    public ICommonParseController getParseController() {
        return this.parseController;
    }

    @Override
    public AbstractParser getParser() {
        return this.fileEnvironment.getParser();
    }

    @Override
    public Collection<Resource> getResourcesVisibleAt(EObject astNode) {
        return this.fileEnvironment.getResourcesVisibleAt(astNode);
    }

    public ICSTRootEnvironment getRootEnvironment() {
        return this.rootEnvironment;
    }

    @Override
    public ISourcePositionLocator getSourcePositionLocator() {
        return this.parseController.getCreationFactory().createSourcePositionLocator(this.getRootEnvironment());
    }

    public Iterator<IToken> getTokenIterator(IRegion region) {
        int regionOffset = region.getOffset();
        int regionLength = region.getLength();
        int regionEnd = regionOffset + regionLength - 1;
        DerivedPrsStream stream = this.getParser().getIPrsStream();
        if (stream != null && stream.getStreamLength() > 0) {
            return new TokenIterator((IPrsStream)stream, regionEnd, regionOffset);
        }
        return new NullTokenIterator();
    }

    @Override
    public ICommonParseController.TokenKind getTokenKind(int kind) {
        return this.parseController.getTokenKind(kind);
    }

    @Override
    public boolean isCompleteable(int kind) {
        return this.parseController.isCompleteable(kind);
    }

    @Override
    public boolean isIdentifier(int kind) {
        return this.parseController.isIdentifier(kind);
    }

    @Override
    public boolean isKeyword(int kind) {
        return this.parseController.isKeyword(kind);
    }

    public ICSTRootEnvironment parse(Reader reader, IProgressMonitor progressMonitor) throws IOException, CoreException {
        this.rootEnvironment = this.fileEnvironment.parse(reader, this.fileEnvironment.getFile(), progressMonitor);
        if (this.rootEnvironment == null) {
            return null;
        }
        if (this.rootEnvironment.getCSTErrorTokens() <= 0) {
            this.rootEnvironment.validate();
        }
        this.cst = this.rootEnvironment.getCSTNode();
        this.ast = this.rootEnvironment.getASTNode();
        return this.rootEnvironment;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class NullTokenIterator
    implements Iterator<IToken> {
        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public IToken next() {
            return null;
        }

        @Override
        public void remove() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class TokenIterator
    implements Iterator<IToken> {
        final IPrsStream stream;
        final int firstTokIdx;
        final int lastTokIdx;
        int curTokIdx;
        IToken[][] precedingAdjuncts;
        int[] nextPrecedingAdjunct;
        IToken[] followingAdjuncts;
        int nextFollowingAdjunct;
        private boolean finalTokenReturned;
        private boolean finalAdjunctsReturned;

        private TokenIterator(IPrsStream stream, int regionEnd, int regionOffset) {
            this.stream = stream;
            this.firstTokIdx = this.getTokenIndexAtCharacter(regionOffset);
            this.curTokIdx = Math.max(1, this.firstTokIdx);
            int endIdx = this.getTokenIndexAtCharacter(regionEnd);
            char[] streamChars = stream.getInputChars();
            if (streamChars != null) {
                try {
                    if (1 <= regionEnd && regionEnd < streamChars.length && streamChars[regionEnd] == '\uffff') {
                        --endIdx;
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    ErrorHandler.logError((String)"SimpleLPGParseController.getTokenIterator(IRegion):  error initializing lastTokIdx", (Throwable)e);
                }
            }
            while (endIdx >= 0) {
                IToken lastToken = stream.getIToken(endIdx);
                if (!(lastToken instanceof ErrorToken)) break;
                --endIdx;
            }
            this.lastTokIdx = endIdx;
            this.precedingAdjuncts = new IToken[this.lastTokIdx + 1][];
            this.nextPrecedingAdjunct = new int[this.lastTokIdx + 1];
            int i = 0;
            while (i < this.precedingAdjuncts.length) {
                this.precedingAdjuncts[i] = stream.getPrecedingAdjuncts(i);
                ++i;
            }
            i = 0;
            while (i < this.nextPrecedingAdjunct.length) {
                this.nextPrecedingAdjunct[i] = this.precedingAdjuncts[i].length == 0 ? -1 : 0;
                ++i;
            }
            this.followingAdjuncts = this.lastTokIdx <= 0 ? new IToken[0] : stream.getFollowingAdjuncts(this.lastTokIdx);
            this.nextFollowingAdjunct = this.followingAdjuncts.length == 0 ? -1 : 0;
            this.finalTokenReturned = regionEnd < 1 || this.lastTokIdx <= 0;
            this.finalAdjunctsReturned = this.followingAdjuncts.length <= 0;
        }

        private int getTokenIndexAtCharacter(int offset) {
            int result = this.stream.getTokenIndexAtCharacter(offset);
            if (result < 0) {
                result = -result + 1;
            }
            if (result >= this.stream.getTokens().size()) {
                result = this.stream.getTokens().size() - 1;
            }
            return result;
        }

        @Override
        public boolean hasNext() {
            return !this.finalTokenReturned || !this.finalAdjunctsReturned;
        }

        @Override
        public IToken next() {
            int next = -1;
            if (this.curTokIdx <= this.lastTokIdx) {
                next = this.nextPrecedingAdjunct[this.curTokIdx];
                if (next >= 0 && next < this.precedingAdjuncts[this.curTokIdx].length) {
                    int n = this.curTokIdx;
                    int n2 = this.nextPrecedingAdjunct[n];
                    this.nextPrecedingAdjunct[n] = n2 + 1;
                    return this.precedingAdjuncts[this.curTokIdx][n2];
                }
                this.finalTokenReturned = this.curTokIdx >= this.lastTokIdx;
                return this.stream.getIToken(this.curTokIdx++);
            }
            if (this.nextFollowingAdjunct >= 0 && this.nextFollowingAdjunct < this.followingAdjuncts.length) {
                this.finalAdjunctsReturned = this.nextFollowingAdjunct + 1 >= this.followingAdjuncts.length;
                return this.followingAdjuncts[this.nextFollowingAdjunct++];
            }
            return null;
        }

        @Override
        public void remove() {
            throw new IllegalArgumentException("Unimplemented");
        }
    }
}

