/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.editor.ui.imp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lpg.runtime.ErrorToken;
import lpg.runtime.IToken;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.imp.parser.ISourcePositionLocator;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.cst.PathNameCS;
import org.eclipse.ocl.cst.SimpleNameCS;
import org.eclipse.ocl.expressions.StringLiteralExp;
import org.eclipse.ocl.lpg.AbstractParser;
import org.eclipse.ocl.lpg.DerivedPrsStream;
import org.eclipse.qvt.declarative.ecore.utils.EcoreUtils;
import org.eclipse.qvt.declarative.ecore.utils.TracingOption;
import org.eclipse.qvt.declarative.editor.ui.QVTEditorPlugin;
import org.eclipse.qvt.declarative.editor.ui.imp.CommonNonProposal;
import org.eclipse.qvt.declarative.editor.ui.imp.CommonProposal;
import org.eclipse.qvt.declarative.editor.ui.imp.ICommonKeyword;
import org.eclipse.qvt.declarative.editor.ui.imp.ICommonParseController;
import org.eclipse.qvt.declarative.editor.ui.imp.ICommonParseResult;
import org.eclipse.qvt.declarative.editor.ui.imp.ICommonProposal;
import org.eclipse.qvt.declarative.parser.environment.IHasName;
import org.eclipse.qvt.declarative.parser.qvt.cst.IdentifierCS;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonContentProposals {
    public static TracingOption proposalDebug = new TracingOption(QVTEditorPlugin.PLUGIN_ID, "proposal/debug");
    protected final ICommonParseResult parseResult;
    protected final int offset;
    protected final Map<Object, ICommonProposal> map;
    protected CSTNode cstRoot;
    protected IToken tokenAtOffset;
    protected String prefixAtOffset;

    public CommonContentProposals(ICommonParseResult parseResult, int offset) {
        this.parseResult = parseResult;
        this.offset = offset;
        this.map = new HashMap<Object, ICommonProposal>();
    }

    protected void addIdentifierProposalCandidate(Map<EClassifier, List<EStructuralFeature>> usages, EObject proposal, CSTNode cstNode) {
        if (this.checkName(usages, proposal, cstNode) && this.checkType(usages, proposal, cstNode) && !this.map.containsKey(proposal)) {
            ILabelProvider labelProvider = this.parseResult.getParseController().getLabelProvider();
            String newText = this.getProposalReplacementText(proposal);
            String displayText = this.getProposalDisplayText(labelProvider, proposal, newText);
            Image image = this.getProposalDisplayImage(labelProvider, proposal);
            String oldText = this.getTokenAtOffsetString();
            this.map.put(proposal, new CommonProposal(displayText, this.tokenAtOffset.getStartOffset(), newText, oldText, this.offset, image));
        }
    }

    protected void addIdentifierProposals(CSTNode cstNode) {
        Object astNode = this.getAst(cstNode);
        if (astNode == null) {
            this.map.put(null, new CommonNonProposal("Internal error: no AST node to select completion proposal for " + cstNode.getClass().getSimpleName(), "", this.offset));
            return;
        }
        if (proposalDebug.isActive()) {
            proposalDebug.println("Proposal for '" + this.prefixAtOffset + "' " + cstNode.getClass().getSimpleName() + " " + astNode.getClass().getSimpleName());
        }
        if (astNode instanceof EObject) {
            Map<EClassifier, List<EStructuralFeature>> usages = this.computeUsage((EObject)astNode);
            for (Resource resource : this.getResources(usages, (EObject)astNode)) {
                TreeIterator i = resource.getAllContents();
                while (i.hasNext()) {
                    this.addIdentifierProposalCandidate(usages, (EObject)i.next(), cstNode);
                }
            }
        }
    }

    protected void addIdentifierKeywordProposals(CSTNode cstNode) {
        for (ICommonKeyword keyword : this.parseResult.getKeywords()) {
            if (!keyword.isIdentifier(cstNode)) continue;
            String keywordText = keyword.getText();
            if (this.offset < this.tokenAtOffset.getStartOffset()) {
                this.map.put(keyword, new CommonProposal(keywordText, this.offset, keywordText, "", this.offset, null));
                continue;
            }
            if (!keywordText.startsWith(this.prefixAtOffset)) continue;
            this.map.put(keyword, new CommonProposal(keywordText, this.tokenAtOffset.getStartOffset(), keywordText, this.getTokenAtOffsetString(), this.offset, null));
        }
    }

    protected void addKeywordProposals() {
        for (ICommonKeyword keyword : this.parseResult.getKeywords()) {
            String keywordText = keyword.getText();
            if (this.offset < this.tokenAtOffset.getStartOffset()) {
                this.map.put(keyword, new CommonProposal(keywordText, this.offset, keywordText, "", this.offset, null));
                continue;
            }
            if (!keywordText.startsWith(this.prefixAtOffset)) continue;
            this.map.put(keyword, new CommonProposal(keywordText, this.tokenAtOffset.getStartOffset(), keywordText, this.getTokenAtOffsetString(), this.offset, null));
        }
    }

    protected void addStringProposals() {
        Collection<Resource> resources = this.parseResult.getResourcesVisibleAt(null);
        for (Resource resource : resources) {
            TreeIterator i = resource.getAllContents();
            while (i.hasNext()) {
                this.addStringProposalCandidate((EObject)i.next());
            }
        }
    }

    protected void addStringProposalCandidate(EObject candidate) {
        String string;
        if (candidate instanceof StringLiteralExp && !this.map.containsKey(string = ((StringLiteralExp)candidate).getStringSymbol()) && string.startsWith(this.prefixAtOffset.length() > 0 ? this.prefixAtOffset.substring(1) : "")) {
            String newText = "'" + string + "'";
            String displayText = string;
            Image image = null;
            this.map.put(string, new CommonProposal(displayText, this.tokenAtOffset.getStartOffset(), newText, this.getTokenAtOffsetString(), this.offset, image));
        }
    }

    protected void addUsage(Map<EClassifier, List<EStructuralFeature>> usages, EObject source, EStructuralFeature feature) {
        EClassifier type = EcoreUtils.getEType((EObject)source, (EStructuralFeature)feature);
        List<EStructuralFeature> usageList = usages.get(type);
        if (usageList == null) {
            usageList = new ArrayList<EStructuralFeature>();
            usages.put(type, usageList);
        }
        if (!usageList.contains(feature)) {
            usageList.add(feature);
        }
    }

    protected boolean checkName(Map<EClassifier, List<EStructuralFeature>> usages, EObject eObject, CSTNode cstNode) {
        String name = this.getName(eObject);
        if (name == null) {
            return false;
        }
        return name.startsWith(this.prefixAtOffset);
    }

    protected boolean checkType(Map<EClassifier, List<EStructuralFeature>> usages, EObject eObject, CSTNode cstNode) {
        if (usages.isEmpty()) {
            return false;
        }
        for (Map.Entry<EClassifier, List<EStructuralFeature>> requiredUsage : usages.entrySet()) {
            EClassifier requiredType = requiredUsage.getKey();
            Set<EClass> completableClasses = this.getCompletableTypes(requiredType, cstNode);
            if (completableClasses == null) {
                return false;
            }
            EClass eClass = eObject.eClass();
            boolean completable = false;
            for (EClass completableClass : completableClasses) {
                if (eClass != completableClass && !completableClass.isSuperTypeOf(eClass)) continue;
                completable = true;
                break;
            }
            if (completable) continue;
            return false;
        }
        return true;
    }

    public void computeProposals() {
        this.cstRoot = this.parseResult.getCST();
        if (this.cstRoot == null) {
            if (proposalDebug.isActive()) {
                proposalDebug.println("No CST");
            }
            this.map.put(null, new CommonNonProposal("no info available due to Syntax error(s)", "", this.offset));
            return;
        }
        this.tokenAtOffset = this.getToken();
        this.prefixAtOffset = this.getPrefix();
        ICommonParseController.TokenKind tokenKind = this.parseResult.getTokenKind(this.tokenAtOffset.getKind());
        switch (tokenKind) {
            case IDENTIFIER: {
                ISourcePositionLocator locator = this.parseResult.getSourcePositionLocator();
                CSTNode node = (CSTNode)locator.findNode((Object)this.cstRoot, this.tokenAtOffset.getStartOffset(), this.tokenAtOffset.getEndOffset());
                if (node == null) {
                    if (proposalDebug.isActive()) {
                        proposalDebug.println("No CST node");
                    }
                    this.map.put(null, new CommonNonProposal("no info available due to Syntax error(s)", "", this.offset));
                    break;
                }
                this.addIdentifierProposals(node);
                this.addIdentifierKeywordProposals(node);
                if (!this.map.isEmpty()) break;
                Object astNode = this.getAst(node);
                if (astNode != null) {
                    this.map.put(null, new CommonNonProposal("no completion exists for '" + this.prefixAtOffset + "' " + node.getClass().getSimpleName() + " " + astNode.getClass().getSimpleName(), "", this.offset));
                    break;
                }
                this.map.put(null, new CommonNonProposal("no completion exists for '" + this.prefixAtOffset + "' " + node.getClass().getSimpleName(), "", this.offset));
                break;
            }
            case ERROR: {
                ISourcePositionLocator locator = this.parseResult.getSourcePositionLocator();
                CSTNode node = (CSTNode)locator.findNode((Object)this.cstRoot, this.tokenAtOffset.getStartOffset(), this.tokenAtOffset.getEndOffset());
                this.addIdentifierProposals(node);
                this.addIdentifierKeywordProposals(node);
                this.addKeywordProposals();
                if (!this.map.isEmpty()) break;
                this.map.put(null, new CommonNonProposal("no completion exists for keyword: " + this.prefixAtOffset, "", this.offset));
                break;
            }
            case KEYWORD: {
                ISourcePositionLocator locator = this.parseResult.getSourcePositionLocator();
                CSTNode node = (CSTNode)locator.findNode((Object)this.cstRoot, this.tokenAtOffset.getStartOffset(), this.tokenAtOffset.getEndOffset());
                if (node instanceof IHasName || node instanceof SimpleNameCS) {
                    this.addIdentifierProposals(node);
                    this.addIdentifierKeywordProposals(node);
                } else {
                    this.addKeywordProposals();
                }
                if (!this.map.isEmpty()) break;
                this.map.put(null, new CommonNonProposal("no completion exists for keyword: " + this.prefixAtOffset, "", this.offset));
                break;
            }
            case STRING: {
                this.addStringProposals();
                if (!this.map.isEmpty()) break;
                this.map.put(null, new CommonNonProposal("no completion exists for string: " + this.prefixAtOffset, "", this.offset));
                break;
            }
            default: {
                this.map.put(null, new CommonNonProposal("no completion exists for " + (Object)((Object)tokenKind) + ": " + this.prefixAtOffset, "", this.offset));
            }
        }
    }

    protected Map<EClassifier, List<EStructuralFeature>> computeUsage(EObject astNode) {
        Resource resource;
        HashMap<EClassifier, List<EStructuralFeature>> usages = new HashMap<EClassifier, List<EStructuralFeature>>();
        Object rootAst = this.cstRoot.getAst();
        Resource resource2 = resource = rootAst instanceof Resource ? (Resource)rootAst : null;
        if (resource == null) {
            resource = astNode.eResource();
        }
        Collection settings = EcoreUtil.UsageCrossReferencer.find((EObject)astNode, (Resource)resource);
        for (EStructuralFeature.Setting setting : settings) {
            this.addUsage(usages, setting.getEObject(), setting.getEStructuralFeature());
        }
        EStructuralFeature containingFeature = astNode.eContainingFeature();
        if (containingFeature == null && astNode instanceof EPackage) {
            containingFeature = EcorePackage.Literals.EPACKAGE__ESUBPACKAGES;
        }
        if (containingFeature != null) {
            this.addUsage(usages, astNode.eContainer(), containingFeature);
        }
        return usages;
    }

    protected Object getAst(CSTNode cstNode) {
        if (cstNode == null) {
            return null;
        }
        Object astNode = cstNode.getAst();
        if (astNode == null && (cstNode instanceof IdentifierCS || cstNode instanceof SimpleNameCS || cstNode instanceof PathNameCS) && (astNode = ((CSTNode)cstNode.eContainer()).getAst()) != null && proposalDebug.isActive()) {
            proposalDebug.println("Missing astNode deduced for " + astNode.getClass().getSimpleName());
        }
        return astNode;
    }

    public Set<EClass> getCompletableTypes(EClassifier requiredType, CSTNode cstNode) {
        HashSet<EClass> completableClasses = new HashSet<EClass>();
        if (requiredType instanceof EClass) {
            completableClasses.add((EClass)requiredType);
        }
        return completableClasses;
    }

    protected String getName(EObject eObject) {
        if (eObject instanceof ENamedElement) {
            return ((ENamedElement)eObject).getName();
        }
        if (eObject instanceof IHasName) {
            return ((IHasName)eObject).getName();
        }
        return null;
    }

    protected String getPrefix() {
        if (this.parseResult.isCompleteable(this.tokenAtOffset.getKind()) && this.tokenAtOffset.getStartOffset() <= this.offset && this.offset <= this.tokenAtOffset.getEndOffset() + 1) {
            return this.getTokenAtOffsetString().substring(0, this.offset - this.tokenAtOffset.getStartOffset());
        }
        return "";
    }

    protected Image getProposalDisplayImage(ILabelProvider labelProvider, EObject proposal) {
        return labelProvider.getImage((Object)proposal);
    }

    protected String getProposalDisplayText(ILabelProvider labelProvider, EObject proposal, String newText) {
        EObject container = proposal.eContainer();
        String containerText = EcoreUtils.formatQualifiedName((Object)container, (String)"::");
        return String.valueOf(newText) + " - " + containerText;
    }

    protected String getProposalReplacementText(EObject proposal) {
        return EcoreUtils.formatName((Object)proposal);
    }

    protected Collection<Resource> getResources(Map<EClassifier, List<EStructuralFeature>> usages, EObject astNode) {
        return this.parseResult.getResourcesVisibleAt(astNode);
    }

    protected IToken getToken() {
        AbstractParser parser = this.parseResult.getParser();
        DerivedPrsStream stream = parser.getIPrsStream();
        ErrorToken errorToken = stream.getErrorTokenAtCharacter(this.offset);
        if (errorToken != null) {
            return errorToken;
        }
        int index = stream.getTokenIndexAtCharacter(this.offset);
        int tokenIndex = index < 0 ? -(index - 1) : index;
        IToken token = stream.getIToken(tokenIndex);
        int previousIndex = stream.getPrevious(tokenIndex);
        IToken previousToken = stream.getIToken(previousIndex);
        int previousIndexKind = previousToken.getKind();
        boolean isIdentifier = this.parseResult.isIdentifier(previousIndexKind);
        boolean isKeyword = this.parseResult.isKeyword(previousIndexKind);
        boolean atEnd = this.offset == previousToken.getEndOffset() + 1;
        return (isIdentifier || isKeyword) && atEnd ? previousToken : token;
    }

    protected String getTokenAtOffsetString() {
        return this.tokenAtOffset instanceof ErrorToken ? "" : this.tokenAtOffset.toString();
    }

    public ICompletionProposal[] sortProposals() {
        ArrayList<ICommonProposal> list = new ArrayList<ICommonProposal>(this.map.values());
        Collections.sort(list);
        return list.toArray(new ICommonProposal[list.size()]);
    }
}

