/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import com.google.common.collect.Iterables;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.RegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.RegionsAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.PartialRegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.PartialRegionClassAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.AbstractCyclicPartialRegionsAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TransformationPartitioner;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;

public class CyclicRegionsAnalysis
extends AbstractCyclicPartialRegionsAnalysis<RegionsAnalysis> {
    private final @NonNull Set<@NonNull RegionAnalysis> cyclicRegionAnalyses = new HashSet<RegionAnalysis>();
    private final @NonNull Set<@NonNull PartialRegionClassAnalysis<@NonNull RegionsAnalysis>> cyclicClassAnalyses = new HashSet<PartialRegionClassAnalysis<RegionsAnalysis>>();

    public CyclicRegionsAnalysis(@NonNull Iterable<@NonNull RegionAnalysis> regionAnalyses) {
        this.analyze(regionAnalyses);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void analyze(@NonNull Iterable<@NonNull RegionAnalysis> regionAnalyses) {
        Map<@NonNull PartialRegionAnalysis<@NonNull PRA>, @NonNull Set<@NonNull PartialRegionAnalysis<@NonNull PRA>>> partitioner2predecessors = CompilerUtil.computeTransitivePredecessors(regionAnalyses, TransformationPartitioner.REGION_IMMEDIATE_PREDECESSORS, TransformationPartitioner.REGION_TRANSITIVE_PREDECESSORS);
        Map<@NonNull PartialRegionAnalysis<@NonNull PRA>, @NonNull Set<@NonNull PartialRegionAnalysis<@NonNull PRA>>> partitioner2successors = CompilerUtil.computeTransitiveSuccessors(partitioner2predecessors, TransformationPartitioner.REGION_TRANSITIVE_SUCCESSORS);
        for (PartialRegionAnalysis partialRegionAnalysis : regionAnalyses) {
            HashSet<@NonNull @NonNull E> hashSet = new HashSet(partitioner2predecessors.get(partialRegionAnalysis));
            hashSet.retainAll(partitioner2successors.get(partialRegionAnalysis));
            for (PartialRegionAnalysis intersectingRegionAnalysis : hashSet) {
                this.cyclicRegionAnalyses.add((RegionAnalysis)intersectingRegionAnalysis);
            }
        }
        if (this.cyclicRegionAnalyses.isEmpty()) {
            return;
        }
        HashSet<@NonNull @NonNull E> hashSet = new HashSet();
        HashSet<@NonNull @NonNull E> superProducedClassAnalyses = new HashSet();
        for (PartialRegionAnalysis partialRegionAnalysis : this.cyclicRegionAnalyses) {
            Iterable superProducedClassAnalyses2;
            Iterable<@NonNull PartialRegionClassAnalysis<@NonNull PRA>> consumedClassAnalyses2 = partialRegionAnalysis.getConsumedClassAnalyses();
            if (consumedClassAnalyses2 != null) {
                Iterables.addAll(hashSet, consumedClassAnalyses2);
            }
            if ((superProducedClassAnalyses2 = partialRegionAnalysis.getSuperProducedClassAnalyses()) == null) continue;
            Iterables.addAll(superProducedClassAnalyses, superProducedClassAnalyses2);
        }
        this.cyclicClassAnalyses.addAll(hashSet);
        this.cyclicClassAnalyses.retainAll(superProducedClassAnalyses);
        if (TransformationPartitioner.REGION_CYCLES.isActive()) {
            this.showCycles(TransformationPartitioner.REGION_CYCLES, this.cyclicRegionAnalyses);
        }
    }

    public boolean isCyclic(@NonNull RegionAnalysis regionAnalysis) {
        return this.cyclicRegionAnalyses.contains(regionAnalysis);
    }

    public boolean isCyclic(@NonNull PartialRegionClassAnalysis<@NonNull RegionsAnalysis> classAnalysis) {
        assert (this.cyclicClassAnalyses != null);
        return this.cyclicClassAnalyses.contains(classAnalysis);
    }
}

