/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.xtext.qvtbase.tests;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.dynamic.JavaClasspath;
import org.eclipse.ocl.examples.codegen.dynamic.OCL2JavaFileObject;
import org.eclipse.ocl.examples.xtext.tests.TestProject;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.internal.manager.MetamodelManagerInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.messages.StatusCodes;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.resource.CSResource;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.qvtd.codegen.qvti.QVTiCodeGenOptions;
import org.eclipse.qvtd.codegen.qvti.java.QVTiCodeGenerator;
import org.eclipse.qvtd.compiler.AbstractCompilerChain;
import org.eclipse.qvtd.compiler.CompilerChain;
import org.eclipse.qvtd.compiler.CompilerOptions;
import org.eclipse.qvtd.compiler.DefaultCompilerOptions;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.RootPartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbase;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtimperative.EntryPoint;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeTransformation;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.BasicQVTiExecutor;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.Execution2GraphVisitor;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiIncrementalExecutor;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiTransformationExecutor;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperative;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperativeUtil;
import org.eclipse.qvtd.pivot.qvtschedule.Partition;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.RootRegion;
import org.eclipse.qvtd.pivot.qvtschedule.ScheduleModel;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;
import org.eclipse.qvtd.runtime.evaluation.ModeFactory;
import org.eclipse.qvtd.runtime.evaluation.TransformationExecutor;
import org.eclipse.qvtd.runtime.evaluation.Transformer;
import org.eclipse.qvtd.runtime.utilities.QVTruntimeUtil;
import org.eclipse.qvtd.xtext.qvtbase.tests.LoadTestCase;
import org.eclipse.qvtd.xtext.qvtbase.tests.ModelNormalizer;
import org.eclipse.xtext.resource.XtextResource;

public abstract class AbstractTestQVT
extends QVTimperative {
    protected final @NonNull URI testBundleURI;
    protected final @NonNull URI txURI;
    protected final @NonNull URI intermediateFileNamePrefixURI;
    protected final @NonNull URI srcFileURI;
    protected final @NonNull URI binFileURI;
    private final @NonNull JavaClasspath classpath;
    private final @NonNull Map<@NonNull Class<? extends Partition>, @NonNull Integer> partitionClass2count = new HashMap<Class<? extends Partition>, Integer>();
    protected AbstractCompilerChain compilerChain = null;
    private TransformationExecutor executor = null;
    private Set<@NonNull String> nsURIs = new HashSet<String>();
    private boolean suppressFailureDiagnosis = false;
    protected final @NonNull TestProject testProject;
    private Collection<@NonNull GenPackage> usedGenPackages = null;
    private Collection<@NonNull EPackage> loadedEPackages = null;
    private @Nullable String copyright = null;

    public static @NonNull XtextResource as2cs(@NonNull OCL ocl, @NonNull ResourceSet resourceSet, @NonNull ASResource asResource, @NonNull URI outputURI, String csContentType) throws IOException {
        XtextResource xtextResource = (XtextResource)ClassUtil.nonNullState((Object)((XtextResource)resourceSet.createResource(outputURI, csContentType)));
        ocl.as2cs(asResource, (CSResource)xtextResource);
        LoadTestCase.assertNoResourceErrors("Conversion failed", (Resource)xtextResource);
        URI savedURI = (URI)ClassUtil.nonNullState((Object)asResource.getURI());
        asResource.setURI(outputURI.trimFileExtension().trimFileExtension().appendFileExtension("oclas"));
        asResource.save(DefaultCompilerOptions.defaultSavingOptions);
        asResource.setURI(savedURI);
        try {
            LoadTestCase.assertNoDiagnosticErrors("Concrete Syntax validation failed", xtextResource);
            xtextResource.save(DefaultCompilerOptions.defaultSavingOptions);
        }
        catch (Throwable e) {
            e.printStackTrace();
            URI xmiURI = outputURI.appendFileExtension(".xmi");
            Resource xmiResource = resourceSet.createResource(xmiURI);
            xmiResource.getContents().addAll((Collection)ClassUtil.nullFree((EList)xtextResource.getContents()));
            xmiResource.save(DefaultCompilerOptions.defaultSavingOptions);
            if (e instanceof WrappedException) {
                e = ((WrappedException)e).getCause();
            }
            if (e instanceof Resource.IOWrappedException) {
                e = ((Resource.IOWrappedException)e).getCause();
            }
            LoadTestCase.fail((String)e.toString());
        }
        return xtextResource;
    }

    public static @NonNull ASResource loadQVTiAS(@NonNull OCL ocl, @NonNull URI inputURI) {
        Resource asResource = ocl.getMetamodelManager().getASResourceSet().getResource(inputURI, true);
        assert (asResource != null);
        LoadTestCase.assertNoResourceErrors("Load failed", asResource);
        return (ASResource)asResource;
    }

    public AbstractTestQVT(@NonNull ProjectManager projectManager, @NonNull TestProject testProject, @NonNull URI testBundleURI, @NonNull URI txURI, @NonNull URI intermediateFileNamePrefixURI, @NonNull URI srcFileURI, @NonNull URI binFileURI) throws IOException {
        super(new QVTiEnvironmentFactory(projectManager, null));
        assert (testBundleURI.isPlatform());
        this.testProject = testProject;
        this.testBundleURI = testBundleURI;
        this.txURI = txURI;
        this.intermediateFileNamePrefixURI = intermediateFileNamePrefixURI;
        this.srcFileURI = srcFileURI;
        this.binFileURI = binFileURI;
        this.classpath = CompilerUtil.createDefaultQVTiClasspath();
        this.classpath.addFile(testProject.getOutputFile("test-bin").getFile());
        assert (srcFileURI.isFile());
        assert (srcFileURI.hasAbsolutePath());
        assert (binFileURI.isFile());
        assert (binFileURI.hasAbsolutePath());
        this.getProjectManager().configureLoadFirst(this.getResourceSet(), "http://www.eclipse.org/emf/2002/Ecore");
    }

    public void addClasspathClass(@NonNull Class<?> classpathClass) {
        this.classpath.addClass(classpathClass);
    }

    public @Nullable Resource addInputURI(@NonNull String modelName, @NonNull URI modelURI) {
        return this.executor.addInputURI(modelName, modelURI);
    }

    public @NonNull Resource addOutputURI(@NonNull String modelName, @NonNull URI modelURI) {
        return this.executor.addOutputURI(modelName, modelURI);
    }

    public void addRegisteredPackage(@NonNull String ePackageClassName) throws Exception {
        Class<?> ePackageClass = Class.forName(ePackageClassName);
        Field instanceField = ePackageClass.getField("eINSTANCE");
        EPackage ePackage = (EPackage)instanceField.get(null);
        EPackage.Registry.INSTANCE.put((Object)ePackage.getNsURI(), (Object)ePackage);
    }

    public @NonNull GenPackage addUsedGenPackage(@NonNull String resourcePath, @Nullable String fragment) {
        if (this.usedGenPackages == null) {
            this.usedGenPackages = new ArrayList<GenPackage>();
        }
        GenPackage genPackage = CompilerUtil.getGenPackage((ResourceSet)this.getResourceSet(), (String)resourcePath, (String)fragment);
        this.usedGenPackages.add(genPackage);
        return genPackage;
    }

    public void assertRegionCount(@NonNull Class<? extends Region> partitionClass, int count) {
        QVTruntimeUtil.errPrintln((String)"assertRegionCount suppressed");
    }

    public @NonNull Class<? extends Transformer> buildTransformation(@NonNull String outputName, boolean isIncremental, String ... genModelFiles) throws Exception {
        CompilerOptions options = this.createBuildCompilerChainOptions(isIncremental);
        return this.doBuild(this.txURI, this.intermediateFileNamePrefixURI, Collections.singletonList(Collections.singletonList(outputName)), options, genModelFiles);
    }

    public @NonNull Class<? extends Transformer> buildTransformation(@NonNull Iterable<@NonNull Iterable<@NonNull String>> outputNamesList, boolean isIncremental, String ... genModelFiles) throws Exception {
        CompilerOptions options = this.createBuildCompilerChainOptions(isIncremental);
        return this.doBuild(this.txURI, this.intermediateFileNamePrefixURI, outputNamesList, options, genModelFiles);
    }

    public @NonNull Class<? extends Transformer> buildTransformation_486938(@NonNull String outputName, boolean isIncremental, String ... genModelFiles) throws Exception {
        CompilerOptions options = this.createBuildCompilerChainOptions(isIncremental);
        options.setOption("Java", CompilerChain.JAVA_EXTRA_PREFIX_KEY, (Object)"cg");
        return this.doBuild(this.txURI, this.intermediateFileNamePrefixURI, Collections.singletonList(Collections.singletonList(outputName)), options, genModelFiles);
    }

    protected void checkOutput(@NonNull Resource outputResource, @NonNull URI referenceModelURI, @Nullable ModelNormalizer normalizer) throws IOException, InterruptedException {
        Resource referenceResource = outputResource.getResourceSet().getResource(referenceModelURI, true);
        assert (referenceResource != null);
        if (normalizer != null) {
            assert (!referenceResource.getContents().isEmpty()) : referenceResource.getURI() + " has no contents";
            assert (!outputResource.getContents().isEmpty()) : outputResource.getURI() + " has no contents";
            normalizer.normalize(referenceResource);
            normalizer.normalize(outputResource);
        }
        LoadTestCase.assertSameModel(referenceResource, outputResource);
    }

    public @NonNull Resource checkOutput(@NonNull URI modelURI, @Nullable URI expectedURI, @Nullable ModelNormalizer normalizer) throws IOException, InterruptedException {
        ResourceSet resourceSet = PivotUtilInternal.isASURI((URI)modelURI) ? this.environmentFactory.getMetamodelManager().getASResourceSet() : this.getResourceSet();
        Resource outputResource = (Resource)ClassUtil.nonNullState((Object)resourceSet.getResource(modelURI, true));
        if (expectedURI != null) {
            this.checkOutput(outputResource, expectedURI, normalizer);
        }
        return outputResource;
    }

    public @NonNull ImperativeTransformation compileTransformation(@NonNull String outputName) throws Exception {
        return this.doCompile(this.txURI, this.intermediateFileNamePrefixURI, outputName, (CompilerOptions)this.createCompilerChainOptions());
    }

    protected @NonNull CompilerOptions createBuildCompilerChainOptions(boolean isIncremental) throws IOException {
        DefaultCompilerOptions compilerOptions = this.createCompilerChainOptions();
        compilerOptions.setGenerateClassesOptions(this.srcFileURI, this.binFileURI, this.createClassProjectNames(), isIncremental);
        if (this.generateGenModel()) {
            URI genModelURI = this.intermediateFileNamePrefixURI.appendFileExtension(AbstractCompilerChain.getDefaultFileExtension((String)"GenModel"));
            compilerOptions.setGenerateGenModelOptions(genModelURI, this.getBasePrefix(), this.copyright, this.usedGenPackages);
        }
        return compilerOptions;
    }

    protected @NonNull JavaClasspath createClassProjectNames() {
        this.classpath.addClass(((Object)((Object)this)).getClass());
        return this.classpath;
    }

    protected abstract @NonNull AbstractCompilerChain createCompilerChain(@NonNull URI var1, @NonNull URI var2, @NonNull CompilerOptions var3);

    protected @NonNull DefaultCompilerOptions createCompilerChainOptions() {
        DefaultCompilerOptions compilerOptions = this.createCompilerOptions();
        return compilerOptions;
    }

    protected @NonNull DefaultCompilerOptions createCompilerOptions() {
        DefaultCompilerOptions compilerOptions = new DefaultCompilerOptions();
        compilerOptions.setOption("default", CompilerChain.DEBUG_KEY, (Object)true);
        return compilerOptions;
    }

    public @NonNull Class<? extends Transformer> createGeneratedClass(@NonNull ImperativeTransformation iTransformation, String ... genModelFiles) throws Exception {
        ResourceSet resourceSet = this.getResourceSet();
        resourceSet.getPackageRegistry().put((Object)"http://www.eclipse.org/emf/2002/GenModel", (Object)GenModelPackage.eINSTANCE);
        this.loadGenModels(genModelFiles);
        QVTiCodeGenerator cg = new QVTiCodeGenerator((QVTbaseEnvironmentFactory)this.getEnvironmentFactory(), iTransformation);
        QVTiCodeGenOptions options = cg.getOptions();
        options.setUseNullAnnotations(true);
        this.setPackagePrefixOption(options);
        cg.generateClassFile();
        cg.saveSourceFile(String.valueOf(this.getJavaSourceURI().toString()) + "/");
        File explicitClassPath = new File(String.valueOf(this.getJavaClassURI().toString()) + "/");
        String qualifiedClassName = cg.getQualifiedName();
        String javaCodeSource = cg.generateClassFile();
        OCL2JavaFileObject.saveClass((String)((String)ClassUtil.nonNullState((Object)explicitClassPath.toString())), (String)qualifiedClassName, (String)javaCodeSource);
        Class txClass = OCL2JavaFileObject.loadExplicitClass((File)explicitClassPath, (String)qualifiedClassName);
        if (txClass == null) {
            TestCase.fail((String)"Failed to compile transformation");
            throw new UnsupportedOperationException();
        }
        return txClass;
    }

    public @NonNull QVTiTransformationExecutor createGeneratedExecutor(@NonNull Class<? extends Transformer> txClass) throws Exception {
        QVTiTransformationExecutor generatedExecutor = this.createGeneratedExecutor(this.getEnvironmentFactory(), txClass);
        this.executor = generatedExecutor;
        return generatedExecutor;
    }

    protected @NonNull QVTiTransformationExecutor createGeneratedExecutor(@NonNull QVTiEnvironmentFactory environmentFactory, @NonNull Class<? extends Transformer> txClass) throws ReflectiveOperationException {
        return new QVTiTransformationExecutor(environmentFactory, txClass);
    }

    public @NonNull BasicQVTiExecutor createInterpretedExecutor(@NonNull EntryPoint entryPoint) throws Exception {
        BasicQVTiExecutor interpretedExecutor = this.createInterpretedExecutor(this.getEnvironmentFactory(), entryPoint);
        this.executor = interpretedExecutor;
        return interpretedExecutor;
    }

    protected @NonNull BasicQVTiExecutor createInterpretedExecutor(@NonNull QVTiEnvironmentFactory environmentFactory, @NonNull EntryPoint entryPoint) throws Exception {
        return new QVTiIncrementalExecutor(environmentFactory, entryPoint, ModeFactory.LAZY);
    }

    public synchronized void dispose() {
        if (this.loadedEPackages != null) {
            for (EPackage ePackage : this.loadedEPackages) {
                EPackage.Registry.INSTANCE.remove((Object)ePackage.getNsURI());
            }
        }
        super.dispose();
        if (this.executor != null) {
            this.executor.dispose();
        }
        if (this.compilerChain != null) {
            this.compilerChain.dispose();
        }
        for (String nsURI : this.nsURIs) {
            EPackage.Registry.INSTANCE.remove((Object)nsURI);
        }
    }

    protected @NonNull Class<? extends Transformer> doBuild(@NonNull URI txURI, @NonNull URI intermediateFileNamePrefixURI, @NonNull Iterable<@NonNull Iterable<@NonNull String>> outputNamesList, @NonNull CompilerOptions options, String ... genModelFiles) throws IOException, Exception {
        this.compilerChain = this.createCompilerChain(txURI, intermediateFileNamePrefixURI, options);
        ImperativeTransformation asTransformation = this.compilerChain.compile(outputNamesList);
        URI asURI = asTransformation.eResource().getURI();
        if (asURI != null) {
            URI serializedURI = asURI.trimFileExtension().appendFileExtension("serialized.qvti");
            this.doSerialize(asURI, serializedURI);
        }
        return this.compilerChain.generate(asTransformation, genModelFiles);
    }

    protected @NonNull ImperativeTransformation doCompile(@NonNull URI txURI, @NonNull URI intermediateFileNamePrefixURI, @NonNull String outputName, @NonNull CompilerOptions options) throws Exception {
        this.compilerChain = this.createCompilerChain(txURI, intermediateFileNamePrefixURI, options);
        ImperativeTransformation transformation = this.compilerChain.compile(outputName);
        URI txASURI = transformation.eResource().getURI();
        if (txASURI != null) {
            URI inputURI = txASURI;
            URI serializedURI = txASURI.trimFileExtension().appendFileExtension("serialized.qvti");
            this.doSerialize(inputURI, serializedURI);
        }
        return transformation;
    }

    protected XtextResource doSerialize(@NonNull URI inputURI, @NonNull URI serializedURI) throws Exception {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        OCL ocl = QVTbase.newInstance((ProjectManager)this.getTestProjectManager());
        ocl.getEnvironmentFactory().setSeverity((Object)PivotPackage.Literals.VARIABLE___VALIDATE_COMPATIBLE_INITIALISER_TYPE__DIAGNOSTICCHAIN_MAP, StatusCodes.Severity.IGNORE);
        try {
            ASResource asResource = AbstractTestQVT.loadQVTiAS(ocl, inputURI);
            LoadTestCase.assertNoResourceErrors("Serializing to " + serializedURI, (Resource)asResource);
            LoadTestCase.assertNoUnresolvedProxies("Serializing to " + serializedURI, (Resource)asResource);
            XtextResource xtextResource = null;
            try {
                LoadTestCase.assertNoValidationErrors("Serializing to " + serializedURI, (Resource)asResource);
                xtextResource = AbstractTestQVT.as2cs(ocl, (ResourceSet)resourceSet, asResource, serializedURI, "org.eclipse.qvtd.xtext.qvtimperative");
                resourceSet.getResources().clear();
            }
            catch (AssertionFailedError e) {
                try {
                    AbstractTestQVT.as2cs(ocl, (ResourceSet)resourceSet, asResource, serializedURI, "org.eclipse.qvtd.xtext.qvtimperative");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw e;
            }
            QVTimperative qvti = QVTimperative.newInstance((ProjectManager)this.getTestProjectManager(), null);
            try {
                ImperativeTransformation asTransformation = QVTimperativeUtil.loadTransformation((QVTbaseEnvironmentFactory)qvti.getEnvironmentFactory(), (URI)serializedURI, (boolean)false);
                Resource asResource2 = asTransformation.eResource();
                assert (asResource2 != null);
                LoadTestCase.assertNoResourceErrors("Loading " + serializedURI, asResource2);
                LoadTestCase.assertNoUnresolvedProxies("Loading " + serializedURI, asResource2);
                LoadTestCase.assertNoValidationErrors("Loading " + serializedURI, asResource2);
            }
            finally {
                qvti.dispose();
                qvti = null;
            }
            XtextResource xtextResource2 = xtextResource;
            return xtextResource2;
        }
        finally {
            ocl.dispose();
            ocl = null;
        }
    }

    public boolean executeTransformation() throws Exception {
        Boolean success;
        if (this.suppressFailureDiagnosis) {
            this.executor.setSuppressFailureDiagnosis(true);
        }
        return (success = this.executor.execute(null)) == Boolean.TRUE;
    }

    public boolean executeTransformation(@NonNull String targetModelName) throws Exception {
        Integer typedModelIndex;
        Boolean success;
        if (this.suppressFailureDiagnosis) {
            this.executor.setSuppressFailureDiagnosis(true);
        }
        return (success = this.executor.execute(typedModelIndex = Integer.valueOf(this.executor.getTypedModelIndex(targetModelName)))) == Boolean.TRUE;
    }

    protected boolean generateGenModel() {
        return false;
    }

    protected abstract @NonNull String getBasePrefix();

    public @NonNull JavaClasspath getClasspath() {
        return this.classpath;
    }

    public @NonNull QVTiEnvironmentFactory getEnvironmentFactory() {
        return super.getEnvironmentFactory();
    }

    public @NonNull TransformationExecutor getExecutor() {
        return (TransformationExecutor)ClassUtil.nonNullState((Object)this.executor);
    }

    @Deprecated
    private @NonNull URI getJavaClassURI() {
        return this.testBundleURI.appendSegment("bin");
    }

    @Deprecated
    private @NonNull URI getJavaSourceURI() {
        return this.testBundleURI.appendSegment("test-gen");
    }

    public @NonNull Collection<@NonNull ? extends EObject> getRootEObjects(@NonNull String modelName) {
        return this.executor.getTypedModelInstance(modelName).getRootEObjects();
    }

    public @NonNull Map<Object, Object> getSaveOptions() {
        HashMap<Object, Object> saveOptions = new HashMap<Object, Object>(DefaultCompilerOptions.defaultSavingOptions);
        saveOptions.put("NORMALIZE_CONTENTS", Boolean.TRUE);
        return saveOptions;
    }

    protected @NonNull String getTestBundleName() {
        return this.testBundleURI.segment(1);
    }

    protected @NonNull ProjectManager getTestProjectManager() throws Exception {
        return ProjectManager.NO_PROJECTS;
    }

    public void installClassName(@NonNull String className) throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        Class<?> middleClass = Class.forName(className);
        Field middleField = middleClass.getDeclaredField("eINSTANCE");
        EPackage middleEPackage = (EPackage)middleField.get(null);
        this.getResourceSet().getPackageRegistry().put((Object)middleEPackage.getNsURI(), (Object)middleEPackage);
    }

    protected void instrumentPartition(@NonNull ScheduleManager scheduleManager) {
        ScheduleModel scheduleModel = scheduleManager.getScheduleModel();
        for (RootRegion rootRegion : QVTscheduleUtil.getOwnedRootRegions((ScheduleModel)scheduleModel)) {
            ScheduleManager directedScheduleManager = scheduleManager.getDirectedScheduleManager(rootRegion);
            RootPartitionAnalysis rootPartitionAnalysis = directedScheduleManager.getRootPartitionAnalysis(rootRegion);
            this.instrumentPartition(directedScheduleManager, rootPartitionAnalysis.getPartition());
        }
    }

    protected void instrumentPartition(@NonNull ScheduleManager directedScheduleManager, @NonNull Partition parentPartition) {
        Class<?> partitionClass;
        Integer count = this.partitionClass2count.get(partitionClass = parentPartition.getClass());
        this.partitionClass2count.put(partitionClass, count == null ? 1 : count + 1);
        for (Partition childPartition : directedScheduleManager.getConnectionManager().getCallableChildren(parentPartition)) {
            this.instrumentPartition(directedScheduleManager, childPartition);
        }
    }

    public void loadEPackage(@NonNull Class<?> txClass, @NonNull String qualifiedClassName) throws ClassNotFoundException, IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
        Class<?> ePackageClass = txClass.getClassLoader().loadClass(String.valueOf(this.getBasePrefix()) + "." + qualifiedClassName);
        EPackage ePackage = (EPackage)ePackageClass.getField("eINSTANCE").get(null);
        assert (ePackage != null);
        if (this.loadedEPackages == null) {
            this.loadedEPackages = new ArrayList<EPackage>();
        }
        this.loadedEPackages.add(ePackage);
    }

    public void loadEcoreFile(URI fileURI, EPackage ePackage) {
        ResourceSet rSet = this.getResourceSet();
        rSet.getPackageRegistry().put((Object)fileURI.toString(), (Object)ePackage);
        rSet.getPackageRegistry().put((Object)ePackage.getNsURI(), (Object)ePackage);
    }

    protected void loadGenModel(@NonNull URI genModelURI) {
        ResourceSet resourceSet = this.getResourceSet();
        MetamodelManagerInternal metamodelManager = this.getMetamodelManager();
        Resource csGenResource = resourceSet.getResource(genModelURI, true);
        for (EObject eObject : csGenResource.getContents()) {
            if (!(eObject instanceof GenModel)) continue;
            GenModel genModel = (GenModel)eObject;
            genModel.reconcile();
            metamodelManager.addGenModel(genModel);
        }
    }

    protected void loadGenModels(String ... genModelFiles) {
        URI primaryGenModelURI = this.compilerChain.getURI("GenModel", CompilerChain.URI_KEY);
        this.loadGenModel(primaryGenModelURI);
        String[] stringArray = genModelFiles;
        int n = genModelFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String genModelFile = stringArray[n2];
            URI genModelURI = URI.createURI((String)genModelFile).resolve(this.testBundleURI);
            this.loadGenModel(genModelURI);
            ++n2;
        }
    }

    public void loadGenModels(URI ... genModelURIs) {
        URI[] uRIArray = genModelURIs;
        int n = genModelURIs.length;
        int n2 = 0;
        while (n2 < n) {
            @NonNull URI genModelURI = uRIArray[n2];
            this.loadGenModel(genModelURI);
            ++n2;
        }
    }

    public void removeRegisteredPackage(@NonNull String ePackageClassName, boolean exceptionThrown) throws Exception {
        if (exceptionThrown) {
            try {
                Class<?> ePackageClass = Class.forName(ePackageClassName);
                Field eNsURIField = ePackageClass.getField("eNS_URI");
                String nsURI = String.valueOf(eNsURIField.get(null));
                EPackage.Registry.INSTANCE.remove((Object)nsURI);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            Class<?> ePackageClass = Class.forName(ePackageClassName);
            Field eNsURIField = ePackageClass.getField("eNS_URI");
            String nsURI = String.valueOf(eNsURIField.get(null));
            EPackage.Registry.INSTANCE.remove((Object)nsURI);
        }
    }

    public void removeRegisteredPackage(@NonNull Class<?> txClass, @NonNull String ePackageClassName, boolean exceptionThrown) throws Exception {
        if (exceptionThrown) {
            try {
                Class<?> ePackageClass = txClass.getClassLoader().loadClass(ePackageClassName);
                Field eNsURIField = ePackageClass.getField("eNS_URI");
                String nsURI = String.valueOf(eNsURIField.get(null));
                EPackage.Registry.INSTANCE.remove((Object)nsURI);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            Class<?> ePackageClass = Class.forName(ePackageClassName);
            Field eNsURIField = ePackageClass.getField("eNS_URI");
            String nsURI = String.valueOf(eNsURIField.get(null));
            EPackage.Registry.INSTANCE.remove((Object)nsURI);
        }
    }

    @Deprecated
    public void removeResources() {
        this.getExecutor().getModelsManager().removeResources();
    }

    public void saveModels(@Nullable Map<?, ?> saveOptions) throws IOException {
        this.getExecutor().getModelsManager().saveModels(saveOptions);
    }

    public void setCopyright(@Nullable String copyright) {
        this.copyright = copyright;
    }

    protected void setPackagePrefixOption(@NonNull QVTiCodeGenOptions options) {
    }

    public void setSuppressFailureDiagnosis(boolean suppressFailureDiagnosis) {
        this.suppressFailureDiagnosis = suppressFailureDiagnosis;
    }

    public void writeGraphMLfile(@NonNull URI graphURI) {
        Transformer transformer = ((QVTiTransformationExecutor)this.executor).getTransformer();
        Execution2GraphVisitor.writeGraphMLfile((Transformer)transformer, (URI)graphURI);
    }
}

