/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.atl.atl2qvtr.utilities;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.m2m.atl.common.ATL.Module;
import org.eclipse.m2m.atl.common.OCL.BooleanType;
import org.eclipse.m2m.atl.common.OCL.IntegerType;
import org.eclipse.m2m.atl.common.OCL.OclModel;
import org.eclipse.m2m.atl.common.OCL.OclModelElement;
import org.eclipse.m2m.atl.common.OCL.OclType;
import org.eclipse.m2m.atl.common.OCL.RealType;
import org.eclipse.m2m.atl.common.OCL.StringType;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.evaluation.Executor;

public class HelperUtils {
    public static @Nullable Package getPackage(@NonNull Executor executor, @NonNull Module atlModule, @NonNull String packageName) {
        for (String comment : atlModule.getCommentsBefore()) {
            String key;
            int index;
            String trimmedComment = comment.trim();
            if (!trimmedComment.startsWith("--")) continue;
            if ((trimmedComment = trimmedComment.substring(2).trim()).startsWith("@nsURI")) {
                index = (trimmedComment = trimmedComment.substring(6).trim()).indexOf("=");
                if (index < 0 || !(key = trimmedComment.substring(0, index).trim()).equals(packageName)) continue;
                String string = trimmedComment.substring(index + 1).trim();
                continue;
            }
            if (!trimmedComment.startsWith("@path") || (index = (trimmedComment = trimmedComment.substring(5).trim()).indexOf("=")) < 0 || !(key = trimmedComment.substring(0, index).trim()).equals(packageName)) continue;
            String value = trimmedComment.substring(index + 1).trim();
            URI uri = URI.createPlatformResourceURI((String)value, (boolean)true);
            if (!uri.hasFragment()) {
                uri = uri.appendFragment("/");
            }
            EObject eObject = executor.getEnvironmentFactory().getResourceSet().getEObject(uri, true);
            return (Package)executor.getEnvironmentFactory().getMetamodelManager().getASOfEcore(Package.class, eObject);
        }
        return null;
    }

    public static @Nullable Class getClass(@NonNull Executor executor, @NonNull Module atlModule, @NonNull String packageName, @NonNull String className) {
        Class asClass;
        @Nullable Package asPackage = HelperUtils.getPackage(executor, atlModule, packageName);
        if (asPackage != null && (asClass = asPackage.getOwnedClass(className)) != null) {
            return asClass;
        }
        return null;
    }

    public static @NonNull Class getType(@NonNull Executor executor, @NonNull OclType atlType) {
        StandardLibrary standardLibrary = executor.getStandardLibrary();
        if (atlType instanceof BooleanType) {
            return standardLibrary.getBooleanType();
        }
        if (atlType instanceof IntegerType) {
            return standardLibrary.getIntegerType();
        }
        if (atlType instanceof RealType) {
            return standardLibrary.getRealType();
        }
        if (atlType instanceof StringType) {
            return standardLibrary.getStringType();
        }
        if (atlType instanceof OclModelElement) {
            OclModelElement oclModelElement = (OclModelElement)atlType;
            OclModel metamodel = oclModelElement.getModel();
            Module atlModule = (Module)EcoreUtil.getRootContainer((EObject)oclModelElement);
            assert (atlModule != null);
            String packageName = metamodel.getName();
            assert (packageName != null);
            String className = oclModelElement.getName();
            assert (className != null);
            Class asClass = HelperUtils.getClass(executor, atlModule, packageName, className);
            if (asClass != null) {
                return asClass;
            }
            return standardLibrary.getOclInvalidType();
        }
        return standardLibrary.getOclInvalidType();
    }
}

