/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace;

import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.qvtd.compiler.CompilerChainException;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.HeadNodeGroup;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.trace.Element2MiddleProperty;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.InvocationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.QVTrelationNameGenerator;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.RelationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.AbstractRelationAnalysis2MiddleType;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.Invocation2TraceProperty;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.RelationAnalysis2TraceGroup;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.RelationAnalysis2TraceInterface;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.VariableDeclaration2TraceProperty;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtrelation.Relation;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelationUtil;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.RuleRegion;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class RelationAnalysis2TraceClass
extends AbstractRelationAnalysis2MiddleType {
    private @Nullable Map<@NonNull InvocationAnalysis, @NonNull Invocation2TraceProperty> invocationAnalysis2relation2traceProperty = null;
    private final @NonNull Map<@NonNull String, Element2MiddleProperty> name2element2traceProperty = new HashMap<String, Element2MiddleProperty>();

    public RelationAnalysis2TraceClass(@NonNull RelationAnalysis2TraceGroup relationAnalysis2traceGroup, @NonNull String middleClassName) {
        super(relationAnalysis2traceGroup, middleClassName);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void analyzePatternNodes(@NonNull List<@NonNull HeadNodeGroup> headNodeGroups) {
        boolean manyTracesPerHead = headNodeGroups.size() > 2;
        HashSet<@NonNull E> allHeadGroupNodes = new HashSet();
        for (HeadNodeGroup headNodeGroup : headNodeGroups) {
            Iterables.addAll(allHeadGroupNodes, headNodeGroup.getHeadNodes());
        }
        @NonNull List rootVariables = QVTrelationUtil.getRootVariables((Relation)this.relation);
        for (Node node : QVTscheduleUtil.getOwnedNodes(this.relationAnalysis.getRegion())) {
            VariableDeclaration2TraceProperty variableDeclaration2traceProperty;
            if (!node.isPattern() || !node.isMatched()) continue;
            boolean unitOpposite = allHeadGroupNodes.contains(node) && !manyTracesPerHead;
            TypedModel typedModel = QVTscheduleUtil.getTypedModel((Node)node);
            VariableDeclaration variable = node.basicGetOriginatingVariable();
            if (variable == null || rootVariables.contains(variable) || (variableDeclaration2traceProperty = this.basicGetVariableDeclaration2TraceProperty(variable)) != null) continue;
            this.createVariableDeclaration2TraceProperty(typedModel, variable, unitOpposite);
        }
    }

    @Override
    public void analyzeTraceElements(@NonNull List<@NonNull HeadNodeGroup> headNodeGroups) throws CompilerChainException {
        Iterable<InvocationAnalysis> outgoingWhenInvocationAnalyses;
        RelationAnalysis2TraceGroup baseRelationAnalysis2TraceGroup = this.relationAnalysis2traceGroup.getBaseRelationAnalysis2TraceGroup();
        RelationAnalysis2TraceInterface baseRelationAnalysis2traceInterface = baseRelationAnalysis2TraceGroup.basicGetRuleAnalysis2TraceInterface();
        if (baseRelationAnalysis2traceInterface != null) {
            this.middleClass.getSuperClasses().add(baseRelationAnalysis2traceInterface.getMiddleClass());
        } else {
            this.middleClass.getSuperClasses().add(this.getTransformation2TracePackage().getExecutionClass());
        }
        Iterable<@NonNull InvocationAnalysis> outgoingWhereInvocationAnalyses = this.getRuleAnalysis().basicGetOutgoingWhereInvocationAnalyses();
        if (outgoingWhereInvocationAnalyses != null) {
            for (InvocationAnalysis outgoingWhereInvocationAnalysis : outgoingWhereInvocationAnalyses) {
                this.createInvocation2TraceProperty(outgoingWhereInvocationAnalysis);
            }
        }
        if (this.relation.isIsTopLevel() && (outgoingWhenInvocationAnalyses = this.getRuleAnalysis().basicGetOutgoingWhenInvocationAnalyses()) != null) {
            for (InvocationAnalysis outgoingWhenInvocationAnalysis : outgoingWhenInvocationAnalyses) {
                this.createInvocation2TraceProperty(outgoingWhenInvocationAnalysis);
            }
        }
        if (!QVTrelationUtil.hasOverrides((Relation)this.relation)) {
            this.analyzeRootTemplateVariables(headNodeGroups);
        }
        this.analyzePatternNodes(headNodeGroups);
        this.analyzeGlobalSuccessNode(baseRelationAnalysis2traceInterface);
    }

    protected void analyzeGlobalSuccessNode(@Nullable RelationAnalysis2TraceInterface baseRelationAnalysis2traceInterface) {
        boolean hasTraceInterface = baseRelationAnalysis2traceInterface != null;
        boolean hasWhenInvocation = this.getRuleAnalysis().hasIncomingWhenInvocationAnalyses();
        if (hasTraceInterface) {
            return;
        }
        if (!hasWhenInvocation) {
            return;
        }
        if (!QVTrelationUtil.hasOverrides((Relation)this.relation)) {
            boolean hasPredicatedElement = false;
            RuleRegion region = (RuleRegion)this.getRuleAnalysis().getRegion();
            for (Node node : QVTscheduleUtil.getOwnedNodes((Region)region)) {
                if (!node.isPredicated()) continue;
                hasPredicatedElement = true;
                break;
            }
            if (!hasPredicatedElement) {
                for (Edge edge : QVTscheduleUtil.getOwnedEdges((Region)region)) {
                    if (!edge.isPredicated()) continue;
                    hasPredicatedElement = true;
                    break;
                }
            }
            if (!hasPredicatedElement) {
                return;
            }
        }
        QVTrelationNameGenerator nameGenerator = this.relationAnalysis2traceGroup.getNameGenerator();
        String globalSuccessPropertyName = nameGenerator.createTraceGlobalSuccessPropertyName();
        this.createRelation2GlobalSuccessProperty(globalSuccessPropertyName);
    }

    @Override
    public @Nullable Element2MiddleProperty basicGetRelation2GlobalSuccessProperty() {
        Element2MiddleProperty relation2SuccessProperty = super.basicGetRelation2GlobalSuccessProperty();
        if (relation2SuccessProperty != null) {
            return relation2SuccessProperty;
        }
        RelationAnalysis2TraceGroup baseRelationAnalysis2TraceGroup = this.relationAnalysis2traceGroup.getBaseRelationAnalysis2TraceGroup();
        RelationAnalysis2TraceInterface baseRelationAnalysis2traceInterface = baseRelationAnalysis2TraceGroup.basicGetRuleAnalysis2TraceInterface();
        if (baseRelationAnalysis2traceInterface != null) {
            return baseRelationAnalysis2traceInterface.basicGetRelation2GlobalSuccessProperty();
        }
        return null;
    }

    public @NonNull Invocation2TraceProperty createInvocation2TraceProperty(@NonNull InvocationAnalysis invocationAnalysis) {
        Map<@NonNull InvocationAnalysis, @NonNull Invocation2TraceProperty> invocationAnalysis2relation2traceProperty2 = this.invocationAnalysis2relation2traceProperty;
        if (invocationAnalysis2relation2traceProperty2 == null) {
            this.invocationAnalysis2relation2traceProperty = invocationAnalysis2relation2traceProperty2 = new HashMap<InvocationAnalysis, Invocation2TraceProperty>();
        }
        RelationAnalysis invokedRelationAnalysis = invocationAnalysis.getInvokedRelationAnalysis().getBaseRelationAnalysis();
        RelationAnalysis2TraceGroup invokedRule2TraceGroup = invokedRelationAnalysis.getRuleAnalysis2TraceGroup();
        String nameHint = this.relationAnalysis2traceGroup.getNameGenerator().createInvocationTraceProperty(invokedRelationAnalysis.getRule());
        Invocation2TraceProperty relation2traceProperty = new Invocation2TraceProperty(this, nameHint, invokedRule2TraceGroup.getInvocationClass());
        Invocation2TraceProperty oldRelation2traceProperty = invocationAnalysis2relation2traceProperty2.put(invocationAnalysis, relation2traceProperty);
        assert (oldRelation2traceProperty == null);
        return relation2traceProperty;
    }

    public @NonNull Property createProperty(@NonNull String name, @NonNull Type type) {
        String uniqueName = QVTrelationNameGenerator.getUniqueName(this.name2element2traceProperty.keySet(), name);
        Property property = PivotUtil.createProperty((String)uniqueName, (Type)type);
        return property;
    }

    @Override
    protected @NonNull String createTracePropertyName(@NonNull TypedModel typedModel, @NonNull VariableDeclaration variable) {
        return this.getTransformation2TracePackage().getNameGenerator().createTraceClassPropertyName(typedModel, variable);
    }

    public @NonNull Invocation2TraceProperty getInvocation2TraceProperty(@NonNull InvocationAnalysis invocationAnalysis) {
        return (Invocation2TraceProperty)ClassUtil.nonNullState((Object)((Invocation2TraceProperty)((Map)ClassUtil.nonNullState(this.invocationAnalysis2relation2traceProperty)).get(invocationAnalysis)));
    }

    @Override
    public @NonNull String getUniquePropertyName(@NonNull Element2MiddleProperty element2traceProperty, @NonNull String name) {
        return QVTrelationNameGenerator.getUniqueName(this.name2element2traceProperty, name, element2traceProperty);
    }

    protected void reservePropertyName(@NonNull String name) {
        assert (!this.name2element2traceProperty.containsKey(name));
        this.name2element2traceProperty.put(name, null);
    }

    @Override
    public void synthesizeTraceModel() {
        Map<@NonNull InvocationAnalysis, @NonNull Invocation2TraceProperty> incomingInvocationAnalysis2relation2traceProperty2 = this.invocationAnalysis2relation2traceProperty;
        if (incomingInvocationAnalysis2relation2traceProperty2 != null) {
            for (Invocation2TraceProperty relation2traceProperty : incomingInvocationAnalysis2relation2traceProperty2.values()) {
                relation2traceProperty.synthesizeTraceModel();
            }
        }
        super.synthesizeTraceModel();
    }
}

