/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.RegionUtil;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.AbstractPartition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.Partitioner;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Role;

class SpeculationPartition
extends AbstractPartition {
    public SpeculationPartition(@NonNull Partitioner partitioner) {
        super(partitioner);
        String name = partitioner.getRegion().getName();
        Node node = partitioner.getTraceNode();
        if (node != null && node.isPattern() && node.isClass()) {
            Role speculationNodeRole = RegionUtil.asSpeculation((Role)RegionUtil.getNodeRole((Node)node));
            this.addNode(node, speculationNodeRole);
            for (NavigableEdge edge : node.getNavigationEdges()) {
                this.addReachableConstantOrLoadedNodes(edge.getEdgeTarget());
            }
        }
        this.resolveComputations();
        this.resolvePredicates();
        this.resolveEdgeRoles();
    }

    protected void addReachableConstantOrLoadedNodes(@NonNull Node node) {
        if ((node.isConstant() || node.isLoaded()) && !this.hasNode(node)) {
            this.addNode(node, RegionUtil.getNodeRole((Node)node));
            for (NavigableEdge edge : node.getNavigationEdges()) {
                if (!edge.isConstant() && !edge.isLoaded()) continue;
                this.addReachableConstantOrLoadedNodes(edge.getEdgeTarget());
            }
        }
    }

    @Override
    protected boolean isComputable(@NonNull Set<@NonNull Node> sourceNodes, @NonNull Edge edge) {
        if (edge.isPredicated()) {
            return false;
        }
        if (edge.getEdgeTarget().isRealized()) {
            return false;
        }
        return super.isComputable(sourceNodes, edge);
    }

    @Override
    protected boolean resolveComputations(@NonNull Node targetNode) {
        if (targetNode.isConstant() || targetNode.isLoaded()) {
            return super.resolveComputations(targetNode);
        }
        return false;
    }

    @Override
    protected @Nullable Role resolveEdgeRole(@NonNull Role sourceNodeRole, @NonNull Edge edge, @NonNull Role targetNodeRole) {
        Role edgeRole = RegionUtil.getEdgeRole((Edge)edge);
        if (edgeRole == Role.REALIZED) assert (!this.partitioner.hasRealizedEdge(edge));
        return edgeRole;
    }
}

