/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtp2qvts;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.EdgeConnection;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.MergedEdge;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.MergedMappingRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.MergedNode;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.NavigationEdge;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.SchedulerConstants;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.GraphStringBuilder;

public class MergedNavigationEdge
extends MergedEdge
implements NavigationEdge {
    protected final @NonNull Property source2targetProperty;
    private @Nullable EdgeConnection incomingConnection = null;
    private @Nullable List<@NonNull EdgeConnection> outgoingConnections = null;

    public MergedNavigationEdge(@NonNull MergedMappingRegion mergedRegion, @NonNull MergedNode sourceNode, @NonNull NavigationEdge primaryEdge, @NonNull MergedNode targetNode) {
        super(mergedRegion, sourceNode, primaryEdge, targetNode);
        this.source2targetProperty = primaryEdge.getProperty();
    }

    @Override
    public final void addIncomingConnection(@NonNull EdgeConnection edgeConnection) {
        assert (this.incomingConnection == null);
        assert (Iterables.contains(edgeConnection.getTargetEdges(), (Object)this));
        this.incomingConnection = edgeConnection;
    }

    @Override
    public final void addOutgoingConnection(@NonNull EdgeConnection edgeConnection) {
        assert (Iterables.contains(edgeConnection.getSources(), (Object)this));
        List<@NonNull EdgeConnection> outgoingConnections2 = this.outgoingConnections;
        if (outgoingConnections2 == null) {
            this.outgoingConnections = outgoingConnections2 = new ArrayList<EdgeConnection>();
        } else assert (!outgoingConnections2.contains(edgeConnection));
        outgoingConnections2.add(edgeConnection);
    }

    @Override
    public @NonNull String getDisplayName() {
        return String.valueOf(this.source2targetProperty.getOwningClass().getName()) + "::" + this.source2targetProperty.getName();
    }

    @Override
    public final @Nullable EdgeConnection getIncomingConnection() {
        return this.incomingConnection;
    }

    @Override
    public @NonNull String getLabel() {
        return String.valueOf(this.getName()) + "\\n" + SchedulerConstants.getMultiplicity((TypedElement)this.source2targetProperty);
    }

    @Override
    public final @NonNull List<@NonNull EdgeConnection> getOutgoingConnections() {
        return this.outgoingConnections != null ? this.outgoingConnections : SchedulerConstants.EMPTY_EDGE_CONNECTION_LIST;
    }

    @Override
    public @NonNull Property getProperty() {
        return this.source2targetProperty;
    }

    @Override
    public final void removeIncomingConnection(@NonNull EdgeConnection edgeConnection) {
        assert (Iterables.contains(edgeConnection.getTargetEdges(), (Object)this));
        assert (this.incomingConnection != null);
        this.incomingConnection = null;
    }

    @Override
    public final void removeOutgoingConnection(@NonNull EdgeConnection edgeConnection) {
        assert (Iterables.contains(edgeConnection.getSources(), (Object)this));
        List<EdgeConnection> outgoingConnections2 = this.outgoingConnections;
        assert (outgoingConnections2 != null);
        boolean wasRemoved = outgoingConnections2.remove(edgeConnection);
        assert (wasRemoved);
    }

    @Override
    public void toGraph(@NonNull GraphStringBuilder s) {
        if (this.incomingConnection == null && this.outgoingConnections == null) {
            super.toGraph(s);
        } else {
            this.appendEdgeWithNode(s);
        }
    }
}

