/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtp2qvts;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.AbstractRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.BasicEdgeConnection;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.BasicNodeConnection;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.ClassDatumAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Connection;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.ConnectionRole;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.CyclicScheduledRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.EdgeConnection;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Edges;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.NavigationEdge;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Node;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.NodeConnection;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Region;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.ScheduledRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Scheduler;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.SchedulerConstants;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.SuperRegion;
import org.eclipse.qvtd.compiler.internal.qvts2qvti.QVTs2QVTiVisitor;
import org.eclipse.qvtd.compiler.internal.utilities.SymbolNameBuilder;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtcorebase.analysis.DomainUsage;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.GraphStringBuilder;

public abstract class AbstractScheduledRegion
extends AbstractRegion
implements ScheduledRegion {
    private final @NonNull List<@NonNull Region> regions = new ArrayList<Region>();
    private @NonNull List<@NonNull Connection> connections = new ArrayList<Connection>();
    private final @NonNull Map<@NonNull ClassDatumAnalysis, @NonNull Map<@NonNull Set<@NonNull Node>, @NonNull NodeConnection>> classDatumAnalysis2nodes2nodeConnections = new HashMap<ClassDatumAnalysis, Map<Set<Node>, NodeConnection>>();
    private final @NonNull Map<@NonNull Set<@NonNull NavigationEdge>, @NonNull EdgeConnection> edges2edgeConnection = new HashMap<Set<NavigationEdge>, EdgeConnection>();

    public AbstractScheduledRegion(@NonNull SuperRegion superRegion) {
        super(superRegion);
    }

    @Override
    public void addEdgeConnection(@NonNull EdgeConnection edgeConnection) {
        assert (!this.connections.contains(edgeConnection));
        this.connections.add(edgeConnection);
    }

    @Override
    public void addNodeConnection(@NonNull NodeConnection nodeConnection) {
        assert (!this.connections.contains(nodeConnection));
        this.connections.add(nodeConnection);
    }

    public void addRegion(@NonNull Region region) {
        assert (!this.regions.contains(region));
        if (this.regions.add(region)) {
            region.setInvokingRegion(this);
        }
    }

    @Override
    public @NonNull CyclicScheduledRegion createCyclicScheduledRegion(@NonNull Iterable<@NonNull Region> cycle) {
        for (Region region : cycle) {
            this.removeRegion(region);
        }
        CyclicScheduledRegion cyclicRegion = new CyclicScheduledRegion(this, cycle);
        this.addRegion(cyclicRegion);
        if (Scheduler.DEBUG_GRAPHS.isActive()) {
            cyclicRegion.writeDebugGraphs("3-cycle");
        }
        return cyclicRegion;
    }

    @Override
    public void createLocalSchedule() {
        this.splitConnectionVariables();
        if (Scheduler.DEBUG_GRAPHS.isActive()) {
            this.writeDebugGraphs("5-cycled", true, true, false);
        }
    }

    @Override
    public void createLocalSchedule2(@NonNull List<@NonNull Region> orderedRegions) {
        HashMap<@NonNull TypedModel, @NonNull Map<@NonNull Property, @NonNull List<@NonNull NavigationEdge>>> typedModel2property2predicatedEdges = new HashMap<TypedModel, Map<Property, List<NavigationEdge>>>();
        HashMap<@NonNull TypedModel, @NonNull Map<@NonNull Property, @NonNull List<@NonNull NavigationEdge>>> typedModel2property2realizedEdges = new HashMap<TypedModel, Map<Property, List<NavigationEdge>>>();
        for (Region region : orderedRegions) {
            QVTs2QVTiVisitor.POLLED_PROPERTIES.println("building indexes for " + region + " " + region.getIndexRangeText());
            region.buildPredicatedNavigationEdgesIndex(typedModel2property2predicatedEdges);
            region.buildRealizedNavigationEdgesIndex(typedModel2property2realizedEdges);
        }
        for (Region region : orderedRegions) {
            region.computeCheckedOrEnforcedEdges(typedModel2property2predicatedEdges, typedModel2property2realizedEdges);
        }
        if (Scheduler.DEBUG_GRAPHS.isActive()) {
            this.writeDebugGraphs("9-final", true, true, true);
        }
    }

    @Override
    public @NonNull NodeConnection getAttributeConnection(@NonNull Iterable<@NonNull Node> sourceNodes, @NonNull CompleteClass owningClass, @NonNull Property property, @NonNull ClassDatumAnalysis classDatumAnalysis) {
        HashSet sourceSet;
        NodeConnection connection;
        Map<@NonNull Set<@NonNull Node>, @NonNull NodeConnection> nodes2connection = this.classDatumAnalysis2nodes2nodeConnections.get(classDatumAnalysis);
        if (nodes2connection == null) {
            nodes2connection = new HashMap<Set<Node>, NodeConnection>();
            this.classDatumAnalysis2nodes2nodeConnections.put(classDatumAnalysis, nodes2connection);
        }
        if ((connection = nodes2connection.get(sourceSet = Sets.newHashSet(sourceNodes))) == null) {
            SymbolNameBuilder s = new SymbolNameBuilder();
            s.appendString("ja_");
            s.appendName(owningClass.getName());
            s.appendString("_");
            s.appendName(property.getName());
            connection = new BasicNodeConnection(this, sourceSet, s, classDatumAnalysis);
            nodes2connection.put(sourceSet, connection);
        }
        return connection;
    }

    @Override
    public @NonNull Iterable<@NonNull Region> getCallableRegions() {
        return Iterables.filter(this.getRegions(), (Predicate)AbstractRegion.IsCallableRegionPredicate.INSTANCE);
    }

    @Override
    public @NonNull Collection<@NonNull Connection> getConnections() {
        return this.connections;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public @NonNull EdgeConnection getEdgeConnection(@NonNull Iterable<@NonNull NavigationEdge> sourceEdges, @NonNull Property property) {
        @NonNull HashSet sourceSet = Sets.newHashSet(sourceEdges);
        EdgeConnection connection = this.edges2edgeConnection.get(sourceSet);
        if (connection == null) {
            SymbolNameBuilder s = new SymbolNameBuilder();
            s.appendString("je_");
            s.appendName(property.getOwningClass().getName());
            s.appendString("_");
            s.appendName(property.getName());
            connection = new BasicEdgeConnection(this, sourceSet, s, property);
            this.edges2edgeConnection.put(sourceSet, connection);
        }
        return connection;
    }

    @Override
    public @NonNull Iterable<@NonNull EdgeConnection> getEdgeConnections() {
        return Iterables.filter(this.connections, EdgeConnection.class);
    }

    @Override
    public @NonNull NodeConnection getNodeConnection(@NonNull Iterable<@NonNull Node> sourceNodes, @NonNull ClassDatumAnalysis classDatumAnalysis) {
        HashSet sourceSet;
        NodeConnection connection;
        Map<@NonNull Set<@NonNull Node>, @NonNull NodeConnection> nodes2connection = this.classDatumAnalysis2nodes2nodeConnections.get(classDatumAnalysis);
        if (nodes2connection == null) {
            nodes2connection = new HashMap<Set<Node>, NodeConnection>();
            this.classDatumAnalysis2nodes2nodeConnections.put(classDatumAnalysis, nodes2connection);
        }
        if ((connection = nodes2connection.get(sourceSet = Sets.newHashSet(sourceNodes))) == null) {
            DomainUsage domainUsage = classDatumAnalysis.getDomainUsage();
            SymbolNameBuilder s = new SymbolNameBuilder();
            s.appendString("j");
            s.appendString(domainUsage.isInput() ? "i" : (domainUsage.isOutput() ? "o" : "m"));
            s.appendString("_");
            s.appendName(classDatumAnalysis.getCompleteClass().getName());
            connection = new BasicNodeConnection(this, sourceSet, s, classDatumAnalysis);
            nodes2connection.put(sourceSet, connection);
        }
        return connection;
    }

    @Override
    public @NonNull Iterable<@NonNull NodeConnection> getNodeConnections() {
        return Iterables.filter(this.connections, NodeConnection.class);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public @Nullable Region getNormalizedRegion(@NonNull Region region) {
        if (region != this) ** GOTO lbl6
        return null;
lbl-1000:
        // 1 sources

        {
            if (invokingRegion == this) {
                return region;
            }
            region = invokingRegion;
lbl6:
            // 2 sources

            ** while ((invokingRegion = region.getInvokingRegion()) != null)
        }
lbl7:
        // 1 sources

        return null;
    }

    @Override
    public @NonNull List<@NonNull Region> getRegions() {
        return this.regions;
    }

    @Override
    public void removeConnection(@NonNull Connection connection) {
        block6: {
            block5: {
                boolean wasRemoved = this.connections.remove(connection);
                assert (wasRemoved);
                if (!(connection instanceof NodeConnection)) break block5;
                NodeConnection nodeConnection = (NodeConnection)connection;
                for (Node targetNode : nodeConnection.getTargetNodes()) {
                    targetNode.removeIncomingConnection(nodeConnection);
                }
                for (Node sourceNode : nodeConnection.getSources()) {
                    sourceNode.removeOutgoingConnection(nodeConnection);
                }
                break block6;
            }
            if (!(connection instanceof EdgeConnection)) break block6;
            EdgeConnection edgeConnection = (EdgeConnection)connection;
            for (NavigationEdge targetEdge : edgeConnection.getTargetEdges()) {
                targetEdge.removeIncomingConnection(edgeConnection);
            }
            for (NavigationEdge sourceEdge : edgeConnection.getSources()) {
                sourceEdge.removeOutgoingConnection(edgeConnection);
            }
        }
    }

    protected void removeRegion(@NonNull Region region) {
        this.regions.remove(region);
    }

    @Override
    public void replaceSources(@NonNull NodeConnection connection, @NonNull Set<@NonNull Node> obsoleteSourceNodes, @NonNull Node newSourceNode) {
        ClassDatumAnalysis classDatumAnalysis = connection.getClassDatumAnalysis();
        Map<@NonNull Set<@NonNull Node>, NodeConnection> nodes2connections = this.classDatumAnalysis2nodes2nodeConnections.get(classDatumAnalysis);
        assert (nodes2connections != null);
        HashSet<@NonNull Node> newSourceNodes = new HashSet<Node>();
        Iterables.addAll(newSourceNodes, connection.getSources());
        NodeConnection oldConnection = nodes2connections.remove(newSourceNodes);
        assert (oldConnection == connection);
        newSourceNodes.removeAll(obsoleteSourceNodes);
        newSourceNodes.add(newSourceNode);
        NodeConnection newConnection = this.getNodeConnection(newSourceNodes, classDatumAnalysis);
        for (Node targetNode : connection.getTargetNodes()) {
            ConnectionRole connectionRole = connection.getConnectionRole(targetNode);
            if (connectionRole.isPassed()) {
                newConnection.addPassedTargetNode(targetNode);
                continue;
            }
            newConnection.addUsedTargetNode(targetNode, false);
        }
        this.removeConnection(connection);
    }

    protected void splitConnectionVariables() {
        for (NodeConnection connection : this.getNodeConnections()) {
            if (!connection.isPassed()) continue;
            HashSet<@NonNull Region> loopRegions = null;
            for (Region sourceRegion : connection.getSourceRegions()) {
                if (sourceRegion.isChildCompositionRegion()) continue;
                for (Region targetRegion : connection.getTargetRegions()) {
                    if (sourceRegion != targetRegion) continue;
                    if (loopRegions == null) {
                        loopRegions = new HashSet<Region>();
                    }
                    loopRegions.add(sourceRegion);
                }
            }
            if (loopRegions == null) continue;
            ClassDatumAnalysis classDatumAnalysis = connection.getClassDatumAnalysis();
            ArrayList allSourceNodes = new ArrayList();
            Iterables.addAll(allSourceNodes, connection.getSources());
            for (Region loopRegion : loopRegions) {
                Node sourceNode = connection.getSource(loopRegion);
                Node targetNode = connection.getTarget(loopRegion);
                targetNode.removeIncomingConnection(connection);
                connection.removeTarget(targetNode);
                HashSet<Node> selectedSourceNodes = new HashSet<Node>(allSourceNodes);
                selectedSourceNodes.remove(sourceNode);
                NodeConnection loopConection = this.getNodeConnection(selectedSourceNodes, classDatumAnalysis);
                loopConection.addPassedTargetNode(targetNode);
                Edges.PRIMARY_RECURSION.createEdge(loopRegion, sourceNode, targetNode);
            }
        }
    }

    @Override
    public void toRegionGraph(@NonNull GraphStringBuilder s) {
        s.setLabel(this.getName());
        s.pushCluster();
        for (Region region : this.getCallableRegions()) {
            s.appendNode((GraphStringBuilder.GraphNode)region);
        }
        for (Node node : this.getNodes()) {
            s.appendNode((GraphStringBuilder.GraphNode)node);
        }
        for (Connection connection : this.getConnections()) {
            connection.toRegionGraph(this, s);
        }
        s.popCluster();
    }

    @Override
    public void writeDebugGraphs(@NonNull String context, boolean doNodesGraph, boolean doRegionGraph, boolean doCallGraph) {
        SchedulerConstants scheduler = this.getSchedulerConstants();
        if (doNodesGraph) {
            this.writeDebugGraphs(context);
        }
        if (doRegionGraph) {
            scheduler.writeRegionDOTfile(this, "-r-" + context);
            scheduler.writeRegionGraphMLfile(this, "-r-" + context);
        }
        if (doCallGraph) {
            scheduler.writeCallDOTfile(this, "-c-" + context);
            scheduler.writeCallGraphMLfile(this, "-c-" + context);
        }
    }
}

