/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.codegen.qvti.java;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.analyzer.AnalysisVisitor;
import org.eclipse.ocl.examples.codegen.analyzer.BoxingAnalyzer;
import org.eclipse.ocl.examples.codegen.analyzer.DependencyVisitor;
import org.eclipse.ocl.examples.codegen.analyzer.FieldingAnalyzer;
import org.eclipse.ocl.examples.codegen.analyzer.ReferencesVisitor;
import org.eclipse.ocl.examples.codegen.cgmodel.CGElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGModelFactory;
import org.eclipse.ocl.examples.codegen.cgmodel.CGNamedElement;
import org.eclipse.ocl.examples.codegen.cgmodel.CGPackage;
import org.eclipse.ocl.examples.codegen.cgmodel.CGValuedElement;
import org.eclipse.ocl.examples.codegen.java.CG2JavaPreVisitor;
import org.eclipse.ocl.examples.codegen.java.ImportUtils;
import org.eclipse.ocl.examples.codegen.java.JavaCodeGenerator;
import org.eclipse.ocl.examples.codegen.utilities.CGModelResourceFactory;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.codegen.qvti.QVTiCodeGenOptions;
import org.eclipse.qvtd.codegen.qvti.analyzer.QVTiAS2CGVisitor;
import org.eclipse.qvtd.codegen.qvti.analyzer.QVTiAnalysisVisitor;
import org.eclipse.qvtd.codegen.qvti.analyzer.QVTiAnalyzer;
import org.eclipse.qvtd.codegen.qvti.analyzer.QVTiBoxingAnalyzer;
import org.eclipse.qvtd.codegen.qvti.analyzer.QVTiCG2StringVisitor;
import org.eclipse.qvtd.codegen.qvti.analyzer.QVTiDependencyVisitor;
import org.eclipse.qvtd.codegen.qvti.analyzer.QVTiFieldingAnalyzer;
import org.eclipse.qvtd.codegen.qvti.analyzer.QVTiReferencesVisitor;
import org.eclipse.qvtd.codegen.qvti.java.QVTiCG2JavaPreVisitor;
import org.eclipse.qvtd.codegen.qvti.java.QVTiCG2JavaVisitor;
import org.eclipse.qvtd.codegen.qvti.java.QVTiGlobalContext;
import org.eclipse.qvtd.codegen.qvticgmodel.CGTransformation;
import org.eclipse.qvtd.codegen.utilities.QVTiCGModelResourceFactory;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiTransformationAnalysis;

public class QVTiCodeGenerator
extends JavaCodeGenerator {
    @NonNull
    protected final QVTiAnalyzer cgAnalyzer;
    @NonNull
    protected final Transformation transformation;
    private String javaSourceCode = null;
    @NonNull
    protected final QVTiGlobalContext globalContext = new QVTiGlobalContext(this);
    @NonNull
    protected final Map<Transformation, QVTiTransformationAnalysis> transformation2analysis = new HashMap<Transformation, QVTiTransformationAnalysis>();

    public QVTiCodeGenerator(@NonNull QVTiEnvironmentFactory environmentFactory, @NonNull Transformation transformation) {
        super((EnvironmentFactoryInternal)environmentFactory);
        QVTiCG2StringVisitor.FACTORY.getClass();
        this.cgAnalyzer = new QVTiAnalyzer(this);
        this.transformation = transformation;
    }

    @NonNull
    public AnalysisVisitor createAnalysisVisitor() {
        return new QVTiAnalysisVisitor(this.cgAnalyzer);
    }

    @NonNull
    public BoxingAnalyzer createBoxingAnalyzer() {
        return new QVTiBoxingAnalyzer(this.cgAnalyzer);
    }

    @NonNull
    public CG2JavaPreVisitor createCG2JavaPreVisitor() {
        return new QVTiCG2JavaPreVisitor(this.getGlobalContext());
    }

    @NonNull
    protected QVTiCG2JavaVisitor createCG2JavaVisitor(@NonNull CGPackage cgPackage, @Nullable List<CGValuedElement> sortedGlobals) {
        return new QVTiCG2JavaVisitor(this, cgPackage, sortedGlobals);
    }

    @NonNull
    protected CGPackage createCGPackage() {
        String packagePrefix = this.getOptions().getPackagePrefix();
        CGPackage cgPackage = CGModelFactory.eINSTANCE.createCGPackage();
        cgPackage.setName(packagePrefix);
        QVTiAS2CGVisitor pivot2CGVisitor = this.createAS2CGVisitor(this.cgAnalyzer, this.getGlobalContext());
        CGTransformation cgTransformation = (CGTransformation)ClassUtil.nonNullState((Object)((CGNamedElement)this.transformation.accept((Visitor)pivot2CGVisitor)));
        cgPackage.getClasses().add(cgTransformation);
        return cgPackage;
    }

    @NonNull
    protected QVTiAS2CGVisitor createAS2CGVisitor(@NonNull QVTiAnalyzer analyzer, @NonNull QVTiGlobalContext gContext) {
        return new QVTiAS2CGVisitor(analyzer, gContext);
    }

    @NonNull
    public CGModelResourceFactory getCGResourceFactory() {
        return QVTiCGModelResourceFactory.INSTANCE;
    }

    @NonNull
    public DependencyVisitor createDependencyVisitor() {
        return new QVTiDependencyVisitor(this.cgAnalyzer, this.getGlobalContext(), this.getGlobalPlace());
    }

    @NonNull
    public FieldingAnalyzer createFieldingAnalyzer() {
        return new QVTiFieldingAnalyzer(this.cgAnalyzer);
    }

    @NonNull
    protected QVTiCodeGenOptions createOptions() {
        return new QVTiCodeGenOptions();
    }

    @NonNull
    public ReferencesVisitor createReferencesVisitor() {
        return QVTiReferencesVisitor.INSTANCE;
    }

    @NonNull
    public String generateClassFile() {
        String javaSourceCode2 = this.javaSourceCode;
        if (javaSourceCode2 == null) {
            CGPackage cgPackage = this.createCGPackage();
            this.optimize(cgPackage);
            List sortedGlobals = this.prepareGlobals();
            QVTiCG2JavaVisitor generator = this.createCG2JavaVisitor(cgPackage, sortedGlobals);
            generator.safeVisit((CGElement)cgPackage);
            Set<String> allImports = generator.getAllImports();
            Map long2ShortImportNames = ImportUtils.getLong2ShortImportNames(allImports);
            this.javaSourceCode = javaSourceCode2 = ImportUtils.resolveImports((String)generator.toString(), (Map)long2ShortImportNames);
        }
        return javaSourceCode2;
    }

    @NonNull
    public QVTiAnalyzer getAnalyzer() {
        return this.cgAnalyzer;
    }

    @NonNull
    public QVTiGlobalContext getGlobalContext() {
        return this.globalContext;
    }

    @NonNull
    public QVTiCodeGenOptions getOptions() {
        return (QVTiCodeGenOptions)super.getOptions();
    }

    @NonNull
    public String getQualifiedName() {
        String className = (String)ClassUtil.nonNullState((Object)this.transformation.getName());
        String packagePrefix = this.getOptions().getPackagePrefix();
        if (packagePrefix != null) {
            return String.valueOf(packagePrefix) + "." + className;
        }
        return className;
    }

    @NonNull
    public QVTiTransformationAnalysis getTransformationAnalysis(@NonNull Transformation transformation) {
        QVTiTransformationAnalysis transformationAnalysis = this.transformation2analysis.get(transformation);
        if (transformationAnalysis == null) {
            transformationAnalysis = new QVTiTransformationAnalysis(this.getEnvironmentFactory());
            transformationAnalysis.analyzeTransformation(transformation);
            this.transformation2analysis.put(transformation, transformationAnalysis);
        }
        return transformationAnalysis;
    }

    public void saveSourceFile(@NonNull String savePath) throws IOException {
        String javaCodeSource = this.generateClassFile();
        String qualifiedName = this.getQualifiedName();
        String saveDir = String.valueOf(savePath) + qualifiedName.replace('.', '/');
        String fileName = String.valueOf(saveDir) + ".java";
        new File(saveDir).getParentFile().mkdirs();
        FileWriter writer = new FileWriter(fileName);
        ((Writer)writer).append(javaCodeSource);
        ((Writer)writer).close();
    }
}

