/*******************************************************************************
 * Copyright (c) 2014 E.D.Willink and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     E.D.Willink - initial API and implementation
 *******************************************************************************/
/*
* generated by Xtext
*/
package org.eclipse.qvtd.xtext.qvtrelation.parseTreeConstruction;

import org.eclipse.emf.ecore.*;
import org.eclipse.xtext.*;
import org.eclipse.xtext.parsetree.reconstr.IEObjectConsumer;

import org.eclipse.qvtd.xtext.qvtrelation.services.QVTrelationGrammarAccess;

import com.google.inject.Inject;

@SuppressWarnings("all")
public class QVTrelationParsetreeConstructor extends org.eclipse.xtext.parsetree.reconstr.impl.AbstractParseTreeConstructor {
		
	@Inject
	private QVTrelationGrammarAccess grammarAccess;
	
	@Override
	protected AbstractToken getRootToken(IEObjectConsumer inst) {
		return new ThisRootNode(inst);	
	}
	
protected class ThisRootNode extends RootToken {
	public ThisRootNode(IEObjectConsumer inst) {
		super(inst);
	}
	
	@Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TopLevelCS_Group(this, this, 0, inst);
			case 1: return new CollectionTemplateCS_Group(this, this, 1, inst);
			case 2: return new DefaultValueCS_Group(this, this, 2, inst);
			case 3: return new DomainCS_Group(this, this, 3, inst);
			case 4: return new DomainPatternCS_TemplateAssignment(this, this, 4, inst);
			case 5: return new ElementTemplateCS_Alternatives(this, this, 5, inst);
			case 6: return new KeyDeclCS_Group(this, this, 6, inst);
			case 7: return new LibraryCS_Group(this, this, 7, inst);
			case 8: return new ModelDeclCS_Group(this, this, 8, inst);
			case 9: return new ObjectTemplateCS_Group(this, this, 9, inst);
			case 10: return new ParamDeclarationCS_Group(this, this, 10, inst);
			case 11: return new PredicateCS_Group(this, this, 11, inst);
			case 12: return new PrimitiveTypeDomainCS_Group(this, this, 12, inst);
			case 13: return new PropertyTemplateCS_Group(this, this, 13, inst);
			case 14: return new QueryCS_Group(this, this, 14, inst);
			case 15: return new RelationCS_Group(this, this, 15, inst);
			case 16: return new TemplateCS_Group(this, this, 16, inst);
			case 17: return new TransformationCS_Group(this, this, 17, inst);
			case 18: return new UnitCS_Group(this, this, 18, inst);
			case 19: return new VarDeclarationCS_Group(this, this, 19, inst);
			case 20: return new VarDeclarationIdCS_NameAssignment(this, this, 20, inst);
			case 21: return new WhenCS_Group(this, this, 21, inst);
			case 22: return new WhereCS_Group(this, this, 22, inst);
			case 23: return new NameExpCS_PathNameAssignment(this, this, 23, inst);
			case 24: return new ExpCSOrTemplateCS_Alternatives(this, this, 24, inst);
			case 25: return new TypedTypeRefCS_PathNameAssignment(this, this, 25, inst);
			case 26: return new TypedRefCS_Alternatives(this, this, 26, inst);
			case 27: return new Model_OwnedExpressionAssignment(this, this, 27, inst);
			case 28: return new EssentialOCLUnaryOperatorCS_NameAssignment(this, this, 28, inst);
			case 29: return new EssentialOCLInfixOperatorCS_NameAssignment(this, this, 29, inst);
			case 30: return new EssentialOCLNavigationOperatorCS_NameAssignment(this, this, 30, inst);
			case 31: return new BinaryOperatorCS_Alternatives(this, this, 31, inst);
			case 32: return new InfixOperatorCS_EssentialOCLInfixOperatorCSParserRuleCall(this, this, 32, inst);
			case 33: return new NavigationOperatorCS_EssentialOCLNavigationOperatorCSParserRuleCall(this, this, 33, inst);
			case 34: return new UnaryOperatorCS_EssentialOCLUnaryOperatorCSParserRuleCall(this, this, 34, inst);
			case 35: return new PathNameCS_Group(this, this, 35, inst);
			case 36: return new FirstPathElementCS_ElementAssignment(this, this, 36, inst);
			case 37: return new NextPathElementCS_ElementAssignment(this, this, 37, inst);
			case 38: return new URIPathNameCS_Group(this, this, 38, inst);
			case 39: return new URIFirstPathElementCS_Alternatives(this, this, 39, inst);
			case 40: return new PrimitiveTypeCS_NameAssignment(this, this, 40, inst);
			case 41: return new CollectionTypeCS_Group(this, this, 41, inst);
			case 42: return new MultiplicityBoundsCS_Group(this, this, 42, inst);
			case 43: return new MultiplicityCS_Group(this, this, 43, inst);
			case 44: return new MultiplicityStringCS_StringBoundsAssignment(this, this, 44, inst);
			case 45: return new TupleTypeCS_Group(this, this, 45, inst);
			case 46: return new TuplePartCS_Group(this, this, 46, inst);
			case 47: return new CollectionLiteralExpCS_Group(this, this, 47, inst);
			case 48: return new CollectionLiteralPartCS_Group(this, this, 48, inst);
			case 49: return new ConstructorPartCS_Group(this, this, 49, inst);
			case 50: return new PrimitiveLiteralExpCS_Alternatives(this, this, 50, inst);
			case 51: return new TupleLiteralExpCS_Group(this, this, 51, inst);
			case 52: return new TupleLiteralPartCS_Group(this, this, 52, inst);
			case 53: return new NumberLiteralExpCS_NameAssignment(this, this, 53, inst);
			case 54: return new StringLiteralExpCS_NameAssignment(this, this, 54, inst);
			case 55: return new BooleanLiteralExpCS_Alternatives(this, this, 55, inst);
			case 56: return new UnlimitedNaturalLiteralExpCS_Group(this, this, 56, inst);
			case 57: return new InvalidLiteralExpCS_Group(this, this, 57, inst);
			case 58: return new NullLiteralExpCS_Group(this, this, 58, inst);
			case 59: return new TypeLiteralCS_Alternatives(this, this, 59, inst);
			case 60: return new TypeLiteralWithMultiplicityCS_Group(this, this, 60, inst);
			case 61: return new TypeLiteralExpCS_OwnedTypeAssignment(this, this, 61, inst);
			case 62: return new TypeNameExpCS_PathNameAssignment(this, this, 62, inst);
			case 63: return new TypeExpCS_Group(this, this, 63, inst);
			case 64: return new ExpCS_Alternatives(this, this, 64, inst);
			case 65: return new PrefixedExpCS_Alternatives(this, this, 65, inst);
			case 66: return new PrimaryExpCS_Alternatives(this, this, 66, inst);
			case 67: return new NavigatingArgCS_Group(this, this, 67, inst);
			case 68: return new NavigatingBarArgCS_Group(this, this, 68, inst);
			case 69: return new NavigatingCommaArgCS_Group(this, this, 69, inst);
			case 70: return new NavigatingSemiArgCS_Group(this, this, 70, inst);
			case 71: return new NavigatingArgExpCS_ExpCSParserRuleCall(this, this, 71, inst);
			case 72: return new IfExpCS_Group(this, this, 72, inst);
			case 73: return new LetExpCS_Group(this, this, 73, inst);
			case 74: return new LetVariableCS_Group(this, this, 74, inst);
			case 75: return new NestedExpCS_Group(this, this, 75, inst);
			case 76: return new SelfExpCS_Group(this, this, 76, inst);
			default: return null;
		}	
	}	
}
	

/************ begin Rule TopLevelCS ****************
 *
 * TopLevelCS:
 * 	(ownedImport+=UnitCS | / *ownedInclude+=IncludeCS |* / ownedLibrary+=LibraryCS)* transformations+=TransformationCS*;
 *
 **/

// (ownedImport+=UnitCS | / *ownedInclude+=IncludeCS |* / ownedLibrary+=LibraryCS)* transformations+=TransformationCS*
protected class TopLevelCS_Group extends GroupToken {
	
	public TopLevelCS_Group(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getTopLevelCSAccess().getGroup();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TopLevelCS_TransformationsAssignment_1(lastRuleCallOrigin, this, 0, inst);
			case 1: return new TopLevelCS_Alternatives_0(lastRuleCallOrigin, this, 1, inst);
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index - 2, inst);
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getTopLevelCSRule().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// (ownedImport+=UnitCS | / *ownedInclude+=IncludeCS |* / ownedLibrary+=LibraryCS)*
protected class TopLevelCS_Alternatives_0 extends AlternativesToken {

	public TopLevelCS_Alternatives_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Alternatives getGrammarElement() {
		return grammarAccess.getTopLevelCSAccess().getAlternatives_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TopLevelCS_OwnedImportAssignment_0_0(lastRuleCallOrigin, this, 0, inst);
			case 1: return new TopLevelCS_OwnedLibraryAssignment_0_1(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}

// ownedImport+=UnitCS
protected class TopLevelCS_OwnedImportAssignment_0_0 extends AssignmentToken  {
	
	public TopLevelCS_OwnedImportAssignment_0_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getTopLevelCSAccess().getOwnedImportAssignment_0_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new UnitCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("ownedImport",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("ownedImport");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getUnitCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getTopLevelCSAccess().getOwnedImportUnitCSParserRuleCall_0_0_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new TopLevelCS_Alternatives_0(lastRuleCallOrigin, next, actIndex, consumed);
			default: return lastRuleCallOrigin.createFollowerAfterReturn(next, actIndex , index - 1, consumed);
		}	
	}	
}

// / *ownedInclude+=IncludeCS |* / ownedLibrary+=LibraryCS
protected class TopLevelCS_OwnedLibraryAssignment_0_1 extends AssignmentToken  {
	
	public TopLevelCS_OwnedLibraryAssignment_0_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getTopLevelCSAccess().getOwnedLibraryAssignment_0_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new LibraryCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("ownedLibrary",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("ownedLibrary");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getLibraryCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getTopLevelCSAccess().getOwnedLibraryLibraryCSParserRuleCall_0_1_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new TopLevelCS_Alternatives_0(lastRuleCallOrigin, next, actIndex, consumed);
			default: return lastRuleCallOrigin.createFollowerAfterReturn(next, actIndex , index - 1, consumed);
		}	
	}	
}


// transformations+=TransformationCS*
protected class TopLevelCS_TransformationsAssignment_1 extends AssignmentToken  {
	
	public TopLevelCS_TransformationsAssignment_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getTopLevelCSAccess().getTransformationsAssignment_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TransformationCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("transformations",false)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("transformations");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getTransformationCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getTopLevelCSAccess().getTransformationsTransformationCSParserRuleCall_1_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new TopLevelCS_TransformationsAssignment_1(lastRuleCallOrigin, next, actIndex, consumed);
			case 1: return new TopLevelCS_Alternatives_0(lastRuleCallOrigin, next, actIndex, consumed);
			default: return lastRuleCallOrigin.createFollowerAfterReturn(next, actIndex , index - 2, consumed);
		}	
	}	
}


/************ end Rule TopLevelCS ****************/


/************ begin Rule CollectionTemplateCS ****************
 *
 * //UnitCS: identifier+=[pivot::Element|UnrestrictedName] ('.' identifier+=[pivot::Element|UnrestrictedName])*;
 * CollectionTemplateCS:
 * 	name=UnrestrictedName? ":" type=CollectionTypeCS "{" (memberIdentifiers+=(TemplateCS | ElementTemplateCS) (","
 * 	memberIdentifiers+=(TemplateCS | ElementTemplateCS))* "++" (restIdentifier=[pivot::Variable|UnrestrictedName] | "_"))?
 * 	"}";
 *
 **/

// name=UnrestrictedName? ":" type=CollectionTypeCS "{" (memberIdentifiers+=(TemplateCS | ElementTemplateCS) (","
// memberIdentifiers+=(TemplateCS | ElementTemplateCS))* "++" (restIdentifier=[pivot::Variable|UnrestrictedName] | "_"))?
// "}"
protected class CollectionTemplateCS_Group extends GroupToken {
	
	public CollectionTemplateCS_Group(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getCollectionTemplateCSAccess().getGroup();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new CollectionTemplateCS_RightCurlyBracketKeyword_5(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getCollectionTemplateCSRule().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// name=UnrestrictedName?
protected class CollectionTemplateCS_NameAssignment_0 extends AssignmentToken  {
	
	public CollectionTemplateCS_NameAssignment_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getCollectionTemplateCSAccess().getNameAssignment_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index, inst);
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("name",false)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("name");
		if(valueSerializer.isValid(obj.getEObject(), grammarAccess.getCollectionTemplateCSAccess().getNameUnrestrictedNameParserRuleCall_0_0(), value, null)) {
			type = AssignmentType.DATATYPE_RULE_CALL;
			element = grammarAccess.getCollectionTemplateCSAccess().getNameUnrestrictedNameParserRuleCall_0_0();
			return obj;
		}
		return null;
	}

}

// ":"
protected class CollectionTemplateCS_ColonKeyword_1 extends KeywordToken  {
	
	public CollectionTemplateCS_ColonKeyword_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getCollectionTemplateCSAccess().getColonKeyword_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new CollectionTemplateCS_NameAssignment_0(lastRuleCallOrigin, this, 0, inst);
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index - 1, inst);
		}	
	}

}

// type=CollectionTypeCS
protected class CollectionTemplateCS_TypeAssignment_2 extends AssignmentToken  {
	
	public CollectionTemplateCS_TypeAssignment_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getCollectionTemplateCSAccess().getTypeAssignment_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new CollectionTypeCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("type",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("type");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getCollectionTypeCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getCollectionTemplateCSAccess().getTypeCollectionTypeCSParserRuleCall_2_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new CollectionTemplateCS_ColonKeyword_1(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}

// "{"
protected class CollectionTemplateCS_LeftCurlyBracketKeyword_3 extends KeywordToken  {
	
	public CollectionTemplateCS_LeftCurlyBracketKeyword_3(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getCollectionTemplateCSAccess().getLeftCurlyBracketKeyword_3();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new CollectionTemplateCS_TypeAssignment_2(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// (memberIdentifiers+=(TemplateCS | ElementTemplateCS) ("," memberIdentifiers+=(TemplateCS | ElementTemplateCS))* "++"
// (restIdentifier=[pivot::Variable|UnrestrictedName] | "_"))?
protected class CollectionTemplateCS_Group_4 extends GroupToken {
	
	public CollectionTemplateCS_Group_4(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getCollectionTemplateCSAccess().getGroup_4();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new CollectionTemplateCS_Alternatives_4_3(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// memberIdentifiers+=(TemplateCS | ElementTemplateCS)
protected class CollectionTemplateCS_MemberIdentifiersAssignment_4_0 extends AssignmentToken  {
	
	public CollectionTemplateCS_MemberIdentifiersAssignment_4_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getCollectionTemplateCSAccess().getMemberIdentifiersAssignment_4_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TemplateCS_Group(this, this, 0, inst);
			case 1: return new ElementTemplateCS_Alternatives(this, this, 1, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("memberIdentifiers",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("memberIdentifiers");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getTemplateCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getCollectionTemplateCSAccess().getMemberIdentifiersTemplateCSParserRuleCall_4_0_0_0(); 
				consumed = obj;
				return param;
			}
		}
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getElementTemplateCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getCollectionTemplateCSAccess().getMemberIdentifiersElementTemplateCSParserRuleCall_4_0_0_1(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new CollectionTemplateCS_LeftCurlyBracketKeyword_3(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}

// ("," memberIdentifiers+=(TemplateCS | ElementTemplateCS))*
protected class CollectionTemplateCS_Group_4_1 extends GroupToken {
	
	public CollectionTemplateCS_Group_4_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getCollectionTemplateCSAccess().getGroup_4_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new CollectionTemplateCS_MemberIdentifiersAssignment_4_1_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// ","
protected class CollectionTemplateCS_CommaKeyword_4_1_0 extends KeywordToken  {
	
	public CollectionTemplateCS_CommaKeyword_4_1_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getCollectionTemplateCSAccess().getCommaKeyword_4_1_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new CollectionTemplateCS_Group_4_1(lastRuleCallOrigin, this, 0, inst);
			case 1: return new CollectionTemplateCS_MemberIdentifiersAssignment_4_0(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}

// memberIdentifiers+=(TemplateCS | ElementTemplateCS)
protected class CollectionTemplateCS_MemberIdentifiersAssignment_4_1_1 extends AssignmentToken  {
	
	public CollectionTemplateCS_MemberIdentifiersAssignment_4_1_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getCollectionTemplateCSAccess().getMemberIdentifiersAssignment_4_1_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TemplateCS_Group(this, this, 0, inst);
			case 1: return new ElementTemplateCS_Alternatives(this, this, 1, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("memberIdentifiers",false)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("memberIdentifiers");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getTemplateCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getCollectionTemplateCSAccess().getMemberIdentifiersTemplateCSParserRuleCall_4_1_1_0_0(); 
				consumed = obj;
				return param;
			}
		}
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getElementTemplateCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getCollectionTemplateCSAccess().getMemberIdentifiersElementTemplateCSParserRuleCall_4_1_1_0_1(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new CollectionTemplateCS_CommaKeyword_4_1_0(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}


// "++"
protected class CollectionTemplateCS_PlusSignPlusSignKeyword_4_2 extends KeywordToken  {
	
	public CollectionTemplateCS_PlusSignPlusSignKeyword_4_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getCollectionTemplateCSAccess().getPlusSignPlusSignKeyword_4_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new CollectionTemplateCS_Group_4_1(lastRuleCallOrigin, this, 0, inst);
			case 1: return new CollectionTemplateCS_MemberIdentifiersAssignment_4_0(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}

// restIdentifier=[pivot::Variable|UnrestrictedName] | "_"
protected class CollectionTemplateCS_Alternatives_4_3 extends AlternativesToken {

	public CollectionTemplateCS_Alternatives_4_3(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Alternatives getGrammarElement() {
		return grammarAccess.getCollectionTemplateCSAccess().getAlternatives_4_3();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new CollectionTemplateCS_RestIdentifierAssignment_4_3_0(lastRuleCallOrigin, this, 0, inst);
			case 1: return new CollectionTemplateCS__Keyword_4_3_1(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}

// restIdentifier=[pivot::Variable|UnrestrictedName]
protected class CollectionTemplateCS_RestIdentifierAssignment_4_3_0 extends AssignmentToken  {
	
	public CollectionTemplateCS_RestIdentifierAssignment_4_3_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getCollectionTemplateCSAccess().getRestIdentifierAssignment_4_3_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new CollectionTemplateCS_PlusSignPlusSignKeyword_4_2(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("restIdentifier",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("restIdentifier");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::CrossReferenceImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getCollectionTemplateCSAccess().getRestIdentifierVariableCrossReference_4_3_0_0().getType().getClassifier())) {
				type = AssignmentType.CROSS_REFERENCE;
				element = grammarAccess.getCollectionTemplateCSAccess().getRestIdentifierVariableCrossReference_4_3_0_0(); 
				return obj;
			}
		}
		return null;
	}

}

// "_"
protected class CollectionTemplateCS__Keyword_4_3_1 extends KeywordToken  {
	
	public CollectionTemplateCS__Keyword_4_3_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getCollectionTemplateCSAccess().get_Keyword_4_3_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new CollectionTemplateCS_PlusSignPlusSignKeyword_4_2(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}



// "}"
protected class CollectionTemplateCS_RightCurlyBracketKeyword_5 extends KeywordToken  {
	
	public CollectionTemplateCS_RightCurlyBracketKeyword_5(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getCollectionTemplateCSAccess().getRightCurlyBracketKeyword_5();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new CollectionTemplateCS_Group_4(lastRuleCallOrigin, this, 0, inst);
			case 1: return new CollectionTemplateCS_LeftCurlyBracketKeyword_3(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}


/************ end Rule CollectionTemplateCS ****************/


/************ begin Rule DefaultValueCS ****************
 *
 * DefaultValueCS:
 * 	propertyId=[pivot::Variable|UnrestrictedName] "=" initialiser=ExpCS ";";
 *
 **/

// propertyId=[pivot::Variable|UnrestrictedName] "=" initialiser=ExpCS ";"
protected class DefaultValueCS_Group extends GroupToken {
	
	public DefaultValueCS_Group(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getDefaultValueCSAccess().getGroup();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new DefaultValueCS_SemicolonKeyword_3(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getDefaultValueCSRule().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// propertyId=[pivot::Variable|UnrestrictedName]
protected class DefaultValueCS_PropertyIdAssignment_0 extends AssignmentToken  {
	
	public DefaultValueCS_PropertyIdAssignment_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getDefaultValueCSAccess().getPropertyIdAssignment_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index, inst);
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("propertyId",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("propertyId");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::CrossReferenceImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getDefaultValueCSAccess().getPropertyIdVariableCrossReference_0_0().getType().getClassifier())) {
				type = AssignmentType.CROSS_REFERENCE;
				element = grammarAccess.getDefaultValueCSAccess().getPropertyIdVariableCrossReference_0_0(); 
				return obj;
			}
		}
		return null;
	}

}

// "="
protected class DefaultValueCS_EqualsSignKeyword_1 extends KeywordToken  {
	
	public DefaultValueCS_EqualsSignKeyword_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getDefaultValueCSAccess().getEqualsSignKeyword_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new DefaultValueCS_PropertyIdAssignment_0(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// initialiser=ExpCS
protected class DefaultValueCS_InitialiserAssignment_2 extends AssignmentToken  {
	
	public DefaultValueCS_InitialiserAssignment_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getDefaultValueCSAccess().getInitialiserAssignment_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ExpCS_Alternatives(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("initialiser",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("initialiser");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getExpCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getDefaultValueCSAccess().getInitialiserExpCSParserRuleCall_2_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new DefaultValueCS_EqualsSignKeyword_1(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}

// ";"
protected class DefaultValueCS_SemicolonKeyword_3 extends KeywordToken  {
	
	public DefaultValueCS_SemicolonKeyword_3(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getDefaultValueCSAccess().getSemicolonKeyword_3();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new DefaultValueCS_InitialiserAssignment_2(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}


/************ end Rule DefaultValueCS ****************/


/************ begin Rule DomainCS ****************
 *
 * DomainCS:
 * 	(checkonly?="checkonly" | enforce?="enforce" | "replace")? "domain" modelId=[qvtbase::TypedModel|UnrestrictedName]
 * 	pattern=DomainPatternCS ("implementedby" implementedBy=ExpCS)? ("default_values" "{" defaultValues+=DefaultValueCS+
 * 	"}")? ";";
 *
 **/

// (checkonly?="checkonly" | enforce?="enforce" | "replace")? "domain" modelId=[qvtbase::TypedModel|UnrestrictedName]
// pattern=DomainPatternCS ("implementedby" implementedBy=ExpCS)? ("default_values" "{" defaultValues+=DefaultValueCS+
// "}")? ";"
protected class DomainCS_Group extends GroupToken {
	
	public DomainCS_Group(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getDomainCSAccess().getGroup();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new DomainCS_SemicolonKeyword_6(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getDomainCSRule().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// (checkonly?="checkonly" | enforce?="enforce" | "replace")?
protected class DomainCS_Alternatives_0 extends AlternativesToken {

	public DomainCS_Alternatives_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Alternatives getGrammarElement() {
		return grammarAccess.getDomainCSAccess().getAlternatives_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new DomainCS_CheckonlyAssignment_0_0(lastRuleCallOrigin, this, 0, inst);
			case 1: return new DomainCS_EnforceAssignment_0_1(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}

// checkonly?="checkonly"
protected class DomainCS_CheckonlyAssignment_0_0 extends AssignmentToken  {
	
	public DomainCS_CheckonlyAssignment_0_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getDomainCSAccess().getCheckonlyAssignment_0_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index, inst);
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("checkonly",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("checkonly");
		if(Boolean.TRUE.equals(value)) { // org::eclipse::xtext::impl::KeywordImpl
			type = AssignmentType.KEYWORD;
			element = grammarAccess.getDomainCSAccess().getCheckonlyCheckonlyKeyword_0_0_0();
			return obj;
		}
		return null;
	}

}

// enforce?="enforce"
protected class DomainCS_EnforceAssignment_0_1 extends AssignmentToken  {
	
	public DomainCS_EnforceAssignment_0_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getDomainCSAccess().getEnforceAssignment_0_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index, inst);
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("enforce",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("enforce");
		if(Boolean.TRUE.equals(value)) { // org::eclipse::xtext::impl::KeywordImpl
			type = AssignmentType.KEYWORD;
			element = grammarAccess.getDomainCSAccess().getEnforceEnforceKeyword_0_1_0();
			return obj;
		}
		return null;
	}

}


// "domain"
protected class DomainCS_DomainKeyword_1 extends KeywordToken  {
	
	public DomainCS_DomainKeyword_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getDomainCSAccess().getDomainKeyword_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new DomainCS_Alternatives_0(lastRuleCallOrigin, this, 0, inst);
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index - 1, inst);
		}	
	}

}

// modelId=[qvtbase::TypedModel|UnrestrictedName]
protected class DomainCS_ModelIdAssignment_2 extends AssignmentToken  {
	
	public DomainCS_ModelIdAssignment_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getDomainCSAccess().getModelIdAssignment_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new DomainCS_DomainKeyword_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("modelId",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("modelId");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::CrossReferenceImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getDomainCSAccess().getModelIdTypedModelCrossReference_2_0().getType().getClassifier())) {
				type = AssignmentType.CROSS_REFERENCE;
				element = grammarAccess.getDomainCSAccess().getModelIdTypedModelCrossReference_2_0(); 
				return obj;
			}
		}
		return null;
	}

}

// pattern=DomainPatternCS
protected class DomainCS_PatternAssignment_3 extends AssignmentToken  {
	
	public DomainCS_PatternAssignment_3(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getDomainCSAccess().getPatternAssignment_3();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new DomainPatternCS_TemplateAssignment(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("pattern",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("pattern");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getDomainPatternCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getDomainCSAccess().getPatternDomainPatternCSParserRuleCall_3_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new DomainCS_ModelIdAssignment_2(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}

// ("implementedby" implementedBy=ExpCS)?
protected class DomainCS_Group_4 extends GroupToken {
	
	public DomainCS_Group_4(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getDomainCSAccess().getGroup_4();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new DomainCS_ImplementedByAssignment_4_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// "implementedby"
protected class DomainCS_ImplementedbyKeyword_4_0 extends KeywordToken  {
	
	public DomainCS_ImplementedbyKeyword_4_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getDomainCSAccess().getImplementedbyKeyword_4_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new DomainCS_PatternAssignment_3(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// implementedBy=ExpCS
protected class DomainCS_ImplementedByAssignment_4_1 extends AssignmentToken  {
	
	public DomainCS_ImplementedByAssignment_4_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getDomainCSAccess().getImplementedByAssignment_4_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ExpCS_Alternatives(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("implementedBy",false)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("implementedBy");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getExpCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getDomainCSAccess().getImplementedByExpCSParserRuleCall_4_1_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new DomainCS_ImplementedbyKeyword_4_0(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}


// ("default_values" "{" defaultValues+=DefaultValueCS+ "}")?
protected class DomainCS_Group_5 extends GroupToken {
	
	public DomainCS_Group_5(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getDomainCSAccess().getGroup_5();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new DomainCS_RightCurlyBracketKeyword_5_3(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// "default_values"
protected class DomainCS_Default_valuesKeyword_5_0 extends KeywordToken  {
	
	public DomainCS_Default_valuesKeyword_5_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getDomainCSAccess().getDefault_valuesKeyword_5_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new DomainCS_Group_4(lastRuleCallOrigin, this, 0, inst);
			case 1: return new DomainCS_PatternAssignment_3(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}

// "{"
protected class DomainCS_LeftCurlyBracketKeyword_5_1 extends KeywordToken  {
	
	public DomainCS_LeftCurlyBracketKeyword_5_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getDomainCSAccess().getLeftCurlyBracketKeyword_5_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new DomainCS_Default_valuesKeyword_5_0(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// defaultValues+=DefaultValueCS+
protected class DomainCS_DefaultValuesAssignment_5_2 extends AssignmentToken  {
	
	public DomainCS_DefaultValuesAssignment_5_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getDomainCSAccess().getDefaultValuesAssignment_5_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new DefaultValueCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("defaultValues",false)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("defaultValues");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getDefaultValueCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getDomainCSAccess().getDefaultValuesDefaultValueCSParserRuleCall_5_2_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new DomainCS_DefaultValuesAssignment_5_2(lastRuleCallOrigin, next, actIndex, consumed);
			case 1: return new DomainCS_LeftCurlyBracketKeyword_5_1(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}

// "}"
protected class DomainCS_RightCurlyBracketKeyword_5_3 extends KeywordToken  {
	
	public DomainCS_RightCurlyBracketKeyword_5_3(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getDomainCSAccess().getRightCurlyBracketKeyword_5_3();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new DomainCS_DefaultValuesAssignment_5_2(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}


// ";"
protected class DomainCS_SemicolonKeyword_6 extends KeywordToken  {
	
	public DomainCS_SemicolonKeyword_6(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getDomainCSAccess().getSemicolonKeyword_6();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new DomainCS_Group_5(lastRuleCallOrigin, this, 0, inst);
			case 1: return new DomainCS_Group_4(lastRuleCallOrigin, this, 1, inst);
			case 2: return new DomainCS_PatternAssignment_3(lastRuleCallOrigin, this, 2, inst);
			default: return null;
		}	
	}

}


/************ end Rule DomainCS ****************/


/************ begin Rule DomainPatternCS ****************
 *
 * DomainPatternCS:
 * 	template=TemplateCS;
 *
 **/

// template=TemplateCS
protected class DomainPatternCS_TemplateAssignment extends AssignmentToken  {
	
	public DomainPatternCS_TemplateAssignment(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getDomainPatternCSAccess().getTemplateAssignment();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TemplateCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getDomainPatternCSRule().getType().getClassifier())
			return null;
		if((value = eObjectConsumer.getConsumable("template",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("template");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getTemplateCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getDomainPatternCSAccess().getTemplateTemplateCSParserRuleCall_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(next, actIndex , index, consumed);
		}	
	}	
}

/************ end Rule DomainPatternCS ****************/


/************ begin Rule ElementTemplateCS ****************
 *
 * ElementTemplateCS:
 * 	name=UnrestrictedName | {ElementTemplateCS} "_";
 *
 **/

// name=UnrestrictedName | {ElementTemplateCS} "_"
protected class ElementTemplateCS_Alternatives extends AlternativesToken {

	public ElementTemplateCS_Alternatives(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Alternatives getGrammarElement() {
		return grammarAccess.getElementTemplateCSAccess().getAlternatives();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ElementTemplateCS_NameAssignment_0(lastRuleCallOrigin, this, 0, inst);
			case 1: return new ElementTemplateCS_Group_1(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getElementTemplateCSAccess().getElementTemplateCSAction_1_0().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// name=UnrestrictedName
protected class ElementTemplateCS_NameAssignment_0 extends AssignmentToken  {
	
	public ElementTemplateCS_NameAssignment_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getElementTemplateCSAccess().getNameAssignment_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index, inst);
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("name",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("name");
		if(valueSerializer.isValid(obj.getEObject(), grammarAccess.getElementTemplateCSAccess().getNameUnrestrictedNameParserRuleCall_0_0(), value, null)) {
			type = AssignmentType.DATATYPE_RULE_CALL;
			element = grammarAccess.getElementTemplateCSAccess().getNameUnrestrictedNameParserRuleCall_0_0();
			return obj;
		}
		return null;
	}

}

// {ElementTemplateCS} "_"
protected class ElementTemplateCS_Group_1 extends GroupToken {
	
	public ElementTemplateCS_Group_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getElementTemplateCSAccess().getGroup_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ElementTemplateCS__Keyword_1_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// {ElementTemplateCS}
protected class ElementTemplateCS_ElementTemplateCSAction_1_0 extends ActionToken  {

	public ElementTemplateCS_ElementTemplateCSAction_1_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Action getGrammarElement() {
		return grammarAccess.getElementTemplateCSAccess().getElementTemplateCSAction_1_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index, inst);
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(!eObjectConsumer.isConsumed()) return null;
		return eObjectConsumer;
	}
}

// "_"
protected class ElementTemplateCS__Keyword_1_1 extends KeywordToken  {
	
	public ElementTemplateCS__Keyword_1_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getElementTemplateCSAccess().get_Keyword_1_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ElementTemplateCS_ElementTemplateCSAction_1_0(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}



/************ end Rule ElementTemplateCS ****************/


/************ begin Rule KeyDeclCS ****************
 *
 * KeyDeclCS:
 * 	"key" pathName=PathNameCS "{" (propertyIds+=[pivot::Property|UnrestrictedName] | "opposite" "("
 * 	oppositePropertyIds+=PathNameCS ")") ("," (propertyIds+=[pivot::Property|UnrestrictedName] | "opposite" "("
 * 	oppositePropertyIds+=PathNameCS ")"))* "}" ";";
 *
 **/

// "key" pathName=PathNameCS "{" (propertyIds+=[pivot::Property|UnrestrictedName] | "opposite" "("
// oppositePropertyIds+=PathNameCS ")") ("," (propertyIds+=[pivot::Property|UnrestrictedName] | "opposite" "("
// oppositePropertyIds+=PathNameCS ")"))* "}" ";"
protected class KeyDeclCS_Group extends GroupToken {
	
	public KeyDeclCS_Group(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getKeyDeclCSAccess().getGroup();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new KeyDeclCS_SemicolonKeyword_6(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getKeyDeclCSRule().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// "key"
protected class KeyDeclCS_KeyKeyword_0 extends KeywordToken  {
	
	public KeyDeclCS_KeyKeyword_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getKeyDeclCSAccess().getKeyKeyword_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index, inst);
		}	
	}

}

// pathName=PathNameCS
protected class KeyDeclCS_PathNameAssignment_1 extends AssignmentToken  {
	
	public KeyDeclCS_PathNameAssignment_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getKeyDeclCSAccess().getPathNameAssignment_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PathNameCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("pathName",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("pathName");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getPathNameCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getKeyDeclCSAccess().getPathNamePathNameCSParserRuleCall_1_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new KeyDeclCS_KeyKeyword_0(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}

// "{"
protected class KeyDeclCS_LeftCurlyBracketKeyword_2 extends KeywordToken  {
	
	public KeyDeclCS_LeftCurlyBracketKeyword_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getKeyDeclCSAccess().getLeftCurlyBracketKeyword_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new KeyDeclCS_PathNameAssignment_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// propertyIds+=[pivot::Property|UnrestrictedName] | "opposite" "(" oppositePropertyIds+=PathNameCS ")"
protected class KeyDeclCS_Alternatives_3 extends AlternativesToken {

	public KeyDeclCS_Alternatives_3(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Alternatives getGrammarElement() {
		return grammarAccess.getKeyDeclCSAccess().getAlternatives_3();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new KeyDeclCS_PropertyIdsAssignment_3_0(lastRuleCallOrigin, this, 0, inst);
			case 1: return new KeyDeclCS_Group_3_1(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}

// propertyIds+=[pivot::Property|UnrestrictedName]
protected class KeyDeclCS_PropertyIdsAssignment_3_0 extends AssignmentToken  {
	
	public KeyDeclCS_PropertyIdsAssignment_3_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getKeyDeclCSAccess().getPropertyIdsAssignment_3_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new KeyDeclCS_LeftCurlyBracketKeyword_2(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("propertyIds",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("propertyIds");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::CrossReferenceImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getKeyDeclCSAccess().getPropertyIdsPropertyCrossReference_3_0_0().getType().getClassifier())) {
				type = AssignmentType.CROSS_REFERENCE;
				element = grammarAccess.getKeyDeclCSAccess().getPropertyIdsPropertyCrossReference_3_0_0(); 
				return obj;
			}
		}
		return null;
	}

}

// "opposite" "(" oppositePropertyIds+=PathNameCS ")"
protected class KeyDeclCS_Group_3_1 extends GroupToken {
	
	public KeyDeclCS_Group_3_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getKeyDeclCSAccess().getGroup_3_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new KeyDeclCS_RightParenthesisKeyword_3_1_3(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// "opposite"
protected class KeyDeclCS_OppositeKeyword_3_1_0 extends KeywordToken  {
	
	public KeyDeclCS_OppositeKeyword_3_1_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getKeyDeclCSAccess().getOppositeKeyword_3_1_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new KeyDeclCS_LeftCurlyBracketKeyword_2(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// "("
protected class KeyDeclCS_LeftParenthesisKeyword_3_1_1 extends KeywordToken  {
	
	public KeyDeclCS_LeftParenthesisKeyword_3_1_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getKeyDeclCSAccess().getLeftParenthesisKeyword_3_1_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new KeyDeclCS_OppositeKeyword_3_1_0(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// oppositePropertyIds+=PathNameCS
protected class KeyDeclCS_OppositePropertyIdsAssignment_3_1_2 extends AssignmentToken  {
	
	public KeyDeclCS_OppositePropertyIdsAssignment_3_1_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getKeyDeclCSAccess().getOppositePropertyIdsAssignment_3_1_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PathNameCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("oppositePropertyIds",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("oppositePropertyIds");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getPathNameCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getKeyDeclCSAccess().getOppositePropertyIdsPathNameCSParserRuleCall_3_1_2_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new KeyDeclCS_LeftParenthesisKeyword_3_1_1(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}

// ")"
protected class KeyDeclCS_RightParenthesisKeyword_3_1_3 extends KeywordToken  {
	
	public KeyDeclCS_RightParenthesisKeyword_3_1_3(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getKeyDeclCSAccess().getRightParenthesisKeyword_3_1_3();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new KeyDeclCS_OppositePropertyIdsAssignment_3_1_2(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}



// ("," (propertyIds+=[pivot::Property|UnrestrictedName] | "opposite" "(" oppositePropertyIds+=PathNameCS ")"))*
protected class KeyDeclCS_Group_4 extends GroupToken {
	
	public KeyDeclCS_Group_4(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getKeyDeclCSAccess().getGroup_4();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new KeyDeclCS_Alternatives_4_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// ","
protected class KeyDeclCS_CommaKeyword_4_0 extends KeywordToken  {
	
	public KeyDeclCS_CommaKeyword_4_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getKeyDeclCSAccess().getCommaKeyword_4_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new KeyDeclCS_Group_4(lastRuleCallOrigin, this, 0, inst);
			case 1: return new KeyDeclCS_Alternatives_3(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}

// propertyIds+=[pivot::Property|UnrestrictedName] | "opposite" "(" oppositePropertyIds+=PathNameCS ")"
protected class KeyDeclCS_Alternatives_4_1 extends AlternativesToken {

	public KeyDeclCS_Alternatives_4_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Alternatives getGrammarElement() {
		return grammarAccess.getKeyDeclCSAccess().getAlternatives_4_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new KeyDeclCS_PropertyIdsAssignment_4_1_0(lastRuleCallOrigin, this, 0, inst);
			case 1: return new KeyDeclCS_Group_4_1_1(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}

// propertyIds+=[pivot::Property|UnrestrictedName]
protected class KeyDeclCS_PropertyIdsAssignment_4_1_0 extends AssignmentToken  {
	
	public KeyDeclCS_PropertyIdsAssignment_4_1_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getKeyDeclCSAccess().getPropertyIdsAssignment_4_1_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new KeyDeclCS_CommaKeyword_4_0(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("propertyIds",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("propertyIds");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::CrossReferenceImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getKeyDeclCSAccess().getPropertyIdsPropertyCrossReference_4_1_0_0().getType().getClassifier())) {
				type = AssignmentType.CROSS_REFERENCE;
				element = grammarAccess.getKeyDeclCSAccess().getPropertyIdsPropertyCrossReference_4_1_0_0(); 
				return obj;
			}
		}
		return null;
	}

}

// "opposite" "(" oppositePropertyIds+=PathNameCS ")"
protected class KeyDeclCS_Group_4_1_1 extends GroupToken {
	
	public KeyDeclCS_Group_4_1_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getKeyDeclCSAccess().getGroup_4_1_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new KeyDeclCS_RightParenthesisKeyword_4_1_1_3(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// "opposite"
protected class KeyDeclCS_OppositeKeyword_4_1_1_0 extends KeywordToken  {
	
	public KeyDeclCS_OppositeKeyword_4_1_1_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getKeyDeclCSAccess().getOppositeKeyword_4_1_1_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new KeyDeclCS_CommaKeyword_4_0(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// "("
protected class KeyDeclCS_LeftParenthesisKeyword_4_1_1_1 extends KeywordToken  {
	
	public KeyDeclCS_LeftParenthesisKeyword_4_1_1_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getKeyDeclCSAccess().getLeftParenthesisKeyword_4_1_1_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new KeyDeclCS_OppositeKeyword_4_1_1_0(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// oppositePropertyIds+=PathNameCS
protected class KeyDeclCS_OppositePropertyIdsAssignment_4_1_1_2 extends AssignmentToken  {
	
	public KeyDeclCS_OppositePropertyIdsAssignment_4_1_1_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getKeyDeclCSAccess().getOppositePropertyIdsAssignment_4_1_1_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PathNameCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("oppositePropertyIds",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("oppositePropertyIds");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getPathNameCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getKeyDeclCSAccess().getOppositePropertyIdsPathNameCSParserRuleCall_4_1_1_2_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new KeyDeclCS_LeftParenthesisKeyword_4_1_1_1(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}

// ")"
protected class KeyDeclCS_RightParenthesisKeyword_4_1_1_3 extends KeywordToken  {
	
	public KeyDeclCS_RightParenthesisKeyword_4_1_1_3(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getKeyDeclCSAccess().getRightParenthesisKeyword_4_1_1_3();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new KeyDeclCS_OppositePropertyIdsAssignment_4_1_1_2(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}




// "}"
protected class KeyDeclCS_RightCurlyBracketKeyword_5 extends KeywordToken  {
	
	public KeyDeclCS_RightCurlyBracketKeyword_5(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getKeyDeclCSAccess().getRightCurlyBracketKeyword_5();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new KeyDeclCS_Group_4(lastRuleCallOrigin, this, 0, inst);
			case 1: return new KeyDeclCS_Alternatives_3(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}

// ";"
protected class KeyDeclCS_SemicolonKeyword_6 extends KeywordToken  {
	
	public KeyDeclCS_SemicolonKeyword_6(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getKeyDeclCSAccess().getSemicolonKeyword_6();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new KeyDeclCS_RightCurlyBracketKeyword_5(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}


/************ end Rule KeyDeclCS ****************/


/************ begin Rule LibraryCS ****************
 *
 * LibraryCS returns base::LibraryCS:
 * 	"library" package=[pivot::Package|URI] ";";
 *
 **/

// "library" package=[pivot::Package|URI] ";"
protected class LibraryCS_Group extends GroupToken {
	
	public LibraryCS_Group(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getLibraryCSAccess().getGroup();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new LibraryCS_SemicolonKeyword_2(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getLibraryCSRule().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// "library"
protected class LibraryCS_LibraryKeyword_0 extends KeywordToken  {
	
	public LibraryCS_LibraryKeyword_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getLibraryCSAccess().getLibraryKeyword_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index, inst);
		}	
	}

}

// package=[pivot::Package|URI]
protected class LibraryCS_PackageAssignment_1 extends AssignmentToken  {
	
	public LibraryCS_PackageAssignment_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getLibraryCSAccess().getPackageAssignment_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new LibraryCS_LibraryKeyword_0(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("package",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("package");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::CrossReferenceImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getLibraryCSAccess().getPackagePackageCrossReference_1_0().getType().getClassifier())) {
				type = AssignmentType.CROSS_REFERENCE;
				element = grammarAccess.getLibraryCSAccess().getPackagePackageCrossReference_1_0(); 
				return obj;
			}
		}
		return null;
	}

}

// ";"
protected class LibraryCS_SemicolonKeyword_2 extends KeywordToken  {
	
	public LibraryCS_SemicolonKeyword_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getLibraryCSAccess().getSemicolonKeyword_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new LibraryCS_PackageAssignment_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}


/************ end Rule LibraryCS ****************/


/************ begin Rule ModelDeclCS ****************
 *
 * ModelDeclCS:
 * 	name=UnrestrictedName ":" (metaModelIds+=[pivot::Namespace|UnrestrictedName] | "{"
 * 	metaModelIds+=[pivot::Namespace|UnrestrictedName] ("," metaModelIds+=[pivot::Namespace|UnrestrictedName])* "}");
 *
 **/

// name=UnrestrictedName ":" (metaModelIds+=[pivot::Namespace|UnrestrictedName] | "{"
// metaModelIds+=[pivot::Namespace|UnrestrictedName] ("," metaModelIds+=[pivot::Namespace|UnrestrictedName])* "}")
protected class ModelDeclCS_Group extends GroupToken {
	
	public ModelDeclCS_Group(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getModelDeclCSAccess().getGroup();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ModelDeclCS_Alternatives_2(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getModelDeclCSRule().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// name=UnrestrictedName
protected class ModelDeclCS_NameAssignment_0 extends AssignmentToken  {
	
	public ModelDeclCS_NameAssignment_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getModelDeclCSAccess().getNameAssignment_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index, inst);
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("name",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("name");
		if(valueSerializer.isValid(obj.getEObject(), grammarAccess.getModelDeclCSAccess().getNameUnrestrictedNameParserRuleCall_0_0(), value, null)) {
			type = AssignmentType.DATATYPE_RULE_CALL;
			element = grammarAccess.getModelDeclCSAccess().getNameUnrestrictedNameParserRuleCall_0_0();
			return obj;
		}
		return null;
	}

}

// ":"
protected class ModelDeclCS_ColonKeyword_1 extends KeywordToken  {
	
	public ModelDeclCS_ColonKeyword_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getModelDeclCSAccess().getColonKeyword_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ModelDeclCS_NameAssignment_0(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// metaModelIds+=[pivot::Namespace|UnrestrictedName] | "{" metaModelIds+=[pivot::Namespace|UnrestrictedName] (","
// metaModelIds+=[pivot::Namespace|UnrestrictedName])* "}"
protected class ModelDeclCS_Alternatives_2 extends AlternativesToken {

	public ModelDeclCS_Alternatives_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Alternatives getGrammarElement() {
		return grammarAccess.getModelDeclCSAccess().getAlternatives_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ModelDeclCS_MetaModelIdsAssignment_2_0(lastRuleCallOrigin, this, 0, inst);
			case 1: return new ModelDeclCS_Group_2_1(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}

// metaModelIds+=[pivot::Namespace|UnrestrictedName]
protected class ModelDeclCS_MetaModelIdsAssignment_2_0 extends AssignmentToken  {
	
	public ModelDeclCS_MetaModelIdsAssignment_2_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getModelDeclCSAccess().getMetaModelIdsAssignment_2_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ModelDeclCS_ColonKeyword_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("metaModelIds",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("metaModelIds");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::CrossReferenceImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getModelDeclCSAccess().getMetaModelIdsNamespaceCrossReference_2_0_0().getType().getClassifier())) {
				type = AssignmentType.CROSS_REFERENCE;
				element = grammarAccess.getModelDeclCSAccess().getMetaModelIdsNamespaceCrossReference_2_0_0(); 
				return obj;
			}
		}
		return null;
	}

}

// "{" metaModelIds+=[pivot::Namespace|UnrestrictedName] ("," metaModelIds+=[pivot::Namespace|UnrestrictedName])* "}"
protected class ModelDeclCS_Group_2_1 extends GroupToken {
	
	public ModelDeclCS_Group_2_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getModelDeclCSAccess().getGroup_2_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ModelDeclCS_RightCurlyBracketKeyword_2_1_3(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// "{"
protected class ModelDeclCS_LeftCurlyBracketKeyword_2_1_0 extends KeywordToken  {
	
	public ModelDeclCS_LeftCurlyBracketKeyword_2_1_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getModelDeclCSAccess().getLeftCurlyBracketKeyword_2_1_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ModelDeclCS_ColonKeyword_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// metaModelIds+=[pivot::Namespace|UnrestrictedName]
protected class ModelDeclCS_MetaModelIdsAssignment_2_1_1 extends AssignmentToken  {
	
	public ModelDeclCS_MetaModelIdsAssignment_2_1_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getModelDeclCSAccess().getMetaModelIdsAssignment_2_1_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ModelDeclCS_LeftCurlyBracketKeyword_2_1_0(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("metaModelIds",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("metaModelIds");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::CrossReferenceImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getModelDeclCSAccess().getMetaModelIdsNamespaceCrossReference_2_1_1_0().getType().getClassifier())) {
				type = AssignmentType.CROSS_REFERENCE;
				element = grammarAccess.getModelDeclCSAccess().getMetaModelIdsNamespaceCrossReference_2_1_1_0(); 
				return obj;
			}
		}
		return null;
	}

}

// ("," metaModelIds+=[pivot::Namespace|UnrestrictedName])*
protected class ModelDeclCS_Group_2_1_2 extends GroupToken {
	
	public ModelDeclCS_Group_2_1_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getModelDeclCSAccess().getGroup_2_1_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ModelDeclCS_MetaModelIdsAssignment_2_1_2_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// ","
protected class ModelDeclCS_CommaKeyword_2_1_2_0 extends KeywordToken  {
	
	public ModelDeclCS_CommaKeyword_2_1_2_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getModelDeclCSAccess().getCommaKeyword_2_1_2_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ModelDeclCS_Group_2_1_2(lastRuleCallOrigin, this, 0, inst);
			case 1: return new ModelDeclCS_MetaModelIdsAssignment_2_1_1(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}

// metaModelIds+=[pivot::Namespace|UnrestrictedName]
protected class ModelDeclCS_MetaModelIdsAssignment_2_1_2_1 extends AssignmentToken  {
	
	public ModelDeclCS_MetaModelIdsAssignment_2_1_2_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getModelDeclCSAccess().getMetaModelIdsAssignment_2_1_2_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ModelDeclCS_CommaKeyword_2_1_2_0(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("metaModelIds",false)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("metaModelIds");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::CrossReferenceImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getModelDeclCSAccess().getMetaModelIdsNamespaceCrossReference_2_1_2_1_0().getType().getClassifier())) {
				type = AssignmentType.CROSS_REFERENCE;
				element = grammarAccess.getModelDeclCSAccess().getMetaModelIdsNamespaceCrossReference_2_1_2_1_0(); 
				return obj;
			}
		}
		return null;
	}

}


// "}"
protected class ModelDeclCS_RightCurlyBracketKeyword_2_1_3 extends KeywordToken  {
	
	public ModelDeclCS_RightCurlyBracketKeyword_2_1_3(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getModelDeclCSAccess().getRightCurlyBracketKeyword_2_1_3();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ModelDeclCS_Group_2_1_2(lastRuleCallOrigin, this, 0, inst);
			case 1: return new ModelDeclCS_MetaModelIdsAssignment_2_1_1(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}




/************ end Rule ModelDeclCS ****************/


/************ begin Rule ObjectTemplateCS ****************
 *
 * ObjectTemplateCS:
 * 	name=UnrestrictedName? ":" type=TypedRefCS "{" (propertyTemplates+=PropertyTemplateCS (","
 * 	propertyTemplates+=PropertyTemplateCS)*)? "}";
 *
 **/

// name=UnrestrictedName? ":" type=TypedRefCS "{" (propertyTemplates+=PropertyTemplateCS (","
// propertyTemplates+=PropertyTemplateCS)*)? "}"
protected class ObjectTemplateCS_Group extends GroupToken {
	
	public ObjectTemplateCS_Group(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getObjectTemplateCSAccess().getGroup();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ObjectTemplateCS_RightCurlyBracketKeyword_5(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getObjectTemplateCSRule().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// name=UnrestrictedName?
protected class ObjectTemplateCS_NameAssignment_0 extends AssignmentToken  {
	
	public ObjectTemplateCS_NameAssignment_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getObjectTemplateCSAccess().getNameAssignment_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index, inst);
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("name",false)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("name");
		if(valueSerializer.isValid(obj.getEObject(), grammarAccess.getObjectTemplateCSAccess().getNameUnrestrictedNameParserRuleCall_0_0(), value, null)) {
			type = AssignmentType.DATATYPE_RULE_CALL;
			element = grammarAccess.getObjectTemplateCSAccess().getNameUnrestrictedNameParserRuleCall_0_0();
			return obj;
		}
		return null;
	}

}

// ":"
protected class ObjectTemplateCS_ColonKeyword_1 extends KeywordToken  {
	
	public ObjectTemplateCS_ColonKeyword_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getObjectTemplateCSAccess().getColonKeyword_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ObjectTemplateCS_NameAssignment_0(lastRuleCallOrigin, this, 0, inst);
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index - 1, inst);
		}	
	}

}

// type=TypedRefCS
protected class ObjectTemplateCS_TypeAssignment_2 extends AssignmentToken  {
	
	public ObjectTemplateCS_TypeAssignment_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getObjectTemplateCSAccess().getTypeAssignment_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TypedRefCS_Alternatives(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("type",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("type");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getTypedRefCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getObjectTemplateCSAccess().getTypeTypedRefCSParserRuleCall_2_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new ObjectTemplateCS_ColonKeyword_1(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}

// "{"
protected class ObjectTemplateCS_LeftCurlyBracketKeyword_3 extends KeywordToken  {
	
	public ObjectTemplateCS_LeftCurlyBracketKeyword_3(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getObjectTemplateCSAccess().getLeftCurlyBracketKeyword_3();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ObjectTemplateCS_TypeAssignment_2(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// (propertyTemplates+=PropertyTemplateCS ("," propertyTemplates+=PropertyTemplateCS)*)?
protected class ObjectTemplateCS_Group_4 extends GroupToken {
	
	public ObjectTemplateCS_Group_4(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getObjectTemplateCSAccess().getGroup_4();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ObjectTemplateCS_Group_4_1(lastRuleCallOrigin, this, 0, inst);
			case 1: return new ObjectTemplateCS_PropertyTemplatesAssignment_4_0(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}

// propertyTemplates+=PropertyTemplateCS
protected class ObjectTemplateCS_PropertyTemplatesAssignment_4_0 extends AssignmentToken  {
	
	public ObjectTemplateCS_PropertyTemplatesAssignment_4_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getObjectTemplateCSAccess().getPropertyTemplatesAssignment_4_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PropertyTemplateCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("propertyTemplates",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("propertyTemplates");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getPropertyTemplateCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getObjectTemplateCSAccess().getPropertyTemplatesPropertyTemplateCSParserRuleCall_4_0_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new ObjectTemplateCS_LeftCurlyBracketKeyword_3(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}

// ("," propertyTemplates+=PropertyTemplateCS)*
protected class ObjectTemplateCS_Group_4_1 extends GroupToken {
	
	public ObjectTemplateCS_Group_4_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getObjectTemplateCSAccess().getGroup_4_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ObjectTemplateCS_PropertyTemplatesAssignment_4_1_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// ","
protected class ObjectTemplateCS_CommaKeyword_4_1_0 extends KeywordToken  {
	
	public ObjectTemplateCS_CommaKeyword_4_1_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getObjectTemplateCSAccess().getCommaKeyword_4_1_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ObjectTemplateCS_Group_4_1(lastRuleCallOrigin, this, 0, inst);
			case 1: return new ObjectTemplateCS_PropertyTemplatesAssignment_4_0(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}

// propertyTemplates+=PropertyTemplateCS
protected class ObjectTemplateCS_PropertyTemplatesAssignment_4_1_1 extends AssignmentToken  {
	
	public ObjectTemplateCS_PropertyTemplatesAssignment_4_1_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getObjectTemplateCSAccess().getPropertyTemplatesAssignment_4_1_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PropertyTemplateCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("propertyTemplates",false)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("propertyTemplates");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getPropertyTemplateCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getObjectTemplateCSAccess().getPropertyTemplatesPropertyTemplateCSParserRuleCall_4_1_1_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new ObjectTemplateCS_CommaKeyword_4_1_0(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}



// "}"
protected class ObjectTemplateCS_RightCurlyBracketKeyword_5 extends KeywordToken  {
	
	public ObjectTemplateCS_RightCurlyBracketKeyword_5(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getObjectTemplateCSAccess().getRightCurlyBracketKeyword_5();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ObjectTemplateCS_Group_4(lastRuleCallOrigin, this, 0, inst);
			case 1: return new ObjectTemplateCS_LeftCurlyBracketKeyword_3(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}


/************ end Rule ObjectTemplateCS ****************/


/************ begin Rule ParamDeclarationCS ****************
 *
 * ParamDeclarationCS:
 * 	name=UnrestrictedName ":" ownedType=TypedRefCS;
 *
 **/

// name=UnrestrictedName ":" ownedType=TypedRefCS
protected class ParamDeclarationCS_Group extends GroupToken {
	
	public ParamDeclarationCS_Group(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getParamDeclarationCSAccess().getGroup();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ParamDeclarationCS_OwnedTypeAssignment_2(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getParamDeclarationCSRule().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// name=UnrestrictedName
protected class ParamDeclarationCS_NameAssignment_0 extends AssignmentToken  {
	
	public ParamDeclarationCS_NameAssignment_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getParamDeclarationCSAccess().getNameAssignment_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index, inst);
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("name",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("name");
		if(valueSerializer.isValid(obj.getEObject(), grammarAccess.getParamDeclarationCSAccess().getNameUnrestrictedNameParserRuleCall_0_0(), value, null)) {
			type = AssignmentType.DATATYPE_RULE_CALL;
			element = grammarAccess.getParamDeclarationCSAccess().getNameUnrestrictedNameParserRuleCall_0_0();
			return obj;
		}
		return null;
	}

}

// ":"
protected class ParamDeclarationCS_ColonKeyword_1 extends KeywordToken  {
	
	public ParamDeclarationCS_ColonKeyword_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getParamDeclarationCSAccess().getColonKeyword_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ParamDeclarationCS_NameAssignment_0(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// ownedType=TypedRefCS
protected class ParamDeclarationCS_OwnedTypeAssignment_2 extends AssignmentToken  {
	
	public ParamDeclarationCS_OwnedTypeAssignment_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getParamDeclarationCSAccess().getOwnedTypeAssignment_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TypedRefCS_Alternatives(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("ownedType",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("ownedType");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getTypedRefCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getParamDeclarationCSAccess().getOwnedTypeTypedRefCSParserRuleCall_2_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new ParamDeclarationCS_ColonKeyword_1(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}


/************ end Rule ParamDeclarationCS ****************/


/************ begin Rule PredicateCS ****************
 *
 * PredicateCS:
 * 	expr=ExpCS ";";
 *
 **/

// expr=ExpCS ";"
protected class PredicateCS_Group extends GroupToken {
	
	public PredicateCS_Group(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getPredicateCSAccess().getGroup();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PredicateCS_SemicolonKeyword_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getPredicateCSRule().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// expr=ExpCS
protected class PredicateCS_ExprAssignment_0 extends AssignmentToken  {
	
	public PredicateCS_ExprAssignment_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getPredicateCSAccess().getExprAssignment_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ExpCS_Alternatives(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("expr",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("expr");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getExpCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getPredicateCSAccess().getExprExpCSParserRuleCall_0_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(next, actIndex , index, consumed);
		}	
	}	
}

// ";"
protected class PredicateCS_SemicolonKeyword_1 extends KeywordToken  {
	
	public PredicateCS_SemicolonKeyword_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getPredicateCSAccess().getSemicolonKeyword_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PredicateCS_ExprAssignment_0(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}


/************ end Rule PredicateCS ****************/


/************ begin Rule PrimitiveTypeDomainCS ****************
 *
 * PrimitiveTypeDomainCS:
 * 	"primitive" "domain" name=UnrestrictedName ":" type=TypedRefCS ";";
 *
 **/

// "primitive" "domain" name=UnrestrictedName ":" type=TypedRefCS ";"
protected class PrimitiveTypeDomainCS_Group extends GroupToken {
	
	public PrimitiveTypeDomainCS_Group(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getPrimitiveTypeDomainCSAccess().getGroup();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PrimitiveTypeDomainCS_SemicolonKeyword_5(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getPrimitiveTypeDomainCSRule().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// "primitive"
protected class PrimitiveTypeDomainCS_PrimitiveKeyword_0 extends KeywordToken  {
	
	public PrimitiveTypeDomainCS_PrimitiveKeyword_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getPrimitiveTypeDomainCSAccess().getPrimitiveKeyword_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index, inst);
		}	
	}

}

// "domain"
protected class PrimitiveTypeDomainCS_DomainKeyword_1 extends KeywordToken  {
	
	public PrimitiveTypeDomainCS_DomainKeyword_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getPrimitiveTypeDomainCSAccess().getDomainKeyword_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PrimitiveTypeDomainCS_PrimitiveKeyword_0(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// name=UnrestrictedName
protected class PrimitiveTypeDomainCS_NameAssignment_2 extends AssignmentToken  {
	
	public PrimitiveTypeDomainCS_NameAssignment_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getPrimitiveTypeDomainCSAccess().getNameAssignment_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PrimitiveTypeDomainCS_DomainKeyword_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("name",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("name");
		if(valueSerializer.isValid(obj.getEObject(), grammarAccess.getPrimitiveTypeDomainCSAccess().getNameUnrestrictedNameParserRuleCall_2_0(), value, null)) {
			type = AssignmentType.DATATYPE_RULE_CALL;
			element = grammarAccess.getPrimitiveTypeDomainCSAccess().getNameUnrestrictedNameParserRuleCall_2_0();
			return obj;
		}
		return null;
	}

}

// ":"
protected class PrimitiveTypeDomainCS_ColonKeyword_3 extends KeywordToken  {
	
	public PrimitiveTypeDomainCS_ColonKeyword_3(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getPrimitiveTypeDomainCSAccess().getColonKeyword_3();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PrimitiveTypeDomainCS_NameAssignment_2(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// type=TypedRefCS
protected class PrimitiveTypeDomainCS_TypeAssignment_4 extends AssignmentToken  {
	
	public PrimitiveTypeDomainCS_TypeAssignment_4(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getPrimitiveTypeDomainCSAccess().getTypeAssignment_4();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TypedRefCS_Alternatives(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("type",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("type");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getTypedRefCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getPrimitiveTypeDomainCSAccess().getTypeTypedRefCSParserRuleCall_4_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new PrimitiveTypeDomainCS_ColonKeyword_3(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}

// ";"
protected class PrimitiveTypeDomainCS_SemicolonKeyword_5 extends KeywordToken  {
	
	public PrimitiveTypeDomainCS_SemicolonKeyword_5(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getPrimitiveTypeDomainCSAccess().getSemicolonKeyword_5();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PrimitiveTypeDomainCS_TypeAssignment_4(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}


/************ end Rule PrimitiveTypeDomainCS ****************/


/************ begin Rule PropertyTemplateCS ****************
 *
 * PropertyTemplateCS:
 * 	(propertyId=[pivot::Property|UnrestrictedName] | "opposite" "(" oppositePropertyId=PathNameCS ")") "="
 * 	expression=ExpCSOrTemplateCS;
 *
 **/

// (propertyId=[pivot::Property|UnrestrictedName] | "opposite" "(" oppositePropertyId=PathNameCS ")") "="
// expression=ExpCSOrTemplateCS
protected class PropertyTemplateCS_Group extends GroupToken {
	
	public PropertyTemplateCS_Group(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getPropertyTemplateCSAccess().getGroup();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PropertyTemplateCS_ExpressionAssignment_2(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getPropertyTemplateCSRule().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// propertyId=[pivot::Property|UnrestrictedName] | "opposite" "(" oppositePropertyId=PathNameCS ")"
protected class PropertyTemplateCS_Alternatives_0 extends AlternativesToken {

	public PropertyTemplateCS_Alternatives_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Alternatives getGrammarElement() {
		return grammarAccess.getPropertyTemplateCSAccess().getAlternatives_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PropertyTemplateCS_PropertyIdAssignment_0_0(lastRuleCallOrigin, this, 0, inst);
			case 1: return new PropertyTemplateCS_Group_0_1(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}

// propertyId=[pivot::Property|UnrestrictedName]
protected class PropertyTemplateCS_PropertyIdAssignment_0_0 extends AssignmentToken  {
	
	public PropertyTemplateCS_PropertyIdAssignment_0_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getPropertyTemplateCSAccess().getPropertyIdAssignment_0_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index, inst);
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("propertyId",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("propertyId");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::CrossReferenceImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getPropertyTemplateCSAccess().getPropertyIdPropertyCrossReference_0_0_0().getType().getClassifier())) {
				type = AssignmentType.CROSS_REFERENCE;
				element = grammarAccess.getPropertyTemplateCSAccess().getPropertyIdPropertyCrossReference_0_0_0(); 
				return obj;
			}
		}
		return null;
	}

}

// "opposite" "(" oppositePropertyId=PathNameCS ")"
protected class PropertyTemplateCS_Group_0_1 extends GroupToken {
	
	public PropertyTemplateCS_Group_0_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getPropertyTemplateCSAccess().getGroup_0_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PropertyTemplateCS_RightParenthesisKeyword_0_1_3(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// "opposite"
protected class PropertyTemplateCS_OppositeKeyword_0_1_0 extends KeywordToken  {
	
	public PropertyTemplateCS_OppositeKeyword_0_1_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getPropertyTemplateCSAccess().getOppositeKeyword_0_1_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index, inst);
		}	
	}

}

// "("
protected class PropertyTemplateCS_LeftParenthesisKeyword_0_1_1 extends KeywordToken  {
	
	public PropertyTemplateCS_LeftParenthesisKeyword_0_1_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getPropertyTemplateCSAccess().getLeftParenthesisKeyword_0_1_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PropertyTemplateCS_OppositeKeyword_0_1_0(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// oppositePropertyId=PathNameCS
protected class PropertyTemplateCS_OppositePropertyIdAssignment_0_1_2 extends AssignmentToken  {
	
	public PropertyTemplateCS_OppositePropertyIdAssignment_0_1_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getPropertyTemplateCSAccess().getOppositePropertyIdAssignment_0_1_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PathNameCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("oppositePropertyId",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("oppositePropertyId");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getPathNameCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getPropertyTemplateCSAccess().getOppositePropertyIdPathNameCSParserRuleCall_0_1_2_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new PropertyTemplateCS_LeftParenthesisKeyword_0_1_1(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}

// ")"
protected class PropertyTemplateCS_RightParenthesisKeyword_0_1_3 extends KeywordToken  {
	
	public PropertyTemplateCS_RightParenthesisKeyword_0_1_3(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getPropertyTemplateCSAccess().getRightParenthesisKeyword_0_1_3();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PropertyTemplateCS_OppositePropertyIdAssignment_0_1_2(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}



// "="
protected class PropertyTemplateCS_EqualsSignKeyword_1 extends KeywordToken  {
	
	public PropertyTemplateCS_EqualsSignKeyword_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getPropertyTemplateCSAccess().getEqualsSignKeyword_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PropertyTemplateCS_Alternatives_0(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// expression=ExpCSOrTemplateCS
protected class PropertyTemplateCS_ExpressionAssignment_2 extends AssignmentToken  {
	
	public PropertyTemplateCS_ExpressionAssignment_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getPropertyTemplateCSAccess().getExpressionAssignment_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ExpCSOrTemplateCS_Alternatives(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("expression",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("expression");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getExpCSOrTemplateCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getPropertyTemplateCSAccess().getExpressionExpCSOrTemplateCSParserRuleCall_2_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new PropertyTemplateCS_EqualsSignKeyword_1(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}


/************ end Rule PropertyTemplateCS ****************/


/************ begin Rule QueryCS ****************
 *
 * QueryCS:
 * 	"query" name=UnrestrictedName "(" (inputParamDeclarations+=ParamDeclarationCS (","
 * 	inputParamDeclarations+=ParamDeclarationCS)*)? ")" ":" ownedType=TypedRefCS (";" | "{" expression=ExpCS "}");
 *
 **/

// "query" name=UnrestrictedName "(" (inputParamDeclarations+=ParamDeclarationCS (","
// inputParamDeclarations+=ParamDeclarationCS)*)? ")" ":" ownedType=TypedRefCS (";" | "{" expression=ExpCS "}")
protected class QueryCS_Group extends GroupToken {
	
	public QueryCS_Group(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getQueryCSAccess().getGroup();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new QueryCS_Alternatives_7(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getQueryCSRule().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// "query"
protected class QueryCS_QueryKeyword_0 extends KeywordToken  {
	
	public QueryCS_QueryKeyword_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getQueryCSAccess().getQueryKeyword_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index, inst);
		}	
	}

}

// name=UnrestrictedName
protected class QueryCS_NameAssignment_1 extends AssignmentToken  {
	
	public QueryCS_NameAssignment_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getQueryCSAccess().getNameAssignment_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new QueryCS_QueryKeyword_0(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("name",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("name");
		if(valueSerializer.isValid(obj.getEObject(), grammarAccess.getQueryCSAccess().getNameUnrestrictedNameParserRuleCall_1_0(), value, null)) {
			type = AssignmentType.DATATYPE_RULE_CALL;
			element = grammarAccess.getQueryCSAccess().getNameUnrestrictedNameParserRuleCall_1_0();
			return obj;
		}
		return null;
	}

}

// "("
protected class QueryCS_LeftParenthesisKeyword_2 extends KeywordToken  {
	
	public QueryCS_LeftParenthesisKeyword_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getQueryCSAccess().getLeftParenthesisKeyword_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new QueryCS_NameAssignment_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// (inputParamDeclarations+=ParamDeclarationCS ("," inputParamDeclarations+=ParamDeclarationCS)*)?
protected class QueryCS_Group_3 extends GroupToken {
	
	public QueryCS_Group_3(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getQueryCSAccess().getGroup_3();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new QueryCS_Group_3_1(lastRuleCallOrigin, this, 0, inst);
			case 1: return new QueryCS_InputParamDeclarationsAssignment_3_0(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}

// inputParamDeclarations+=ParamDeclarationCS
protected class QueryCS_InputParamDeclarationsAssignment_3_0 extends AssignmentToken  {
	
	public QueryCS_InputParamDeclarationsAssignment_3_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getQueryCSAccess().getInputParamDeclarationsAssignment_3_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ParamDeclarationCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("inputParamDeclarations",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("inputParamDeclarations");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getParamDeclarationCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getQueryCSAccess().getInputParamDeclarationsParamDeclarationCSParserRuleCall_3_0_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new QueryCS_LeftParenthesisKeyword_2(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}

// ("," inputParamDeclarations+=ParamDeclarationCS)*
protected class QueryCS_Group_3_1 extends GroupToken {
	
	public QueryCS_Group_3_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getQueryCSAccess().getGroup_3_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new QueryCS_InputParamDeclarationsAssignment_3_1_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// ","
protected class QueryCS_CommaKeyword_3_1_0 extends KeywordToken  {
	
	public QueryCS_CommaKeyword_3_1_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getQueryCSAccess().getCommaKeyword_3_1_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new QueryCS_Group_3_1(lastRuleCallOrigin, this, 0, inst);
			case 1: return new QueryCS_InputParamDeclarationsAssignment_3_0(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}

// inputParamDeclarations+=ParamDeclarationCS
protected class QueryCS_InputParamDeclarationsAssignment_3_1_1 extends AssignmentToken  {
	
	public QueryCS_InputParamDeclarationsAssignment_3_1_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getQueryCSAccess().getInputParamDeclarationsAssignment_3_1_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ParamDeclarationCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("inputParamDeclarations",false)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("inputParamDeclarations");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getParamDeclarationCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getQueryCSAccess().getInputParamDeclarationsParamDeclarationCSParserRuleCall_3_1_1_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new QueryCS_CommaKeyword_3_1_0(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}



// ")"
protected class QueryCS_RightParenthesisKeyword_4 extends KeywordToken  {
	
	public QueryCS_RightParenthesisKeyword_4(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getQueryCSAccess().getRightParenthesisKeyword_4();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new QueryCS_Group_3(lastRuleCallOrigin, this, 0, inst);
			case 1: return new QueryCS_LeftParenthesisKeyword_2(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}

// ":"
protected class QueryCS_ColonKeyword_5 extends KeywordToken  {
	
	public QueryCS_ColonKeyword_5(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getQueryCSAccess().getColonKeyword_5();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new QueryCS_RightParenthesisKeyword_4(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// ownedType=TypedRefCS
protected class QueryCS_OwnedTypeAssignment_6 extends AssignmentToken  {
	
	public QueryCS_OwnedTypeAssignment_6(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getQueryCSAccess().getOwnedTypeAssignment_6();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TypedRefCS_Alternatives(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("ownedType",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("ownedType");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getTypedRefCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getQueryCSAccess().getOwnedTypeTypedRefCSParserRuleCall_6_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new QueryCS_ColonKeyword_5(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}

// ";" | "{" expression=ExpCS "}"
protected class QueryCS_Alternatives_7 extends AlternativesToken {

	public QueryCS_Alternatives_7(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Alternatives getGrammarElement() {
		return grammarAccess.getQueryCSAccess().getAlternatives_7();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new QueryCS_SemicolonKeyword_7_0(lastRuleCallOrigin, this, 0, inst);
			case 1: return new QueryCS_Group_7_1(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}

// ";"
protected class QueryCS_SemicolonKeyword_7_0 extends KeywordToken  {
	
	public QueryCS_SemicolonKeyword_7_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getQueryCSAccess().getSemicolonKeyword_7_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new QueryCS_OwnedTypeAssignment_6(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// "{" expression=ExpCS "}"
protected class QueryCS_Group_7_1 extends GroupToken {
	
	public QueryCS_Group_7_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getQueryCSAccess().getGroup_7_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new QueryCS_RightCurlyBracketKeyword_7_1_2(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// "{"
protected class QueryCS_LeftCurlyBracketKeyword_7_1_0 extends KeywordToken  {
	
	public QueryCS_LeftCurlyBracketKeyword_7_1_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getQueryCSAccess().getLeftCurlyBracketKeyword_7_1_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new QueryCS_OwnedTypeAssignment_6(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// expression=ExpCS
protected class QueryCS_ExpressionAssignment_7_1_1 extends AssignmentToken  {
	
	public QueryCS_ExpressionAssignment_7_1_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getQueryCSAccess().getExpressionAssignment_7_1_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ExpCS_Alternatives(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("expression",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("expression");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getExpCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getQueryCSAccess().getExpressionExpCSParserRuleCall_7_1_1_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new QueryCS_LeftCurlyBracketKeyword_7_1_0(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}

// "}"
protected class QueryCS_RightCurlyBracketKeyword_7_1_2 extends KeywordToken  {
	
	public QueryCS_RightCurlyBracketKeyword_7_1_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getQueryCSAccess().getRightCurlyBracketKeyword_7_1_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new QueryCS_ExpressionAssignment_7_1_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}




/************ end Rule QueryCS ****************/


/************ begin Rule RelationCS ****************
 *
 * RelationCS:
 * 	top?="top"? "relation" name=UnrestrictedName ("overrides" overrides=[qvtrelation::Relation|UnrestrictedName])? "{"
 * 	varDeclarations+=VarDeclarationCS* (domains+=DomainCS | domains+=PrimitiveTypeDomainCS)+ when=WhenCS? where=WhereCS?
 * 	"}";
 *
 **/

// top?="top"? "relation" name=UnrestrictedName ("overrides" overrides=[qvtrelation::Relation|UnrestrictedName])? "{"
// varDeclarations+=VarDeclarationCS* (domains+=DomainCS | domains+=PrimitiveTypeDomainCS)+ when=WhenCS? where=WhereCS?
// "}"
protected class RelationCS_Group extends GroupToken {
	
	public RelationCS_Group(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getRelationCSAccess().getGroup();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new RelationCS_RightCurlyBracketKeyword_9(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getRelationCSRule().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// top?="top"?
protected class RelationCS_TopAssignment_0 extends AssignmentToken  {
	
	public RelationCS_TopAssignment_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getRelationCSAccess().getTopAssignment_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index, inst);
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("top",false)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("top");
		if(Boolean.TRUE.equals(value)) { // org::eclipse::xtext::impl::KeywordImpl
			type = AssignmentType.KEYWORD;
			element = grammarAccess.getRelationCSAccess().getTopTopKeyword_0_0();
			return obj;
		}
		return null;
	}

}

// "relation"
protected class RelationCS_RelationKeyword_1 extends KeywordToken  {
	
	public RelationCS_RelationKeyword_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getRelationCSAccess().getRelationKeyword_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new RelationCS_TopAssignment_0(lastRuleCallOrigin, this, 0, inst);
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index - 1, inst);
		}	
	}

}

// name=UnrestrictedName
protected class RelationCS_NameAssignment_2 extends AssignmentToken  {
	
	public RelationCS_NameAssignment_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getRelationCSAccess().getNameAssignment_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new RelationCS_RelationKeyword_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("name",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("name");
		if(valueSerializer.isValid(obj.getEObject(), grammarAccess.getRelationCSAccess().getNameUnrestrictedNameParserRuleCall_2_0(), value, null)) {
			type = AssignmentType.DATATYPE_RULE_CALL;
			element = grammarAccess.getRelationCSAccess().getNameUnrestrictedNameParserRuleCall_2_0();
			return obj;
		}
		return null;
	}

}

// ("overrides" overrides=[qvtrelation::Relation|UnrestrictedName])?
protected class RelationCS_Group_3 extends GroupToken {
	
	public RelationCS_Group_3(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getRelationCSAccess().getGroup_3();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new RelationCS_OverridesAssignment_3_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// "overrides"
protected class RelationCS_OverridesKeyword_3_0 extends KeywordToken  {
	
	public RelationCS_OverridesKeyword_3_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getRelationCSAccess().getOverridesKeyword_3_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new RelationCS_NameAssignment_2(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// overrides=[qvtrelation::Relation|UnrestrictedName]
protected class RelationCS_OverridesAssignment_3_1 extends AssignmentToken  {
	
	public RelationCS_OverridesAssignment_3_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getRelationCSAccess().getOverridesAssignment_3_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new RelationCS_OverridesKeyword_3_0(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("overrides",false)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("overrides");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::CrossReferenceImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getRelationCSAccess().getOverridesRelationCrossReference_3_1_0().getType().getClassifier())) {
				type = AssignmentType.CROSS_REFERENCE;
				element = grammarAccess.getRelationCSAccess().getOverridesRelationCrossReference_3_1_0(); 
				return obj;
			}
		}
		return null;
	}

}


// "{"
protected class RelationCS_LeftCurlyBracketKeyword_4 extends KeywordToken  {
	
	public RelationCS_LeftCurlyBracketKeyword_4(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getRelationCSAccess().getLeftCurlyBracketKeyword_4();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new RelationCS_Group_3(lastRuleCallOrigin, this, 0, inst);
			case 1: return new RelationCS_NameAssignment_2(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}

// varDeclarations+=VarDeclarationCS*
protected class RelationCS_VarDeclarationsAssignment_5 extends AssignmentToken  {
	
	public RelationCS_VarDeclarationsAssignment_5(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getRelationCSAccess().getVarDeclarationsAssignment_5();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new VarDeclarationCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("varDeclarations",false)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("varDeclarations");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getVarDeclarationCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getRelationCSAccess().getVarDeclarationsVarDeclarationCSParserRuleCall_5_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new RelationCS_VarDeclarationsAssignment_5(lastRuleCallOrigin, next, actIndex, consumed);
			case 1: return new RelationCS_LeftCurlyBracketKeyword_4(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}

// (domains+=DomainCS | domains+=PrimitiveTypeDomainCS)+
protected class RelationCS_Alternatives_6 extends AlternativesToken {

	public RelationCS_Alternatives_6(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Alternatives getGrammarElement() {
		return grammarAccess.getRelationCSAccess().getAlternatives_6();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new RelationCS_DomainsAssignment_6_0(lastRuleCallOrigin, this, 0, inst);
			case 1: return new RelationCS_DomainsAssignment_6_1(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}

// domains+=DomainCS
protected class RelationCS_DomainsAssignment_6_0 extends AssignmentToken  {
	
	public RelationCS_DomainsAssignment_6_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getRelationCSAccess().getDomainsAssignment_6_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new DomainCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("domains",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("domains");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getDomainCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getRelationCSAccess().getDomainsDomainCSParserRuleCall_6_0_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new RelationCS_Alternatives_6(lastRuleCallOrigin, next, actIndex, consumed);
			case 1: return new RelationCS_VarDeclarationsAssignment_5(lastRuleCallOrigin, next, actIndex, consumed);
			case 2: return new RelationCS_LeftCurlyBracketKeyword_4(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}

// domains+=PrimitiveTypeDomainCS
protected class RelationCS_DomainsAssignment_6_1 extends AssignmentToken  {
	
	public RelationCS_DomainsAssignment_6_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getRelationCSAccess().getDomainsAssignment_6_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PrimitiveTypeDomainCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("domains",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("domains");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getPrimitiveTypeDomainCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getRelationCSAccess().getDomainsPrimitiveTypeDomainCSParserRuleCall_6_1_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new RelationCS_Alternatives_6(lastRuleCallOrigin, next, actIndex, consumed);
			case 1: return new RelationCS_VarDeclarationsAssignment_5(lastRuleCallOrigin, next, actIndex, consumed);
			case 2: return new RelationCS_LeftCurlyBracketKeyword_4(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}


// when=WhenCS?
protected class RelationCS_WhenAssignment_7 extends AssignmentToken  {
	
	public RelationCS_WhenAssignment_7(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getRelationCSAccess().getWhenAssignment_7();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new WhenCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("when",false)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("when");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getWhenCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getRelationCSAccess().getWhenWhenCSParserRuleCall_7_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new RelationCS_Alternatives_6(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}

// where=WhereCS?
protected class RelationCS_WhereAssignment_8 extends AssignmentToken  {
	
	public RelationCS_WhereAssignment_8(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getRelationCSAccess().getWhereAssignment_8();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new WhereCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("where",false)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("where");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getWhereCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getRelationCSAccess().getWhereWhereCSParserRuleCall_8_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new RelationCS_WhenAssignment_7(lastRuleCallOrigin, next, actIndex, consumed);
			case 1: return new RelationCS_Alternatives_6(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}

// "}"
protected class RelationCS_RightCurlyBracketKeyword_9 extends KeywordToken  {
	
	public RelationCS_RightCurlyBracketKeyword_9(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getRelationCSAccess().getRightCurlyBracketKeyword_9();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new RelationCS_WhereAssignment_8(lastRuleCallOrigin, this, 0, inst);
			case 1: return new RelationCS_WhenAssignment_7(lastRuleCallOrigin, this, 1, inst);
			case 2: return new RelationCS_Alternatives_6(lastRuleCallOrigin, this, 2, inst);
			default: return null;
		}	
	}

}


/************ end Rule RelationCS ****************/


/************ begin Rule TemplateCS ****************
 *
 * TemplateCS:
 * 	(CollectionTemplateCS | ObjectTemplateCS) ("{" guardExpression=ExpCS "}")?;
 *
 **/

// (CollectionTemplateCS | ObjectTemplateCS) ("{" guardExpression=ExpCS "}")?
protected class TemplateCS_Group extends GroupToken {
	
	public TemplateCS_Group(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getTemplateCSAccess().getGroup();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TemplateCS_Group_1(lastRuleCallOrigin, this, 0, inst);
			case 1: return new TemplateCS_Alternatives_0(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getCollectionTemplateCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getObjectTemplateCSRule().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// CollectionTemplateCS | ObjectTemplateCS
protected class TemplateCS_Alternatives_0 extends AlternativesToken {

	public TemplateCS_Alternatives_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Alternatives getGrammarElement() {
		return grammarAccess.getTemplateCSAccess().getAlternatives_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TemplateCS_CollectionTemplateCSParserRuleCall_0_0(lastRuleCallOrigin, this, 0, inst);
			case 1: return new TemplateCS_ObjectTemplateCSParserRuleCall_0_1(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}

// CollectionTemplateCS
protected class TemplateCS_CollectionTemplateCSParserRuleCall_0_0 extends RuleCallToken {
	
	public TemplateCS_CollectionTemplateCSParserRuleCall_0_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public RuleCall getGrammarElement() {
		return grammarAccess.getTemplateCSAccess().getCollectionTemplateCSParserRuleCall_0_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new CollectionTemplateCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getCollectionTemplateCSRule().getType().getClassifier())
			return null;
		if(checkForRecursion(CollectionTemplateCS_Group.class, eObjectConsumer)) return null;
		return eObjectConsumer;
	}
	
    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(next, actIndex , index, inst);
		}	
	}	
}

// ObjectTemplateCS
protected class TemplateCS_ObjectTemplateCSParserRuleCall_0_1 extends RuleCallToken {
	
	public TemplateCS_ObjectTemplateCSParserRuleCall_0_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public RuleCall getGrammarElement() {
		return grammarAccess.getTemplateCSAccess().getObjectTemplateCSParserRuleCall_0_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ObjectTemplateCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getObjectTemplateCSRule().getType().getClassifier())
			return null;
		if(checkForRecursion(ObjectTemplateCS_Group.class, eObjectConsumer)) return null;
		return eObjectConsumer;
	}
	
    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(next, actIndex , index, inst);
		}	
	}	
}


// ("{" guardExpression=ExpCS "}")?
protected class TemplateCS_Group_1 extends GroupToken {
	
	public TemplateCS_Group_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getTemplateCSAccess().getGroup_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TemplateCS_RightCurlyBracketKeyword_1_2(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// "{"
protected class TemplateCS_LeftCurlyBracketKeyword_1_0 extends KeywordToken  {
	
	public TemplateCS_LeftCurlyBracketKeyword_1_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getTemplateCSAccess().getLeftCurlyBracketKeyword_1_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TemplateCS_Alternatives_0(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// guardExpression=ExpCS
protected class TemplateCS_GuardExpressionAssignment_1_1 extends AssignmentToken  {
	
	public TemplateCS_GuardExpressionAssignment_1_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getTemplateCSAccess().getGuardExpressionAssignment_1_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ExpCS_Alternatives(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("guardExpression",false)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("guardExpression");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getExpCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getTemplateCSAccess().getGuardExpressionExpCSParserRuleCall_1_1_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new TemplateCS_LeftCurlyBracketKeyword_1_0(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}

// "}"
protected class TemplateCS_RightCurlyBracketKeyword_1_2 extends KeywordToken  {
	
	public TemplateCS_RightCurlyBracketKeyword_1_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getTemplateCSAccess().getRightCurlyBracketKeyword_1_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TemplateCS_GuardExpressionAssignment_1_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}



/************ end Rule TemplateCS ****************/


/************ begin Rule TransformationCS ****************
 *
 * TransformationCS:
 * 	"transformation" name=UnrestrictedName "(" modelDecls+=ModelDeclCS ("," modelDecls+=ModelDeclCS)* ")" ("extends"
 * 	extends+=[qvtbase::Transformation|UnrestrictedName] ("," extends+=[qvtbase::Transformation|UnrestrictedName])*)? "{"
 * 	keyDecls+=KeyDeclCS* (relation+=RelationCS | queries+=QueryCS)* "}";
 *
 **/

// "transformation" name=UnrestrictedName "(" modelDecls+=ModelDeclCS ("," modelDecls+=ModelDeclCS)* ")" ("extends"
// extends+=[qvtbase::Transformation|UnrestrictedName] ("," extends+=[qvtbase::Transformation|UnrestrictedName])*)? "{"
// keyDecls+=KeyDeclCS* (relation+=RelationCS | queries+=QueryCS)* "}"
protected class TransformationCS_Group extends GroupToken {
	
	public TransformationCS_Group(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getTransformationCSAccess().getGroup();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TransformationCS_RightCurlyBracketKeyword_10(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getTransformationCSRule().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// "transformation"
protected class TransformationCS_TransformationKeyword_0 extends KeywordToken  {
	
	public TransformationCS_TransformationKeyword_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getTransformationCSAccess().getTransformationKeyword_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index, inst);
		}	
	}

}

// name=UnrestrictedName
protected class TransformationCS_NameAssignment_1 extends AssignmentToken  {
	
	public TransformationCS_NameAssignment_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getTransformationCSAccess().getNameAssignment_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TransformationCS_TransformationKeyword_0(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("name",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("name");
		if(valueSerializer.isValid(obj.getEObject(), grammarAccess.getTransformationCSAccess().getNameUnrestrictedNameParserRuleCall_1_0(), value, null)) {
			type = AssignmentType.DATATYPE_RULE_CALL;
			element = grammarAccess.getTransformationCSAccess().getNameUnrestrictedNameParserRuleCall_1_0();
			return obj;
		}
		return null;
	}

}

// "("
protected class TransformationCS_LeftParenthesisKeyword_2 extends KeywordToken  {
	
	public TransformationCS_LeftParenthesisKeyword_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getTransformationCSAccess().getLeftParenthesisKeyword_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TransformationCS_NameAssignment_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// modelDecls+=ModelDeclCS
protected class TransformationCS_ModelDeclsAssignment_3 extends AssignmentToken  {
	
	public TransformationCS_ModelDeclsAssignment_3(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getTransformationCSAccess().getModelDeclsAssignment_3();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ModelDeclCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("modelDecls",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("modelDecls");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getModelDeclCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getTransformationCSAccess().getModelDeclsModelDeclCSParserRuleCall_3_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new TransformationCS_LeftParenthesisKeyword_2(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}

// ("," modelDecls+=ModelDeclCS)*
protected class TransformationCS_Group_4 extends GroupToken {
	
	public TransformationCS_Group_4(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getTransformationCSAccess().getGroup_4();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TransformationCS_ModelDeclsAssignment_4_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// ","
protected class TransformationCS_CommaKeyword_4_0 extends KeywordToken  {
	
	public TransformationCS_CommaKeyword_4_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getTransformationCSAccess().getCommaKeyword_4_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TransformationCS_Group_4(lastRuleCallOrigin, this, 0, inst);
			case 1: return new TransformationCS_ModelDeclsAssignment_3(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}

// modelDecls+=ModelDeclCS
protected class TransformationCS_ModelDeclsAssignment_4_1 extends AssignmentToken  {
	
	public TransformationCS_ModelDeclsAssignment_4_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getTransformationCSAccess().getModelDeclsAssignment_4_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ModelDeclCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("modelDecls",false)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("modelDecls");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getModelDeclCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getTransformationCSAccess().getModelDeclsModelDeclCSParserRuleCall_4_1_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new TransformationCS_CommaKeyword_4_0(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}


// ")"
protected class TransformationCS_RightParenthesisKeyword_5 extends KeywordToken  {
	
	public TransformationCS_RightParenthesisKeyword_5(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getTransformationCSAccess().getRightParenthesisKeyword_5();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TransformationCS_Group_4(lastRuleCallOrigin, this, 0, inst);
			case 1: return new TransformationCS_ModelDeclsAssignment_3(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}

// ("extends" extends+=[qvtbase::Transformation|UnrestrictedName] (","
// extends+=[qvtbase::Transformation|UnrestrictedName])*)?
protected class TransformationCS_Group_6 extends GroupToken {
	
	public TransformationCS_Group_6(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getTransformationCSAccess().getGroup_6();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TransformationCS_Group_6_2(lastRuleCallOrigin, this, 0, inst);
			case 1: return new TransformationCS_ExtendsAssignment_6_1(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}

// "extends"
protected class TransformationCS_ExtendsKeyword_6_0 extends KeywordToken  {
	
	public TransformationCS_ExtendsKeyword_6_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getTransformationCSAccess().getExtendsKeyword_6_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TransformationCS_RightParenthesisKeyword_5(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// extends+=[qvtbase::Transformation|UnrestrictedName]
protected class TransformationCS_ExtendsAssignment_6_1 extends AssignmentToken  {
	
	public TransformationCS_ExtendsAssignment_6_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getTransformationCSAccess().getExtendsAssignment_6_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TransformationCS_ExtendsKeyword_6_0(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("extends",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("extends");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::CrossReferenceImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getTransformationCSAccess().getExtendsTransformationCrossReference_6_1_0().getType().getClassifier())) {
				type = AssignmentType.CROSS_REFERENCE;
				element = grammarAccess.getTransformationCSAccess().getExtendsTransformationCrossReference_6_1_0(); 
				return obj;
			}
		}
		return null;
	}

}

// ("," extends+=[qvtbase::Transformation|UnrestrictedName])*
protected class TransformationCS_Group_6_2 extends GroupToken {
	
	public TransformationCS_Group_6_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getTransformationCSAccess().getGroup_6_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TransformationCS_ExtendsAssignment_6_2_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// ","
protected class TransformationCS_CommaKeyword_6_2_0 extends KeywordToken  {
	
	public TransformationCS_CommaKeyword_6_2_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getTransformationCSAccess().getCommaKeyword_6_2_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TransformationCS_Group_6_2(lastRuleCallOrigin, this, 0, inst);
			case 1: return new TransformationCS_ExtendsAssignment_6_1(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}

// extends+=[qvtbase::Transformation|UnrestrictedName]
protected class TransformationCS_ExtendsAssignment_6_2_1 extends AssignmentToken  {
	
	public TransformationCS_ExtendsAssignment_6_2_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getTransformationCSAccess().getExtendsAssignment_6_2_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TransformationCS_CommaKeyword_6_2_0(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("extends",false)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("extends");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::CrossReferenceImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getTransformationCSAccess().getExtendsTransformationCrossReference_6_2_1_0().getType().getClassifier())) {
				type = AssignmentType.CROSS_REFERENCE;
				element = grammarAccess.getTransformationCSAccess().getExtendsTransformationCrossReference_6_2_1_0(); 
				return obj;
			}
		}
		return null;
	}

}



// "{"
protected class TransformationCS_LeftCurlyBracketKeyword_7 extends KeywordToken  {
	
	public TransformationCS_LeftCurlyBracketKeyword_7(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getTransformationCSAccess().getLeftCurlyBracketKeyword_7();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TransformationCS_Group_6(lastRuleCallOrigin, this, 0, inst);
			case 1: return new TransformationCS_RightParenthesisKeyword_5(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}

// keyDecls+=KeyDeclCS*
protected class TransformationCS_KeyDeclsAssignment_8 extends AssignmentToken  {
	
	public TransformationCS_KeyDeclsAssignment_8(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getTransformationCSAccess().getKeyDeclsAssignment_8();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new KeyDeclCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("keyDecls",false)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("keyDecls");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getKeyDeclCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getTransformationCSAccess().getKeyDeclsKeyDeclCSParserRuleCall_8_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new TransformationCS_KeyDeclsAssignment_8(lastRuleCallOrigin, next, actIndex, consumed);
			case 1: return new TransformationCS_LeftCurlyBracketKeyword_7(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}

// (relation+=RelationCS | queries+=QueryCS)*
protected class TransformationCS_Alternatives_9 extends AlternativesToken {

	public TransformationCS_Alternatives_9(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Alternatives getGrammarElement() {
		return grammarAccess.getTransformationCSAccess().getAlternatives_9();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TransformationCS_RelationAssignment_9_0(lastRuleCallOrigin, this, 0, inst);
			case 1: return new TransformationCS_QueriesAssignment_9_1(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}

// relation+=RelationCS
protected class TransformationCS_RelationAssignment_9_0 extends AssignmentToken  {
	
	public TransformationCS_RelationAssignment_9_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getTransformationCSAccess().getRelationAssignment_9_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new RelationCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("relation",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("relation");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getRelationCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getTransformationCSAccess().getRelationRelationCSParserRuleCall_9_0_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new TransformationCS_Alternatives_9(lastRuleCallOrigin, next, actIndex, consumed);
			case 1: return new TransformationCS_KeyDeclsAssignment_8(lastRuleCallOrigin, next, actIndex, consumed);
			case 2: return new TransformationCS_LeftCurlyBracketKeyword_7(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}

// queries+=QueryCS
protected class TransformationCS_QueriesAssignment_9_1 extends AssignmentToken  {
	
	public TransformationCS_QueriesAssignment_9_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getTransformationCSAccess().getQueriesAssignment_9_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new QueryCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("queries",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("queries");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getQueryCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getTransformationCSAccess().getQueriesQueryCSParserRuleCall_9_1_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new TransformationCS_Alternatives_9(lastRuleCallOrigin, next, actIndex, consumed);
			case 1: return new TransformationCS_KeyDeclsAssignment_8(lastRuleCallOrigin, next, actIndex, consumed);
			case 2: return new TransformationCS_LeftCurlyBracketKeyword_7(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}


// "}"
protected class TransformationCS_RightCurlyBracketKeyword_10 extends KeywordToken  {
	
	public TransformationCS_RightCurlyBracketKeyword_10(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getTransformationCSAccess().getRightCurlyBracketKeyword_10();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TransformationCS_Alternatives_9(lastRuleCallOrigin, this, 0, inst);
			case 1: return new TransformationCS_KeyDeclsAssignment_8(lastRuleCallOrigin, this, 1, inst);
			case 2: return new TransformationCS_LeftCurlyBracketKeyword_7(lastRuleCallOrigin, this, 2, inst);
			default: return null;
		}	
	}

}


/************ end Rule TransformationCS ****************/


/************ begin Rule UnitCS ****************
 *
 * UnitCS returns base::ImportCS:
 * 	"import" (name=UnrestrictedName ":")? pathName=URIPathNameCS ("::" all?="*")? ";";
 *
 **/

// "import" (name=UnrestrictedName ":")? pathName=URIPathNameCS ("::" all?="*")? ";"
protected class UnitCS_Group extends GroupToken {
	
	public UnitCS_Group(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getUnitCSAccess().getGroup();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new UnitCS_SemicolonKeyword_4(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getUnitCSRule().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// "import"
protected class UnitCS_ImportKeyword_0 extends KeywordToken  {
	
	public UnitCS_ImportKeyword_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getUnitCSAccess().getImportKeyword_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index, inst);
		}	
	}

}

// (name=UnrestrictedName ":")?
protected class UnitCS_Group_1 extends GroupToken {
	
	public UnitCS_Group_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getUnitCSAccess().getGroup_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new UnitCS_ColonKeyword_1_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// name=UnrestrictedName
protected class UnitCS_NameAssignment_1_0 extends AssignmentToken  {
	
	public UnitCS_NameAssignment_1_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getUnitCSAccess().getNameAssignment_1_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new UnitCS_ImportKeyword_0(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("name",false)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("name");
		if(valueSerializer.isValid(obj.getEObject(), grammarAccess.getUnitCSAccess().getNameUnrestrictedNameParserRuleCall_1_0_0(), value, null)) {
			type = AssignmentType.DATATYPE_RULE_CALL;
			element = grammarAccess.getUnitCSAccess().getNameUnrestrictedNameParserRuleCall_1_0_0();
			return obj;
		}
		return null;
	}

}

// ":"
protected class UnitCS_ColonKeyword_1_1 extends KeywordToken  {
	
	public UnitCS_ColonKeyword_1_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getUnitCSAccess().getColonKeyword_1_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new UnitCS_NameAssignment_1_0(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}


// pathName=URIPathNameCS
protected class UnitCS_PathNameAssignment_2 extends AssignmentToken  {
	
	public UnitCS_PathNameAssignment_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getUnitCSAccess().getPathNameAssignment_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new URIPathNameCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("pathName",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("pathName");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getURIPathNameCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getUnitCSAccess().getPathNameURIPathNameCSParserRuleCall_2_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new UnitCS_Group_1(lastRuleCallOrigin, next, actIndex, consumed);
			case 1: return new UnitCS_ImportKeyword_0(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}

// ("::" all?="*")?
protected class UnitCS_Group_3 extends GroupToken {
	
	public UnitCS_Group_3(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getUnitCSAccess().getGroup_3();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new UnitCS_AllAssignment_3_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// "::"
protected class UnitCS_ColonColonKeyword_3_0 extends KeywordToken  {
	
	public UnitCS_ColonColonKeyword_3_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getUnitCSAccess().getColonColonKeyword_3_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new UnitCS_PathNameAssignment_2(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// all?="*"
protected class UnitCS_AllAssignment_3_1 extends AssignmentToken  {
	
	public UnitCS_AllAssignment_3_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getUnitCSAccess().getAllAssignment_3_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new UnitCS_ColonColonKeyword_3_0(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("all",false)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("all");
		if(Boolean.TRUE.equals(value)) { // org::eclipse::xtext::impl::KeywordImpl
			type = AssignmentType.KEYWORD;
			element = grammarAccess.getUnitCSAccess().getAllAsteriskKeyword_3_1_0();
			return obj;
		}
		return null;
	}

}


// ";"
protected class UnitCS_SemicolonKeyword_4 extends KeywordToken  {
	
	public UnitCS_SemicolonKeyword_4(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getUnitCSAccess().getSemicolonKeyword_4();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new UnitCS_Group_3(lastRuleCallOrigin, this, 0, inst);
			case 1: return new UnitCS_PathNameAssignment_2(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}


/************ end Rule UnitCS ****************/


/************ begin Rule VarDeclarationCS ****************
 *
 * VarDeclarationCS:
 * 	varDeclarationIds+=VarDeclarationIdCS ("," varDeclarationIds+=VarDeclarationIdCS)* ":" type=TypedRefCS ";";
 *
 **/

// varDeclarationIds+=VarDeclarationIdCS ("," varDeclarationIds+=VarDeclarationIdCS)* ":" type=TypedRefCS ";"
protected class VarDeclarationCS_Group extends GroupToken {
	
	public VarDeclarationCS_Group(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getVarDeclarationCSAccess().getGroup();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new VarDeclarationCS_SemicolonKeyword_4(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getVarDeclarationCSRule().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// varDeclarationIds+=VarDeclarationIdCS
protected class VarDeclarationCS_VarDeclarationIdsAssignment_0 extends AssignmentToken  {
	
	public VarDeclarationCS_VarDeclarationIdsAssignment_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getVarDeclarationCSAccess().getVarDeclarationIdsAssignment_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new VarDeclarationIdCS_NameAssignment(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("varDeclarationIds",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("varDeclarationIds");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getVarDeclarationIdCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getVarDeclarationCSAccess().getVarDeclarationIdsVarDeclarationIdCSParserRuleCall_0_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(next, actIndex , index, consumed);
		}	
	}	
}

// ("," varDeclarationIds+=VarDeclarationIdCS)*
protected class VarDeclarationCS_Group_1 extends GroupToken {
	
	public VarDeclarationCS_Group_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getVarDeclarationCSAccess().getGroup_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new VarDeclarationCS_VarDeclarationIdsAssignment_1_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// ","
protected class VarDeclarationCS_CommaKeyword_1_0 extends KeywordToken  {
	
	public VarDeclarationCS_CommaKeyword_1_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getVarDeclarationCSAccess().getCommaKeyword_1_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new VarDeclarationCS_Group_1(lastRuleCallOrigin, this, 0, inst);
			case 1: return new VarDeclarationCS_VarDeclarationIdsAssignment_0(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}

// varDeclarationIds+=VarDeclarationIdCS
protected class VarDeclarationCS_VarDeclarationIdsAssignment_1_1 extends AssignmentToken  {
	
	public VarDeclarationCS_VarDeclarationIdsAssignment_1_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getVarDeclarationCSAccess().getVarDeclarationIdsAssignment_1_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new VarDeclarationIdCS_NameAssignment(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("varDeclarationIds",false)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("varDeclarationIds");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getVarDeclarationIdCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getVarDeclarationCSAccess().getVarDeclarationIdsVarDeclarationIdCSParserRuleCall_1_1_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new VarDeclarationCS_CommaKeyword_1_0(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}


// ":"
protected class VarDeclarationCS_ColonKeyword_2 extends KeywordToken  {
	
	public VarDeclarationCS_ColonKeyword_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getVarDeclarationCSAccess().getColonKeyword_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new VarDeclarationCS_Group_1(lastRuleCallOrigin, this, 0, inst);
			case 1: return new VarDeclarationCS_VarDeclarationIdsAssignment_0(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}

// type=TypedRefCS
protected class VarDeclarationCS_TypeAssignment_3 extends AssignmentToken  {
	
	public VarDeclarationCS_TypeAssignment_3(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getVarDeclarationCSAccess().getTypeAssignment_3();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TypedRefCS_Alternatives(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("type",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("type");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getTypedRefCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getVarDeclarationCSAccess().getTypeTypedRefCSParserRuleCall_3_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new VarDeclarationCS_ColonKeyword_2(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}

// ";"
protected class VarDeclarationCS_SemicolonKeyword_4 extends KeywordToken  {
	
	public VarDeclarationCS_SemicolonKeyword_4(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getVarDeclarationCSAccess().getSemicolonKeyword_4();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new VarDeclarationCS_TypeAssignment_3(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}


/************ end Rule VarDeclarationCS ****************/


/************ begin Rule VarDeclarationIdCS ****************
 *
 * VarDeclarationIdCS:
 * 	name=UnrestrictedName;
 *
 **/

// name=UnrestrictedName
protected class VarDeclarationIdCS_NameAssignment extends AssignmentToken  {
	
	public VarDeclarationIdCS_NameAssignment(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getVarDeclarationIdCSAccess().getNameAssignment();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index, inst);
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getVarDeclarationIdCSRule().getType().getClassifier())
			return null;
		if((value = eObjectConsumer.getConsumable("name",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("name");
		if(valueSerializer.isValid(obj.getEObject(), grammarAccess.getVarDeclarationIdCSAccess().getNameUnrestrictedNameParserRuleCall_0(), value, null)) {
			type = AssignmentType.DATATYPE_RULE_CALL;
			element = grammarAccess.getVarDeclarationIdCSAccess().getNameUnrestrictedNameParserRuleCall_0();
			return obj;
		}
		return null;
	}

}

/************ end Rule VarDeclarationIdCS ****************/


/************ begin Rule WhenCS ****************
 *
 * WhenCS returns PatternCS:
 * 	{PatternCS} "when" "{" predicates+=PredicateCS* "}";
 *
 **/

// {PatternCS} "when" "{" predicates+=PredicateCS* "}"
protected class WhenCS_Group extends GroupToken {
	
	public WhenCS_Group(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getWhenCSAccess().getGroup();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new WhenCS_RightCurlyBracketKeyword_4(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getWhenCSAccess().getPatternCSAction_0().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// {PatternCS}
protected class WhenCS_PatternCSAction_0 extends ActionToken  {

	public WhenCS_PatternCSAction_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Action getGrammarElement() {
		return grammarAccess.getWhenCSAccess().getPatternCSAction_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index, inst);
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(!eObjectConsumer.isConsumed()) return null;
		return eObjectConsumer;
	}
}

// "when"
protected class WhenCS_WhenKeyword_1 extends KeywordToken  {
	
	public WhenCS_WhenKeyword_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getWhenCSAccess().getWhenKeyword_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new WhenCS_PatternCSAction_0(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// "{"
protected class WhenCS_LeftCurlyBracketKeyword_2 extends KeywordToken  {
	
	public WhenCS_LeftCurlyBracketKeyword_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getWhenCSAccess().getLeftCurlyBracketKeyword_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new WhenCS_WhenKeyword_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// predicates+=PredicateCS*
protected class WhenCS_PredicatesAssignment_3 extends AssignmentToken  {
	
	public WhenCS_PredicatesAssignment_3(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getWhenCSAccess().getPredicatesAssignment_3();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PredicateCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("predicates",false)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("predicates");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getPredicateCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getWhenCSAccess().getPredicatesPredicateCSParserRuleCall_3_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new WhenCS_PredicatesAssignment_3(lastRuleCallOrigin, next, actIndex, consumed);
			case 1: return new WhenCS_LeftCurlyBracketKeyword_2(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}

// "}"
protected class WhenCS_RightCurlyBracketKeyword_4 extends KeywordToken  {
	
	public WhenCS_RightCurlyBracketKeyword_4(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getWhenCSAccess().getRightCurlyBracketKeyword_4();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new WhenCS_PredicatesAssignment_3(lastRuleCallOrigin, this, 0, inst);
			case 1: return new WhenCS_LeftCurlyBracketKeyword_2(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}


/************ end Rule WhenCS ****************/


/************ begin Rule WhereCS ****************
 *
 * WhereCS returns PatternCS:
 * 	{PatternCS} "where" "{" predicates+=PredicateCS* "}";
 *
 **/

// {PatternCS} "where" "{" predicates+=PredicateCS* "}"
protected class WhereCS_Group extends GroupToken {
	
	public WhereCS_Group(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getWhereCSAccess().getGroup();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new WhereCS_RightCurlyBracketKeyword_4(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getWhereCSAccess().getPatternCSAction_0().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// {PatternCS}
protected class WhereCS_PatternCSAction_0 extends ActionToken  {

	public WhereCS_PatternCSAction_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Action getGrammarElement() {
		return grammarAccess.getWhereCSAccess().getPatternCSAction_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index, inst);
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(!eObjectConsumer.isConsumed()) return null;
		return eObjectConsumer;
	}
}

// "where"
protected class WhereCS_WhereKeyword_1 extends KeywordToken  {
	
	public WhereCS_WhereKeyword_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getWhereCSAccess().getWhereKeyword_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new WhereCS_PatternCSAction_0(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// "{"
protected class WhereCS_LeftCurlyBracketKeyword_2 extends KeywordToken  {
	
	public WhereCS_LeftCurlyBracketKeyword_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getWhereCSAccess().getLeftCurlyBracketKeyword_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new WhereCS_WhereKeyword_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// predicates+=PredicateCS*
protected class WhereCS_PredicatesAssignment_3 extends AssignmentToken  {
	
	public WhereCS_PredicatesAssignment_3(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getWhereCSAccess().getPredicatesAssignment_3();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PredicateCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("predicates",false)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("predicates");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getPredicateCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getWhereCSAccess().getPredicatesPredicateCSParserRuleCall_3_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new WhereCS_PredicatesAssignment_3(lastRuleCallOrigin, next, actIndex, consumed);
			case 1: return new WhereCS_LeftCurlyBracketKeyword_2(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}

// "}"
protected class WhereCS_RightCurlyBracketKeyword_4 extends KeywordToken  {
	
	public WhereCS_RightCurlyBracketKeyword_4(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getWhereCSAccess().getRightCurlyBracketKeyword_4();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new WhereCS_PredicatesAssignment_3(lastRuleCallOrigin, this, 0, inst);
			case 1: return new WhereCS_LeftCurlyBracketKeyword_2(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}


/************ end Rule WhereCS ****************/


/************ begin Rule NameExpCS ****************
 *
 * NameExpCS returns essentialocl::NameExpCS:
 * 	pathName=PathNameCS;
 *
 **/

// pathName=PathNameCS
protected class NameExpCS_PathNameAssignment extends AssignmentToken  {
	
	public NameExpCS_PathNameAssignment(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getNameExpCSAccess().getPathNameAssignment();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PathNameCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getNameExpCSRule().getType().getClassifier())
			return null;
		if((value = eObjectConsumer.getConsumable("pathName",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("pathName");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getPathNameCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getNameExpCSAccess().getPathNamePathNameCSParserRuleCall_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(next, actIndex , index, consumed);
		}	
	}	
}

/************ end Rule NameExpCS ****************/


/************ begin Rule ExpCSOrTemplateCS ****************
 *
 * //<OCLExpressionCS> ::= <PropertyCallExpCS> 
 * //                    | <VariableExpCS>
 * //                    | <LiteralExpCS>
 * //                    | <LetExpCS>
 * //                    | <IfExpCS>
 * //                    | '(' <OCLExpressionCS> ')'
 * //                    | <template>  
 * //	notNameExpressionCS -> templateCS
 * ExpCSOrTemplateCS returns essentialocl::ExpCS:
 * 	ExpCS | TemplateCS;
 *
 **/

// ExpCS | TemplateCS
protected class ExpCSOrTemplateCS_Alternatives extends AlternativesToken {

	public ExpCSOrTemplateCS_Alternatives(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Alternatives getGrammarElement() {
		return grammarAccess.getExpCSOrTemplateCSAccess().getAlternatives();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ExpCSOrTemplateCS_ExpCSParserRuleCall_0(lastRuleCallOrigin, this, 0, inst);
			case 1: return new ExpCSOrTemplateCS_TemplateCSParserRuleCall_1(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getBooleanLiteralExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getCollectionLiteralExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getCollectionTemplateCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getPrimaryExpCSAccess().getConstructorExpCSNameExpAction_7_2_1_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getIfExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getPrimaryExpCSAccess().getIndexExpCSNameExpAction_7_2_0_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getExpCSAccess().getInfixExpCSOwnedExpressionAction_0_1_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getInvalidLiteralExpCSAccess().getInvalidLiteralExpCSAction_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getPrimaryExpCSAccess().getInvocationExpCSNameExpAction_7_2_2_1_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getLetExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getPrimaryExpCSAccess().getNameExpCSAction_7_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getNestedExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getNullLiteralExpCSAccess().getNullLiteralExpCSAction_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getNumberLiteralExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getObjectTemplateCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getExpCSAccess().getPrefixExpCSAction_1_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getSelfExpCSAccess().getSelfExpCSAction_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getStringLiteralExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getTupleLiteralExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getTypeLiteralExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getUnlimitedNaturalLiteralExpCSAccess().getUnlimitedNaturalLiteralExpCSAction_0().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// ExpCS
protected class ExpCSOrTemplateCS_ExpCSParserRuleCall_0 extends RuleCallToken {
	
	public ExpCSOrTemplateCS_ExpCSParserRuleCall_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public RuleCall getGrammarElement() {
		return grammarAccess.getExpCSOrTemplateCSAccess().getExpCSParserRuleCall_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ExpCS_Alternatives(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getBooleanLiteralExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getCollectionLiteralExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getPrimaryExpCSAccess().getConstructorExpCSNameExpAction_7_2_1_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getIfExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getPrimaryExpCSAccess().getIndexExpCSNameExpAction_7_2_0_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getExpCSAccess().getInfixExpCSOwnedExpressionAction_0_1_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getInvalidLiteralExpCSAccess().getInvalidLiteralExpCSAction_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getPrimaryExpCSAccess().getInvocationExpCSNameExpAction_7_2_2_1_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getLetExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getPrimaryExpCSAccess().getNameExpCSAction_7_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getNestedExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getNullLiteralExpCSAccess().getNullLiteralExpCSAction_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getNumberLiteralExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getExpCSAccess().getPrefixExpCSAction_1_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getSelfExpCSAccess().getSelfExpCSAction_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getStringLiteralExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getTupleLiteralExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getTypeLiteralExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getUnlimitedNaturalLiteralExpCSAccess().getUnlimitedNaturalLiteralExpCSAction_0().getType().getClassifier())
			return null;
		if(checkForRecursion(ExpCS_Alternatives.class, eObjectConsumer)) return null;
		return eObjectConsumer;
	}
	
    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(next, actIndex , index, inst);
		}	
	}	
}

// TemplateCS
protected class ExpCSOrTemplateCS_TemplateCSParserRuleCall_1 extends RuleCallToken {
	
	public ExpCSOrTemplateCS_TemplateCSParserRuleCall_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public RuleCall getGrammarElement() {
		return grammarAccess.getExpCSOrTemplateCSAccess().getTemplateCSParserRuleCall_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TemplateCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getCollectionTemplateCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getObjectTemplateCSRule().getType().getClassifier())
			return null;
		if(checkForRecursion(TemplateCS_Group.class, eObjectConsumer)) return null;
		return eObjectConsumer;
	}
	
    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(next, actIndex , index, inst);
		}	
	}	
}


/************ end Rule ExpCSOrTemplateCS ****************/


/************ begin Rule TypedTypeRefCS ****************
 *
 * TypedTypeRefCS returns base::TypedTypeRefCS:
 * 	pathName=PathNameCS;
 *
 **/

// pathName=PathNameCS
protected class TypedTypeRefCS_PathNameAssignment extends AssignmentToken  {
	
	public TypedTypeRefCS_PathNameAssignment(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getTypedTypeRefCSAccess().getPathNameAssignment();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PathNameCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getTypedTypeRefCSRule().getType().getClassifier())
			return null;
		if((value = eObjectConsumer.getConsumable("pathName",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("pathName");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getPathNameCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getTypedTypeRefCSAccess().getPathNamePathNameCSParserRuleCall_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(next, actIndex , index, consumed);
		}	
	}	
}

/************ end Rule TypedTypeRefCS ****************/


/************ begin Rule TypedRefCS ****************
 *
 * TypedRefCS returns base::TypedRefCS:
 * 	PrimitiveTypeCS | CollectionTypeCS | TypedTypeRefCS;
 *
 **/

// PrimitiveTypeCS | CollectionTypeCS | TypedTypeRefCS
protected class TypedRefCS_Alternatives extends AlternativesToken {

	public TypedRefCS_Alternatives(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Alternatives getGrammarElement() {
		return grammarAccess.getTypedRefCSAccess().getAlternatives();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TypedRefCS_PrimitiveTypeCSParserRuleCall_0(lastRuleCallOrigin, this, 0, inst);
			case 1: return new TypedRefCS_CollectionTypeCSParserRuleCall_1(lastRuleCallOrigin, this, 1, inst);
			case 2: return new TypedRefCS_TypedTypeRefCSParserRuleCall_2(lastRuleCallOrigin, this, 2, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getCollectionTypeCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getPrimitiveTypeCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getTypedTypeRefCSRule().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// PrimitiveTypeCS
protected class TypedRefCS_PrimitiveTypeCSParserRuleCall_0 extends RuleCallToken {
	
	public TypedRefCS_PrimitiveTypeCSParserRuleCall_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public RuleCall getGrammarElement() {
		return grammarAccess.getTypedRefCSAccess().getPrimitiveTypeCSParserRuleCall_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PrimitiveTypeCS_NameAssignment(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getPrimitiveTypeCSRule().getType().getClassifier())
			return null;
		if(checkForRecursion(PrimitiveTypeCS_NameAssignment.class, eObjectConsumer)) return null;
		return eObjectConsumer;
	}
	
    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(next, actIndex , index, inst);
		}	
	}	
}

// CollectionTypeCS
protected class TypedRefCS_CollectionTypeCSParserRuleCall_1 extends RuleCallToken {
	
	public TypedRefCS_CollectionTypeCSParserRuleCall_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public RuleCall getGrammarElement() {
		return grammarAccess.getTypedRefCSAccess().getCollectionTypeCSParserRuleCall_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new CollectionTypeCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getCollectionTypeCSRule().getType().getClassifier())
			return null;
		if(checkForRecursion(CollectionTypeCS_Group.class, eObjectConsumer)) return null;
		return eObjectConsumer;
	}
	
    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(next, actIndex , index, inst);
		}	
	}	
}

// TypedTypeRefCS
protected class TypedRefCS_TypedTypeRefCSParserRuleCall_2 extends RuleCallToken {
	
	public TypedRefCS_TypedTypeRefCSParserRuleCall_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public RuleCall getGrammarElement() {
		return grammarAccess.getTypedRefCSAccess().getTypedTypeRefCSParserRuleCall_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TypedTypeRefCS_PathNameAssignment(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getTypedTypeRefCSRule().getType().getClassifier())
			return null;
		if(checkForRecursion(TypedTypeRefCS_PathNameAssignment.class, eObjectConsumer)) return null;
		return eObjectConsumer;
	}
	
    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(next, actIndex , index, inst);
		}	
	}	
}


/************ end Rule TypedRefCS ****************/



/************ begin Rule Model ****************
 *
 * //generate essentialOCLCST "http://www.eclipse.org/ocl/3.0.0/EssentialOCLCST"
 * Model returns ContextCS:
 * 	ownedExpression=ExpCS;
 *
 **/

// ownedExpression=ExpCS
protected class Model_OwnedExpressionAssignment extends AssignmentToken  {
	
	public Model_OwnedExpressionAssignment(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getModelAccess().getOwnedExpressionAssignment();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ExpCS_Alternatives(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getModelRule().getType().getClassifier())
			return null;
		if((value = eObjectConsumer.getConsumable("ownedExpression",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("ownedExpression");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getExpCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getModelAccess().getOwnedExpressionExpCSParserRuleCall_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(next, actIndex , index, consumed);
		}	
	}	
}

/************ end Rule Model ****************/








/************ begin Rule EssentialOCLUnaryOperatorCS ****************
 *
 * EssentialOCLUnaryOperatorCS returns UnaryOperatorCS:
 * 	name=("-" | "not");
 *
 **/

// name=("-" | "not")
protected class EssentialOCLUnaryOperatorCS_NameAssignment extends AssignmentToken  {
	
	public EssentialOCLUnaryOperatorCS_NameAssignment(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getEssentialOCLUnaryOperatorCSAccess().getNameAssignment();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index, inst);
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getEssentialOCLUnaryOperatorCSRule().getType().getClassifier())
			return null;
		if((value = eObjectConsumer.getConsumable("name",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("name");
		if(keywordSerializer.isValid(obj.getEObject(), grammarAccess.getEssentialOCLUnaryOperatorCSAccess().getNameHyphenMinusKeyword_0_0(), value, null)) {
			type = AssignmentType.KEYWORD;
			element = grammarAccess.getEssentialOCLUnaryOperatorCSAccess().getNameHyphenMinusKeyword_0_0();
			return obj;
		}
		if(keywordSerializer.isValid(obj.getEObject(), grammarAccess.getEssentialOCLUnaryOperatorCSAccess().getNameNotKeyword_0_1(), value, null)) {
			type = AssignmentType.KEYWORD;
			element = grammarAccess.getEssentialOCLUnaryOperatorCSAccess().getNameNotKeyword_0_1();
			return obj;
		}
		return null;
	}

}

/************ end Rule EssentialOCLUnaryOperatorCS ****************/


/************ begin Rule EssentialOCLInfixOperatorCS ****************
 *
 * EssentialOCLInfixOperatorCS returns BinaryOperatorCS:
 * 	name=("*" | "/" | "+" | "-" | ">" | "<" | ">=" | "<=" | "=" | "<>" | "and" | "or" | "xor" | "implies");
 *
 **/

// name=("*" | "/" | "+" | "-" | ">" | "<" | ">=" | "<=" | "=" | "<>" | "and" | "or" | "xor" | "implies")
protected class EssentialOCLInfixOperatorCS_NameAssignment extends AssignmentToken  {
	
	public EssentialOCLInfixOperatorCS_NameAssignment(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getEssentialOCLInfixOperatorCSAccess().getNameAssignment();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index, inst);
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getEssentialOCLInfixOperatorCSRule().getType().getClassifier())
			return null;
		if((value = eObjectConsumer.getConsumable("name",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("name");
		if(keywordSerializer.isValid(obj.getEObject(), grammarAccess.getEssentialOCLInfixOperatorCSAccess().getNameAsteriskKeyword_0_0(), value, null)) {
			type = AssignmentType.KEYWORD;
			element = grammarAccess.getEssentialOCLInfixOperatorCSAccess().getNameAsteriskKeyword_0_0();
			return obj;
		}
		if(keywordSerializer.isValid(obj.getEObject(), grammarAccess.getEssentialOCLInfixOperatorCSAccess().getNameSolidusKeyword_0_1(), value, null)) {
			type = AssignmentType.KEYWORD;
			element = grammarAccess.getEssentialOCLInfixOperatorCSAccess().getNameSolidusKeyword_0_1();
			return obj;
		}
		if(keywordSerializer.isValid(obj.getEObject(), grammarAccess.getEssentialOCLInfixOperatorCSAccess().getNamePlusSignKeyword_0_2(), value, null)) {
			type = AssignmentType.KEYWORD;
			element = grammarAccess.getEssentialOCLInfixOperatorCSAccess().getNamePlusSignKeyword_0_2();
			return obj;
		}
		if(keywordSerializer.isValid(obj.getEObject(), grammarAccess.getEssentialOCLInfixOperatorCSAccess().getNameHyphenMinusKeyword_0_3(), value, null)) {
			type = AssignmentType.KEYWORD;
			element = grammarAccess.getEssentialOCLInfixOperatorCSAccess().getNameHyphenMinusKeyword_0_3();
			return obj;
		}
		if(keywordSerializer.isValid(obj.getEObject(), grammarAccess.getEssentialOCLInfixOperatorCSAccess().getNameGreaterThanSignKeyword_0_4(), value, null)) {
			type = AssignmentType.KEYWORD;
			element = grammarAccess.getEssentialOCLInfixOperatorCSAccess().getNameGreaterThanSignKeyword_0_4();
			return obj;
		}
		if(keywordSerializer.isValid(obj.getEObject(), grammarAccess.getEssentialOCLInfixOperatorCSAccess().getNameLessThanSignKeyword_0_5(), value, null)) {
			type = AssignmentType.KEYWORD;
			element = grammarAccess.getEssentialOCLInfixOperatorCSAccess().getNameLessThanSignKeyword_0_5();
			return obj;
		}
		if(keywordSerializer.isValid(obj.getEObject(), grammarAccess.getEssentialOCLInfixOperatorCSAccess().getNameGreaterThanSignEqualsSignKeyword_0_6(), value, null)) {
			type = AssignmentType.KEYWORD;
			element = grammarAccess.getEssentialOCLInfixOperatorCSAccess().getNameGreaterThanSignEqualsSignKeyword_0_6();
			return obj;
		}
		if(keywordSerializer.isValid(obj.getEObject(), grammarAccess.getEssentialOCLInfixOperatorCSAccess().getNameLessThanSignEqualsSignKeyword_0_7(), value, null)) {
			type = AssignmentType.KEYWORD;
			element = grammarAccess.getEssentialOCLInfixOperatorCSAccess().getNameLessThanSignEqualsSignKeyword_0_7();
			return obj;
		}
		if(keywordSerializer.isValid(obj.getEObject(), grammarAccess.getEssentialOCLInfixOperatorCSAccess().getNameEqualsSignKeyword_0_8(), value, null)) {
			type = AssignmentType.KEYWORD;
			element = grammarAccess.getEssentialOCLInfixOperatorCSAccess().getNameEqualsSignKeyword_0_8();
			return obj;
		}
		if(keywordSerializer.isValid(obj.getEObject(), grammarAccess.getEssentialOCLInfixOperatorCSAccess().getNameLessThanSignGreaterThanSignKeyword_0_9(), value, null)) {
			type = AssignmentType.KEYWORD;
			element = grammarAccess.getEssentialOCLInfixOperatorCSAccess().getNameLessThanSignGreaterThanSignKeyword_0_9();
			return obj;
		}
		if(keywordSerializer.isValid(obj.getEObject(), grammarAccess.getEssentialOCLInfixOperatorCSAccess().getNameAndKeyword_0_10(), value, null)) {
			type = AssignmentType.KEYWORD;
			element = grammarAccess.getEssentialOCLInfixOperatorCSAccess().getNameAndKeyword_0_10();
			return obj;
		}
		if(keywordSerializer.isValid(obj.getEObject(), grammarAccess.getEssentialOCLInfixOperatorCSAccess().getNameOrKeyword_0_11(), value, null)) {
			type = AssignmentType.KEYWORD;
			element = grammarAccess.getEssentialOCLInfixOperatorCSAccess().getNameOrKeyword_0_11();
			return obj;
		}
		if(keywordSerializer.isValid(obj.getEObject(), grammarAccess.getEssentialOCLInfixOperatorCSAccess().getNameXorKeyword_0_12(), value, null)) {
			type = AssignmentType.KEYWORD;
			element = grammarAccess.getEssentialOCLInfixOperatorCSAccess().getNameXorKeyword_0_12();
			return obj;
		}
		if(keywordSerializer.isValid(obj.getEObject(), grammarAccess.getEssentialOCLInfixOperatorCSAccess().getNameImpliesKeyword_0_13(), value, null)) {
			type = AssignmentType.KEYWORD;
			element = grammarAccess.getEssentialOCLInfixOperatorCSAccess().getNameImpliesKeyword_0_13();
			return obj;
		}
		return null;
	}

}

/************ end Rule EssentialOCLInfixOperatorCS ****************/


/************ begin Rule EssentialOCLNavigationOperatorCS ****************
 *
 * EssentialOCLNavigationOperatorCS returns NavigationOperatorCS:
 * 	name=("." | "->");
 *
 **/

// name=("." | "->")
protected class EssentialOCLNavigationOperatorCS_NameAssignment extends AssignmentToken  {
	
	public EssentialOCLNavigationOperatorCS_NameAssignment(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getEssentialOCLNavigationOperatorCSAccess().getNameAssignment();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index, inst);
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getEssentialOCLNavigationOperatorCSRule().getType().getClassifier())
			return null;
		if((value = eObjectConsumer.getConsumable("name",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("name");
		if(keywordSerializer.isValid(obj.getEObject(), grammarAccess.getEssentialOCLNavigationOperatorCSAccess().getNameFullStopKeyword_0_0(), value, null)) {
			type = AssignmentType.KEYWORD;
			element = grammarAccess.getEssentialOCLNavigationOperatorCSAccess().getNameFullStopKeyword_0_0();
			return obj;
		}
		if(keywordSerializer.isValid(obj.getEObject(), grammarAccess.getEssentialOCLNavigationOperatorCSAccess().getNameHyphenMinusGreaterThanSignKeyword_0_1(), value, null)) {
			type = AssignmentType.KEYWORD;
			element = grammarAccess.getEssentialOCLNavigationOperatorCSAccess().getNameHyphenMinusGreaterThanSignKeyword_0_1();
			return obj;
		}
		return null;
	}

}

/************ end Rule EssentialOCLNavigationOperatorCS ****************/




/************ begin Rule BinaryOperatorCS ****************
 *
 * BinaryOperatorCS:
 * 	InfixOperatorCS | NavigationOperatorCS;
 *
 **/

// InfixOperatorCS | NavigationOperatorCS
protected class BinaryOperatorCS_Alternatives extends AlternativesToken {

	public BinaryOperatorCS_Alternatives(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Alternatives getGrammarElement() {
		return grammarAccess.getBinaryOperatorCSAccess().getAlternatives();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new BinaryOperatorCS_InfixOperatorCSParserRuleCall_0(lastRuleCallOrigin, this, 0, inst);
			case 1: return new BinaryOperatorCS_NavigationOperatorCSParserRuleCall_1(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getEssentialOCLInfixOperatorCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getEssentialOCLNavigationOperatorCSRule().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// InfixOperatorCS
protected class BinaryOperatorCS_InfixOperatorCSParserRuleCall_0 extends RuleCallToken {
	
	public BinaryOperatorCS_InfixOperatorCSParserRuleCall_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public RuleCall getGrammarElement() {
		return grammarAccess.getBinaryOperatorCSAccess().getInfixOperatorCSParserRuleCall_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new InfixOperatorCS_EssentialOCLInfixOperatorCSParserRuleCall(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getEssentialOCLInfixOperatorCSRule().getType().getClassifier())
			return null;
		if(checkForRecursion(InfixOperatorCS_EssentialOCLInfixOperatorCSParserRuleCall.class, eObjectConsumer)) return null;
		return eObjectConsumer;
	}
	
    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(next, actIndex , index, inst);
		}	
	}	
}

// NavigationOperatorCS
protected class BinaryOperatorCS_NavigationOperatorCSParserRuleCall_1 extends RuleCallToken {
	
	public BinaryOperatorCS_NavigationOperatorCSParserRuleCall_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public RuleCall getGrammarElement() {
		return grammarAccess.getBinaryOperatorCSAccess().getNavigationOperatorCSParserRuleCall_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new NavigationOperatorCS_EssentialOCLNavigationOperatorCSParserRuleCall(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getEssentialOCLNavigationOperatorCSRule().getType().getClassifier())
			return null;
		if(checkForRecursion(NavigationOperatorCS_EssentialOCLNavigationOperatorCSParserRuleCall.class, eObjectConsumer)) return null;
		return eObjectConsumer;
	}
	
    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(next, actIndex , index, inst);
		}	
	}	
}


/************ end Rule BinaryOperatorCS ****************/


/************ begin Rule InfixOperatorCS ****************
 *
 * // Intended to be overrideable
 * InfixOperatorCS returns BinaryOperatorCS:
 * 	EssentialOCLInfixOperatorCS;
 *
 **/

// EssentialOCLInfixOperatorCS
protected class InfixOperatorCS_EssentialOCLInfixOperatorCSParserRuleCall extends RuleCallToken {
	
	public InfixOperatorCS_EssentialOCLInfixOperatorCSParserRuleCall(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public RuleCall getGrammarElement() {
		return grammarAccess.getInfixOperatorCSAccess().getEssentialOCLInfixOperatorCSParserRuleCall();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new EssentialOCLInfixOperatorCS_NameAssignment(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getEssentialOCLInfixOperatorCSRule().getType().getClassifier())
			return null;
		if(checkForRecursion(EssentialOCLInfixOperatorCS_NameAssignment.class, eObjectConsumer)) return null;
		return eObjectConsumer;
	}
	
    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(next, actIndex , index, inst);
		}	
	}	
}

/************ end Rule InfixOperatorCS ****************/


/************ begin Rule NavigationOperatorCS ****************
 *
 * // Intended to be overrideable
 * NavigationOperatorCS:
 * 	EssentialOCLNavigationOperatorCS;
 *
 **/

// EssentialOCLNavigationOperatorCS
protected class NavigationOperatorCS_EssentialOCLNavigationOperatorCSParserRuleCall extends RuleCallToken {
	
	public NavigationOperatorCS_EssentialOCLNavigationOperatorCSParserRuleCall(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public RuleCall getGrammarElement() {
		return grammarAccess.getNavigationOperatorCSAccess().getEssentialOCLNavigationOperatorCSParserRuleCall();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new EssentialOCLNavigationOperatorCS_NameAssignment(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getEssentialOCLNavigationOperatorCSRule().getType().getClassifier())
			return null;
		if(checkForRecursion(EssentialOCLNavigationOperatorCS_NameAssignment.class, eObjectConsumer)) return null;
		return eObjectConsumer;
	}
	
    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(next, actIndex , index, inst);
		}	
	}	
}

/************ end Rule NavigationOperatorCS ****************/


/************ begin Rule UnaryOperatorCS ****************
 *
 * // Intended to be overrideable
 * UnaryOperatorCS:
 * 	EssentialOCLUnaryOperatorCS;
 *
 **/

// EssentialOCLUnaryOperatorCS
protected class UnaryOperatorCS_EssentialOCLUnaryOperatorCSParserRuleCall extends RuleCallToken {
	
	public UnaryOperatorCS_EssentialOCLUnaryOperatorCSParserRuleCall(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public RuleCall getGrammarElement() {
		return grammarAccess.getUnaryOperatorCSAccess().getEssentialOCLUnaryOperatorCSParserRuleCall();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new EssentialOCLUnaryOperatorCS_NameAssignment(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getEssentialOCLUnaryOperatorCSRule().getType().getClassifier())
			return null;
		if(checkForRecursion(EssentialOCLUnaryOperatorCS_NameAssignment.class, eObjectConsumer)) return null;
		return eObjectConsumer;
	}
	
    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(next, actIndex , index, inst);
		}	
	}	
}

/************ end Rule UnaryOperatorCS ****************/





/************ begin Rule PathNameCS ****************
 *
 * PathNameCS returns base::PathNameCS:
 * 	path+=FirstPathElementCS ("::" path+=NextPathElementCS)*;
 *
 **/

// path+=FirstPathElementCS ("::" path+=NextPathElementCS)*
protected class PathNameCS_Group extends GroupToken {
	
	public PathNameCS_Group(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getPathNameCSAccess().getGroup();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PathNameCS_Group_1(lastRuleCallOrigin, this, 0, inst);
			case 1: return new PathNameCS_PathAssignment_0(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getPathNameCSRule().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// path+=FirstPathElementCS
protected class PathNameCS_PathAssignment_0 extends AssignmentToken  {
	
	public PathNameCS_PathAssignment_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getPathNameCSAccess().getPathAssignment_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new FirstPathElementCS_ElementAssignment(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("path",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("path");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getFirstPathElementCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getPathNameCSAccess().getPathFirstPathElementCSParserRuleCall_0_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(next, actIndex , index, consumed);
		}	
	}	
}

// ("::" path+=NextPathElementCS)*
protected class PathNameCS_Group_1 extends GroupToken {
	
	public PathNameCS_Group_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getPathNameCSAccess().getGroup_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PathNameCS_PathAssignment_1_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// "::"
protected class PathNameCS_ColonColonKeyword_1_0 extends KeywordToken  {
	
	public PathNameCS_ColonColonKeyword_1_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getPathNameCSAccess().getColonColonKeyword_1_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PathNameCS_Group_1(lastRuleCallOrigin, this, 0, inst);
			case 1: return new PathNameCS_PathAssignment_0(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}

// path+=NextPathElementCS
protected class PathNameCS_PathAssignment_1_1 extends AssignmentToken  {
	
	public PathNameCS_PathAssignment_1_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getPathNameCSAccess().getPathAssignment_1_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new NextPathElementCS_ElementAssignment(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("path",false)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("path");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getNextPathElementCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getPathNameCSAccess().getPathNextPathElementCSParserRuleCall_1_1_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new PathNameCS_ColonColonKeyword_1_0(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}



/************ end Rule PathNameCS ****************/


/************ begin Rule FirstPathElementCS ****************
 *
 * FirstPathElementCS returns base::PathElementCS:
 * 	element=[pivot::NamedElement|UnrestrictedName];
 *
 **/

// element=[pivot::NamedElement|UnrestrictedName]
protected class FirstPathElementCS_ElementAssignment extends AssignmentToken  {
	
	public FirstPathElementCS_ElementAssignment(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getFirstPathElementCSAccess().getElementAssignment();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index, inst);
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getFirstPathElementCSRule().getType().getClassifier())
			return null;
		if((value = eObjectConsumer.getConsumable("element",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("element");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::CrossReferenceImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getFirstPathElementCSAccess().getElementNamedElementCrossReference_0().getType().getClassifier()) && crossRefSerializer.isValid(obj.getEObject(), grammarAccess.getFirstPathElementCSAccess().getElementNamedElementCrossReference_0(), (EObject)value , null)) {
				type = AssignmentType.CROSS_REFERENCE;
				element = grammarAccess.getFirstPathElementCSAccess().getElementNamedElementCrossReference_0(); 
				return obj;
			}
		}
		return null;
	}

}

/************ end Rule FirstPathElementCS ****************/


/************ begin Rule NextPathElementCS ****************
 *
 * NextPathElementCS returns base::PathElementCS:
 * 	element=[pivot::NamedElement|UnreservedName];
 *
 **/

// element=[pivot::NamedElement|UnreservedName]
protected class NextPathElementCS_ElementAssignment extends AssignmentToken  {
	
	public NextPathElementCS_ElementAssignment(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getNextPathElementCSAccess().getElementAssignment();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index, inst);
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getNextPathElementCSRule().getType().getClassifier())
			return null;
		if((value = eObjectConsumer.getConsumable("element",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("element");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::CrossReferenceImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getNextPathElementCSAccess().getElementNamedElementCrossReference_0().getType().getClassifier()) && crossRefSerializer.isValid(obj.getEObject(), grammarAccess.getNextPathElementCSAccess().getElementNamedElementCrossReference_0(), (EObject)value , null)) {
				type = AssignmentType.CROSS_REFERENCE;
				element = grammarAccess.getNextPathElementCSAccess().getElementNamedElementCrossReference_0(); 
				return obj;
			}
		}
		return null;
	}

}

/************ end Rule NextPathElementCS ****************/


/************ begin Rule URIPathNameCS ****************
 *
 * URIPathNameCS returns base::PathNameCS:
 * 	path+=URIFirstPathElementCS ("::" path+=NextPathElementCS)*;
 *
 **/

// path+=URIFirstPathElementCS ("::" path+=NextPathElementCS)*
protected class URIPathNameCS_Group extends GroupToken {
	
	public URIPathNameCS_Group(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getURIPathNameCSAccess().getGroup();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new URIPathNameCS_Group_1(lastRuleCallOrigin, this, 0, inst);
			case 1: return new URIPathNameCS_PathAssignment_0(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getURIPathNameCSRule().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// path+=URIFirstPathElementCS
protected class URIPathNameCS_PathAssignment_0 extends AssignmentToken  {
	
	public URIPathNameCS_PathAssignment_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getURIPathNameCSAccess().getPathAssignment_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new URIFirstPathElementCS_Alternatives(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("path",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("path");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getURIFirstPathElementCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getURIPathNameCSAccess().getPathURIFirstPathElementCSParserRuleCall_0_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(next, actIndex , index, consumed);
		}	
	}	
}

// ("::" path+=NextPathElementCS)*
protected class URIPathNameCS_Group_1 extends GroupToken {
	
	public URIPathNameCS_Group_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getURIPathNameCSAccess().getGroup_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new URIPathNameCS_PathAssignment_1_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// "::"
protected class URIPathNameCS_ColonColonKeyword_1_0 extends KeywordToken  {
	
	public URIPathNameCS_ColonColonKeyword_1_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getURIPathNameCSAccess().getColonColonKeyword_1_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new URIPathNameCS_Group_1(lastRuleCallOrigin, this, 0, inst);
			case 1: return new URIPathNameCS_PathAssignment_0(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}

// path+=NextPathElementCS
protected class URIPathNameCS_PathAssignment_1_1 extends AssignmentToken  {
	
	public URIPathNameCS_PathAssignment_1_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getURIPathNameCSAccess().getPathAssignment_1_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new NextPathElementCS_ElementAssignment(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("path",false)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("path");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getNextPathElementCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getURIPathNameCSAccess().getPathNextPathElementCSParserRuleCall_1_1_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new URIPathNameCS_ColonColonKeyword_1_0(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}



/************ end Rule URIPathNameCS ****************/


/************ begin Rule URIFirstPathElementCS ****************
 *
 * URIFirstPathElementCS returns base::PathElementCS:
 * 	element=[pivot::NamedElement|UnrestrictedName] | {base::PathElementWithURICS} element=[pivot::Namespace|URI];
 *
 **/

// element=[pivot::NamedElement|UnrestrictedName] | {base::PathElementWithURICS} element=[pivot::Namespace|URI]
protected class URIFirstPathElementCS_Alternatives extends AlternativesToken {

	public URIFirstPathElementCS_Alternatives(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Alternatives getGrammarElement() {
		return grammarAccess.getURIFirstPathElementCSAccess().getAlternatives();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new URIFirstPathElementCS_ElementAssignment_0(lastRuleCallOrigin, this, 0, inst);
			case 1: return new URIFirstPathElementCS_Group_1(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getURIFirstPathElementCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getURIFirstPathElementCSAccess().getPathElementWithURICSAction_1_0().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// element=[pivot::NamedElement|UnrestrictedName]
protected class URIFirstPathElementCS_ElementAssignment_0 extends AssignmentToken  {
	
	public URIFirstPathElementCS_ElementAssignment_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getURIFirstPathElementCSAccess().getElementAssignment_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index, inst);
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getURIFirstPathElementCSRule().getType().getClassifier())
			return null;
		if((value = eObjectConsumer.getConsumable("element",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("element");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::CrossReferenceImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getURIFirstPathElementCSAccess().getElementNamedElementCrossReference_0_0().getType().getClassifier()) && crossRefSerializer.isValid(obj.getEObject(), grammarAccess.getURIFirstPathElementCSAccess().getElementNamedElementCrossReference_0_0(), (EObject)value , null)) {
				type = AssignmentType.CROSS_REFERENCE;
				element = grammarAccess.getURIFirstPathElementCSAccess().getElementNamedElementCrossReference_0_0(); 
				return obj;
			}
		}
		return null;
	}

}

// {base::PathElementWithURICS} element=[pivot::Namespace|URI]
protected class URIFirstPathElementCS_Group_1 extends GroupToken {
	
	public URIFirstPathElementCS_Group_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getURIFirstPathElementCSAccess().getGroup_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new URIFirstPathElementCS_ElementAssignment_1_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getURIFirstPathElementCSAccess().getPathElementWithURICSAction_1_0().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// {base::PathElementWithURICS}
protected class URIFirstPathElementCS_PathElementWithURICSAction_1_0 extends ActionToken  {

	public URIFirstPathElementCS_PathElementWithURICSAction_1_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Action getGrammarElement() {
		return grammarAccess.getURIFirstPathElementCSAccess().getPathElementWithURICSAction_1_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index, inst);
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(!eObjectConsumer.isConsumed()) return null;
		return eObjectConsumer;
	}
}

// element=[pivot::Namespace|URI]
protected class URIFirstPathElementCS_ElementAssignment_1_1 extends AssignmentToken  {
	
	public URIFirstPathElementCS_ElementAssignment_1_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getURIFirstPathElementCSAccess().getElementAssignment_1_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new URIFirstPathElementCS_PathElementWithURICSAction_1_0(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("element",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("element");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::CrossReferenceImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getURIFirstPathElementCSAccess().getElementNamespaceCrossReference_1_1_0().getType().getClassifier()) && crossRefSerializer.isValid(obj.getEObject(), grammarAccess.getURIFirstPathElementCSAccess().getElementNamespaceCrossReference_1_1_0(), (EObject)value , null)) {
				type = AssignmentType.CROSS_REFERENCE;
				element = grammarAccess.getURIFirstPathElementCSAccess().getElementNamespaceCrossReference_1_1_0(); 
				return obj;
			}
		}
		return null;
	}

}



/************ end Rule URIFirstPathElementCS ****************/



/************ begin Rule PrimitiveTypeCS ****************
 *
 * PrimitiveTypeCS returns base::PrimitiveTypeRefCS:
 * 	name=PrimitiveTypeIdentifier;
 *
 **/

// name=PrimitiveTypeIdentifier
protected class PrimitiveTypeCS_NameAssignment extends AssignmentToken  {
	
	public PrimitiveTypeCS_NameAssignment(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getPrimitiveTypeCSAccess().getNameAssignment();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index, inst);
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getPrimitiveTypeCSRule().getType().getClassifier())
			return null;
		if((value = eObjectConsumer.getConsumable("name",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("name");
		if(valueSerializer.isValid(obj.getEObject(), grammarAccess.getPrimitiveTypeCSAccess().getNamePrimitiveTypeIdentifierParserRuleCall_0(), value, null)) {
			type = AssignmentType.DATATYPE_RULE_CALL;
			element = grammarAccess.getPrimitiveTypeCSAccess().getNamePrimitiveTypeIdentifierParserRuleCall_0();
			return obj;
		}
		return null;
	}

}

/************ end Rule PrimitiveTypeCS ****************/



/************ begin Rule CollectionTypeCS ****************
 *
 * CollectionTypeCS:
 * 	name=CollectionTypeIdentifier ("(" ownedType=TypeExpCS ")")?;
 *
 **/

// name=CollectionTypeIdentifier ("(" ownedType=TypeExpCS ")")?
protected class CollectionTypeCS_Group extends GroupToken {
	
	public CollectionTypeCS_Group(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getCollectionTypeCSAccess().getGroup();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new CollectionTypeCS_Group_1(lastRuleCallOrigin, this, 0, inst);
			case 1: return new CollectionTypeCS_NameAssignment_0(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getCollectionTypeCSRule().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// name=CollectionTypeIdentifier
protected class CollectionTypeCS_NameAssignment_0 extends AssignmentToken  {
	
	public CollectionTypeCS_NameAssignment_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getCollectionTypeCSAccess().getNameAssignment_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index, inst);
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("name",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("name");
		if(valueSerializer.isValid(obj.getEObject(), grammarAccess.getCollectionTypeCSAccess().getNameCollectionTypeIdentifierParserRuleCall_0_0(), value, null)) {
			type = AssignmentType.DATATYPE_RULE_CALL;
			element = grammarAccess.getCollectionTypeCSAccess().getNameCollectionTypeIdentifierParserRuleCall_0_0();
			return obj;
		}
		return null;
	}

}

// ("(" ownedType=TypeExpCS ")")?
protected class CollectionTypeCS_Group_1 extends GroupToken {
	
	public CollectionTypeCS_Group_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getCollectionTypeCSAccess().getGroup_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new CollectionTypeCS_RightParenthesisKeyword_1_2(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// "("
protected class CollectionTypeCS_LeftParenthesisKeyword_1_0 extends KeywordToken  {
	
	public CollectionTypeCS_LeftParenthesisKeyword_1_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getCollectionTypeCSAccess().getLeftParenthesisKeyword_1_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new CollectionTypeCS_NameAssignment_0(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// ownedType=TypeExpCS
protected class CollectionTypeCS_OwnedTypeAssignment_1_1 extends AssignmentToken  {
	
	public CollectionTypeCS_OwnedTypeAssignment_1_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getCollectionTypeCSAccess().getOwnedTypeAssignment_1_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TypeExpCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("ownedType",false)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("ownedType");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getTypeExpCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getCollectionTypeCSAccess().getOwnedTypeTypeExpCSParserRuleCall_1_1_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new CollectionTypeCS_LeftParenthesisKeyword_1_0(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}

// ")"
protected class CollectionTypeCS_RightParenthesisKeyword_1_2 extends KeywordToken  {
	
	public CollectionTypeCS_RightParenthesisKeyword_1_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getCollectionTypeCSAccess().getRightParenthesisKeyword_1_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new CollectionTypeCS_OwnedTypeAssignment_1_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}



/************ end Rule CollectionTypeCS ****************/


/************ begin Rule MultiplicityBoundsCS ****************
 *
 * MultiplicityBoundsCS returns base::MultiplicityBoundsCS:
 * 	lowerBound=LOWER (".." upperBound=UPPER)?;
 *
 **/

// lowerBound=LOWER (".." upperBound=UPPER)?
protected class MultiplicityBoundsCS_Group extends GroupToken {
	
	public MultiplicityBoundsCS_Group(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getMultiplicityBoundsCSAccess().getGroup();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new MultiplicityBoundsCS_Group_1(lastRuleCallOrigin, this, 0, inst);
			case 1: return new MultiplicityBoundsCS_LowerBoundAssignment_0(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getMultiplicityBoundsCSRule().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// lowerBound=LOWER
protected class MultiplicityBoundsCS_LowerBoundAssignment_0 extends AssignmentToken  {
	
	public MultiplicityBoundsCS_LowerBoundAssignment_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getMultiplicityBoundsCSAccess().getLowerBoundAssignment_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index, inst);
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("lowerBound",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("lowerBound");
		if(valueSerializer.isValid(obj.getEObject(), grammarAccess.getMultiplicityBoundsCSAccess().getLowerBoundLOWERParserRuleCall_0_0(), value, null)) {
			type = AssignmentType.DATATYPE_RULE_CALL;
			element = grammarAccess.getMultiplicityBoundsCSAccess().getLowerBoundLOWERParserRuleCall_0_0();
			return obj;
		}
		return null;
	}

}

// (".." upperBound=UPPER)?
protected class MultiplicityBoundsCS_Group_1 extends GroupToken {
	
	public MultiplicityBoundsCS_Group_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getMultiplicityBoundsCSAccess().getGroup_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new MultiplicityBoundsCS_UpperBoundAssignment_1_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// ".."
protected class MultiplicityBoundsCS_FullStopFullStopKeyword_1_0 extends KeywordToken  {
	
	public MultiplicityBoundsCS_FullStopFullStopKeyword_1_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getMultiplicityBoundsCSAccess().getFullStopFullStopKeyword_1_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new MultiplicityBoundsCS_LowerBoundAssignment_0(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// upperBound=UPPER
protected class MultiplicityBoundsCS_UpperBoundAssignment_1_1 extends AssignmentToken  {
	
	public MultiplicityBoundsCS_UpperBoundAssignment_1_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getMultiplicityBoundsCSAccess().getUpperBoundAssignment_1_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new MultiplicityBoundsCS_FullStopFullStopKeyword_1_0(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("upperBound",false)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("upperBound");
		if(valueSerializer.isValid(obj.getEObject(), grammarAccess.getMultiplicityBoundsCSAccess().getUpperBoundUPPERParserRuleCall_1_1_0(), value, null)) {
			type = AssignmentType.DATATYPE_RULE_CALL;
			element = grammarAccess.getMultiplicityBoundsCSAccess().getUpperBoundUPPERParserRuleCall_1_1_0();
			return obj;
		}
		return null;
	}

}



/************ end Rule MultiplicityBoundsCS ****************/


/************ begin Rule MultiplicityCS ****************
 *
 * MultiplicityCS returns base::MultiplicityCS:
 * 	"[" (MultiplicityBoundsCS | MultiplicityStringCS) "]";
 *
 **/

// "[" (MultiplicityBoundsCS | MultiplicityStringCS) "]"
protected class MultiplicityCS_Group extends GroupToken {
	
	public MultiplicityCS_Group(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getMultiplicityCSAccess().getGroup();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new MultiplicityCS_RightSquareBracketKeyword_2(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getMultiplicityBoundsCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getMultiplicityStringCSRule().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// "["
protected class MultiplicityCS_LeftSquareBracketKeyword_0 extends KeywordToken  {
	
	public MultiplicityCS_LeftSquareBracketKeyword_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getMultiplicityCSAccess().getLeftSquareBracketKeyword_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index, inst);
		}	
	}

}

// MultiplicityBoundsCS | MultiplicityStringCS
protected class MultiplicityCS_Alternatives_1 extends AlternativesToken {

	public MultiplicityCS_Alternatives_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Alternatives getGrammarElement() {
		return grammarAccess.getMultiplicityCSAccess().getAlternatives_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new MultiplicityCS_MultiplicityBoundsCSParserRuleCall_1_0(lastRuleCallOrigin, this, 0, inst);
			case 1: return new MultiplicityCS_MultiplicityStringCSParserRuleCall_1_1(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}

// MultiplicityBoundsCS
protected class MultiplicityCS_MultiplicityBoundsCSParserRuleCall_1_0 extends RuleCallToken {
	
	public MultiplicityCS_MultiplicityBoundsCSParserRuleCall_1_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public RuleCall getGrammarElement() {
		return grammarAccess.getMultiplicityCSAccess().getMultiplicityBoundsCSParserRuleCall_1_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new MultiplicityBoundsCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getMultiplicityBoundsCSRule().getType().getClassifier())
			return null;
		if(checkForRecursion(MultiplicityBoundsCS_Group.class, eObjectConsumer)) return null;
		return eObjectConsumer;
	}
	
    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new MultiplicityCS_LeftSquareBracketKeyword_0(lastRuleCallOrigin, next, actIndex, inst);
			default: return null;
		}	
	}	
}

// MultiplicityStringCS
protected class MultiplicityCS_MultiplicityStringCSParserRuleCall_1_1 extends RuleCallToken {
	
	public MultiplicityCS_MultiplicityStringCSParserRuleCall_1_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public RuleCall getGrammarElement() {
		return grammarAccess.getMultiplicityCSAccess().getMultiplicityStringCSParserRuleCall_1_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new MultiplicityStringCS_StringBoundsAssignment(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getMultiplicityStringCSRule().getType().getClassifier())
			return null;
		if(checkForRecursion(MultiplicityStringCS_StringBoundsAssignment.class, eObjectConsumer)) return null;
		return eObjectConsumer;
	}
	
    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new MultiplicityCS_LeftSquareBracketKeyword_0(lastRuleCallOrigin, next, actIndex, inst);
			default: return null;
		}	
	}	
}


// "]"
protected class MultiplicityCS_RightSquareBracketKeyword_2 extends KeywordToken  {
	
	public MultiplicityCS_RightSquareBracketKeyword_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getMultiplicityCSAccess().getRightSquareBracketKeyword_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new MultiplicityCS_Alternatives_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}


/************ end Rule MultiplicityCS ****************/


/************ begin Rule MultiplicityStringCS ****************
 *
 * MultiplicityStringCS returns base::MultiplicityStringCS:
 * 	stringBounds=("*" | "+" | "?");
 *
 **/

// stringBounds=("*" | "+" | "?")
protected class MultiplicityStringCS_StringBoundsAssignment extends AssignmentToken  {
	
	public MultiplicityStringCS_StringBoundsAssignment(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getMultiplicityStringCSAccess().getStringBoundsAssignment();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index, inst);
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getMultiplicityStringCSRule().getType().getClassifier())
			return null;
		if((value = eObjectConsumer.getConsumable("stringBounds",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("stringBounds");
		if(keywordSerializer.isValid(obj.getEObject(), grammarAccess.getMultiplicityStringCSAccess().getStringBoundsAsteriskKeyword_0_0(), value, null)) {
			type = AssignmentType.KEYWORD;
			element = grammarAccess.getMultiplicityStringCSAccess().getStringBoundsAsteriskKeyword_0_0();
			return obj;
		}
		if(keywordSerializer.isValid(obj.getEObject(), grammarAccess.getMultiplicityStringCSAccess().getStringBoundsPlusSignKeyword_0_1(), value, null)) {
			type = AssignmentType.KEYWORD;
			element = grammarAccess.getMultiplicityStringCSAccess().getStringBoundsPlusSignKeyword_0_1();
			return obj;
		}
		if(keywordSerializer.isValid(obj.getEObject(), grammarAccess.getMultiplicityStringCSAccess().getStringBoundsQuestionMarkKeyword_0_2(), value, null)) {
			type = AssignmentType.KEYWORD;
			element = grammarAccess.getMultiplicityStringCSAccess().getStringBoundsQuestionMarkKeyword_0_2();
			return obj;
		}
		return null;
	}

}

/************ end Rule MultiplicityStringCS ****************/


/************ begin Rule TupleTypeCS ****************
 *
 * TupleTypeCS returns base::TupleTypeCS:
 * 	name="Tuple" ("(" (ownedParts+=TuplePartCS ("," ownedParts+=TuplePartCS)*)? ")")?;
 *
 **/

// name="Tuple" ("(" (ownedParts+=TuplePartCS ("," ownedParts+=TuplePartCS)*)? ")")?
protected class TupleTypeCS_Group extends GroupToken {
	
	public TupleTypeCS_Group(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getTupleTypeCSAccess().getGroup();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TupleTypeCS_Group_1(lastRuleCallOrigin, this, 0, inst);
			case 1: return new TupleTypeCS_NameAssignment_0(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getTupleTypeCSRule().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// name="Tuple"
protected class TupleTypeCS_NameAssignment_0 extends AssignmentToken  {
	
	public TupleTypeCS_NameAssignment_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getTupleTypeCSAccess().getNameAssignment_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index, inst);
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("name",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("name");
		if(keywordSerializer.isValid(obj.getEObject(), grammarAccess.getTupleTypeCSAccess().getNameTupleKeyword_0_0(), value, null)) {
			type = AssignmentType.KEYWORD;
			element = grammarAccess.getTupleTypeCSAccess().getNameTupleKeyword_0_0();
			return obj;
		}
		return null;
	}

}

// ("(" (ownedParts+=TuplePartCS ("," ownedParts+=TuplePartCS)*)? ")")?
protected class TupleTypeCS_Group_1 extends GroupToken {
	
	public TupleTypeCS_Group_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getTupleTypeCSAccess().getGroup_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TupleTypeCS_RightParenthesisKeyword_1_2(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// "("
protected class TupleTypeCS_LeftParenthesisKeyword_1_0 extends KeywordToken  {
	
	public TupleTypeCS_LeftParenthesisKeyword_1_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getTupleTypeCSAccess().getLeftParenthesisKeyword_1_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TupleTypeCS_NameAssignment_0(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// (ownedParts+=TuplePartCS ("," ownedParts+=TuplePartCS)*)?
protected class TupleTypeCS_Group_1_1 extends GroupToken {
	
	public TupleTypeCS_Group_1_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getTupleTypeCSAccess().getGroup_1_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TupleTypeCS_Group_1_1_1(lastRuleCallOrigin, this, 0, inst);
			case 1: return new TupleTypeCS_OwnedPartsAssignment_1_1_0(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}

// ownedParts+=TuplePartCS
protected class TupleTypeCS_OwnedPartsAssignment_1_1_0 extends AssignmentToken  {
	
	public TupleTypeCS_OwnedPartsAssignment_1_1_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getTupleTypeCSAccess().getOwnedPartsAssignment_1_1_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TuplePartCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("ownedParts",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("ownedParts");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getTuplePartCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getTupleTypeCSAccess().getOwnedPartsTuplePartCSParserRuleCall_1_1_0_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new TupleTypeCS_LeftParenthesisKeyword_1_0(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}

// ("," ownedParts+=TuplePartCS)*
protected class TupleTypeCS_Group_1_1_1 extends GroupToken {
	
	public TupleTypeCS_Group_1_1_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getTupleTypeCSAccess().getGroup_1_1_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TupleTypeCS_OwnedPartsAssignment_1_1_1_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// ","
protected class TupleTypeCS_CommaKeyword_1_1_1_0 extends KeywordToken  {
	
	public TupleTypeCS_CommaKeyword_1_1_1_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getTupleTypeCSAccess().getCommaKeyword_1_1_1_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TupleTypeCS_Group_1_1_1(lastRuleCallOrigin, this, 0, inst);
			case 1: return new TupleTypeCS_OwnedPartsAssignment_1_1_0(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}

// ownedParts+=TuplePartCS
protected class TupleTypeCS_OwnedPartsAssignment_1_1_1_1 extends AssignmentToken  {
	
	public TupleTypeCS_OwnedPartsAssignment_1_1_1_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getTupleTypeCSAccess().getOwnedPartsAssignment_1_1_1_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TuplePartCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("ownedParts",false)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("ownedParts");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getTuplePartCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getTupleTypeCSAccess().getOwnedPartsTuplePartCSParserRuleCall_1_1_1_1_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new TupleTypeCS_CommaKeyword_1_1_1_0(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}



// ")"
protected class TupleTypeCS_RightParenthesisKeyword_1_2 extends KeywordToken  {
	
	public TupleTypeCS_RightParenthesisKeyword_1_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getTupleTypeCSAccess().getRightParenthesisKeyword_1_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TupleTypeCS_Group_1_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}



/************ end Rule TupleTypeCS ****************/


/************ begin Rule TuplePartCS ****************
 *
 * TuplePartCS returns base::TuplePartCS:
 * 	name=UnrestrictedName ":" ownedType=TypeExpCS;
 *
 **/

// name=UnrestrictedName ":" ownedType=TypeExpCS
protected class TuplePartCS_Group extends GroupToken {
	
	public TuplePartCS_Group(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getTuplePartCSAccess().getGroup();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TuplePartCS_OwnedTypeAssignment_2(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getTuplePartCSRule().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// name=UnrestrictedName
protected class TuplePartCS_NameAssignment_0 extends AssignmentToken  {
	
	public TuplePartCS_NameAssignment_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getTuplePartCSAccess().getNameAssignment_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index, inst);
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("name",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("name");
		if(valueSerializer.isValid(obj.getEObject(), grammarAccess.getTuplePartCSAccess().getNameUnrestrictedNameParserRuleCall_0_0(), value, null)) {
			type = AssignmentType.DATATYPE_RULE_CALL;
			element = grammarAccess.getTuplePartCSAccess().getNameUnrestrictedNameParserRuleCall_0_0();
			return obj;
		}
		return null;
	}

}

// ":"
protected class TuplePartCS_ColonKeyword_1 extends KeywordToken  {
	
	public TuplePartCS_ColonKeyword_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getTuplePartCSAccess().getColonKeyword_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TuplePartCS_NameAssignment_0(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// ownedType=TypeExpCS
protected class TuplePartCS_OwnedTypeAssignment_2 extends AssignmentToken  {
	
	public TuplePartCS_OwnedTypeAssignment_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getTuplePartCSAccess().getOwnedTypeAssignment_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TypeExpCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("ownedType",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("ownedType");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getTypeExpCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getTuplePartCSAccess().getOwnedTypeTypeExpCSParserRuleCall_2_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new TuplePartCS_ColonKeyword_1(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}


/************ end Rule TuplePartCS ****************/


/************ begin Rule CollectionLiteralExpCS ****************
 *
 * //---------------------------------------------------------------------
 * //  Literals
 * //---------------------------------------------------------------------
 * CollectionLiteralExpCS:
 * 	ownedType=CollectionTypeCS "{" (ownedParts+=CollectionLiteralPartCS ("," ownedParts+=CollectionLiteralPartCS)*)? "}";
 *
 **/

// ownedType=CollectionTypeCS "{" (ownedParts+=CollectionLiteralPartCS ("," ownedParts+=CollectionLiteralPartCS)*)? "}"
protected class CollectionLiteralExpCS_Group extends GroupToken {
	
	public CollectionLiteralExpCS_Group(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getCollectionLiteralExpCSAccess().getGroup();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new CollectionLiteralExpCS_RightCurlyBracketKeyword_3(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getCollectionLiteralExpCSRule().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// ownedType=CollectionTypeCS
protected class CollectionLiteralExpCS_OwnedTypeAssignment_0 extends AssignmentToken  {
	
	public CollectionLiteralExpCS_OwnedTypeAssignment_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getCollectionLiteralExpCSAccess().getOwnedTypeAssignment_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new CollectionTypeCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("ownedType",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("ownedType");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getCollectionTypeCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getCollectionLiteralExpCSAccess().getOwnedTypeCollectionTypeCSParserRuleCall_0_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(next, actIndex , index, consumed);
		}	
	}	
}

// "{"
protected class CollectionLiteralExpCS_LeftCurlyBracketKeyword_1 extends KeywordToken  {
	
	public CollectionLiteralExpCS_LeftCurlyBracketKeyword_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getCollectionLiteralExpCSAccess().getLeftCurlyBracketKeyword_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new CollectionLiteralExpCS_OwnedTypeAssignment_0(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// (ownedParts+=CollectionLiteralPartCS ("," ownedParts+=CollectionLiteralPartCS)*)?
protected class CollectionLiteralExpCS_Group_2 extends GroupToken {
	
	public CollectionLiteralExpCS_Group_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getCollectionLiteralExpCSAccess().getGroup_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new CollectionLiteralExpCS_Group_2_1(lastRuleCallOrigin, this, 0, inst);
			case 1: return new CollectionLiteralExpCS_OwnedPartsAssignment_2_0(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}

// ownedParts+=CollectionLiteralPartCS
protected class CollectionLiteralExpCS_OwnedPartsAssignment_2_0 extends AssignmentToken  {
	
	public CollectionLiteralExpCS_OwnedPartsAssignment_2_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getCollectionLiteralExpCSAccess().getOwnedPartsAssignment_2_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new CollectionLiteralPartCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("ownedParts",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("ownedParts");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getCollectionLiteralPartCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getCollectionLiteralExpCSAccess().getOwnedPartsCollectionLiteralPartCSParserRuleCall_2_0_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new CollectionLiteralExpCS_LeftCurlyBracketKeyword_1(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}

// ("," ownedParts+=CollectionLiteralPartCS)*
protected class CollectionLiteralExpCS_Group_2_1 extends GroupToken {
	
	public CollectionLiteralExpCS_Group_2_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getCollectionLiteralExpCSAccess().getGroup_2_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new CollectionLiteralExpCS_OwnedPartsAssignment_2_1_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// ","
protected class CollectionLiteralExpCS_CommaKeyword_2_1_0 extends KeywordToken  {
	
	public CollectionLiteralExpCS_CommaKeyword_2_1_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getCollectionLiteralExpCSAccess().getCommaKeyword_2_1_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new CollectionLiteralExpCS_Group_2_1(lastRuleCallOrigin, this, 0, inst);
			case 1: return new CollectionLiteralExpCS_OwnedPartsAssignment_2_0(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}

// ownedParts+=CollectionLiteralPartCS
protected class CollectionLiteralExpCS_OwnedPartsAssignment_2_1_1 extends AssignmentToken  {
	
	public CollectionLiteralExpCS_OwnedPartsAssignment_2_1_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getCollectionLiteralExpCSAccess().getOwnedPartsAssignment_2_1_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new CollectionLiteralPartCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("ownedParts",false)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("ownedParts");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getCollectionLiteralPartCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getCollectionLiteralExpCSAccess().getOwnedPartsCollectionLiteralPartCSParserRuleCall_2_1_1_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new CollectionLiteralExpCS_CommaKeyword_2_1_0(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}



// "}"
protected class CollectionLiteralExpCS_RightCurlyBracketKeyword_3 extends KeywordToken  {
	
	public CollectionLiteralExpCS_RightCurlyBracketKeyword_3(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getCollectionLiteralExpCSAccess().getRightCurlyBracketKeyword_3();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new CollectionLiteralExpCS_Group_2(lastRuleCallOrigin, this, 0, inst);
			case 1: return new CollectionLiteralExpCS_LeftCurlyBracketKeyword_1(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}


/************ end Rule CollectionLiteralExpCS ****************/


/************ begin Rule CollectionLiteralPartCS ****************
 *
 * CollectionLiteralPartCS:
 * 	expressionCS=ExpCS (".." lastExpressionCS=ExpCS)?;
 *
 **/

// expressionCS=ExpCS (".." lastExpressionCS=ExpCS)?
protected class CollectionLiteralPartCS_Group extends GroupToken {
	
	public CollectionLiteralPartCS_Group(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getCollectionLiteralPartCSAccess().getGroup();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new CollectionLiteralPartCS_Group_1(lastRuleCallOrigin, this, 0, inst);
			case 1: return new CollectionLiteralPartCS_ExpressionCSAssignment_0(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getCollectionLiteralPartCSRule().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// expressionCS=ExpCS
protected class CollectionLiteralPartCS_ExpressionCSAssignment_0 extends AssignmentToken  {
	
	public CollectionLiteralPartCS_ExpressionCSAssignment_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getCollectionLiteralPartCSAccess().getExpressionCSAssignment_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ExpCS_Alternatives(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("expressionCS",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("expressionCS");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getExpCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getCollectionLiteralPartCSAccess().getExpressionCSExpCSParserRuleCall_0_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(next, actIndex , index, consumed);
		}	
	}	
}

// (".." lastExpressionCS=ExpCS)?
protected class CollectionLiteralPartCS_Group_1 extends GroupToken {
	
	public CollectionLiteralPartCS_Group_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getCollectionLiteralPartCSAccess().getGroup_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new CollectionLiteralPartCS_LastExpressionCSAssignment_1_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// ".."
protected class CollectionLiteralPartCS_FullStopFullStopKeyword_1_0 extends KeywordToken  {
	
	public CollectionLiteralPartCS_FullStopFullStopKeyword_1_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getCollectionLiteralPartCSAccess().getFullStopFullStopKeyword_1_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new CollectionLiteralPartCS_ExpressionCSAssignment_0(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// lastExpressionCS=ExpCS
protected class CollectionLiteralPartCS_LastExpressionCSAssignment_1_1 extends AssignmentToken  {
	
	public CollectionLiteralPartCS_LastExpressionCSAssignment_1_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getCollectionLiteralPartCSAccess().getLastExpressionCSAssignment_1_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ExpCS_Alternatives(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("lastExpressionCS",false)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("lastExpressionCS");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getExpCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getCollectionLiteralPartCSAccess().getLastExpressionCSExpCSParserRuleCall_1_1_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new CollectionLiteralPartCS_FullStopFullStopKeyword_1_0(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}



/************ end Rule CollectionLiteralPartCS ****************/


/************ begin Rule ConstructorPartCS ****************
 *
 * ConstructorPartCS:
 * 	property=[pivot::Property|UnrestrictedName] "=" initExpression=ExpCS;
 *
 **/

// property=[pivot::Property|UnrestrictedName] "=" initExpression=ExpCS
protected class ConstructorPartCS_Group extends GroupToken {
	
	public ConstructorPartCS_Group(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getConstructorPartCSAccess().getGroup();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ConstructorPartCS_InitExpressionAssignment_2(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getConstructorPartCSRule().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// property=[pivot::Property|UnrestrictedName]
protected class ConstructorPartCS_PropertyAssignment_0 extends AssignmentToken  {
	
	public ConstructorPartCS_PropertyAssignment_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getConstructorPartCSAccess().getPropertyAssignment_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index, inst);
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("property",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("property");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::CrossReferenceImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getConstructorPartCSAccess().getPropertyPropertyCrossReference_0_0().getType().getClassifier())) {
				type = AssignmentType.CROSS_REFERENCE;
				element = grammarAccess.getConstructorPartCSAccess().getPropertyPropertyCrossReference_0_0(); 
				return obj;
			}
		}
		return null;
	}

}

// "="
protected class ConstructorPartCS_EqualsSignKeyword_1 extends KeywordToken  {
	
	public ConstructorPartCS_EqualsSignKeyword_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getConstructorPartCSAccess().getEqualsSignKeyword_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ConstructorPartCS_PropertyAssignment_0(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// initExpression=ExpCS
protected class ConstructorPartCS_InitExpressionAssignment_2 extends AssignmentToken  {
	
	public ConstructorPartCS_InitExpressionAssignment_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getConstructorPartCSAccess().getInitExpressionAssignment_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ExpCS_Alternatives(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("initExpression",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("initExpression");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getExpCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getConstructorPartCSAccess().getInitExpressionExpCSParserRuleCall_2_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new ConstructorPartCS_EqualsSignKeyword_1(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}


/************ end Rule ConstructorPartCS ****************/


/************ begin Rule PrimitiveLiteralExpCS ****************
 *
 * PrimitiveLiteralExpCS:
 * 	NumberLiteralExpCS | StringLiteralExpCS | BooleanLiteralExpCS | UnlimitedNaturalLiteralExpCS | InvalidLiteralExpCS |
 * 	NullLiteralExpCS;
 *
 **/

// NumberLiteralExpCS | StringLiteralExpCS | BooleanLiteralExpCS | UnlimitedNaturalLiteralExpCS | InvalidLiteralExpCS |
// NullLiteralExpCS
protected class PrimitiveLiteralExpCS_Alternatives extends AlternativesToken {

	public PrimitiveLiteralExpCS_Alternatives(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Alternatives getGrammarElement() {
		return grammarAccess.getPrimitiveLiteralExpCSAccess().getAlternatives();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PrimitiveLiteralExpCS_NumberLiteralExpCSParserRuleCall_0(lastRuleCallOrigin, this, 0, inst);
			case 1: return new PrimitiveLiteralExpCS_StringLiteralExpCSParserRuleCall_1(lastRuleCallOrigin, this, 1, inst);
			case 2: return new PrimitiveLiteralExpCS_BooleanLiteralExpCSParserRuleCall_2(lastRuleCallOrigin, this, 2, inst);
			case 3: return new PrimitiveLiteralExpCS_UnlimitedNaturalLiteralExpCSParserRuleCall_3(lastRuleCallOrigin, this, 3, inst);
			case 4: return new PrimitiveLiteralExpCS_InvalidLiteralExpCSParserRuleCall_4(lastRuleCallOrigin, this, 4, inst);
			case 5: return new PrimitiveLiteralExpCS_NullLiteralExpCSParserRuleCall_5(lastRuleCallOrigin, this, 5, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getBooleanLiteralExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getInvalidLiteralExpCSAccess().getInvalidLiteralExpCSAction_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getNullLiteralExpCSAccess().getNullLiteralExpCSAction_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getNumberLiteralExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getStringLiteralExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getUnlimitedNaturalLiteralExpCSAccess().getUnlimitedNaturalLiteralExpCSAction_0().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// NumberLiteralExpCS
protected class PrimitiveLiteralExpCS_NumberLiteralExpCSParserRuleCall_0 extends RuleCallToken {
	
	public PrimitiveLiteralExpCS_NumberLiteralExpCSParserRuleCall_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public RuleCall getGrammarElement() {
		return grammarAccess.getPrimitiveLiteralExpCSAccess().getNumberLiteralExpCSParserRuleCall_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new NumberLiteralExpCS_NameAssignment(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getNumberLiteralExpCSRule().getType().getClassifier())
			return null;
		if(checkForRecursion(NumberLiteralExpCS_NameAssignment.class, eObjectConsumer)) return null;
		return eObjectConsumer;
	}
	
    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(next, actIndex , index, inst);
		}	
	}	
}

// StringLiteralExpCS
protected class PrimitiveLiteralExpCS_StringLiteralExpCSParserRuleCall_1 extends RuleCallToken {
	
	public PrimitiveLiteralExpCS_StringLiteralExpCSParserRuleCall_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public RuleCall getGrammarElement() {
		return grammarAccess.getPrimitiveLiteralExpCSAccess().getStringLiteralExpCSParserRuleCall_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new StringLiteralExpCS_NameAssignment(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getStringLiteralExpCSRule().getType().getClassifier())
			return null;
		if(checkForRecursion(StringLiteralExpCS_NameAssignment.class, eObjectConsumer)) return null;
		return eObjectConsumer;
	}
	
    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(next, actIndex , index, inst);
		}	
	}	
}

// BooleanLiteralExpCS
protected class PrimitiveLiteralExpCS_BooleanLiteralExpCSParserRuleCall_2 extends RuleCallToken {
	
	public PrimitiveLiteralExpCS_BooleanLiteralExpCSParserRuleCall_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public RuleCall getGrammarElement() {
		return grammarAccess.getPrimitiveLiteralExpCSAccess().getBooleanLiteralExpCSParserRuleCall_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new BooleanLiteralExpCS_Alternatives(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getBooleanLiteralExpCSRule().getType().getClassifier())
			return null;
		if(checkForRecursion(BooleanLiteralExpCS_Alternatives.class, eObjectConsumer)) return null;
		return eObjectConsumer;
	}
	
    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(next, actIndex , index, inst);
		}	
	}	
}

// UnlimitedNaturalLiteralExpCS
protected class PrimitiveLiteralExpCS_UnlimitedNaturalLiteralExpCSParserRuleCall_3 extends RuleCallToken {
	
	public PrimitiveLiteralExpCS_UnlimitedNaturalLiteralExpCSParserRuleCall_3(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public RuleCall getGrammarElement() {
		return grammarAccess.getPrimitiveLiteralExpCSAccess().getUnlimitedNaturalLiteralExpCSParserRuleCall_3();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new UnlimitedNaturalLiteralExpCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getUnlimitedNaturalLiteralExpCSAccess().getUnlimitedNaturalLiteralExpCSAction_0().getType().getClassifier())
			return null;
		if(checkForRecursion(UnlimitedNaturalLiteralExpCS_Group.class, eObjectConsumer)) return null;
		return eObjectConsumer;
	}
	
    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(next, actIndex , index, inst);
		}	
	}	
}

// InvalidLiteralExpCS
protected class PrimitiveLiteralExpCS_InvalidLiteralExpCSParserRuleCall_4 extends RuleCallToken {
	
	public PrimitiveLiteralExpCS_InvalidLiteralExpCSParserRuleCall_4(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public RuleCall getGrammarElement() {
		return grammarAccess.getPrimitiveLiteralExpCSAccess().getInvalidLiteralExpCSParserRuleCall_4();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new InvalidLiteralExpCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getInvalidLiteralExpCSAccess().getInvalidLiteralExpCSAction_0().getType().getClassifier())
			return null;
		if(checkForRecursion(InvalidLiteralExpCS_Group.class, eObjectConsumer)) return null;
		return eObjectConsumer;
	}
	
    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(next, actIndex , index, inst);
		}	
	}	
}

// NullLiteralExpCS
protected class PrimitiveLiteralExpCS_NullLiteralExpCSParserRuleCall_5 extends RuleCallToken {
	
	public PrimitiveLiteralExpCS_NullLiteralExpCSParserRuleCall_5(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public RuleCall getGrammarElement() {
		return grammarAccess.getPrimitiveLiteralExpCSAccess().getNullLiteralExpCSParserRuleCall_5();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new NullLiteralExpCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getNullLiteralExpCSAccess().getNullLiteralExpCSAction_0().getType().getClassifier())
			return null;
		if(checkForRecursion(NullLiteralExpCS_Group.class, eObjectConsumer)) return null;
		return eObjectConsumer;
	}
	
    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(next, actIndex , index, inst);
		}	
	}	
}


/************ end Rule PrimitiveLiteralExpCS ****************/


/************ begin Rule TupleLiteralExpCS ****************
 *
 * TupleLiteralExpCS:
 * 	"Tuple" "{" ownedParts+=TupleLiteralPartCS ("," ownedParts+=TupleLiteralPartCS)* "}";
 *
 **/

// "Tuple" "{" ownedParts+=TupleLiteralPartCS ("," ownedParts+=TupleLiteralPartCS)* "}"
protected class TupleLiteralExpCS_Group extends GroupToken {
	
	public TupleLiteralExpCS_Group(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getTupleLiteralExpCSAccess().getGroup();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TupleLiteralExpCS_RightCurlyBracketKeyword_4(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getTupleLiteralExpCSRule().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// "Tuple"
protected class TupleLiteralExpCS_TupleKeyword_0 extends KeywordToken  {
	
	public TupleLiteralExpCS_TupleKeyword_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getTupleLiteralExpCSAccess().getTupleKeyword_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index, inst);
		}	
	}

}

// "{"
protected class TupleLiteralExpCS_LeftCurlyBracketKeyword_1 extends KeywordToken  {
	
	public TupleLiteralExpCS_LeftCurlyBracketKeyword_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getTupleLiteralExpCSAccess().getLeftCurlyBracketKeyword_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TupleLiteralExpCS_TupleKeyword_0(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// ownedParts+=TupleLiteralPartCS
protected class TupleLiteralExpCS_OwnedPartsAssignment_2 extends AssignmentToken  {
	
	public TupleLiteralExpCS_OwnedPartsAssignment_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getTupleLiteralExpCSAccess().getOwnedPartsAssignment_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TupleLiteralPartCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("ownedParts",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("ownedParts");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getTupleLiteralPartCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getTupleLiteralExpCSAccess().getOwnedPartsTupleLiteralPartCSParserRuleCall_2_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new TupleLiteralExpCS_LeftCurlyBracketKeyword_1(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}

// ("," ownedParts+=TupleLiteralPartCS)*
protected class TupleLiteralExpCS_Group_3 extends GroupToken {
	
	public TupleLiteralExpCS_Group_3(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getTupleLiteralExpCSAccess().getGroup_3();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TupleLiteralExpCS_OwnedPartsAssignment_3_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// ","
protected class TupleLiteralExpCS_CommaKeyword_3_0 extends KeywordToken  {
	
	public TupleLiteralExpCS_CommaKeyword_3_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getTupleLiteralExpCSAccess().getCommaKeyword_3_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TupleLiteralExpCS_Group_3(lastRuleCallOrigin, this, 0, inst);
			case 1: return new TupleLiteralExpCS_OwnedPartsAssignment_2(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}

// ownedParts+=TupleLiteralPartCS
protected class TupleLiteralExpCS_OwnedPartsAssignment_3_1 extends AssignmentToken  {
	
	public TupleLiteralExpCS_OwnedPartsAssignment_3_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getTupleLiteralExpCSAccess().getOwnedPartsAssignment_3_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TupleLiteralPartCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("ownedParts",false)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("ownedParts");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getTupleLiteralPartCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getTupleLiteralExpCSAccess().getOwnedPartsTupleLiteralPartCSParserRuleCall_3_1_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new TupleLiteralExpCS_CommaKeyword_3_0(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}


// "}"
protected class TupleLiteralExpCS_RightCurlyBracketKeyword_4 extends KeywordToken  {
	
	public TupleLiteralExpCS_RightCurlyBracketKeyword_4(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getTupleLiteralExpCSAccess().getRightCurlyBracketKeyword_4();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TupleLiteralExpCS_Group_3(lastRuleCallOrigin, this, 0, inst);
			case 1: return new TupleLiteralExpCS_OwnedPartsAssignment_2(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}


/************ end Rule TupleLiteralExpCS ****************/


/************ begin Rule TupleLiteralPartCS ****************
 *
 * TupleLiteralPartCS:
 * 	name=UnrestrictedName (":" ownedType=TypeExpCS)? "=" initExpression=ExpCS;
 *
 **/

// name=UnrestrictedName (":" ownedType=TypeExpCS)? "=" initExpression=ExpCS
protected class TupleLiteralPartCS_Group extends GroupToken {
	
	public TupleLiteralPartCS_Group(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getTupleLiteralPartCSAccess().getGroup();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TupleLiteralPartCS_InitExpressionAssignment_3(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getTupleLiteralPartCSRule().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// name=UnrestrictedName
protected class TupleLiteralPartCS_NameAssignment_0 extends AssignmentToken  {
	
	public TupleLiteralPartCS_NameAssignment_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getTupleLiteralPartCSAccess().getNameAssignment_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index, inst);
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("name",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("name");
		if(valueSerializer.isValid(obj.getEObject(), grammarAccess.getTupleLiteralPartCSAccess().getNameUnrestrictedNameParserRuleCall_0_0(), value, null)) {
			type = AssignmentType.DATATYPE_RULE_CALL;
			element = grammarAccess.getTupleLiteralPartCSAccess().getNameUnrestrictedNameParserRuleCall_0_0();
			return obj;
		}
		return null;
	}

}

// (":" ownedType=TypeExpCS)?
protected class TupleLiteralPartCS_Group_1 extends GroupToken {
	
	public TupleLiteralPartCS_Group_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getTupleLiteralPartCSAccess().getGroup_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TupleLiteralPartCS_OwnedTypeAssignment_1_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// ":"
protected class TupleLiteralPartCS_ColonKeyword_1_0 extends KeywordToken  {
	
	public TupleLiteralPartCS_ColonKeyword_1_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getTupleLiteralPartCSAccess().getColonKeyword_1_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TupleLiteralPartCS_NameAssignment_0(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// ownedType=TypeExpCS
protected class TupleLiteralPartCS_OwnedTypeAssignment_1_1 extends AssignmentToken  {
	
	public TupleLiteralPartCS_OwnedTypeAssignment_1_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getTupleLiteralPartCSAccess().getOwnedTypeAssignment_1_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TypeExpCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("ownedType",false)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("ownedType");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getTypeExpCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getTupleLiteralPartCSAccess().getOwnedTypeTypeExpCSParserRuleCall_1_1_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new TupleLiteralPartCS_ColonKeyword_1_0(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}


// "="
protected class TupleLiteralPartCS_EqualsSignKeyword_2 extends KeywordToken  {
	
	public TupleLiteralPartCS_EqualsSignKeyword_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getTupleLiteralPartCSAccess().getEqualsSignKeyword_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TupleLiteralPartCS_Group_1(lastRuleCallOrigin, this, 0, inst);
			case 1: return new TupleLiteralPartCS_NameAssignment_0(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}

// initExpression=ExpCS
protected class TupleLiteralPartCS_InitExpressionAssignment_3 extends AssignmentToken  {
	
	public TupleLiteralPartCS_InitExpressionAssignment_3(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getTupleLiteralPartCSAccess().getInitExpressionAssignment_3();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ExpCS_Alternatives(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("initExpression",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("initExpression");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getExpCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getTupleLiteralPartCSAccess().getInitExpressionExpCSParserRuleCall_3_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new TupleLiteralPartCS_EqualsSignKeyword_2(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}


/************ end Rule TupleLiteralPartCS ****************/


/************ begin Rule NumberLiteralExpCS ****************
 *
 * NumberLiteralExpCS:
 * 	name=NUMBER_LITERAL;
 *
 **/

// name=NUMBER_LITERAL
protected class NumberLiteralExpCS_NameAssignment extends AssignmentToken  {
	
	public NumberLiteralExpCS_NameAssignment(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getNumberLiteralExpCSAccess().getNameAssignment();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index, inst);
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getNumberLiteralExpCSRule().getType().getClassifier())
			return null;
		if((value = eObjectConsumer.getConsumable("name",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("name");
		if(valueSerializer.isValid(obj.getEObject(), grammarAccess.getNumberLiteralExpCSAccess().getNameNUMBER_LITERALParserRuleCall_0(), value, null)) {
			type = AssignmentType.DATATYPE_RULE_CALL;
			element = grammarAccess.getNumberLiteralExpCSAccess().getNameNUMBER_LITERALParserRuleCall_0();
			return obj;
		}
		return null;
	}

}

/************ end Rule NumberLiteralExpCS ****************/


/************ begin Rule StringLiteralExpCS ****************
 *
 * StringLiteralExpCS:
 * 	name+=StringLiteral+;
 *
 **/

// name+=StringLiteral+
protected class StringLiteralExpCS_NameAssignment extends AssignmentToken  {
	
	public StringLiteralExpCS_NameAssignment(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getStringLiteralExpCSAccess().getNameAssignment();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new StringLiteralExpCS_NameAssignment(lastRuleCallOrigin, this, 0, inst);
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index - 1, inst);
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("name",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("name");
		if(valueSerializer.isValid(obj.getEObject(), grammarAccess.getStringLiteralExpCSAccess().getNameStringLiteralParserRuleCall_0(), value, null)) {
			type = AssignmentType.DATATYPE_RULE_CALL;
			element = grammarAccess.getStringLiteralExpCSAccess().getNameStringLiteralParserRuleCall_0();
			return obj;
		}
		return null;
	}

}

/************ end Rule StringLiteralExpCS ****************/


/************ begin Rule BooleanLiteralExpCS ****************
 *
 * BooleanLiteralExpCS:
 * 	name="true" | name="false";
 *
 **/

// name="true" | name="false"
protected class BooleanLiteralExpCS_Alternatives extends AlternativesToken {

	public BooleanLiteralExpCS_Alternatives(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Alternatives getGrammarElement() {
		return grammarAccess.getBooleanLiteralExpCSAccess().getAlternatives();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new BooleanLiteralExpCS_NameAssignment_0(lastRuleCallOrigin, this, 0, inst);
			case 1: return new BooleanLiteralExpCS_NameAssignment_1(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getBooleanLiteralExpCSRule().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// name="true"
protected class BooleanLiteralExpCS_NameAssignment_0 extends AssignmentToken  {
	
	public BooleanLiteralExpCS_NameAssignment_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getBooleanLiteralExpCSAccess().getNameAssignment_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index, inst);
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("name",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("name");
		if(keywordSerializer.isValid(obj.getEObject(), grammarAccess.getBooleanLiteralExpCSAccess().getNameTrueKeyword_0_0(), value, null)) {
			type = AssignmentType.KEYWORD;
			element = grammarAccess.getBooleanLiteralExpCSAccess().getNameTrueKeyword_0_0();
			return obj;
		}
		return null;
	}

}

// name="false"
protected class BooleanLiteralExpCS_NameAssignment_1 extends AssignmentToken  {
	
	public BooleanLiteralExpCS_NameAssignment_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getBooleanLiteralExpCSAccess().getNameAssignment_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index, inst);
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("name",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("name");
		if(keywordSerializer.isValid(obj.getEObject(), grammarAccess.getBooleanLiteralExpCSAccess().getNameFalseKeyword_1_0(), value, null)) {
			type = AssignmentType.KEYWORD;
			element = grammarAccess.getBooleanLiteralExpCSAccess().getNameFalseKeyword_1_0();
			return obj;
		}
		return null;
	}

}


/************ end Rule BooleanLiteralExpCS ****************/


/************ begin Rule UnlimitedNaturalLiteralExpCS ****************
 *
 * UnlimitedNaturalLiteralExpCS:
 * 	{UnlimitedNaturalLiteralExpCS} "*";
 *
 **/

// {UnlimitedNaturalLiteralExpCS} "*"
protected class UnlimitedNaturalLiteralExpCS_Group extends GroupToken {
	
	public UnlimitedNaturalLiteralExpCS_Group(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getUnlimitedNaturalLiteralExpCSAccess().getGroup();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new UnlimitedNaturalLiteralExpCS_AsteriskKeyword_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getUnlimitedNaturalLiteralExpCSAccess().getUnlimitedNaturalLiteralExpCSAction_0().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// {UnlimitedNaturalLiteralExpCS}
protected class UnlimitedNaturalLiteralExpCS_UnlimitedNaturalLiteralExpCSAction_0 extends ActionToken  {

	public UnlimitedNaturalLiteralExpCS_UnlimitedNaturalLiteralExpCSAction_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Action getGrammarElement() {
		return grammarAccess.getUnlimitedNaturalLiteralExpCSAccess().getUnlimitedNaturalLiteralExpCSAction_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index, inst);
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(!eObjectConsumer.isConsumed()) return null;
		return eObjectConsumer;
	}
}

// "*"
protected class UnlimitedNaturalLiteralExpCS_AsteriskKeyword_1 extends KeywordToken  {
	
	public UnlimitedNaturalLiteralExpCS_AsteriskKeyword_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getUnlimitedNaturalLiteralExpCSAccess().getAsteriskKeyword_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new UnlimitedNaturalLiteralExpCS_UnlimitedNaturalLiteralExpCSAction_0(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}


/************ end Rule UnlimitedNaturalLiteralExpCS ****************/


/************ begin Rule InvalidLiteralExpCS ****************
 *
 * InvalidLiteralExpCS:
 * 	{InvalidLiteralExpCS} "invalid";
 *
 **/

// {InvalidLiteralExpCS} "invalid"
protected class InvalidLiteralExpCS_Group extends GroupToken {
	
	public InvalidLiteralExpCS_Group(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getInvalidLiteralExpCSAccess().getGroup();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new InvalidLiteralExpCS_InvalidKeyword_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getInvalidLiteralExpCSAccess().getInvalidLiteralExpCSAction_0().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// {InvalidLiteralExpCS}
protected class InvalidLiteralExpCS_InvalidLiteralExpCSAction_0 extends ActionToken  {

	public InvalidLiteralExpCS_InvalidLiteralExpCSAction_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Action getGrammarElement() {
		return grammarAccess.getInvalidLiteralExpCSAccess().getInvalidLiteralExpCSAction_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index, inst);
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(!eObjectConsumer.isConsumed()) return null;
		return eObjectConsumer;
	}
}

// "invalid"
protected class InvalidLiteralExpCS_InvalidKeyword_1 extends KeywordToken  {
	
	public InvalidLiteralExpCS_InvalidKeyword_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getInvalidLiteralExpCSAccess().getInvalidKeyword_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new InvalidLiteralExpCS_InvalidLiteralExpCSAction_0(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}


/************ end Rule InvalidLiteralExpCS ****************/


/************ begin Rule NullLiteralExpCS ****************
 *
 * NullLiteralExpCS:
 * 	{NullLiteralExpCS} "null";
 *
 **/

// {NullLiteralExpCS} "null"
protected class NullLiteralExpCS_Group extends GroupToken {
	
	public NullLiteralExpCS_Group(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getNullLiteralExpCSAccess().getGroup();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new NullLiteralExpCS_NullKeyword_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getNullLiteralExpCSAccess().getNullLiteralExpCSAction_0().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// {NullLiteralExpCS}
protected class NullLiteralExpCS_NullLiteralExpCSAction_0 extends ActionToken  {

	public NullLiteralExpCS_NullLiteralExpCSAction_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Action getGrammarElement() {
		return grammarAccess.getNullLiteralExpCSAccess().getNullLiteralExpCSAction_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index, inst);
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(!eObjectConsumer.isConsumed()) return null;
		return eObjectConsumer;
	}
}

// "null"
protected class NullLiteralExpCS_NullKeyword_1 extends KeywordToken  {
	
	public NullLiteralExpCS_NullKeyword_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getNullLiteralExpCSAccess().getNullKeyword_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new NullLiteralExpCS_NullLiteralExpCSAction_0(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}


/************ end Rule NullLiteralExpCS ****************/


/************ begin Rule TypeLiteralCS ****************
 *
 * TypeLiteralCS returns base::TypedRefCS:
 * 	PrimitiveTypeCS | CollectionTypeCS | TupleTypeCS;
 *
 **/

// PrimitiveTypeCS | CollectionTypeCS | TupleTypeCS
protected class TypeLiteralCS_Alternatives extends AlternativesToken {

	public TypeLiteralCS_Alternatives(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Alternatives getGrammarElement() {
		return grammarAccess.getTypeLiteralCSAccess().getAlternatives();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TypeLiteralCS_PrimitiveTypeCSParserRuleCall_0(lastRuleCallOrigin, this, 0, inst);
			case 1: return new TypeLiteralCS_CollectionTypeCSParserRuleCall_1(lastRuleCallOrigin, this, 1, inst);
			case 2: return new TypeLiteralCS_TupleTypeCSParserRuleCall_2(lastRuleCallOrigin, this, 2, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getCollectionTypeCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getPrimitiveTypeCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getTupleTypeCSRule().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// PrimitiveTypeCS
protected class TypeLiteralCS_PrimitiveTypeCSParserRuleCall_0 extends RuleCallToken {
	
	public TypeLiteralCS_PrimitiveTypeCSParserRuleCall_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public RuleCall getGrammarElement() {
		return grammarAccess.getTypeLiteralCSAccess().getPrimitiveTypeCSParserRuleCall_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PrimitiveTypeCS_NameAssignment(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getPrimitiveTypeCSRule().getType().getClassifier())
			return null;
		if(checkForRecursion(PrimitiveTypeCS_NameAssignment.class, eObjectConsumer)) return null;
		return eObjectConsumer;
	}
	
    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(next, actIndex , index, inst);
		}	
	}	
}

// CollectionTypeCS
protected class TypeLiteralCS_CollectionTypeCSParserRuleCall_1 extends RuleCallToken {
	
	public TypeLiteralCS_CollectionTypeCSParserRuleCall_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public RuleCall getGrammarElement() {
		return grammarAccess.getTypeLiteralCSAccess().getCollectionTypeCSParserRuleCall_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new CollectionTypeCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getCollectionTypeCSRule().getType().getClassifier())
			return null;
		if(checkForRecursion(CollectionTypeCS_Group.class, eObjectConsumer)) return null;
		return eObjectConsumer;
	}
	
    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(next, actIndex , index, inst);
		}	
	}	
}

// TupleTypeCS
protected class TypeLiteralCS_TupleTypeCSParserRuleCall_2 extends RuleCallToken {
	
	public TypeLiteralCS_TupleTypeCSParserRuleCall_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public RuleCall getGrammarElement() {
		return grammarAccess.getTypeLiteralCSAccess().getTupleTypeCSParserRuleCall_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TupleTypeCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getTupleTypeCSRule().getType().getClassifier())
			return null;
		if(checkForRecursion(TupleTypeCS_Group.class, eObjectConsumer)) return null;
		return eObjectConsumer;
	}
	
    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(next, actIndex , index, inst);
		}	
	}	
}


/************ end Rule TypeLiteralCS ****************/


/************ begin Rule TypeLiteralWithMultiplicityCS ****************
 *
 * TypeLiteralWithMultiplicityCS returns base::TypedRefCS:
 * 	TypeLiteralCS multiplicity=MultiplicityCS?;
 *
 **/

// TypeLiteralCS multiplicity=MultiplicityCS?
protected class TypeLiteralWithMultiplicityCS_Group extends GroupToken {
	
	public TypeLiteralWithMultiplicityCS_Group(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getTypeLiteralWithMultiplicityCSAccess().getGroup();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TypeLiteralWithMultiplicityCS_MultiplicityAssignment_1(lastRuleCallOrigin, this, 0, inst);
			case 1: return new TypeLiteralWithMultiplicityCS_TypeLiteralCSParserRuleCall_0(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getCollectionTypeCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getPrimitiveTypeCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getTupleTypeCSRule().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// TypeLiteralCS
protected class TypeLiteralWithMultiplicityCS_TypeLiteralCSParserRuleCall_0 extends RuleCallToken {
	
	public TypeLiteralWithMultiplicityCS_TypeLiteralCSParserRuleCall_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public RuleCall getGrammarElement() {
		return grammarAccess.getTypeLiteralWithMultiplicityCSAccess().getTypeLiteralCSParserRuleCall_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TypeLiteralCS_Alternatives(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(checkForRecursion(TypeLiteralCS_Alternatives.class, eObjectConsumer)) return null;
		return eObjectConsumer;
	}
	
    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(next, actIndex , index, inst);
		}	
	}	
}

// multiplicity=MultiplicityCS?
protected class TypeLiteralWithMultiplicityCS_MultiplicityAssignment_1 extends AssignmentToken  {
	
	public TypeLiteralWithMultiplicityCS_MultiplicityAssignment_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getTypeLiteralWithMultiplicityCSAccess().getMultiplicityAssignment_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new MultiplicityCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("multiplicity",false)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("multiplicity");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getMultiplicityCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getTypeLiteralWithMultiplicityCSAccess().getMultiplicityMultiplicityCSParserRuleCall_1_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new TypeLiteralWithMultiplicityCS_TypeLiteralCSParserRuleCall_0(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}


/************ end Rule TypeLiteralWithMultiplicityCS ****************/


/************ begin Rule TypeLiteralExpCS ****************
 *
 * TypeLiteralExpCS:
 * 	ownedType=TypeLiteralWithMultiplicityCS;
 *
 **/

// ownedType=TypeLiteralWithMultiplicityCS
protected class TypeLiteralExpCS_OwnedTypeAssignment extends AssignmentToken  {
	
	public TypeLiteralExpCS_OwnedTypeAssignment(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getTypeLiteralExpCSAccess().getOwnedTypeAssignment();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TypeLiteralWithMultiplicityCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getTypeLiteralExpCSRule().getType().getClassifier())
			return null;
		if((value = eObjectConsumer.getConsumable("ownedType",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("ownedType");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getTypeLiteralWithMultiplicityCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getTypeLiteralExpCSAccess().getOwnedTypeTypeLiteralWithMultiplicityCSParserRuleCall_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(next, actIndex , index, consumed);
		}	
	}	
}

/************ end Rule TypeLiteralExpCS ****************/


/************ begin Rule TypeNameExpCS ****************
 *
 * TypeNameExpCS:
 * 	pathName=PathNameCS;
 *
 **/

// pathName=PathNameCS
protected class TypeNameExpCS_PathNameAssignment extends AssignmentToken  {
	
	public TypeNameExpCS_PathNameAssignment(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getTypeNameExpCSAccess().getPathNameAssignment();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PathNameCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getTypeNameExpCSRule().getType().getClassifier())
			return null;
		if((value = eObjectConsumer.getConsumable("pathName",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("pathName");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getPathNameCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getTypeNameExpCSAccess().getPathNamePathNameCSParserRuleCall_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(next, actIndex , index, consumed);
		}	
	}	
}

/************ end Rule TypeNameExpCS ****************/


/************ begin Rule TypeExpCS ****************
 *
 * TypeExpCS returns base::TypedRefCS:
 * 	(TypeNameExpCS | TypeLiteralCS) multiplicity=MultiplicityCS?;
 *
 **/

// (TypeNameExpCS | TypeLiteralCS) multiplicity=MultiplicityCS?
protected class TypeExpCS_Group extends GroupToken {
	
	public TypeExpCS_Group(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getTypeExpCSAccess().getGroup();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TypeExpCS_MultiplicityAssignment_1(lastRuleCallOrigin, this, 0, inst);
			case 1: return new TypeExpCS_Alternatives_0(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getCollectionTypeCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getPrimitiveTypeCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getTupleTypeCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getTypeNameExpCSRule().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// TypeNameExpCS | TypeLiteralCS
protected class TypeExpCS_Alternatives_0 extends AlternativesToken {

	public TypeExpCS_Alternatives_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Alternatives getGrammarElement() {
		return grammarAccess.getTypeExpCSAccess().getAlternatives_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TypeExpCS_TypeNameExpCSParserRuleCall_0_0(lastRuleCallOrigin, this, 0, inst);
			case 1: return new TypeExpCS_TypeLiteralCSParserRuleCall_0_1(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}

// TypeNameExpCS
protected class TypeExpCS_TypeNameExpCSParserRuleCall_0_0 extends RuleCallToken {
	
	public TypeExpCS_TypeNameExpCSParserRuleCall_0_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public RuleCall getGrammarElement() {
		return grammarAccess.getTypeExpCSAccess().getTypeNameExpCSParserRuleCall_0_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TypeNameExpCS_PathNameAssignment(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getTypeNameExpCSRule().getType().getClassifier())
			return null;
		if(checkForRecursion(TypeNameExpCS_PathNameAssignment.class, eObjectConsumer)) return null;
		return eObjectConsumer;
	}
	
    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(next, actIndex , index, inst);
		}	
	}	
}

// TypeLiteralCS
protected class TypeExpCS_TypeLiteralCSParserRuleCall_0_1 extends RuleCallToken {
	
	public TypeExpCS_TypeLiteralCSParserRuleCall_0_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public RuleCall getGrammarElement() {
		return grammarAccess.getTypeExpCSAccess().getTypeLiteralCSParserRuleCall_0_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TypeLiteralCS_Alternatives(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getCollectionTypeCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getPrimitiveTypeCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getTupleTypeCSRule().getType().getClassifier())
			return null;
		if(checkForRecursion(TypeLiteralCS_Alternatives.class, eObjectConsumer)) return null;
		return eObjectConsumer;
	}
	
    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(next, actIndex , index, inst);
		}	
	}	
}


// multiplicity=MultiplicityCS?
protected class TypeExpCS_MultiplicityAssignment_1 extends AssignmentToken  {
	
	public TypeExpCS_MultiplicityAssignment_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getTypeExpCSAccess().getMultiplicityAssignment_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new MultiplicityCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("multiplicity",false)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("multiplicity");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getMultiplicityCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getTypeExpCSAccess().getMultiplicityMultiplicityCSParserRuleCall_1_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new TypeExpCS_Alternatives_0(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}


/************ end Rule TypeExpCS ****************/


/************ begin Rule ExpCS ****************
 *
 * //---------------------------------------------------------------------
 * //  Expressions
 * //---------------------------------------------------------------------
 * // An ExpCS permits a LetExpCS only in the final term to ensure
 * //  that let is right associative, whereas infix operators are left associative.
 * //   a = 64 / 16 / let b : Integer in 8 / let c : Integer in 4 
 * // is
 * //   a = (64 / 16) / (let b : Integer in 8 / (let c : Integer in 4 ))
 * ExpCS:
 * 	PrefixedExpCS ({InfixExpCS.ownedExpression+=current} ownedOperator+=BinaryOperatorCS (ownedExpression+=PrefixedExpCS
 * 	(ownedOperator+=BinaryOperatorCS ownedExpression+=PrefixedExpCS)* (ownedOperator+=BinaryOperatorCS
 * 	ownedExpression+=LetExpCS)? | ownedExpression+=LetExpCS))? | {PrefixExpCS} ownedOperator+=UnaryOperatorCS+
 * 	ownedExpression=LetExpCS | LetExpCS;
 *
 **/

// PrefixedExpCS ({InfixExpCS.ownedExpression+=current} ownedOperator+=BinaryOperatorCS (ownedExpression+=PrefixedExpCS
// (ownedOperator+=BinaryOperatorCS ownedExpression+=PrefixedExpCS)* (ownedOperator+=BinaryOperatorCS
// ownedExpression+=LetExpCS)? | ownedExpression+=LetExpCS))? | {PrefixExpCS} ownedOperator+=UnaryOperatorCS+
// ownedExpression=LetExpCS | LetExpCS
protected class ExpCS_Alternatives extends AlternativesToken {

	public ExpCS_Alternatives(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Alternatives getGrammarElement() {
		return grammarAccess.getExpCSAccess().getAlternatives();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ExpCS_Group_0(lastRuleCallOrigin, this, 0, inst);
			case 1: return new ExpCS_Group_1(lastRuleCallOrigin, this, 1, inst);
			case 2: return new ExpCS_LetExpCSParserRuleCall_2(lastRuleCallOrigin, this, 2, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getBooleanLiteralExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getCollectionLiteralExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getPrimaryExpCSAccess().getConstructorExpCSNameExpAction_7_2_1_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getIfExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getPrimaryExpCSAccess().getIndexExpCSNameExpAction_7_2_0_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getExpCSAccess().getInfixExpCSOwnedExpressionAction_0_1_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getInvalidLiteralExpCSAccess().getInvalidLiteralExpCSAction_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getPrimaryExpCSAccess().getInvocationExpCSNameExpAction_7_2_2_1_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getLetExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getPrimaryExpCSAccess().getNameExpCSAction_7_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getNestedExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getNullLiteralExpCSAccess().getNullLiteralExpCSAction_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getNumberLiteralExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getExpCSAccess().getPrefixExpCSAction_1_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getSelfExpCSAccess().getSelfExpCSAction_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getStringLiteralExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getTupleLiteralExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getTypeLiteralExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getUnlimitedNaturalLiteralExpCSAccess().getUnlimitedNaturalLiteralExpCSAction_0().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// PrefixedExpCS ({InfixExpCS.ownedExpression+=current} ownedOperator+=BinaryOperatorCS (ownedExpression+=PrefixedExpCS
// (ownedOperator+=BinaryOperatorCS ownedExpression+=PrefixedExpCS)* (ownedOperator+=BinaryOperatorCS
// ownedExpression+=LetExpCS)? | ownedExpression+=LetExpCS))?
protected class ExpCS_Group_0 extends GroupToken {
	
	public ExpCS_Group_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getExpCSAccess().getGroup_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ExpCS_Group_0_1(lastRuleCallOrigin, this, 0, inst);
			case 1: return new ExpCS_PrefixedExpCSParserRuleCall_0_0(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getBooleanLiteralExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getCollectionLiteralExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getPrimaryExpCSAccess().getConstructorExpCSNameExpAction_7_2_1_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getIfExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getPrimaryExpCSAccess().getIndexExpCSNameExpAction_7_2_0_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getExpCSAccess().getInfixExpCSOwnedExpressionAction_0_1_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getInvalidLiteralExpCSAccess().getInvalidLiteralExpCSAction_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getPrimaryExpCSAccess().getInvocationExpCSNameExpAction_7_2_2_1_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getPrimaryExpCSAccess().getNameExpCSAction_7_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getNestedExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getNullLiteralExpCSAccess().getNullLiteralExpCSAction_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getNumberLiteralExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getPrefixedExpCSAccess().getPrefixExpCSAction_0_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getSelfExpCSAccess().getSelfExpCSAction_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getStringLiteralExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getTupleLiteralExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getTypeLiteralExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getUnlimitedNaturalLiteralExpCSAccess().getUnlimitedNaturalLiteralExpCSAction_0().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// PrefixedExpCS
protected class ExpCS_PrefixedExpCSParserRuleCall_0_0 extends RuleCallToken {
	
	public ExpCS_PrefixedExpCSParserRuleCall_0_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public RuleCall getGrammarElement() {
		return grammarAccess.getExpCSAccess().getPrefixedExpCSParserRuleCall_0_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PrefixedExpCS_Alternatives(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getBooleanLiteralExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getCollectionLiteralExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getPrimaryExpCSAccess().getConstructorExpCSNameExpAction_7_2_1_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getIfExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getPrimaryExpCSAccess().getIndexExpCSNameExpAction_7_2_0_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getInvalidLiteralExpCSAccess().getInvalidLiteralExpCSAction_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getPrimaryExpCSAccess().getInvocationExpCSNameExpAction_7_2_2_1_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getPrimaryExpCSAccess().getNameExpCSAction_7_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getNestedExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getNullLiteralExpCSAccess().getNullLiteralExpCSAction_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getNumberLiteralExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getPrefixedExpCSAccess().getPrefixExpCSAction_0_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getSelfExpCSAccess().getSelfExpCSAction_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getStringLiteralExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getTupleLiteralExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getTypeLiteralExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getUnlimitedNaturalLiteralExpCSAccess().getUnlimitedNaturalLiteralExpCSAction_0().getType().getClassifier())
			return null;
		if(checkForRecursion(PrefixedExpCS_Alternatives.class, eObjectConsumer)) return null;
		return eObjectConsumer;
	}
	
    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(next, actIndex , index, inst);
		}	
	}	
}

// ({InfixExpCS.ownedExpression+=current} ownedOperator+=BinaryOperatorCS (ownedExpression+=PrefixedExpCS
// (ownedOperator+=BinaryOperatorCS ownedExpression+=PrefixedExpCS)* (ownedOperator+=BinaryOperatorCS
// ownedExpression+=LetExpCS)? | ownedExpression+=LetExpCS))?
protected class ExpCS_Group_0_1 extends GroupToken {
	
	public ExpCS_Group_0_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getExpCSAccess().getGroup_0_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ExpCS_Alternatives_0_1_2(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getExpCSAccess().getInfixExpCSOwnedExpressionAction_0_1_0().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// {InfixExpCS.ownedExpression+=current}
protected class ExpCS_InfixExpCSOwnedExpressionAction_0_1_0 extends ActionToken  {

	public ExpCS_InfixExpCSOwnedExpressionAction_0_1_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Action getGrammarElement() {
		return grammarAccess.getExpCSAccess().getInfixExpCSOwnedExpressionAction_0_1_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ExpCS_PrefixedExpCSParserRuleCall_0_0(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		Object val = eObjectConsumer.getConsumable("ownedExpression", false);
		if(val == null) return null;
		if(!eObjectConsumer.isConsumedWithLastConsumtion("ownedExpression")) return null;
		return createEObjectConsumer((EObject) val);
	}
}

// ownedOperator+=BinaryOperatorCS
protected class ExpCS_OwnedOperatorAssignment_0_1_1 extends AssignmentToken  {
	
	public ExpCS_OwnedOperatorAssignment_0_1_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getExpCSAccess().getOwnedOperatorAssignment_0_1_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new BinaryOperatorCS_Alternatives(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("ownedOperator",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("ownedOperator");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getBinaryOperatorCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getExpCSAccess().getOwnedOperatorBinaryOperatorCSParserRuleCall_0_1_1_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new ExpCS_InfixExpCSOwnedExpressionAction_0_1_0(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}

// ownedExpression+=PrefixedExpCS (ownedOperator+=BinaryOperatorCS ownedExpression+=PrefixedExpCS)*
// (ownedOperator+=BinaryOperatorCS ownedExpression+=LetExpCS)? | ownedExpression+=LetExpCS
protected class ExpCS_Alternatives_0_1_2 extends AlternativesToken {

	public ExpCS_Alternatives_0_1_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Alternatives getGrammarElement() {
		return grammarAccess.getExpCSAccess().getAlternatives_0_1_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ExpCS_Group_0_1_2_0(lastRuleCallOrigin, this, 0, inst);
			case 1: return new ExpCS_OwnedExpressionAssignment_0_1_2_1(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}

// ownedExpression+=PrefixedExpCS (ownedOperator+=BinaryOperatorCS ownedExpression+=PrefixedExpCS)*
// (ownedOperator+=BinaryOperatorCS ownedExpression+=LetExpCS)?
protected class ExpCS_Group_0_1_2_0 extends GroupToken {
	
	public ExpCS_Group_0_1_2_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getExpCSAccess().getGroup_0_1_2_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ExpCS_Group_0_1_2_0_2(lastRuleCallOrigin, this, 0, inst);
			case 1: return new ExpCS_Group_0_1_2_0_1(lastRuleCallOrigin, this, 1, inst);
			case 2: return new ExpCS_OwnedExpressionAssignment_0_1_2_0_0(lastRuleCallOrigin, this, 2, inst);
			default: return null;
		}	
	}

}

// ownedExpression+=PrefixedExpCS
protected class ExpCS_OwnedExpressionAssignment_0_1_2_0_0 extends AssignmentToken  {
	
	public ExpCS_OwnedExpressionAssignment_0_1_2_0_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getExpCSAccess().getOwnedExpressionAssignment_0_1_2_0_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PrefixedExpCS_Alternatives(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("ownedExpression",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("ownedExpression");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getPrefixedExpCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getExpCSAccess().getOwnedExpressionPrefixedExpCSParserRuleCall_0_1_2_0_0_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new ExpCS_OwnedOperatorAssignment_0_1_1(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}

// (ownedOperator+=BinaryOperatorCS ownedExpression+=PrefixedExpCS)*
protected class ExpCS_Group_0_1_2_0_1 extends GroupToken {
	
	public ExpCS_Group_0_1_2_0_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getExpCSAccess().getGroup_0_1_2_0_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ExpCS_OwnedExpressionAssignment_0_1_2_0_1_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// ownedOperator+=BinaryOperatorCS
protected class ExpCS_OwnedOperatorAssignment_0_1_2_0_1_0 extends AssignmentToken  {
	
	public ExpCS_OwnedOperatorAssignment_0_1_2_0_1_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getExpCSAccess().getOwnedOperatorAssignment_0_1_2_0_1_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new BinaryOperatorCS_Alternatives(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("ownedOperator",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("ownedOperator");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getBinaryOperatorCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getExpCSAccess().getOwnedOperatorBinaryOperatorCSParserRuleCall_0_1_2_0_1_0_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new ExpCS_Group_0_1_2_0_1(lastRuleCallOrigin, next, actIndex, consumed);
			case 1: return new ExpCS_OwnedExpressionAssignment_0_1_2_0_0(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}

// ownedExpression+=PrefixedExpCS
protected class ExpCS_OwnedExpressionAssignment_0_1_2_0_1_1 extends AssignmentToken  {
	
	public ExpCS_OwnedExpressionAssignment_0_1_2_0_1_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getExpCSAccess().getOwnedExpressionAssignment_0_1_2_0_1_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PrefixedExpCS_Alternatives(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("ownedExpression",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("ownedExpression");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getPrefixedExpCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getExpCSAccess().getOwnedExpressionPrefixedExpCSParserRuleCall_0_1_2_0_1_1_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new ExpCS_OwnedOperatorAssignment_0_1_2_0_1_0(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}


// (ownedOperator+=BinaryOperatorCS ownedExpression+=LetExpCS)?
protected class ExpCS_Group_0_1_2_0_2 extends GroupToken {
	
	public ExpCS_Group_0_1_2_0_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getExpCSAccess().getGroup_0_1_2_0_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ExpCS_OwnedExpressionAssignment_0_1_2_0_2_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// ownedOperator+=BinaryOperatorCS
protected class ExpCS_OwnedOperatorAssignment_0_1_2_0_2_0 extends AssignmentToken  {
	
	public ExpCS_OwnedOperatorAssignment_0_1_2_0_2_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getExpCSAccess().getOwnedOperatorAssignment_0_1_2_0_2_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new BinaryOperatorCS_Alternatives(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("ownedOperator",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("ownedOperator");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getBinaryOperatorCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getExpCSAccess().getOwnedOperatorBinaryOperatorCSParserRuleCall_0_1_2_0_2_0_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new ExpCS_Group_0_1_2_0_1(lastRuleCallOrigin, next, actIndex, consumed);
			case 1: return new ExpCS_OwnedExpressionAssignment_0_1_2_0_0(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}

// ownedExpression+=LetExpCS
protected class ExpCS_OwnedExpressionAssignment_0_1_2_0_2_1 extends AssignmentToken  {
	
	public ExpCS_OwnedExpressionAssignment_0_1_2_0_2_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getExpCSAccess().getOwnedExpressionAssignment_0_1_2_0_2_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new LetExpCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("ownedExpression",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("ownedExpression");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getLetExpCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getExpCSAccess().getOwnedExpressionLetExpCSParserRuleCall_0_1_2_0_2_1_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new ExpCS_OwnedOperatorAssignment_0_1_2_0_2_0(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}



// ownedExpression+=LetExpCS
protected class ExpCS_OwnedExpressionAssignment_0_1_2_1 extends AssignmentToken  {
	
	public ExpCS_OwnedExpressionAssignment_0_1_2_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getExpCSAccess().getOwnedExpressionAssignment_0_1_2_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new LetExpCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("ownedExpression",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("ownedExpression");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getLetExpCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getExpCSAccess().getOwnedExpressionLetExpCSParserRuleCall_0_1_2_1_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new ExpCS_OwnedOperatorAssignment_0_1_1(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}




// {PrefixExpCS} ownedOperator+=UnaryOperatorCS+ ownedExpression=LetExpCS
protected class ExpCS_Group_1 extends GroupToken {
	
	public ExpCS_Group_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getExpCSAccess().getGroup_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ExpCS_OwnedExpressionAssignment_1_2(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getExpCSAccess().getPrefixExpCSAction_1_0().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// {PrefixExpCS}
protected class ExpCS_PrefixExpCSAction_1_0 extends ActionToken  {

	public ExpCS_PrefixExpCSAction_1_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Action getGrammarElement() {
		return grammarAccess.getExpCSAccess().getPrefixExpCSAction_1_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index, inst);
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(!eObjectConsumer.isConsumed()) return null;
		return eObjectConsumer;
	}
}

// ownedOperator+=UnaryOperatorCS+
protected class ExpCS_OwnedOperatorAssignment_1_1 extends AssignmentToken  {
	
	public ExpCS_OwnedOperatorAssignment_1_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getExpCSAccess().getOwnedOperatorAssignment_1_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new UnaryOperatorCS_EssentialOCLUnaryOperatorCSParserRuleCall(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("ownedOperator",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("ownedOperator");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getUnaryOperatorCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getExpCSAccess().getOwnedOperatorUnaryOperatorCSParserRuleCall_1_1_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new ExpCS_OwnedOperatorAssignment_1_1(lastRuleCallOrigin, next, actIndex, consumed);
			case 1: return new ExpCS_PrefixExpCSAction_1_0(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}

// ownedExpression=LetExpCS
protected class ExpCS_OwnedExpressionAssignment_1_2 extends AssignmentToken  {
	
	public ExpCS_OwnedExpressionAssignment_1_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getExpCSAccess().getOwnedExpressionAssignment_1_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new LetExpCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("ownedExpression",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("ownedExpression");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getLetExpCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getExpCSAccess().getOwnedExpressionLetExpCSParserRuleCall_1_2_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new ExpCS_OwnedOperatorAssignment_1_1(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}


// LetExpCS
protected class ExpCS_LetExpCSParserRuleCall_2 extends RuleCallToken {
	
	public ExpCS_LetExpCSParserRuleCall_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public RuleCall getGrammarElement() {
		return grammarAccess.getExpCSAccess().getLetExpCSParserRuleCall_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new LetExpCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getLetExpCSRule().getType().getClassifier())
			return null;
		if(checkForRecursion(LetExpCS_Group.class, eObjectConsumer)) return null;
		return eObjectConsumer;
	}
	
    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(next, actIndex , index, inst);
		}	
	}	
}


/************ end Rule ExpCS ****************/


/************ begin Rule PrefixedExpCS ****************
 *
 * PrefixedExpCS returns ExpCS:
 * 	{PrefixExpCS} ownedOperator+=UnaryOperatorCS+ ownedExpression=PrimaryExpCS | PrimaryExpCS;
 *
 **/

// {PrefixExpCS} ownedOperator+=UnaryOperatorCS+ ownedExpression=PrimaryExpCS | PrimaryExpCS
protected class PrefixedExpCS_Alternatives extends AlternativesToken {

	public PrefixedExpCS_Alternatives(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Alternatives getGrammarElement() {
		return grammarAccess.getPrefixedExpCSAccess().getAlternatives();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PrefixedExpCS_Group_0(lastRuleCallOrigin, this, 0, inst);
			case 1: return new PrefixedExpCS_PrimaryExpCSParserRuleCall_1(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getBooleanLiteralExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getCollectionLiteralExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getPrimaryExpCSAccess().getConstructorExpCSNameExpAction_7_2_1_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getIfExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getPrimaryExpCSAccess().getIndexExpCSNameExpAction_7_2_0_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getInvalidLiteralExpCSAccess().getInvalidLiteralExpCSAction_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getPrimaryExpCSAccess().getInvocationExpCSNameExpAction_7_2_2_1_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getPrimaryExpCSAccess().getNameExpCSAction_7_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getNestedExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getNullLiteralExpCSAccess().getNullLiteralExpCSAction_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getNumberLiteralExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getPrefixedExpCSAccess().getPrefixExpCSAction_0_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getSelfExpCSAccess().getSelfExpCSAction_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getStringLiteralExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getTupleLiteralExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getTypeLiteralExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getUnlimitedNaturalLiteralExpCSAccess().getUnlimitedNaturalLiteralExpCSAction_0().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// {PrefixExpCS} ownedOperator+=UnaryOperatorCS+ ownedExpression=PrimaryExpCS
protected class PrefixedExpCS_Group_0 extends GroupToken {
	
	public PrefixedExpCS_Group_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getPrefixedExpCSAccess().getGroup_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PrefixedExpCS_OwnedExpressionAssignment_0_2(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getPrefixedExpCSAccess().getPrefixExpCSAction_0_0().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// {PrefixExpCS}
protected class PrefixedExpCS_PrefixExpCSAction_0_0 extends ActionToken  {

	public PrefixedExpCS_PrefixExpCSAction_0_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Action getGrammarElement() {
		return grammarAccess.getPrefixedExpCSAccess().getPrefixExpCSAction_0_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index, inst);
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(!eObjectConsumer.isConsumed()) return null;
		return eObjectConsumer;
	}
}

// ownedOperator+=UnaryOperatorCS+
protected class PrefixedExpCS_OwnedOperatorAssignment_0_1 extends AssignmentToken  {
	
	public PrefixedExpCS_OwnedOperatorAssignment_0_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getPrefixedExpCSAccess().getOwnedOperatorAssignment_0_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new UnaryOperatorCS_EssentialOCLUnaryOperatorCSParserRuleCall(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("ownedOperator",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("ownedOperator");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getUnaryOperatorCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getPrefixedExpCSAccess().getOwnedOperatorUnaryOperatorCSParserRuleCall_0_1_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new PrefixedExpCS_OwnedOperatorAssignment_0_1(lastRuleCallOrigin, next, actIndex, consumed);
			case 1: return new PrefixedExpCS_PrefixExpCSAction_0_0(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}

// ownedExpression=PrimaryExpCS
protected class PrefixedExpCS_OwnedExpressionAssignment_0_2 extends AssignmentToken  {
	
	public PrefixedExpCS_OwnedExpressionAssignment_0_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getPrefixedExpCSAccess().getOwnedExpressionAssignment_0_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PrimaryExpCS_Alternatives(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("ownedExpression",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("ownedExpression");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getPrimaryExpCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getPrefixedExpCSAccess().getOwnedExpressionPrimaryExpCSParserRuleCall_0_2_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new PrefixedExpCS_OwnedOperatorAssignment_0_1(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}


// PrimaryExpCS
protected class PrefixedExpCS_PrimaryExpCSParserRuleCall_1 extends RuleCallToken {
	
	public PrefixedExpCS_PrimaryExpCSParserRuleCall_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public RuleCall getGrammarElement() {
		return grammarAccess.getPrefixedExpCSAccess().getPrimaryExpCSParserRuleCall_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PrimaryExpCS_Alternatives(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getBooleanLiteralExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getCollectionLiteralExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getPrimaryExpCSAccess().getConstructorExpCSNameExpAction_7_2_1_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getIfExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getPrimaryExpCSAccess().getIndexExpCSNameExpAction_7_2_0_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getInvalidLiteralExpCSAccess().getInvalidLiteralExpCSAction_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getPrimaryExpCSAccess().getInvocationExpCSNameExpAction_7_2_2_1_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getPrimaryExpCSAccess().getNameExpCSAction_7_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getNestedExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getNullLiteralExpCSAccess().getNullLiteralExpCSAction_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getNumberLiteralExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getSelfExpCSAccess().getSelfExpCSAction_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getStringLiteralExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getTupleLiteralExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getTypeLiteralExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getUnlimitedNaturalLiteralExpCSAccess().getUnlimitedNaturalLiteralExpCSAction_0().getType().getClassifier())
			return null;
		if(checkForRecursion(PrimaryExpCS_Alternatives.class, eObjectConsumer)) return null;
		return eObjectConsumer;
	}
	
    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(next, actIndex , index, inst);
		}	
	}	
}


/************ end Rule PrefixedExpCS ****************/


/************ begin Rule PrimaryExpCS ****************
 *
 * PrimaryExpCS returns ExpCS:
 * 	NestedExpCS | IfExpCS | SelfExpCS | PrimitiveLiteralExpCS | TupleLiteralExpCS | CollectionLiteralExpCS |
 * 	TypeLiteralExpCS | {NameExpCS} pathName=PathNameCS ({IndexExpCS.nameExp=current} "[" firstIndexes+=ExpCS (","
 * 	firstIndexes+=ExpCS)* "]" ("[" secondIndexes+=ExpCS ("," secondIndexes+=ExpCS)* "]")? (atPre?="@" "pre")? |
 * 	{ConstructorExpCS.nameExp=current} "{" ((ownedParts+=ConstructorPartCS ("," ownedParts+=ConstructorPartCS)*)? |
 * 	value=StringLiteral) "}" | (atPre?="@" "pre")? ({InvocationExpCS.nameExp=current} "(" (argument+=NavigatingArgCS
 * 	argument+=NavigatingCommaArgCS* (argument+=NavigatingSemiArgCS argument+=NavigatingCommaArgCS*)?
 * 	(argument+=NavigatingBarArgCS argument+=NavigatingCommaArgCS*)?)? ")")?);
 *
 **/

// NestedExpCS | IfExpCS | SelfExpCS | PrimitiveLiteralExpCS | TupleLiteralExpCS | CollectionLiteralExpCS |
// TypeLiteralExpCS | {NameExpCS} pathName=PathNameCS ({IndexExpCS.nameExp=current} "[" firstIndexes+=ExpCS (","
// firstIndexes+=ExpCS)* "]" ("[" secondIndexes+=ExpCS ("," secondIndexes+=ExpCS)* "]")? (atPre?="@" "pre")? |
// {ConstructorExpCS.nameExp=current} "{" ((ownedParts+=ConstructorPartCS ("," ownedParts+=ConstructorPartCS)*)? |
// value=StringLiteral) "}" | (atPre?="@" "pre")? ({InvocationExpCS.nameExp=current} "(" (argument+=NavigatingArgCS
// argument+=NavigatingCommaArgCS* (argument+=NavigatingSemiArgCS argument+=NavigatingCommaArgCS*)?
// (argument+=NavigatingBarArgCS argument+=NavigatingCommaArgCS*)?)? ")")?)
protected class PrimaryExpCS_Alternatives extends AlternativesToken {

	public PrimaryExpCS_Alternatives(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Alternatives getGrammarElement() {
		return grammarAccess.getPrimaryExpCSAccess().getAlternatives();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PrimaryExpCS_NestedExpCSParserRuleCall_0(lastRuleCallOrigin, this, 0, inst);
			case 1: return new PrimaryExpCS_IfExpCSParserRuleCall_1(lastRuleCallOrigin, this, 1, inst);
			case 2: return new PrimaryExpCS_SelfExpCSParserRuleCall_2(lastRuleCallOrigin, this, 2, inst);
			case 3: return new PrimaryExpCS_PrimitiveLiteralExpCSParserRuleCall_3(lastRuleCallOrigin, this, 3, inst);
			case 4: return new PrimaryExpCS_TupleLiteralExpCSParserRuleCall_4(lastRuleCallOrigin, this, 4, inst);
			case 5: return new PrimaryExpCS_CollectionLiteralExpCSParserRuleCall_5(lastRuleCallOrigin, this, 5, inst);
			case 6: return new PrimaryExpCS_TypeLiteralExpCSParserRuleCall_6(lastRuleCallOrigin, this, 6, inst);
			case 7: return new PrimaryExpCS_Group_7(lastRuleCallOrigin, this, 7, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getBooleanLiteralExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getCollectionLiteralExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getPrimaryExpCSAccess().getConstructorExpCSNameExpAction_7_2_1_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getIfExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getPrimaryExpCSAccess().getIndexExpCSNameExpAction_7_2_0_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getInvalidLiteralExpCSAccess().getInvalidLiteralExpCSAction_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getPrimaryExpCSAccess().getInvocationExpCSNameExpAction_7_2_2_1_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getPrimaryExpCSAccess().getNameExpCSAction_7_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getNestedExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getNullLiteralExpCSAccess().getNullLiteralExpCSAction_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getNumberLiteralExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getSelfExpCSAccess().getSelfExpCSAction_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getStringLiteralExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getTupleLiteralExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getTypeLiteralExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getUnlimitedNaturalLiteralExpCSAccess().getUnlimitedNaturalLiteralExpCSAction_0().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// NestedExpCS
protected class PrimaryExpCS_NestedExpCSParserRuleCall_0 extends RuleCallToken {
	
	public PrimaryExpCS_NestedExpCSParserRuleCall_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public RuleCall getGrammarElement() {
		return grammarAccess.getPrimaryExpCSAccess().getNestedExpCSParserRuleCall_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new NestedExpCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getNestedExpCSRule().getType().getClassifier())
			return null;
		if(checkForRecursion(NestedExpCS_Group.class, eObjectConsumer)) return null;
		return eObjectConsumer;
	}
	
    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(next, actIndex , index, inst);
		}	
	}	
}

// IfExpCS
protected class PrimaryExpCS_IfExpCSParserRuleCall_1 extends RuleCallToken {
	
	public PrimaryExpCS_IfExpCSParserRuleCall_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public RuleCall getGrammarElement() {
		return grammarAccess.getPrimaryExpCSAccess().getIfExpCSParserRuleCall_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new IfExpCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getIfExpCSRule().getType().getClassifier())
			return null;
		if(checkForRecursion(IfExpCS_Group.class, eObjectConsumer)) return null;
		return eObjectConsumer;
	}
	
    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(next, actIndex , index, inst);
		}	
	}	
}

// SelfExpCS
protected class PrimaryExpCS_SelfExpCSParserRuleCall_2 extends RuleCallToken {
	
	public PrimaryExpCS_SelfExpCSParserRuleCall_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public RuleCall getGrammarElement() {
		return grammarAccess.getPrimaryExpCSAccess().getSelfExpCSParserRuleCall_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new SelfExpCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getSelfExpCSAccess().getSelfExpCSAction_0().getType().getClassifier())
			return null;
		if(checkForRecursion(SelfExpCS_Group.class, eObjectConsumer)) return null;
		return eObjectConsumer;
	}
	
    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(next, actIndex , index, inst);
		}	
	}	
}

// PrimitiveLiteralExpCS
protected class PrimaryExpCS_PrimitiveLiteralExpCSParserRuleCall_3 extends RuleCallToken {
	
	public PrimaryExpCS_PrimitiveLiteralExpCSParserRuleCall_3(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public RuleCall getGrammarElement() {
		return grammarAccess.getPrimaryExpCSAccess().getPrimitiveLiteralExpCSParserRuleCall_3();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PrimitiveLiteralExpCS_Alternatives(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getBooleanLiteralExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getInvalidLiteralExpCSAccess().getInvalidLiteralExpCSAction_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getNullLiteralExpCSAccess().getNullLiteralExpCSAction_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getNumberLiteralExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getStringLiteralExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getUnlimitedNaturalLiteralExpCSAccess().getUnlimitedNaturalLiteralExpCSAction_0().getType().getClassifier())
			return null;
		if(checkForRecursion(PrimitiveLiteralExpCS_Alternatives.class, eObjectConsumer)) return null;
		return eObjectConsumer;
	}
	
    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(next, actIndex , index, inst);
		}	
	}	
}

// TupleLiteralExpCS
protected class PrimaryExpCS_TupleLiteralExpCSParserRuleCall_4 extends RuleCallToken {
	
	public PrimaryExpCS_TupleLiteralExpCSParserRuleCall_4(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public RuleCall getGrammarElement() {
		return grammarAccess.getPrimaryExpCSAccess().getTupleLiteralExpCSParserRuleCall_4();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TupleLiteralExpCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getTupleLiteralExpCSRule().getType().getClassifier())
			return null;
		if(checkForRecursion(TupleLiteralExpCS_Group.class, eObjectConsumer)) return null;
		return eObjectConsumer;
	}
	
    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(next, actIndex , index, inst);
		}	
	}	
}

// CollectionLiteralExpCS
protected class PrimaryExpCS_CollectionLiteralExpCSParserRuleCall_5 extends RuleCallToken {
	
	public PrimaryExpCS_CollectionLiteralExpCSParserRuleCall_5(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public RuleCall getGrammarElement() {
		return grammarAccess.getPrimaryExpCSAccess().getCollectionLiteralExpCSParserRuleCall_5();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new CollectionLiteralExpCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getCollectionLiteralExpCSRule().getType().getClassifier())
			return null;
		if(checkForRecursion(CollectionLiteralExpCS_Group.class, eObjectConsumer)) return null;
		return eObjectConsumer;
	}
	
    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(next, actIndex , index, inst);
		}	
	}	
}

// TypeLiteralExpCS
protected class PrimaryExpCS_TypeLiteralExpCSParserRuleCall_6 extends RuleCallToken {
	
	public PrimaryExpCS_TypeLiteralExpCSParserRuleCall_6(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public RuleCall getGrammarElement() {
		return grammarAccess.getPrimaryExpCSAccess().getTypeLiteralExpCSParserRuleCall_6();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TypeLiteralExpCS_OwnedTypeAssignment(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getTypeLiteralExpCSRule().getType().getClassifier())
			return null;
		if(checkForRecursion(TypeLiteralExpCS_OwnedTypeAssignment.class, eObjectConsumer)) return null;
		return eObjectConsumer;
	}
	
    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(next, actIndex , index, inst);
		}	
	}	
}

// {NameExpCS} pathName=PathNameCS ({IndexExpCS.nameExp=current} "[" firstIndexes+=ExpCS ("," firstIndexes+=ExpCS)* "]"
// ("[" secondIndexes+=ExpCS ("," secondIndexes+=ExpCS)* "]")? (atPre?="@" "pre")? | {ConstructorExpCS.nameExp=current}
// "{" ((ownedParts+=ConstructorPartCS ("," ownedParts+=ConstructorPartCS)*)? | value=StringLiteral) "}" | (atPre?="@"
// "pre")? ({InvocationExpCS.nameExp=current} "(" (argument+=NavigatingArgCS argument+=NavigatingCommaArgCS*
// (argument+=NavigatingSemiArgCS argument+=NavigatingCommaArgCS*)? (argument+=NavigatingBarArgCS
// argument+=NavigatingCommaArgCS*)?)? ")")?)
protected class PrimaryExpCS_Group_7 extends GroupToken {
	
	public PrimaryExpCS_Group_7(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getPrimaryExpCSAccess().getGroup_7();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PrimaryExpCS_Alternatives_7_2(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getPrimaryExpCSAccess().getConstructorExpCSNameExpAction_7_2_1_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getPrimaryExpCSAccess().getIndexExpCSNameExpAction_7_2_0_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getPrimaryExpCSAccess().getInvocationExpCSNameExpAction_7_2_2_1_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getPrimaryExpCSAccess().getNameExpCSAction_7_0().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// {NameExpCS}
protected class PrimaryExpCS_NameExpCSAction_7_0 extends ActionToken  {

	public PrimaryExpCS_NameExpCSAction_7_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Action getGrammarElement() {
		return grammarAccess.getPrimaryExpCSAccess().getNameExpCSAction_7_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index, inst);
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(!eObjectConsumer.isConsumed()) return null;
		return eObjectConsumer;
	}
}

// pathName=PathNameCS
protected class PrimaryExpCS_PathNameAssignment_7_1 extends AssignmentToken  {
	
	public PrimaryExpCS_PathNameAssignment_7_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getPrimaryExpCSAccess().getPathNameAssignment_7_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PathNameCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getPrimaryExpCSAccess().getNameExpCSAction_7_0().getType().getClassifier())
			return null;
		if((value = eObjectConsumer.getConsumable("pathName",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("pathName");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getPathNameCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getPrimaryExpCSAccess().getPathNamePathNameCSParserRuleCall_7_1_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new PrimaryExpCS_NameExpCSAction_7_0(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}

// {IndexExpCS.nameExp=current} "[" firstIndexes+=ExpCS ("," firstIndexes+=ExpCS)* "]" ("[" secondIndexes+=ExpCS (","
// secondIndexes+=ExpCS)* "]")? (atPre?="@" "pre")? | {ConstructorExpCS.nameExp=current} "{"
// ((ownedParts+=ConstructorPartCS ("," ownedParts+=ConstructorPartCS)*)? | value=StringLiteral) "}" | (atPre?="@" "pre")?
// ({InvocationExpCS.nameExp=current} "(" (argument+=NavigatingArgCS argument+=NavigatingCommaArgCS*
// (argument+=NavigatingSemiArgCS argument+=NavigatingCommaArgCS*)? (argument+=NavigatingBarArgCS
// argument+=NavigatingCommaArgCS*)?)? ")")?
protected class PrimaryExpCS_Alternatives_7_2 extends AlternativesToken {

	public PrimaryExpCS_Alternatives_7_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Alternatives getGrammarElement() {
		return grammarAccess.getPrimaryExpCSAccess().getAlternatives_7_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PrimaryExpCS_Group_7_2_0(lastRuleCallOrigin, this, 0, inst);
			case 1: return new PrimaryExpCS_Group_7_2_1(lastRuleCallOrigin, this, 1, inst);
			case 2: return new PrimaryExpCS_Group_7_2_2(lastRuleCallOrigin, this, 2, inst);
			default: return null;
		}	
	}

}

// {IndexExpCS.nameExp=current} "[" firstIndexes+=ExpCS ("," firstIndexes+=ExpCS)* "]" ("[" secondIndexes+=ExpCS (","
// secondIndexes+=ExpCS)* "]")? (atPre?="@" "pre")?
protected class PrimaryExpCS_Group_7_2_0 extends GroupToken {
	
	public PrimaryExpCS_Group_7_2_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getPrimaryExpCSAccess().getGroup_7_2_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PrimaryExpCS_Group_7_2_0_6(lastRuleCallOrigin, this, 0, inst);
			case 1: return new PrimaryExpCS_Group_7_2_0_5(lastRuleCallOrigin, this, 1, inst);
			case 2: return new PrimaryExpCS_RightSquareBracketKeyword_7_2_0_4(lastRuleCallOrigin, this, 2, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getPrimaryExpCSAccess().getIndexExpCSNameExpAction_7_2_0_0().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// {IndexExpCS.nameExp=current}
protected class PrimaryExpCS_IndexExpCSNameExpAction_7_2_0_0 extends ActionToken  {

	public PrimaryExpCS_IndexExpCSNameExpAction_7_2_0_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Action getGrammarElement() {
		return grammarAccess.getPrimaryExpCSAccess().getIndexExpCSNameExpAction_7_2_0_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PrimaryExpCS_PathNameAssignment_7_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		Object val = eObjectConsumer.getConsumable("nameExp", false);
		if(val == null) return null;
		if(!eObjectConsumer.isConsumedWithLastConsumtion("nameExp")) return null;
		return createEObjectConsumer((EObject) val);
	}
}

// "["
protected class PrimaryExpCS_LeftSquareBracketKeyword_7_2_0_1 extends KeywordToken  {
	
	public PrimaryExpCS_LeftSquareBracketKeyword_7_2_0_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getPrimaryExpCSAccess().getLeftSquareBracketKeyword_7_2_0_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PrimaryExpCS_IndexExpCSNameExpAction_7_2_0_0(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// firstIndexes+=ExpCS
protected class PrimaryExpCS_FirstIndexesAssignment_7_2_0_2 extends AssignmentToken  {
	
	public PrimaryExpCS_FirstIndexesAssignment_7_2_0_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getPrimaryExpCSAccess().getFirstIndexesAssignment_7_2_0_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ExpCS_Alternatives(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("firstIndexes",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("firstIndexes");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getExpCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getPrimaryExpCSAccess().getFirstIndexesExpCSParserRuleCall_7_2_0_2_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new PrimaryExpCS_LeftSquareBracketKeyword_7_2_0_1(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}

// ("," firstIndexes+=ExpCS)*
protected class PrimaryExpCS_Group_7_2_0_3 extends GroupToken {
	
	public PrimaryExpCS_Group_7_2_0_3(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getPrimaryExpCSAccess().getGroup_7_2_0_3();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PrimaryExpCS_FirstIndexesAssignment_7_2_0_3_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// ","
protected class PrimaryExpCS_CommaKeyword_7_2_0_3_0 extends KeywordToken  {
	
	public PrimaryExpCS_CommaKeyword_7_2_0_3_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getPrimaryExpCSAccess().getCommaKeyword_7_2_0_3_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PrimaryExpCS_Group_7_2_0_3(lastRuleCallOrigin, this, 0, inst);
			case 1: return new PrimaryExpCS_FirstIndexesAssignment_7_2_0_2(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}

// firstIndexes+=ExpCS
protected class PrimaryExpCS_FirstIndexesAssignment_7_2_0_3_1 extends AssignmentToken  {
	
	public PrimaryExpCS_FirstIndexesAssignment_7_2_0_3_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getPrimaryExpCSAccess().getFirstIndexesAssignment_7_2_0_3_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ExpCS_Alternatives(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("firstIndexes",false)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("firstIndexes");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getExpCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getPrimaryExpCSAccess().getFirstIndexesExpCSParserRuleCall_7_2_0_3_1_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new PrimaryExpCS_CommaKeyword_7_2_0_3_0(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}


// "]"
protected class PrimaryExpCS_RightSquareBracketKeyword_7_2_0_4 extends KeywordToken  {
	
	public PrimaryExpCS_RightSquareBracketKeyword_7_2_0_4(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getPrimaryExpCSAccess().getRightSquareBracketKeyword_7_2_0_4();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PrimaryExpCS_Group_7_2_0_3(lastRuleCallOrigin, this, 0, inst);
			case 1: return new PrimaryExpCS_FirstIndexesAssignment_7_2_0_2(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}

// ("[" secondIndexes+=ExpCS ("," secondIndexes+=ExpCS)* "]")?
protected class PrimaryExpCS_Group_7_2_0_5 extends GroupToken {
	
	public PrimaryExpCS_Group_7_2_0_5(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getPrimaryExpCSAccess().getGroup_7_2_0_5();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PrimaryExpCS_RightSquareBracketKeyword_7_2_0_5_3(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// "["
protected class PrimaryExpCS_LeftSquareBracketKeyword_7_2_0_5_0 extends KeywordToken  {
	
	public PrimaryExpCS_LeftSquareBracketKeyword_7_2_0_5_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getPrimaryExpCSAccess().getLeftSquareBracketKeyword_7_2_0_5_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PrimaryExpCS_RightSquareBracketKeyword_7_2_0_4(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// secondIndexes+=ExpCS
protected class PrimaryExpCS_SecondIndexesAssignment_7_2_0_5_1 extends AssignmentToken  {
	
	public PrimaryExpCS_SecondIndexesAssignment_7_2_0_5_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getPrimaryExpCSAccess().getSecondIndexesAssignment_7_2_0_5_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ExpCS_Alternatives(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("secondIndexes",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("secondIndexes");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getExpCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getPrimaryExpCSAccess().getSecondIndexesExpCSParserRuleCall_7_2_0_5_1_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new PrimaryExpCS_LeftSquareBracketKeyword_7_2_0_5_0(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}

// ("," secondIndexes+=ExpCS)*
protected class PrimaryExpCS_Group_7_2_0_5_2 extends GroupToken {
	
	public PrimaryExpCS_Group_7_2_0_5_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getPrimaryExpCSAccess().getGroup_7_2_0_5_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PrimaryExpCS_SecondIndexesAssignment_7_2_0_5_2_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// ","
protected class PrimaryExpCS_CommaKeyword_7_2_0_5_2_0 extends KeywordToken  {
	
	public PrimaryExpCS_CommaKeyword_7_2_0_5_2_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getPrimaryExpCSAccess().getCommaKeyword_7_2_0_5_2_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PrimaryExpCS_Group_7_2_0_5_2(lastRuleCallOrigin, this, 0, inst);
			case 1: return new PrimaryExpCS_SecondIndexesAssignment_7_2_0_5_1(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}

// secondIndexes+=ExpCS
protected class PrimaryExpCS_SecondIndexesAssignment_7_2_0_5_2_1 extends AssignmentToken  {
	
	public PrimaryExpCS_SecondIndexesAssignment_7_2_0_5_2_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getPrimaryExpCSAccess().getSecondIndexesAssignment_7_2_0_5_2_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ExpCS_Alternatives(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("secondIndexes",false)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("secondIndexes");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getExpCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getPrimaryExpCSAccess().getSecondIndexesExpCSParserRuleCall_7_2_0_5_2_1_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new PrimaryExpCS_CommaKeyword_7_2_0_5_2_0(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}


// "]"
protected class PrimaryExpCS_RightSquareBracketKeyword_7_2_0_5_3 extends KeywordToken  {
	
	public PrimaryExpCS_RightSquareBracketKeyword_7_2_0_5_3(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getPrimaryExpCSAccess().getRightSquareBracketKeyword_7_2_0_5_3();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PrimaryExpCS_Group_7_2_0_5_2(lastRuleCallOrigin, this, 0, inst);
			case 1: return new PrimaryExpCS_SecondIndexesAssignment_7_2_0_5_1(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}


// (atPre?="@" "pre")?
protected class PrimaryExpCS_Group_7_2_0_6 extends GroupToken {
	
	public PrimaryExpCS_Group_7_2_0_6(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getPrimaryExpCSAccess().getGroup_7_2_0_6();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PrimaryExpCS_PreKeyword_7_2_0_6_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// atPre?="@"
protected class PrimaryExpCS_AtPreAssignment_7_2_0_6_0 extends AssignmentToken  {
	
	public PrimaryExpCS_AtPreAssignment_7_2_0_6_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getPrimaryExpCSAccess().getAtPreAssignment_7_2_0_6_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PrimaryExpCS_Group_7_2_0_5(lastRuleCallOrigin, this, 0, inst);
			case 1: return new PrimaryExpCS_RightSquareBracketKeyword_7_2_0_4(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("atPre",false)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("atPre");
		if(Boolean.TRUE.equals(value)) { // org::eclipse::xtext::impl::KeywordImpl
			type = AssignmentType.KEYWORD;
			element = grammarAccess.getPrimaryExpCSAccess().getAtPreCommercialAtKeyword_7_2_0_6_0_0();
			return obj;
		}
		return null;
	}

}

// "pre"
protected class PrimaryExpCS_PreKeyword_7_2_0_6_1 extends KeywordToken  {
	
	public PrimaryExpCS_PreKeyword_7_2_0_6_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getPrimaryExpCSAccess().getPreKeyword_7_2_0_6_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PrimaryExpCS_AtPreAssignment_7_2_0_6_0(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}



// {ConstructorExpCS.nameExp=current} "{" ((ownedParts+=ConstructorPartCS ("," ownedParts+=ConstructorPartCS)*)? |
// value=StringLiteral) "}"
protected class PrimaryExpCS_Group_7_2_1 extends GroupToken {
	
	public PrimaryExpCS_Group_7_2_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getPrimaryExpCSAccess().getGroup_7_2_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PrimaryExpCS_RightCurlyBracketKeyword_7_2_1_3(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getPrimaryExpCSAccess().getConstructorExpCSNameExpAction_7_2_1_0().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// {ConstructorExpCS.nameExp=current}
protected class PrimaryExpCS_ConstructorExpCSNameExpAction_7_2_1_0 extends ActionToken  {

	public PrimaryExpCS_ConstructorExpCSNameExpAction_7_2_1_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Action getGrammarElement() {
		return grammarAccess.getPrimaryExpCSAccess().getConstructorExpCSNameExpAction_7_2_1_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PrimaryExpCS_PathNameAssignment_7_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		Object val = eObjectConsumer.getConsumable("nameExp", false);
		if(val == null) return null;
		if(!eObjectConsumer.isConsumedWithLastConsumtion("nameExp")) return null;
		return createEObjectConsumer((EObject) val);
	}
}

// "{"
protected class PrimaryExpCS_LeftCurlyBracketKeyword_7_2_1_1 extends KeywordToken  {
	
	public PrimaryExpCS_LeftCurlyBracketKeyword_7_2_1_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getPrimaryExpCSAccess().getLeftCurlyBracketKeyword_7_2_1_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PrimaryExpCS_ConstructorExpCSNameExpAction_7_2_1_0(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// (ownedParts+=ConstructorPartCS ("," ownedParts+=ConstructorPartCS)*)? | value=StringLiteral
protected class PrimaryExpCS_Alternatives_7_2_1_2 extends AlternativesToken {

	public PrimaryExpCS_Alternatives_7_2_1_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Alternatives getGrammarElement() {
		return grammarAccess.getPrimaryExpCSAccess().getAlternatives_7_2_1_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PrimaryExpCS_Group_7_2_1_2_0(lastRuleCallOrigin, this, 0, inst);
			case 1: return new PrimaryExpCS_ValueAssignment_7_2_1_2_1(lastRuleCallOrigin, this, 1, inst);
			case 2: return new PrimaryExpCS_LeftCurlyBracketKeyword_7_2_1_1(lastRuleCallOrigin, this, 2, inst);
			default: return null;
		}	
	}

}

// (ownedParts+=ConstructorPartCS ("," ownedParts+=ConstructorPartCS)*)?
protected class PrimaryExpCS_Group_7_2_1_2_0 extends GroupToken {
	
	public PrimaryExpCS_Group_7_2_1_2_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getPrimaryExpCSAccess().getGroup_7_2_1_2_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PrimaryExpCS_Group_7_2_1_2_0_1(lastRuleCallOrigin, this, 0, inst);
			case 1: return new PrimaryExpCS_OwnedPartsAssignment_7_2_1_2_0_0(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}

// ownedParts+=ConstructorPartCS
protected class PrimaryExpCS_OwnedPartsAssignment_7_2_1_2_0_0 extends AssignmentToken  {
	
	public PrimaryExpCS_OwnedPartsAssignment_7_2_1_2_0_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getPrimaryExpCSAccess().getOwnedPartsAssignment_7_2_1_2_0_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ConstructorPartCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("ownedParts",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("ownedParts");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getConstructorPartCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getPrimaryExpCSAccess().getOwnedPartsConstructorPartCSParserRuleCall_7_2_1_2_0_0_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new PrimaryExpCS_LeftCurlyBracketKeyword_7_2_1_1(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}

// ("," ownedParts+=ConstructorPartCS)*
protected class PrimaryExpCS_Group_7_2_1_2_0_1 extends GroupToken {
	
	public PrimaryExpCS_Group_7_2_1_2_0_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getPrimaryExpCSAccess().getGroup_7_2_1_2_0_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PrimaryExpCS_OwnedPartsAssignment_7_2_1_2_0_1_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// ","
protected class PrimaryExpCS_CommaKeyword_7_2_1_2_0_1_0 extends KeywordToken  {
	
	public PrimaryExpCS_CommaKeyword_7_2_1_2_0_1_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getPrimaryExpCSAccess().getCommaKeyword_7_2_1_2_0_1_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PrimaryExpCS_Group_7_2_1_2_0_1(lastRuleCallOrigin, this, 0, inst);
			case 1: return new PrimaryExpCS_OwnedPartsAssignment_7_2_1_2_0_0(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}

// ownedParts+=ConstructorPartCS
protected class PrimaryExpCS_OwnedPartsAssignment_7_2_1_2_0_1_1 extends AssignmentToken  {
	
	public PrimaryExpCS_OwnedPartsAssignment_7_2_1_2_0_1_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getPrimaryExpCSAccess().getOwnedPartsAssignment_7_2_1_2_0_1_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ConstructorPartCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("ownedParts",false)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("ownedParts");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getConstructorPartCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getPrimaryExpCSAccess().getOwnedPartsConstructorPartCSParserRuleCall_7_2_1_2_0_1_1_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new PrimaryExpCS_CommaKeyword_7_2_1_2_0_1_0(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}



// value=StringLiteral
protected class PrimaryExpCS_ValueAssignment_7_2_1_2_1 extends AssignmentToken  {
	
	public PrimaryExpCS_ValueAssignment_7_2_1_2_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getPrimaryExpCSAccess().getValueAssignment_7_2_1_2_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PrimaryExpCS_LeftCurlyBracketKeyword_7_2_1_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("value",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("value");
		if(valueSerializer.isValid(obj.getEObject(), grammarAccess.getPrimaryExpCSAccess().getValueStringLiteralParserRuleCall_7_2_1_2_1_0(), value, null)) {
			type = AssignmentType.DATATYPE_RULE_CALL;
			element = grammarAccess.getPrimaryExpCSAccess().getValueStringLiteralParserRuleCall_7_2_1_2_1_0();
			return obj;
		}
		return null;
	}

}


// "}"
protected class PrimaryExpCS_RightCurlyBracketKeyword_7_2_1_3 extends KeywordToken  {
	
	public PrimaryExpCS_RightCurlyBracketKeyword_7_2_1_3(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getPrimaryExpCSAccess().getRightCurlyBracketKeyword_7_2_1_3();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PrimaryExpCS_Alternatives_7_2_1_2(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}


// (atPre?="@" "pre")? ({InvocationExpCS.nameExp=current} "(" (argument+=NavigatingArgCS argument+=NavigatingCommaArgCS*
// (argument+=NavigatingSemiArgCS argument+=NavigatingCommaArgCS*)? (argument+=NavigatingBarArgCS
// argument+=NavigatingCommaArgCS*)?)? ")")?
protected class PrimaryExpCS_Group_7_2_2 extends GroupToken {
	
	public PrimaryExpCS_Group_7_2_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getPrimaryExpCSAccess().getGroup_7_2_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PrimaryExpCS_Group_7_2_2_1(lastRuleCallOrigin, this, 0, inst);
			case 1: return new PrimaryExpCS_Group_7_2_2_0(lastRuleCallOrigin, this, 1, inst);
			case 2: return new PrimaryExpCS_PathNameAssignment_7_1(lastRuleCallOrigin, this, 2, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getPrimaryExpCSAccess().getInvocationExpCSNameExpAction_7_2_2_1_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getPrimaryExpCSAccess().getNameExpCSAction_7_0().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// (atPre?="@" "pre")?
protected class PrimaryExpCS_Group_7_2_2_0 extends GroupToken {
	
	public PrimaryExpCS_Group_7_2_2_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getPrimaryExpCSAccess().getGroup_7_2_2_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PrimaryExpCS_PreKeyword_7_2_2_0_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getPrimaryExpCSAccess().getNameExpCSAction_7_0().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// atPre?="@"
protected class PrimaryExpCS_AtPreAssignment_7_2_2_0_0 extends AssignmentToken  {
	
	public PrimaryExpCS_AtPreAssignment_7_2_2_0_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getPrimaryExpCSAccess().getAtPreAssignment_7_2_2_0_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PrimaryExpCS_PathNameAssignment_7_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("atPre",false)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("atPre");
		if(Boolean.TRUE.equals(value)) { // org::eclipse::xtext::impl::KeywordImpl
			type = AssignmentType.KEYWORD;
			element = grammarAccess.getPrimaryExpCSAccess().getAtPreCommercialAtKeyword_7_2_2_0_0_0();
			return obj;
		}
		return null;
	}

}

// "pre"
protected class PrimaryExpCS_PreKeyword_7_2_2_0_1 extends KeywordToken  {
	
	public PrimaryExpCS_PreKeyword_7_2_2_0_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getPrimaryExpCSAccess().getPreKeyword_7_2_2_0_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PrimaryExpCS_AtPreAssignment_7_2_2_0_0(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}


// ({InvocationExpCS.nameExp=current} "(" (argument+=NavigatingArgCS argument+=NavigatingCommaArgCS*
// (argument+=NavigatingSemiArgCS argument+=NavigatingCommaArgCS*)? (argument+=NavigatingBarArgCS
// argument+=NavigatingCommaArgCS*)?)? ")")?
protected class PrimaryExpCS_Group_7_2_2_1 extends GroupToken {
	
	public PrimaryExpCS_Group_7_2_2_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getPrimaryExpCSAccess().getGroup_7_2_2_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PrimaryExpCS_RightParenthesisKeyword_7_2_2_1_3(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getPrimaryExpCSAccess().getInvocationExpCSNameExpAction_7_2_2_1_0().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// {InvocationExpCS.nameExp=current}
protected class PrimaryExpCS_InvocationExpCSNameExpAction_7_2_2_1_0 extends ActionToken  {

	public PrimaryExpCS_InvocationExpCSNameExpAction_7_2_2_1_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Action getGrammarElement() {
		return grammarAccess.getPrimaryExpCSAccess().getInvocationExpCSNameExpAction_7_2_2_1_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PrimaryExpCS_Group_7_2_2_0(lastRuleCallOrigin, this, 0, inst);
			case 1: return new PrimaryExpCS_PathNameAssignment_7_1(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		Object val = eObjectConsumer.getConsumable("nameExp", false);
		if(val == null) return null;
		if(!eObjectConsumer.isConsumedWithLastConsumtion("nameExp")) return null;
		return createEObjectConsumer((EObject) val);
	}
}

// "("
protected class PrimaryExpCS_LeftParenthesisKeyword_7_2_2_1_1 extends KeywordToken  {
	
	public PrimaryExpCS_LeftParenthesisKeyword_7_2_2_1_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getPrimaryExpCSAccess().getLeftParenthesisKeyword_7_2_2_1_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PrimaryExpCS_InvocationExpCSNameExpAction_7_2_2_1_0(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// (argument+=NavigatingArgCS argument+=NavigatingCommaArgCS* (argument+=NavigatingSemiArgCS
// argument+=NavigatingCommaArgCS*)? (argument+=NavigatingBarArgCS argument+=NavigatingCommaArgCS*)?)?
protected class PrimaryExpCS_Group_7_2_2_1_2 extends GroupToken {
	
	public PrimaryExpCS_Group_7_2_2_1_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getPrimaryExpCSAccess().getGroup_7_2_2_1_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PrimaryExpCS_Group_7_2_2_1_2_3(lastRuleCallOrigin, this, 0, inst);
			case 1: return new PrimaryExpCS_Group_7_2_2_1_2_2(lastRuleCallOrigin, this, 1, inst);
			case 2: return new PrimaryExpCS_ArgumentAssignment_7_2_2_1_2_1(lastRuleCallOrigin, this, 2, inst);
			case 3: return new PrimaryExpCS_ArgumentAssignment_7_2_2_1_2_0(lastRuleCallOrigin, this, 3, inst);
			default: return null;
		}	
	}

}

// argument+=NavigatingArgCS
protected class PrimaryExpCS_ArgumentAssignment_7_2_2_1_2_0 extends AssignmentToken  {
	
	public PrimaryExpCS_ArgumentAssignment_7_2_2_1_2_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getPrimaryExpCSAccess().getArgumentAssignment_7_2_2_1_2_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new NavigatingArgCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("argument",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("argument");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getNavigatingArgCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getPrimaryExpCSAccess().getArgumentNavigatingArgCSParserRuleCall_7_2_2_1_2_0_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new PrimaryExpCS_LeftParenthesisKeyword_7_2_2_1_1(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}

// argument+=NavigatingCommaArgCS*
protected class PrimaryExpCS_ArgumentAssignment_7_2_2_1_2_1 extends AssignmentToken  {
	
	public PrimaryExpCS_ArgumentAssignment_7_2_2_1_2_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getPrimaryExpCSAccess().getArgumentAssignment_7_2_2_1_2_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new NavigatingCommaArgCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("argument",false)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("argument");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getNavigatingCommaArgCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getPrimaryExpCSAccess().getArgumentNavigatingCommaArgCSParserRuleCall_7_2_2_1_2_1_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new PrimaryExpCS_ArgumentAssignment_7_2_2_1_2_1(lastRuleCallOrigin, next, actIndex, consumed);
			case 1: return new PrimaryExpCS_ArgumentAssignment_7_2_2_1_2_0(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}

// (argument+=NavigatingSemiArgCS argument+=NavigatingCommaArgCS*)?
protected class PrimaryExpCS_Group_7_2_2_1_2_2 extends GroupToken {
	
	public PrimaryExpCS_Group_7_2_2_1_2_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getPrimaryExpCSAccess().getGroup_7_2_2_1_2_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PrimaryExpCS_ArgumentAssignment_7_2_2_1_2_2_1(lastRuleCallOrigin, this, 0, inst);
			case 1: return new PrimaryExpCS_ArgumentAssignment_7_2_2_1_2_2_0(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}

// argument+=NavigatingSemiArgCS
protected class PrimaryExpCS_ArgumentAssignment_7_2_2_1_2_2_0 extends AssignmentToken  {
	
	public PrimaryExpCS_ArgumentAssignment_7_2_2_1_2_2_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getPrimaryExpCSAccess().getArgumentAssignment_7_2_2_1_2_2_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new NavigatingSemiArgCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("argument",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("argument");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getNavigatingSemiArgCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getPrimaryExpCSAccess().getArgumentNavigatingSemiArgCSParserRuleCall_7_2_2_1_2_2_0_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new PrimaryExpCS_ArgumentAssignment_7_2_2_1_2_1(lastRuleCallOrigin, next, actIndex, consumed);
			case 1: return new PrimaryExpCS_ArgumentAssignment_7_2_2_1_2_0(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}

// argument+=NavigatingCommaArgCS*
protected class PrimaryExpCS_ArgumentAssignment_7_2_2_1_2_2_1 extends AssignmentToken  {
	
	public PrimaryExpCS_ArgumentAssignment_7_2_2_1_2_2_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getPrimaryExpCSAccess().getArgumentAssignment_7_2_2_1_2_2_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new NavigatingCommaArgCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("argument",false)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("argument");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getNavigatingCommaArgCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getPrimaryExpCSAccess().getArgumentNavigatingCommaArgCSParserRuleCall_7_2_2_1_2_2_1_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new PrimaryExpCS_ArgumentAssignment_7_2_2_1_2_2_1(lastRuleCallOrigin, next, actIndex, consumed);
			case 1: return new PrimaryExpCS_ArgumentAssignment_7_2_2_1_2_2_0(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}


// (argument+=NavigatingBarArgCS argument+=NavigatingCommaArgCS*)?
protected class PrimaryExpCS_Group_7_2_2_1_2_3 extends GroupToken {
	
	public PrimaryExpCS_Group_7_2_2_1_2_3(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getPrimaryExpCSAccess().getGroup_7_2_2_1_2_3();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PrimaryExpCS_ArgumentAssignment_7_2_2_1_2_3_1(lastRuleCallOrigin, this, 0, inst);
			case 1: return new PrimaryExpCS_ArgumentAssignment_7_2_2_1_2_3_0(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}

// argument+=NavigatingBarArgCS
protected class PrimaryExpCS_ArgumentAssignment_7_2_2_1_2_3_0 extends AssignmentToken  {
	
	public PrimaryExpCS_ArgumentAssignment_7_2_2_1_2_3_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getPrimaryExpCSAccess().getArgumentAssignment_7_2_2_1_2_3_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new NavigatingBarArgCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("argument",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("argument");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getNavigatingBarArgCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getPrimaryExpCSAccess().getArgumentNavigatingBarArgCSParserRuleCall_7_2_2_1_2_3_0_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new PrimaryExpCS_Group_7_2_2_1_2_2(lastRuleCallOrigin, next, actIndex, consumed);
			case 1: return new PrimaryExpCS_ArgumentAssignment_7_2_2_1_2_1(lastRuleCallOrigin, next, actIndex, consumed);
			case 2: return new PrimaryExpCS_ArgumentAssignment_7_2_2_1_2_0(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}

// argument+=NavigatingCommaArgCS*
protected class PrimaryExpCS_ArgumentAssignment_7_2_2_1_2_3_1 extends AssignmentToken  {
	
	public PrimaryExpCS_ArgumentAssignment_7_2_2_1_2_3_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getPrimaryExpCSAccess().getArgumentAssignment_7_2_2_1_2_3_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new NavigatingCommaArgCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("argument",false)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("argument");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getNavigatingCommaArgCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getPrimaryExpCSAccess().getArgumentNavigatingCommaArgCSParserRuleCall_7_2_2_1_2_3_1_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new PrimaryExpCS_ArgumentAssignment_7_2_2_1_2_3_1(lastRuleCallOrigin, next, actIndex, consumed);
			case 1: return new PrimaryExpCS_ArgumentAssignment_7_2_2_1_2_3_0(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}



// ")"
protected class PrimaryExpCS_RightParenthesisKeyword_7_2_2_1_3 extends KeywordToken  {
	
	public PrimaryExpCS_RightParenthesisKeyword_7_2_2_1_3(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getPrimaryExpCSAccess().getRightParenthesisKeyword_7_2_2_1_3();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new PrimaryExpCS_Group_7_2_2_1_2(lastRuleCallOrigin, this, 0, inst);
			case 1: return new PrimaryExpCS_LeftParenthesisKeyword_7_2_2_1_1(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}






/************ end Rule PrimaryExpCS ****************/


/************ begin Rule NavigatingArgCS ****************
 *
 * // Type-less init is an illegal infix expression
 * NavigatingArgCS:
 * 	name=NavigatingArgExpCS (":" ownedType=TypeExpCS ("=" init=ExpCS)?)?;
 *
 **/

// name=NavigatingArgExpCS (":" ownedType=TypeExpCS ("=" init=ExpCS)?)?
protected class NavigatingArgCS_Group extends GroupToken {
	
	public NavigatingArgCS_Group(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getNavigatingArgCSAccess().getGroup();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new NavigatingArgCS_Group_1(lastRuleCallOrigin, this, 0, inst);
			case 1: return new NavigatingArgCS_NameAssignment_0(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getNavigatingArgCSRule().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// name=NavigatingArgExpCS
protected class NavigatingArgCS_NameAssignment_0 extends AssignmentToken  {
	
	public NavigatingArgCS_NameAssignment_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getNavigatingArgCSAccess().getNameAssignment_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new NavigatingArgExpCS_ExpCSParserRuleCall(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("name",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("name");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getNavigatingArgExpCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getNavigatingArgCSAccess().getNameNavigatingArgExpCSParserRuleCall_0_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(next, actIndex , index, consumed);
		}	
	}	
}

// (":" ownedType=TypeExpCS ("=" init=ExpCS)?)?
protected class NavigatingArgCS_Group_1 extends GroupToken {
	
	public NavigatingArgCS_Group_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getNavigatingArgCSAccess().getGroup_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new NavigatingArgCS_Group_1_2(lastRuleCallOrigin, this, 0, inst);
			case 1: return new NavigatingArgCS_OwnedTypeAssignment_1_1(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}

// ":"
protected class NavigatingArgCS_ColonKeyword_1_0 extends KeywordToken  {
	
	public NavigatingArgCS_ColonKeyword_1_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getNavigatingArgCSAccess().getColonKeyword_1_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new NavigatingArgCS_NameAssignment_0(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// ownedType=TypeExpCS
protected class NavigatingArgCS_OwnedTypeAssignment_1_1 extends AssignmentToken  {
	
	public NavigatingArgCS_OwnedTypeAssignment_1_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getNavigatingArgCSAccess().getOwnedTypeAssignment_1_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TypeExpCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("ownedType",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("ownedType");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getTypeExpCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getNavigatingArgCSAccess().getOwnedTypeTypeExpCSParserRuleCall_1_1_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new NavigatingArgCS_ColonKeyword_1_0(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}

// ("=" init=ExpCS)?
protected class NavigatingArgCS_Group_1_2 extends GroupToken {
	
	public NavigatingArgCS_Group_1_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getNavigatingArgCSAccess().getGroup_1_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new NavigatingArgCS_InitAssignment_1_2_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// "="
protected class NavigatingArgCS_EqualsSignKeyword_1_2_0 extends KeywordToken  {
	
	public NavigatingArgCS_EqualsSignKeyword_1_2_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getNavigatingArgCSAccess().getEqualsSignKeyword_1_2_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new NavigatingArgCS_OwnedTypeAssignment_1_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// init=ExpCS
protected class NavigatingArgCS_InitAssignment_1_2_1 extends AssignmentToken  {
	
	public NavigatingArgCS_InitAssignment_1_2_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getNavigatingArgCSAccess().getInitAssignment_1_2_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ExpCS_Alternatives(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("init",false)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("init");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getExpCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getNavigatingArgCSAccess().getInitExpCSParserRuleCall_1_2_1_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new NavigatingArgCS_EqualsSignKeyword_1_2_0(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}




/************ end Rule NavigatingArgCS ****************/


/************ begin Rule NavigatingBarArgCS ****************
 *
 * // Type-less init is an illegal infix expression
 * NavigatingBarArgCS returns NavigatingArgCS:
 * 	prefix="|" name=NavigatingArgExpCS (":" ownedType=TypeExpCS ("=" init=ExpCS)?)?;
 *
 **/

// prefix="|" name=NavigatingArgExpCS (":" ownedType=TypeExpCS ("=" init=ExpCS)?)?
protected class NavigatingBarArgCS_Group extends GroupToken {
	
	public NavigatingBarArgCS_Group(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getNavigatingBarArgCSAccess().getGroup();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new NavigatingBarArgCS_Group_2(lastRuleCallOrigin, this, 0, inst);
			case 1: return new NavigatingBarArgCS_NameAssignment_1(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getNavigatingBarArgCSRule().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// prefix="|"
protected class NavigatingBarArgCS_PrefixAssignment_0 extends AssignmentToken  {
	
	public NavigatingBarArgCS_PrefixAssignment_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getNavigatingBarArgCSAccess().getPrefixAssignment_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index, inst);
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("prefix",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("prefix");
		if(keywordSerializer.isValid(obj.getEObject(), grammarAccess.getNavigatingBarArgCSAccess().getPrefixVerticalLineKeyword_0_0(), value, null)) {
			type = AssignmentType.KEYWORD;
			element = grammarAccess.getNavigatingBarArgCSAccess().getPrefixVerticalLineKeyword_0_0();
			return obj;
		}
		return null;
	}

}

// name=NavigatingArgExpCS
protected class NavigatingBarArgCS_NameAssignment_1 extends AssignmentToken  {
	
	public NavigatingBarArgCS_NameAssignment_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getNavigatingBarArgCSAccess().getNameAssignment_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new NavigatingArgExpCS_ExpCSParserRuleCall(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("name",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("name");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getNavigatingArgExpCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getNavigatingBarArgCSAccess().getNameNavigatingArgExpCSParserRuleCall_1_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new NavigatingBarArgCS_PrefixAssignment_0(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}

// (":" ownedType=TypeExpCS ("=" init=ExpCS)?)?
protected class NavigatingBarArgCS_Group_2 extends GroupToken {
	
	public NavigatingBarArgCS_Group_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getNavigatingBarArgCSAccess().getGroup_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new NavigatingBarArgCS_Group_2_2(lastRuleCallOrigin, this, 0, inst);
			case 1: return new NavigatingBarArgCS_OwnedTypeAssignment_2_1(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}

// ":"
protected class NavigatingBarArgCS_ColonKeyword_2_0 extends KeywordToken  {
	
	public NavigatingBarArgCS_ColonKeyword_2_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getNavigatingBarArgCSAccess().getColonKeyword_2_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new NavigatingBarArgCS_NameAssignment_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// ownedType=TypeExpCS
protected class NavigatingBarArgCS_OwnedTypeAssignment_2_1 extends AssignmentToken  {
	
	public NavigatingBarArgCS_OwnedTypeAssignment_2_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getNavigatingBarArgCSAccess().getOwnedTypeAssignment_2_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TypeExpCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("ownedType",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("ownedType");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getTypeExpCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getNavigatingBarArgCSAccess().getOwnedTypeTypeExpCSParserRuleCall_2_1_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new NavigatingBarArgCS_ColonKeyword_2_0(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}

// ("=" init=ExpCS)?
protected class NavigatingBarArgCS_Group_2_2 extends GroupToken {
	
	public NavigatingBarArgCS_Group_2_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getNavigatingBarArgCSAccess().getGroup_2_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new NavigatingBarArgCS_InitAssignment_2_2_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// "="
protected class NavigatingBarArgCS_EqualsSignKeyword_2_2_0 extends KeywordToken  {
	
	public NavigatingBarArgCS_EqualsSignKeyword_2_2_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getNavigatingBarArgCSAccess().getEqualsSignKeyword_2_2_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new NavigatingBarArgCS_OwnedTypeAssignment_2_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// init=ExpCS
protected class NavigatingBarArgCS_InitAssignment_2_2_1 extends AssignmentToken  {
	
	public NavigatingBarArgCS_InitAssignment_2_2_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getNavigatingBarArgCSAccess().getInitAssignment_2_2_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ExpCS_Alternatives(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("init",false)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("init");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getExpCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getNavigatingBarArgCSAccess().getInitExpCSParserRuleCall_2_2_1_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new NavigatingBarArgCS_EqualsSignKeyword_2_2_0(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}




/************ end Rule NavigatingBarArgCS ****************/


/************ begin Rule NavigatingCommaArgCS ****************
 *
 * // Type-less init is an illegal infix expression
 * NavigatingCommaArgCS returns NavigatingArgCS:
 * 	prefix="," name=NavigatingArgExpCS (":" ownedType=TypeExpCS ("=" init=ExpCS)?)?;
 *
 **/

// prefix="," name=NavigatingArgExpCS (":" ownedType=TypeExpCS ("=" init=ExpCS)?)?
protected class NavigatingCommaArgCS_Group extends GroupToken {
	
	public NavigatingCommaArgCS_Group(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getNavigatingCommaArgCSAccess().getGroup();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new NavigatingCommaArgCS_Group_2(lastRuleCallOrigin, this, 0, inst);
			case 1: return new NavigatingCommaArgCS_NameAssignment_1(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getNavigatingCommaArgCSRule().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// prefix=","
protected class NavigatingCommaArgCS_PrefixAssignment_0 extends AssignmentToken  {
	
	public NavigatingCommaArgCS_PrefixAssignment_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getNavigatingCommaArgCSAccess().getPrefixAssignment_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index, inst);
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("prefix",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("prefix");
		if(keywordSerializer.isValid(obj.getEObject(), grammarAccess.getNavigatingCommaArgCSAccess().getPrefixCommaKeyword_0_0(), value, null)) {
			type = AssignmentType.KEYWORD;
			element = grammarAccess.getNavigatingCommaArgCSAccess().getPrefixCommaKeyword_0_0();
			return obj;
		}
		return null;
	}

}

// name=NavigatingArgExpCS
protected class NavigatingCommaArgCS_NameAssignment_1 extends AssignmentToken  {
	
	public NavigatingCommaArgCS_NameAssignment_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getNavigatingCommaArgCSAccess().getNameAssignment_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new NavigatingArgExpCS_ExpCSParserRuleCall(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("name",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("name");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getNavigatingArgExpCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getNavigatingCommaArgCSAccess().getNameNavigatingArgExpCSParserRuleCall_1_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new NavigatingCommaArgCS_PrefixAssignment_0(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}

// (":" ownedType=TypeExpCS ("=" init=ExpCS)?)?
protected class NavigatingCommaArgCS_Group_2 extends GroupToken {
	
	public NavigatingCommaArgCS_Group_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getNavigatingCommaArgCSAccess().getGroup_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new NavigatingCommaArgCS_Group_2_2(lastRuleCallOrigin, this, 0, inst);
			case 1: return new NavigatingCommaArgCS_OwnedTypeAssignment_2_1(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}

// ":"
protected class NavigatingCommaArgCS_ColonKeyword_2_0 extends KeywordToken  {
	
	public NavigatingCommaArgCS_ColonKeyword_2_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getNavigatingCommaArgCSAccess().getColonKeyword_2_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new NavigatingCommaArgCS_NameAssignment_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// ownedType=TypeExpCS
protected class NavigatingCommaArgCS_OwnedTypeAssignment_2_1 extends AssignmentToken  {
	
	public NavigatingCommaArgCS_OwnedTypeAssignment_2_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getNavigatingCommaArgCSAccess().getOwnedTypeAssignment_2_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TypeExpCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("ownedType",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("ownedType");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getTypeExpCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getNavigatingCommaArgCSAccess().getOwnedTypeTypeExpCSParserRuleCall_2_1_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new NavigatingCommaArgCS_ColonKeyword_2_0(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}

// ("=" init=ExpCS)?
protected class NavigatingCommaArgCS_Group_2_2 extends GroupToken {
	
	public NavigatingCommaArgCS_Group_2_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getNavigatingCommaArgCSAccess().getGroup_2_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new NavigatingCommaArgCS_InitAssignment_2_2_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// "="
protected class NavigatingCommaArgCS_EqualsSignKeyword_2_2_0 extends KeywordToken  {
	
	public NavigatingCommaArgCS_EqualsSignKeyword_2_2_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getNavigatingCommaArgCSAccess().getEqualsSignKeyword_2_2_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new NavigatingCommaArgCS_OwnedTypeAssignment_2_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// init=ExpCS
protected class NavigatingCommaArgCS_InitAssignment_2_2_1 extends AssignmentToken  {
	
	public NavigatingCommaArgCS_InitAssignment_2_2_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getNavigatingCommaArgCSAccess().getInitAssignment_2_2_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ExpCS_Alternatives(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("init",false)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("init");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getExpCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getNavigatingCommaArgCSAccess().getInitExpCSParserRuleCall_2_2_1_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new NavigatingCommaArgCS_EqualsSignKeyword_2_2_0(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}




/************ end Rule NavigatingCommaArgCS ****************/


/************ begin Rule NavigatingSemiArgCS ****************
 *
 * // Type-less init is an illegal infix expression
 * NavigatingSemiArgCS returns NavigatingArgCS:
 * 	prefix=";" name=NavigatingArgExpCS (":" ownedType=TypeExpCS ("=" init=ExpCS)?)?;
 *
 **/

// prefix=";" name=NavigatingArgExpCS (":" ownedType=TypeExpCS ("=" init=ExpCS)?)?
protected class NavigatingSemiArgCS_Group extends GroupToken {
	
	public NavigatingSemiArgCS_Group(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getNavigatingSemiArgCSAccess().getGroup();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new NavigatingSemiArgCS_Group_2(lastRuleCallOrigin, this, 0, inst);
			case 1: return new NavigatingSemiArgCS_NameAssignment_1(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getNavigatingSemiArgCSRule().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// prefix=";"
protected class NavigatingSemiArgCS_PrefixAssignment_0 extends AssignmentToken  {
	
	public NavigatingSemiArgCS_PrefixAssignment_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getNavigatingSemiArgCSAccess().getPrefixAssignment_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index, inst);
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("prefix",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("prefix");
		if(keywordSerializer.isValid(obj.getEObject(), grammarAccess.getNavigatingSemiArgCSAccess().getPrefixSemicolonKeyword_0_0(), value, null)) {
			type = AssignmentType.KEYWORD;
			element = grammarAccess.getNavigatingSemiArgCSAccess().getPrefixSemicolonKeyword_0_0();
			return obj;
		}
		return null;
	}

}

// name=NavigatingArgExpCS
protected class NavigatingSemiArgCS_NameAssignment_1 extends AssignmentToken  {
	
	public NavigatingSemiArgCS_NameAssignment_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getNavigatingSemiArgCSAccess().getNameAssignment_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new NavigatingArgExpCS_ExpCSParserRuleCall(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("name",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("name");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getNavigatingArgExpCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getNavigatingSemiArgCSAccess().getNameNavigatingArgExpCSParserRuleCall_1_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new NavigatingSemiArgCS_PrefixAssignment_0(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}

// (":" ownedType=TypeExpCS ("=" init=ExpCS)?)?
protected class NavigatingSemiArgCS_Group_2 extends GroupToken {
	
	public NavigatingSemiArgCS_Group_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getNavigatingSemiArgCSAccess().getGroup_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new NavigatingSemiArgCS_Group_2_2(lastRuleCallOrigin, this, 0, inst);
			case 1: return new NavigatingSemiArgCS_OwnedTypeAssignment_2_1(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}

// ":"
protected class NavigatingSemiArgCS_ColonKeyword_2_0 extends KeywordToken  {
	
	public NavigatingSemiArgCS_ColonKeyword_2_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getNavigatingSemiArgCSAccess().getColonKeyword_2_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new NavigatingSemiArgCS_NameAssignment_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// ownedType=TypeExpCS
protected class NavigatingSemiArgCS_OwnedTypeAssignment_2_1 extends AssignmentToken  {
	
	public NavigatingSemiArgCS_OwnedTypeAssignment_2_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getNavigatingSemiArgCSAccess().getOwnedTypeAssignment_2_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TypeExpCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("ownedType",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("ownedType");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getTypeExpCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getNavigatingSemiArgCSAccess().getOwnedTypeTypeExpCSParserRuleCall_2_1_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new NavigatingSemiArgCS_ColonKeyword_2_0(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}

// ("=" init=ExpCS)?
protected class NavigatingSemiArgCS_Group_2_2 extends GroupToken {
	
	public NavigatingSemiArgCS_Group_2_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getNavigatingSemiArgCSAccess().getGroup_2_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new NavigatingSemiArgCS_InitAssignment_2_2_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// "="
protected class NavigatingSemiArgCS_EqualsSignKeyword_2_2_0 extends KeywordToken  {
	
	public NavigatingSemiArgCS_EqualsSignKeyword_2_2_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getNavigatingSemiArgCSAccess().getEqualsSignKeyword_2_2_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new NavigatingSemiArgCS_OwnedTypeAssignment_2_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// init=ExpCS
protected class NavigatingSemiArgCS_InitAssignment_2_2_1 extends AssignmentToken  {
	
	public NavigatingSemiArgCS_InitAssignment_2_2_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getNavigatingSemiArgCSAccess().getInitAssignment_2_2_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ExpCS_Alternatives(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("init",false)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("init");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getExpCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getNavigatingSemiArgCSAccess().getInitExpCSParserRuleCall_2_2_1_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new NavigatingSemiArgCS_EqualsSignKeyword_2_2_0(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}




/************ end Rule NavigatingSemiArgCS ****************/


/************ begin Rule NavigatingArgExpCS ****************
 *
 * // Intended to be overridden
 * //	'?'	-- defined by Complete OCL
 * NavigatingArgExpCS returns ExpCS:
 * 	ExpCS;
 *
 **/

// ExpCS
protected class NavigatingArgExpCS_ExpCSParserRuleCall extends RuleCallToken {
	
	public NavigatingArgExpCS_ExpCSParserRuleCall(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public RuleCall getGrammarElement() {
		return grammarAccess.getNavigatingArgExpCSAccess().getExpCSParserRuleCall();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ExpCS_Alternatives(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getBooleanLiteralExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getCollectionLiteralExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getPrimaryExpCSAccess().getConstructorExpCSNameExpAction_7_2_1_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getIfExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getPrimaryExpCSAccess().getIndexExpCSNameExpAction_7_2_0_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getExpCSAccess().getInfixExpCSOwnedExpressionAction_0_1_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getInvalidLiteralExpCSAccess().getInvalidLiteralExpCSAction_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getPrimaryExpCSAccess().getInvocationExpCSNameExpAction_7_2_2_1_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getLetExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getPrimaryExpCSAccess().getNameExpCSAction_7_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getNestedExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getNullLiteralExpCSAccess().getNullLiteralExpCSAction_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getNumberLiteralExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getExpCSAccess().getPrefixExpCSAction_1_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getSelfExpCSAccess().getSelfExpCSAction_0().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getStringLiteralExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getTupleLiteralExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getTypeLiteralExpCSRule().getType().getClassifier() && 
		   getEObject().eClass() != grammarAccess.getUnlimitedNaturalLiteralExpCSAccess().getUnlimitedNaturalLiteralExpCSAction_0().getType().getClassifier())
			return null;
		if(checkForRecursion(ExpCS_Alternatives.class, eObjectConsumer)) return null;
		return eObjectConsumer;
	}
	
    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(next, actIndex , index, inst);
		}	
	}	
}

/************ end Rule NavigatingArgExpCS ****************/


/************ begin Rule IfExpCS ****************
 *
 * IfExpCS:
 * 	"if" condition=ExpCS "then" thenExpression=ExpCS "else" elseExpression=ExpCS "endif";
 *
 **/

// "if" condition=ExpCS "then" thenExpression=ExpCS "else" elseExpression=ExpCS "endif"
protected class IfExpCS_Group extends GroupToken {
	
	public IfExpCS_Group(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getIfExpCSAccess().getGroup();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new IfExpCS_EndifKeyword_6(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getIfExpCSRule().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// "if"
protected class IfExpCS_IfKeyword_0 extends KeywordToken  {
	
	public IfExpCS_IfKeyword_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getIfExpCSAccess().getIfKeyword_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index, inst);
		}	
	}

}

// condition=ExpCS
protected class IfExpCS_ConditionAssignment_1 extends AssignmentToken  {
	
	public IfExpCS_ConditionAssignment_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getIfExpCSAccess().getConditionAssignment_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ExpCS_Alternatives(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("condition",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("condition");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getExpCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getIfExpCSAccess().getConditionExpCSParserRuleCall_1_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new IfExpCS_IfKeyword_0(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}

// "then"
protected class IfExpCS_ThenKeyword_2 extends KeywordToken  {
	
	public IfExpCS_ThenKeyword_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getIfExpCSAccess().getThenKeyword_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new IfExpCS_ConditionAssignment_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// thenExpression=ExpCS
protected class IfExpCS_ThenExpressionAssignment_3 extends AssignmentToken  {
	
	public IfExpCS_ThenExpressionAssignment_3(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getIfExpCSAccess().getThenExpressionAssignment_3();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ExpCS_Alternatives(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("thenExpression",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("thenExpression");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getExpCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getIfExpCSAccess().getThenExpressionExpCSParserRuleCall_3_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new IfExpCS_ThenKeyword_2(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}

// "else"
protected class IfExpCS_ElseKeyword_4 extends KeywordToken  {
	
	public IfExpCS_ElseKeyword_4(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getIfExpCSAccess().getElseKeyword_4();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new IfExpCS_ThenExpressionAssignment_3(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// elseExpression=ExpCS
protected class IfExpCS_ElseExpressionAssignment_5 extends AssignmentToken  {
	
	public IfExpCS_ElseExpressionAssignment_5(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getIfExpCSAccess().getElseExpressionAssignment_5();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ExpCS_Alternatives(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("elseExpression",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("elseExpression");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getExpCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getIfExpCSAccess().getElseExpressionExpCSParserRuleCall_5_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new IfExpCS_ElseKeyword_4(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}

// "endif"
protected class IfExpCS_EndifKeyword_6 extends KeywordToken  {
	
	public IfExpCS_EndifKeyword_6(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getIfExpCSAccess().getEndifKeyword_6();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new IfExpCS_ElseExpressionAssignment_5(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}


/************ end Rule IfExpCS ****************/


/************ begin Rule LetExpCS ****************
 *
 * LetExpCS:
 * 	"let" variable+=LetVariableCS ("," variable+=LetVariableCS)* "in" in=ExpCS;
 *
 **/

// "let" variable+=LetVariableCS ("," variable+=LetVariableCS)* "in" in=ExpCS
protected class LetExpCS_Group extends GroupToken {
	
	public LetExpCS_Group(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getLetExpCSAccess().getGroup();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new LetExpCS_InAssignment_4(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getLetExpCSRule().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// "let"
protected class LetExpCS_LetKeyword_0 extends KeywordToken  {
	
	public LetExpCS_LetKeyword_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getLetExpCSAccess().getLetKeyword_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index, inst);
		}	
	}

}

// variable+=LetVariableCS
protected class LetExpCS_VariableAssignment_1 extends AssignmentToken  {
	
	public LetExpCS_VariableAssignment_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getLetExpCSAccess().getVariableAssignment_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new LetVariableCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("variable",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("variable");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getLetVariableCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getLetExpCSAccess().getVariableLetVariableCSParserRuleCall_1_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new LetExpCS_LetKeyword_0(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}

// ("," variable+=LetVariableCS)*
protected class LetExpCS_Group_2 extends GroupToken {
	
	public LetExpCS_Group_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getLetExpCSAccess().getGroup_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new LetExpCS_VariableAssignment_2_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// ","
protected class LetExpCS_CommaKeyword_2_0 extends KeywordToken  {
	
	public LetExpCS_CommaKeyword_2_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getLetExpCSAccess().getCommaKeyword_2_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new LetExpCS_Group_2(lastRuleCallOrigin, this, 0, inst);
			case 1: return new LetExpCS_VariableAssignment_1(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}

// variable+=LetVariableCS
protected class LetExpCS_VariableAssignment_2_1 extends AssignmentToken  {
	
	public LetExpCS_VariableAssignment_2_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getLetExpCSAccess().getVariableAssignment_2_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new LetVariableCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("variable",false)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("variable");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getLetVariableCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getLetExpCSAccess().getVariableLetVariableCSParserRuleCall_2_1_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new LetExpCS_CommaKeyword_2_0(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}


// "in"
protected class LetExpCS_InKeyword_3 extends KeywordToken  {
	
	public LetExpCS_InKeyword_3(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getLetExpCSAccess().getInKeyword_3();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new LetExpCS_Group_2(lastRuleCallOrigin, this, 0, inst);
			case 1: return new LetExpCS_VariableAssignment_1(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}

// in=ExpCS
protected class LetExpCS_InAssignment_4 extends AssignmentToken  {
	
	public LetExpCS_InAssignment_4(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getLetExpCSAccess().getInAssignment_4();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ExpCS_Alternatives(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("in",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("in");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getExpCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getLetExpCSAccess().getInExpCSParserRuleCall_4_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new LetExpCS_InKeyword_3(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}


/************ end Rule LetExpCS ****************/


/************ begin Rule LetVariableCS ****************
 *
 * LetVariableCS:
 * 	name=UnrestrictedName (":" ownedType=TypeExpCS)? "=" initExpression=ExpCS;
 *
 **/

// name=UnrestrictedName (":" ownedType=TypeExpCS)? "=" initExpression=ExpCS
protected class LetVariableCS_Group extends GroupToken {
	
	public LetVariableCS_Group(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getLetVariableCSAccess().getGroup();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new LetVariableCS_InitExpressionAssignment_3(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getLetVariableCSRule().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// name=UnrestrictedName
protected class LetVariableCS_NameAssignment_0 extends AssignmentToken  {
	
	public LetVariableCS_NameAssignment_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getLetVariableCSAccess().getNameAssignment_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index, inst);
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("name",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("name");
		if(valueSerializer.isValid(obj.getEObject(), grammarAccess.getLetVariableCSAccess().getNameUnrestrictedNameParserRuleCall_0_0(), value, null)) {
			type = AssignmentType.DATATYPE_RULE_CALL;
			element = grammarAccess.getLetVariableCSAccess().getNameUnrestrictedNameParserRuleCall_0_0();
			return obj;
		}
		return null;
	}

}

// (":" ownedType=TypeExpCS)?
protected class LetVariableCS_Group_1 extends GroupToken {
	
	public LetVariableCS_Group_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getLetVariableCSAccess().getGroup_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new LetVariableCS_OwnedTypeAssignment_1_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// ":"
protected class LetVariableCS_ColonKeyword_1_0 extends KeywordToken  {
	
	public LetVariableCS_ColonKeyword_1_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getLetVariableCSAccess().getColonKeyword_1_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new LetVariableCS_NameAssignment_0(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}

// ownedType=TypeExpCS
protected class LetVariableCS_OwnedTypeAssignment_1_1 extends AssignmentToken  {
	
	public LetVariableCS_OwnedTypeAssignment_1_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getLetVariableCSAccess().getOwnedTypeAssignment_1_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new TypeExpCS_Group(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("ownedType",false)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("ownedType");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getTypeExpCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getLetVariableCSAccess().getOwnedTypeTypeExpCSParserRuleCall_1_1_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new LetVariableCS_ColonKeyword_1_0(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}


// "="
protected class LetVariableCS_EqualsSignKeyword_2 extends KeywordToken  {
	
	public LetVariableCS_EqualsSignKeyword_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getLetVariableCSAccess().getEqualsSignKeyword_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new LetVariableCS_Group_1(lastRuleCallOrigin, this, 0, inst);
			case 1: return new LetVariableCS_NameAssignment_0(lastRuleCallOrigin, this, 1, inst);
			default: return null;
		}	
	}

}

// initExpression=ExpCS
protected class LetVariableCS_InitExpressionAssignment_3 extends AssignmentToken  {
	
	public LetVariableCS_InitExpressionAssignment_3(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getLetVariableCSAccess().getInitExpressionAssignment_3();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ExpCS_Alternatives(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("initExpression",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("initExpression");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getExpCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getLetVariableCSAccess().getInitExpressionExpCSParserRuleCall_3_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new LetVariableCS_EqualsSignKeyword_2(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}


/************ end Rule LetVariableCS ****************/


/************ begin Rule NestedExpCS ****************
 *
 * NestedExpCS:
 * 	"(" source=ExpCS ")";
 *
 **/

// "(" source=ExpCS ")"
protected class NestedExpCS_Group extends GroupToken {
	
	public NestedExpCS_Group(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getNestedExpCSAccess().getGroup();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new NestedExpCS_RightParenthesisKeyword_2(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getNestedExpCSRule().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// "("
protected class NestedExpCS_LeftParenthesisKeyword_0 extends KeywordToken  {
	
	public NestedExpCS_LeftParenthesisKeyword_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getNestedExpCSAccess().getLeftParenthesisKeyword_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index, inst);
		}	
	}

}

// source=ExpCS
protected class NestedExpCS_SourceAssignment_1 extends AssignmentToken  {
	
	public NestedExpCS_SourceAssignment_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Assignment getGrammarElement() {
		return grammarAccess.getNestedExpCSAccess().getSourceAssignment_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new ExpCS_Alternatives(this, this, 0, inst);
			default: return null;
		}	
	}

    @Override	
	public IEObjectConsumer tryConsume() {
		if((value = eObjectConsumer.getConsumable("source",true)) == null) return null;
		IEObjectConsumer obj = eObjectConsumer.cloneAndConsume("source");
		if(value instanceof EObject) { // org::eclipse::xtext::impl::RuleCallImpl
			IEObjectConsumer param = createEObjectConsumer((EObject)value);
			if(param.isInstanceOf(grammarAccess.getExpCSRule().getType().getClassifier())) {
				type = AssignmentType.PARSER_RULE_CALL;
				element = grammarAccess.getNestedExpCSAccess().getSourceExpCSParserRuleCall_1_0(); 
				consumed = obj;
				return param;
			}
		}
		return null;
	}

    @Override
	public AbstractToken createFollowerAfterReturn(AbstractToken next,	int actIndex, int index, IEObjectConsumer inst) {
		if(value == inst.getEObject() && !inst.isConsumed()) return null;
		switch(index) {
			case 0: return new NestedExpCS_LeftParenthesisKeyword_0(lastRuleCallOrigin, next, actIndex, consumed);
			default: return null;
		}	
	}	
}

// ")"
protected class NestedExpCS_RightParenthesisKeyword_2 extends KeywordToken  {
	
	public NestedExpCS_RightParenthesisKeyword_2(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getNestedExpCSAccess().getRightParenthesisKeyword_2();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new NestedExpCS_SourceAssignment_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}


/************ end Rule NestedExpCS ****************/


/************ begin Rule SelfExpCS ****************
 *
 * SelfExpCS:
 * 	{SelfExpCS} "self";
 *
 **/

// {SelfExpCS} "self"
protected class SelfExpCS_Group extends GroupToken {
	
	public SelfExpCS_Group(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Group getGrammarElement() {
		return grammarAccess.getSelfExpCSAccess().getGroup();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new SelfExpCS_SelfKeyword_1(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(getEObject().eClass() != grammarAccess.getSelfExpCSAccess().getSelfExpCSAction_0().getType().getClassifier())
			return null;
		return eObjectConsumer;
	}

}

// {SelfExpCS}
protected class SelfExpCS_SelfExpCSAction_0 extends ActionToken  {

	public SelfExpCS_SelfExpCSAction_0(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Action getGrammarElement() {
		return grammarAccess.getSelfExpCSAccess().getSelfExpCSAction_0();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			default: return lastRuleCallOrigin.createFollowerAfterReturn(this, index, index, inst);
		}	
	}

    @Override
	public IEObjectConsumer tryConsume() {
		if(!eObjectConsumer.isConsumed()) return null;
		return eObjectConsumer;
	}
}

// "self"
protected class SelfExpCS_SelfKeyword_1 extends KeywordToken  {
	
	public SelfExpCS_SelfKeyword_1(AbstractToken lastRuleCallOrigin, AbstractToken next, int transitionIndex, IEObjectConsumer eObjectConsumer) {
		super(lastRuleCallOrigin, next, transitionIndex, eObjectConsumer);
	}
	
	@Override
	public Keyword getGrammarElement() {
		return grammarAccess.getSelfExpCSAccess().getSelfKeyword_1();
	}

    @Override
	public AbstractToken createFollower(int index, IEObjectConsumer inst) {
		switch(index) {
			case 0: return new SelfExpCS_SelfExpCSAction_0(lastRuleCallOrigin, this, 0, inst);
			default: return null;
		}	
	}

}


/************ end Rule SelfExpCS ****************/

}
