/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.debug.ui.launching;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.qvtd.debug.launching.QVTiLaunchConstants;
import org.eclipse.qvtd.debug.ui.QVTdDebugUIPlugin;
import org.eclipse.qvtd.debug.ui.launching.AbstractMainTab;
import org.eclipse.qvtd.debug.ui.launching.LaunchingUtils;
import org.eclipse.qvtd.debug.ui.launching.ParameterRow;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtcorebase.BottomPattern;
import org.eclipse.qvtd.pivot.qvtcorebase.CoreDomain;
import org.eclipse.qvtd.pivot.qvtimperative.Mapping;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEnvironmentFactory;
import org.eclipse.qvtd.xtext.qvtimperative.utilities.QVTiXtextEvaluator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class MainTab
extends AbstractMainTab
implements QVTiLaunchConstants {
    protected Text txPath;
    protected Button txBrowseWS;
    protected Button txBrowseFile;
    protected Group inputsGroup;
    protected Group outputsGroup;

    public boolean canSave() {
        String txName;
        URI txURI;
        assert (!this.initializing);
        ResourceSet resourceSet = this.getMetaModelManager().getExternalResourceSet();
        URIConverter uriConverter = resourceSet.getURIConverter();
        boolean txExists = uriConverter.exists(txURI = URI.createURI((String)(txName = this.txPath.getText()), (boolean)true), null);
        if (!txExists) {
            this.setErrorMessage("Selected file " + txName + " does not exist");
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public void createControl(Composite parent) {
        Composite control = this.createForm(parent);
        this.txPath.addModifyListener((ModifyListener)new TransformationModifyListener());
        LaunchingUtils.prepareBrowseWorkspaceButton(this.txBrowseWS, this.txPath, false);
        LaunchingUtils.prepareBrowseFileSystemButton(this.txBrowseFile, this.txPath, false);
        this.updateParametersGroup(this.inputsGroup, 0, EMPTY_MAP);
        this.updateParametersGroup(this.outputsGroup, 8192, EMPTY_MAP);
        control.setBounds(0, 0, 300, 300);
        control.layout();
        control.pack();
    }

    public Composite createForm(Composite parent) {
        Composite control = new Composite(parent, 0);
        this.setControl((Control)control);
        control.setLayout((Layout)new GridLayout(1, false));
        control.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Group txGroup = new Group(control, 0);
        txGroup.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        txGroup.setText("Transformation");
        txGroup.setLayout((Layout)new GridLayout(3, false));
        this.txPath = new Text((Composite)txGroup, 2048);
        GridData gd_txPath = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_txPath.minimumWidth = 100;
        this.txPath.setLayoutData((Object)gd_txPath);
        this.txBrowseWS = new Button((Composite)txGroup, 0);
        this.txBrowseWS.setText("Browse Workspace...");
        this.txBrowseFile = new Button((Composite)txGroup, 0);
        this.txBrowseFile.setText("Browse File...");
        this.inputsGroup = new Group(control, 0);
        this.inputsGroup.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.inputsGroup.setText("Inputs");
        this.inputsGroup.setLayout((Layout)new GridLayout(1, false));
        this.outputsGroup = new Group(control, 0);
        this.outputsGroup.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.outputsGroup.setText("Outputs");
        this.outputsGroup.setLayout((Layout)new GridLayout(1, false));
        return control;
    }

    protected String getDefaultPath(@NonNull Group group, String name) {
        if (name != null) {
            Control[] controlArray = group.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                if (child instanceof ParameterRow) {
                    ParameterRow row = (ParameterRow)child;
                    if (name.equals(row.name.getText())) {
                        return row.path.getText();
                    }
                }
                ++n2;
            }
        }
        return "";
    }

    public Image getImage() {
        return QVTdDebugUIPlugin.getDefault().createImage("icons/QVTiModelFile.gif");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        assert (!this.initializing);
        try {
            try {
                this.initializing = true;
                this.txPath.setText(configuration.getAttribute("tx", ""));
                Map inMap = configuration.getAttribute("in", EMPTY_MAP);
                Map outMap = configuration.getAttribute("out", EMPTY_MAP);
                if (inMap != null) {
                    this.refreshParametersGroup(this.inputsGroup, 0, inMap);
                }
                if (outMap != null) {
                    this.refreshParametersGroup(this.outputsGroup, 8192, outMap);
                }
            }
            catch (CoreException coreException) {
                this.initializing = false;
                this.updateLaunchConfigurationDialog();
            }
        }
        finally {
            this.initializing = false;
            this.updateLaunchConfigurationDialog();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("tx", this.txPath.getText());
        HashMap<String, String> inputMap = new HashMap<String, String>();
        Control[] controlArray = this.inputsGroup.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof ParameterRow) {
                ParameterRow row = (ParameterRow)child;
                inputMap.put(row.name.getText(), row.path.getText());
            }
            ++n2;
        }
        configuration.setAttribute("in", inputMap);
        HashMap<String, String> outputMap = new HashMap<String, String>();
        Control[] controlArray2 = this.outputsGroup.getChildren();
        int n3 = controlArray2.length;
        n = 0;
        while (n < n3) {
            Control child = controlArray2[n];
            if (child instanceof ParameterRow) {
                ParameterRow row = (ParameterRow)child;
                outputMap.put(row.name.getText(), row.path.getText());
            }
            ++n;
        }
        configuration.setAttribute("out", outputMap);
    }

    protected void refreshParametersGroup(@NonNull Group group, int style, @NonNull Map<String, String> map) {
        ArrayList<String> keys = new ArrayList<String>(map.keySet());
        Collections.sort(keys);
        Control[] children = group.getChildren();
        int i = 0;
        while (i < children.length) {
            ParameterRow row = (ParameterRow)children[i];
            String text = row.name.getText();
            String path = map.get(text);
            if (path != null) {
                row.path.setText(path);
            }
            ++i;
        }
        group.layout();
    }

    @Override
    protected void setDefaults(@NonNull ILaunchConfigurationWorkingCopy configuration, @NonNull IFile iFile) {
        configuration.setAttribute("tx", iFile.getFullPath().toString());
        configuration.setAttribute("in", EMPTY_MAP);
        configuration.setAttribute("out", EMPTY_MAP);
    }

    protected void updateParametersGroup(@NonNull Group group, int style, @NonNull Map<String, String> map) {
        ArrayList<String> keys = new ArrayList<String>(map.keySet());
        Collections.sort(keys);
        Control[] children = group.getChildren();
        int iMax = Math.min(children.length, keys.size());
        int i = 0;
        while (i < iMax) {
            ParameterRow row = (ParameterRow)children[i];
            String string = (String)keys.get(i);
            row.name.setText(string);
            row.path.setText(map.get(string));
            ++i;
        }
        while (i < keys.size()) {
            String string = (String)keys.get(i);
            String parameterPath = map.get(string);
            new ParameterRow(this, group, style, string, parameterPath);
            ++i;
        }
        while (i < children.length) {
            children[i].dispose();
            ++i;
        }
        group.layout();
    }

    protected class TransformationModifyListener
    implements ModifyListener {
        protected TransformationModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (MainTab.this.txPath.isDisposed()) {
                return;
            }
            String txName = MainTab.this.txPath.getText();
            URI txURI = URI.createURI((String)txName, (boolean)true);
            try {
                Group inputsGroup2 = MainTab.this.inputsGroup;
                Group outputsGroup2 = MainTab.this.outputsGroup;
                QVTiEnvironmentFactory envFactory = new QVTiEnvironmentFactory(null, MainTab.this.getMetaModelManager());
                QVTiXtextEvaluator xtextEvaluator = new QVTiXtextEvaluator(envFactory, txURI);
                Transformation transformation = xtextEvaluator.getTransformation();
                HashSet<TypedModel> inputs = new HashSet<TypedModel>();
                HashSet<TypedModel> outputs = new HashSet<TypedModel>();
                HashMap<String, String> inputMap = new HashMap<String, String>();
                HashMap<String, String> outputMap = new HashMap<String, String>();
                for (Rule rule : transformation.getRule()) {
                    if (!(rule instanceof Mapping)) continue;
                    Mapping mapping = (Mapping)rule;
                    for (Domain domain : mapping.getDomain()) {
                        if (!(domain instanceof CoreDomain)) continue;
                        CoreDomain coreDomain = (CoreDomain)domain;
                        BottomPattern bottomPattern = coreDomain.getBottomPattern();
                        TypedModel typedModel = coreDomain.getTypedModel();
                        String name = typedModel.getName();
                        if (bottomPattern.getRealizedVariable().isEmpty()) {
                            if (!inputs.add(typedModel)) continue;
                            inputMap.put(name, MainTab.this.getDefaultPath(inputsGroup2, name));
                            continue;
                        }
                        if (!outputs.add(typedModel)) continue;
                        outputMap.put(name, MainTab.this.getDefaultPath(outputsGroup2, name));
                    }
                }
                for (String key : outputMap.keySet()) {
                    inputMap.remove(key);
                }
                MainTab.this.updateParametersGroup(inputsGroup2, 0, inputMap);
                MainTab.this.updateParametersGroup(outputsGroup2, 8192, outputMap);
            }
            catch (Exception ex) {
                MainTab.this.setErrorMessage("Failed to load '" + txName + "': " + ex.toString());
            }
            MainTab.this.updateLaunchConfigurationDialog();
        }
    }
}

