/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtimperative.evaluation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainExpression;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.elements.DomainTypedElement;
import org.eclipse.ocl.examples.domain.evaluation.DomainModelManager;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;
import org.eclipse.ocl.examples.pivot.Environment;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.VariableExp;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitorImpl;
import org.eclipse.ocl.examples.pivot.manager.PivotIdResolver;
import org.eclipse.ocl.examples.pivot.util.Visitable;
import org.eclipse.ocl.examples.pivot.util.Visitor;
import org.eclipse.qvtd.pivot.qvtbase.BaseModel;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.Function;
import org.eclipse.qvtd.pivot.qvtbase.FunctionParameter;
import org.eclipse.qvtd.pivot.qvtbase.Pattern;
import org.eclipse.qvtd.pivot.qvtbase.Predicate;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.Unit;
import org.eclipse.qvtd.pivot.qvtcorebase.Area;
import org.eclipse.qvtd.pivot.qvtcorebase.Assignment;
import org.eclipse.qvtd.pivot.qvtcorebase.BottomPattern;
import org.eclipse.qvtd.pivot.qvtcorebase.CoreDomain;
import org.eclipse.qvtd.pivot.qvtcorebase.CorePattern;
import org.eclipse.qvtd.pivot.qvtcorebase.EnforcementOperation;
import org.eclipse.qvtd.pivot.qvtcorebase.GuardPattern;
import org.eclipse.qvtd.pivot.qvtcorebase.PropertyAssignment;
import org.eclipse.qvtd.pivot.qvtcorebase.RealizedVariable;
import org.eclipse.qvtd.pivot.qvtcorebase.VariableAssignment;
import org.eclipse.qvtd.pivot.qvtcorebase.utilities.QVTcoreBaseUtil;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeModel;
import org.eclipse.qvtd.pivot.qvtimperative.Mapping;
import org.eclipse.qvtd.pivot.qvtimperative.MappingCall;
import org.eclipse.qvtd.pivot.qvtimperative.MappingCallBinding;
import org.eclipse.qvtd.pivot.qvtimperative.MiddlePropertyAssignment;
import org.eclipse.qvtd.pivot.qvtimperative.MiddlePropertyCallExp;
import org.eclipse.qvtd.pivot.qvtimperative.VariablePredicate;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.IQVTiEvaluationEnvironment;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEnvironment;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEvaluationVisitor;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiModelManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QVTiAbstractEvaluationVisitor
extends EvaluationVisitorImpl
implements QVTiEvaluationVisitor {
    public QVTiAbstractEvaluationVisitor(@NonNull QVTiEnvironment env, @NonNull IQVTiEvaluationEnvironment evalEnv) {
        super((Environment)env, (EvaluationEnvironment)evalEnv, (DomainModelManager)evalEnv.getModelManager());
    }

    @Override
    @Nullable
    public Object visitImperativeModel(@NonNull ImperativeModel object) {
        return this.visiting((Visitable)object);
    }

    @Override
    @NonNull
    public abstract QVTiEvaluationVisitor createNestedEvaluator();

    private void doMappingCallRecursion(@NonNull Mapping mapping, @NonNull List<Variable> loopedVariables, @NonNull List<Iterable<?>> loopedValues, int depth) {
        assert (depth < loopedVariables.size());
        Variable boundVariable = loopedVariables.get(depth);
        Type guardType = boundVariable.getType();
        PivotIdResolver idResolver = this.metaModelManager.getIdResolver();
        int nestedDepth = depth + 1;
        for (Object value : loopedValues.get(depth)) {
            DomainType valueType = idResolver.getDynamicTypeOf(value);
            if (guardType == null || !valueType.conformsTo((DomainStandardLibrary)this.metaModelManager, (DomainType)guardType)) continue;
            this.getEvaluationEnvironment().replace((DomainTypedElement)boundVariable, value);
            if (nestedDepth >= loopedVariables.size()) {
                mapping.accept((Visitor)this.undecoratedVisitor);
                continue;
            }
            this.doMappingCallRecursion(mapping, loopedVariables, loopedValues, nestedDepth);
        }
    }

    @NonNull
    public QVTiEnvironment getEnvironment() {
        return (QVTiEnvironment)super.getEnvironment();
    }

    @NonNull
    public IQVTiEvaluationEnvironment getEvaluationEnvironment() {
        return (IQVTiEvaluationEnvironment)super.getEvaluationEnvironment();
    }

    @NonNull
    public QVTiModelManager getModelManager() {
        return (QVTiModelManager)this.modelManager;
    }

    protected boolean isMtoRMapping(@NonNull Mapping mapping) {
        if (mapping.getDomain().size() == 0) {
            return false;
        }
        for (Domain domain : mapping.getDomain()) {
            if (domain.isIsEnforceable()) continue;
            return false;
        }
        return true;
    }

    protected boolean isMtoMMapping(@NonNull Mapping mapping) {
        return mapping.getDomain().size() == 0;
    }

    protected boolean isLtoMMapping(@NonNull Mapping mapping) {
        if (mapping.getDomain().size() == 0) {
            return false;
        }
        for (Domain domain : mapping.getDomain()) {
            if (!domain.isIsEnforceable()) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public Object visitAssignment(@NonNull Assignment object) {
        return this.visiting((Visitable)object);
    }

    @Nullable
    public Object visitBaseModel(@NonNull BaseModel object) {
        return this.visiting((Visitable)object);
    }

    @Nullable
    public Object visitBottomPattern(@NonNull BottomPattern object) {
        return this.visiting((Visitable)object);
    }

    @Nullable
    public Object visitCoreDomain(@NonNull CoreDomain object) {
        return this.visiting((Visitable)object);
    }

    @Nullable
    public Object visitDomain(@NonNull Domain object) {
        return this.visiting((Visitable)object);
    }

    @Nullable
    public Object visitCorePattern(@NonNull CorePattern object) {
        return this.visiting((Visitable)object);
    }

    @Nullable
    public Object visitEnforcementOperation(@NonNull EnforcementOperation object) {
        return this.visiting((Visitable)object);
    }

    @Nullable
    public Object visitFunction(@NonNull Function object) {
        return this.visiting((Visitable)object);
    }

    @Nullable
    public Object visitFunctionParameter(@NonNull FunctionParameter object) {
        return this.visiting((Visitable)object);
    }

    @Nullable
    public Object visitGuardPattern(@NonNull GuardPattern guardPattern) {
        for (Predicate predicate : guardPattern.getPredicate()) {
            Object result = predicate.accept((Visitor)this.undecoratedVisitor);
            if (result == Boolean.TRUE) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    public Object visitMappingCall(@NonNull MappingCall mappingCall) {
        Mapping calledMapping = (Mapping)DomainUtil.nonNullModel((Object)mappingCall.getReferredMapping());
        ArrayList<Variable> loopedVariables = null;
        ArrayList<Iterable> loopedValues = null;
        for (MappingCallBinding binding : mappingCall.getBinding()) {
            Variable boundVariable = (Variable)DomainUtil.nonNullModel((Object)binding.getBoundVariable());
            Object valueOrValues = null;
            try {
                valueOrValues = ((QVTiEvaluationVisitor)this.undecoratedVisitor).safeVisit((Visitable)binding.getValue());
            }
            catch (InvalidValueException ex) {
                return null;
            }
            if (!binding.isIsLoop()) {
                DomainType valueType = this.metaModelManager.getIdResolver().getDynamicTypeOf(valueOrValues);
                Type varType = boundVariable.getType();
                if (varType != null && valueType.conformsTo((DomainStandardLibrary)this.metaModelManager, (DomainType)varType)) {
                    try {
                        this.evaluationEnvironment.add((DomainTypedElement)boundVariable, valueOrValues);
                    }
                    catch (IllegalArgumentException ex) {
                        this.evaluationEnvironment.replace((DomainTypedElement)boundVariable, valueOrValues);
                    }
                    continue;
                }
                return null;
            }
            if (!(valueOrValues instanceof Iterable)) continue;
            if (loopedVariables == null) {
                loopedVariables = new ArrayList<Variable>();
            }
            if (loopedValues == null) {
                loopedValues = new ArrayList<Iterable>();
            }
            loopedVariables.add(boundVariable);
            loopedValues.add((Iterable)valueOrValues);
            try {
                this.evaluationEnvironment.add((DomainTypedElement)boundVariable, null);
            }
            catch (IllegalArgumentException ex) {
                this.evaluationEnvironment.replace((DomainTypedElement)boundVariable, null);
            }
        }
        if (loopedValues == null || loopedVariables == null) {
            calledMapping.accept((Visitor)this.undecoratedVisitor);
        } else {
            this.doMappingCallRecursion(calledMapping, loopedVariables, loopedValues, 0);
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitMappingCallBinding(@NonNull MappingCallBinding object) {
        return this.visiting((Visitable)object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public Object visitMiddlePropertyAssignment(@NonNull MiddlePropertyAssignment propertyAssignment) {
        OCLExpression slotExp = propertyAssignment.getSlotExpression();
        Area area = ((BottomPattern)propertyAssignment.eContainer()).getArea();
        if (!(area instanceof Mapping)) return true;
        if (!(slotExp instanceof VariableExp)) throw new IllegalArgumentException("Unsupported " + propertyAssignment.eClass().getName() + " specification. The slot expression type (" + slotExp.getType().getName() + ") is not supported yet.");
        Variable slotVar = (Variable)((VariableExp)slotExp).getReferredVariable();
        if (slotVar == null) throw new IllegalArgumentException("Unsupported " + propertyAssignment.eClass().getName() + " specification. The referred variable of the slot expression (" + slotExp.getType().getName() + ") was not found.");
        Object slotBinding = this.evaluationEnvironment.getValueOf((DomainTypedElement)slotVar);
        if (slotBinding == null) throw new IllegalArgumentException("Unsupported " + propertyAssignment.eClass().getName() + " specification. The assigment refers to a variable not defined in the" + " current environment");
        Object value = null;
        try {
            try {
                value = this.safeVisit((Visitable)propertyAssignment.getValue());
            }
            catch (InvalidValueException ex) {
                System.out.println("visitMiddlePropertyAssignment InvalidValueException");
                if (value == null) return true;
                Object unboxedValue = this.metaModelManager.getIdResolver().unboxedValueOf(value);
                Property p = propertyAssignment.getTargetProperty();
                p.initValue(slotBinding, unboxedValue);
                Integer cacheIndex = propertyAssignment.getCacheIndex();
                if (cacheIndex == null) return true;
                this.getModelManager().setMiddleOpposite(cacheIndex, slotBinding, unboxedValue);
                return true;
            }
        }
        catch (Throwable throwable) {
            if (value == null) throw throwable;
            Object unboxedValue = this.metaModelManager.getIdResolver().unboxedValueOf(value);
            Property p = propertyAssignment.getTargetProperty();
            p.initValue(slotBinding, unboxedValue);
            Integer cacheIndex = propertyAssignment.getCacheIndex();
            if (cacheIndex == null) throw throwable;
            this.getModelManager().setMiddleOpposite(cacheIndex, slotBinding, unboxedValue);
            throw throwable;
        }
        if (value == null) return true;
        Object unboxedValue = this.metaModelManager.getIdResolver().unboxedValueOf(value);
        Property p = propertyAssignment.getTargetProperty();
        p.initValue(slotBinding, unboxedValue);
        Integer cacheIndex = propertyAssignment.getCacheIndex();
        if (cacheIndex == null) return true;
        this.getModelManager().setMiddleOpposite(cacheIndex, slotBinding, unboxedValue);
        return true;
    }

    @Override
    @Nullable
    public Object visitMiddlePropertyCallExp(@NonNull MiddlePropertyCallExp pPropertyCallExp) {
        Object sourceValue;
        OCLExpression source = pPropertyCallExp.getSource();
        Object object = sourceValue = source != null ? this.undecoratedVisitor.evaluate((DomainExpression)source) : null;
        if (sourceValue != null) {
            Integer cacheIndex = (Integer)DomainUtil.nonNullState((Object)pPropertyCallExp.getCacheIndex());
            Object middleOpposite = this.getModelManager().getMiddleOpposite(cacheIndex, sourceValue);
            return DomainUtil.nonNullState((Object)middleOpposite);
        }
        throw new InvalidValueException("Failed to evaluate '" + pPropertyCallExp.getReferredProperty() + "'", new Object[]{sourceValue, pPropertyCallExp});
    }

    @Nullable
    public Object visitPattern(@NonNull Pattern object) {
        return this.visiting((Visitable)object);
    }

    @Nullable
    public Object visitPredicate(@NonNull Predicate predicate) {
        OCLExpression exp = predicate.getConditionExpression();
        Object expResult = exp.accept((Visitor)this.undecoratedVisitor);
        return expResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public Object visitPropertyAssignment(@NonNull PropertyAssignment propertyAssignment) {
        OCLExpression slotExp = propertyAssignment.getSlotExpression();
        if (!(slotExp instanceof VariableExp)) throw new IllegalArgumentException("Unsupported " + propertyAssignment.eClass().getName() + " specification. The slot expression type (" + slotExp.getType().getName() + ") is not supported yet.");
        Variable slotVar = (Variable)((VariableExp)slotExp).getReferredVariable();
        if (slotVar == null) throw new IllegalArgumentException("Unsupported " + propertyAssignment.eClass().getName() + " specification. The referred variable of the slot expression (" + slotExp.getType().getName() + ") was not found.");
        Object slotBinding = this.evaluationEnvironment.getValueOf((DomainTypedElement)slotVar);
        if (slotBinding == null) {
            throw new IllegalArgumentException("Unsupported " + propertyAssignment.eClass().getName() + " specification. The assigment refers to a variable not defined in the" + " current environment");
        }
        Object value = this.safeVisit((Visitable)propertyAssignment.getValue());
        value = this.metaModelManager.getIdResolver().unboxedValueOf(value);
        Property p = propertyAssignment.getTargetProperty();
        p.initValue(slotBinding, value);
        return true;
    }

    @Nullable
    public Object visitRealizedVariable(@NonNull RealizedVariable realizedVariable) {
        Area area = ((BottomPattern)realizedVariable.eContainer()).getArea();
        Object element = realizedVariable.getType().createInstance();
        TypedModel tm = QVTcoreBaseUtil.getTypedModel((Area)area);
        assert (tm != null);
        ((QVTiModelManager)this.modelManager).addModelElement(tm, element);
        this.evaluationEnvironment.replace((DomainTypedElement)realizedVariable, element);
        return element;
    }

    @Nullable
    public Object visitRule(@NonNull Rule object) {
        return this.visiting((Visitable)object);
    }

    @Nullable
    public Object visitTransformation(@NonNull Transformation object) {
        return this.visiting((Visitable)object);
    }

    @Nullable
    public Object visitTypedModel(@NonNull TypedModel object) {
        return this.visiting((Visitable)object);
    }

    @Nullable
    public Object visitUnit(@NonNull Unit object) {
        return this.visiting((Visitable)object);
    }

    @Nullable
    public Object visitVariableAssignment(@NonNull VariableAssignment variableAssignment) {
        Variable targetVariable = variableAssignment.getTargetVariable();
        Object value = ((QVTiEvaluationVisitor)this.undecoratedVisitor).safeVisit((Visitable)variableAssignment.getValue());
        if (targetVariable != null) {
            this.evaluationEnvironment.replace((DomainTypedElement)targetVariable, value);
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitVariablePredicate(@NonNull VariablePredicate variablePredicate) {
        PivotIdResolver idResolver = this.metaModelManager.getIdResolver();
        OCLExpression exp = variablePredicate.getConditionExpression();
        Object value = ((QVTiEvaluationVisitor)this.undecoratedVisitor).safeVisit((Visitable)exp);
        Variable variable = variablePredicate.getTargetVariable();
        Type guardType = variable.getType();
        DomainType valueType = idResolver.getDynamicTypeOf(value);
        if (guardType == null || !valueType.conformsTo((DomainStandardLibrary)this.metaModelManager, (DomainType)guardType)) {
            return false;
        }
        this.evaluationEnvironment.replace((DomainTypedElement)variable, value);
        return true;
    }
}

