/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtimperative.utilities;

import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.prettyprint.PrettyPrinter;
import org.eclipse.ocl.examples.pivot.util.AbstractVisitor;
import org.eclipse.ocl.examples.pivot.util.Visitable;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.Predicate;
import org.eclipse.qvtd.pivot.qvtcorebase.Area;
import org.eclipse.qvtd.pivot.qvtcorebase.Assignment;
import org.eclipse.qvtd.pivot.qvtcorebase.BottomPattern;
import org.eclipse.qvtd.pivot.qvtcorebase.CoreDomain;
import org.eclipse.qvtd.pivot.qvtcorebase.GuardPattern;
import org.eclipse.qvtd.pivot.qvtcorebase.PropertyAssignment;
import org.eclipse.qvtd.pivot.qvtcorebase.RealizedVariable;
import org.eclipse.qvtd.pivot.qvtcorebase.utilities.QVTcoreBasePrettyPrintVisitor;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeModel;
import org.eclipse.qvtd.pivot.qvtimperative.Mapping;
import org.eclipse.qvtd.pivot.qvtimperative.MappingCall;
import org.eclipse.qvtd.pivot.qvtimperative.MappingCallBinding;
import org.eclipse.qvtd.pivot.qvtimperative.QVTimperativePackage;
import org.eclipse.qvtd.pivot.qvtimperative.util.QVTimperativeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QVTimperativePrettyPrintVisitor
extends QVTcoreBasePrettyPrintVisitor
implements QVTimperativeVisitor<Object> {
    @NonNull
    public static PrettyPrinter.Factory FACTORY = new Factory();

    public QVTimperativePrettyPrintVisitor(@NonNull PrettyPrinter context) {
        super(context);
    }

    private void doArea(Area pArea) {
        ((PrettyPrinter)this.context).append(" (");
        this.safeVisit((Visitable)pArea.getGuardPattern());
        ((PrettyPrinter)this.context).append(")\n{");
        this.safeVisit((Visitable)pArea.getBottomPattern());
        ((PrettyPrinter)this.context).append("}\n");
    }

    public Object visitBottomPattern(@NonNull BottomPattern pBottomPattern) {
        for (RealizedVariable pRealizedVariable : pBottomPattern.getRealizedVariable()) {
            this.safeVisit((Visitable)pRealizedVariable);
        }
        ((PrettyPrinter)this.context).append(" |\n");
        for (Assignment pAssignment : pBottomPattern.getAssignment()) {
            this.safeVisit((Visitable)pAssignment);
        }
        return null;
    }

    public Object visitGuardPattern(@NonNull GuardPattern pGuardPattern) {
        for (Variable pVariable : pGuardPattern.getVariable()) {
            this.safeVisit((Visitable)pVariable);
        }
        ((PrettyPrinter)this.context).append(" |\n");
        for (Predicate pPredicate : pGuardPattern.getPredicate()) {
            this.safeVisit((Visitable)pPredicate);
        }
        return null;
    }

    @Override
    public Object visitImperativeModel(@NonNull ImperativeModel object) {
        return null;
    }

    @Override
    public Object visitMapping(@NonNull Mapping pMapping) {
        ((PrettyPrinter)this.context).append("map ");
        ((PrettyPrinter)this.context).appendName((NamedElement)pMapping);
        ((PrettyPrinter)this.context).append(" in ");
        ((PrettyPrinter)this.context).appendName((NamedElement)pMapping.getTransformation());
        ((PrettyPrinter)this.context).append(") {\n");
        ((PrettyPrinter)this.context).push("", "");
        for (Domain pDomain : pMapping.getDomain()) {
            if (!(pDomain instanceof CoreDomain)) continue;
            ((PrettyPrinter)this.context).appendName((NamedElement)pDomain);
            this.doArea((Area)((CoreDomain)pDomain));
        }
        ((PrettyPrinter)this.context).append("where");
        this.doArea((Area)pMapping);
        for (MappingCall pMappingCall : pMapping.getMappingCall()) {
            this.safeVisit((Visitable)pMappingCall);
        }
        ((PrettyPrinter)this.context).pop();
        ((PrettyPrinter)this.context).append("\n}");
        return null;
    }

    @Override
    public Object visitMappingCall(@NonNull MappingCall pMappingCall) {
        ((PrettyPrinter)this.context).append("map ");
        ((PrettyPrinter)this.context).appendName((NamedElement)pMappingCall.getReferredMapping());
        ((PrettyPrinter)this.context).append(" {\n");
        ((PrettyPrinter)this.context).push("", "");
        for (MappingCallBinding mappingCallBinding : pMappingCall.getBinding()) {
            this.safeVisit((Visitable)mappingCallBinding);
        }
        ((PrettyPrinter)this.context).append("}");
        ((PrettyPrinter)this.context).pop();
        return null;
    }

    @Override
    public Object visitMappingCallBinding(@NonNull MappingCallBinding bMappingCallBinding) {
        ((PrettyPrinter)this.context).appendName((NamedElement)bMappingCallBinding.getBoundVariable());
        ((PrettyPrinter)this.context).append(bMappingCallBinding.isIsLoop() ? " <= " : " := ");
        this.safeVisit((Visitable)bMappingCallBinding.getValue());
        ((PrettyPrinter)this.context).append(";\n");
        return null;
    }

    public Object visitPredicate(@NonNull Predicate pPredicate) {
        this.safeVisit((Visitable)pPredicate.getConditionExpression());
        return null;
    }

    public Object visitPropertyAssignment(@NonNull PropertyAssignment pPropertyAssignment) {
        this.safeVisit((Visitable)pPropertyAssignment.getSlotExpression());
        ((PrettyPrinter)this.context).append(" = ");
        this.safeVisit((Visitable)pPropertyAssignment.getValue());
        ((PrettyPrinter)this.context).append(";\n");
        return null;
    }

    public Object visitRealizedVariable(@NonNull RealizedVariable pRealizedVariable) {
        ((PrettyPrinter)this.context).append("realize ");
        this.visitVariable((Variable)pRealizedVariable);
        return null;
    }

    public Object visitVariable(@NonNull Variable pVariable) {
        super.visitVariable(pVariable);
        ((PrettyPrinter)this.context).append(";\n");
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Factory
    implements PrettyPrinter.Factory {
        private Factory() {
            QVTcoreBasePrettyPrintVisitor.FACTORY.getClass();
            PrettyPrinter.addFactory((EPackage)QVTimperativePackage.eINSTANCE, (PrettyPrinter.Factory)this);
        }

        @NonNull
        public AbstractVisitor<Object, PrettyPrinter> createPrettyPrintVisitor(@NonNull PrettyPrinter printer) {
            return new QVTimperativePrettyPrintVisitor(printer);
        }
    }
}

