/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.preferences;

import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.internal.ui.actions.StatusInfo;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.m2m.atl.adt.ui.preferences.ProfileManager;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CreateProfileDialog
extends StatusDialog {
    private Text fNameText;
    private Combo fProfileCombo;
    private static final StatusInfo fOk = new StatusInfo();
    private static final StatusInfo fEmpty = new StatusInfo(4, "The profile name is empty");
    private static final StatusInfo fDuplicate = new StatusInfo(4, "A profile with this name already exists");
    private final ProfileManager fProfileManager;
    private final List<ProfileManager.Profile> fSortedProfiles;
    private final String[] fSortedNames;
    private ProfileManager.CustomProfile fCreatedProfile;

    public CreateProfileDialog(Shell parentShell, ProfileManager profileManager) {
        super(parentShell);
        this.fProfileManager = profileManager;
        this.fSortedProfiles = this.fProfileManager.getSortedProfiles();
        this.fSortedNames = this.fProfileManager.getSortedDisplayNames();
    }

    public void create() {
        super.create();
        this.setTitle("Create a new profile");
    }

    public Control createDialogArea(Composite parent) {
        int numColumns = 2;
        Composite composite = (Composite)super.createDialogArea(parent);
        ((GridLayout)composite.getLayout()).numColumns = 2;
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.widthHint = this.convertWidthInCharsToPixels(60);
        Label nameLabel = new Label(composite, 64);
        nameLabel.setText("Name of the profile:");
        nameLabel.setLayoutData((Object)gd);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fNameText = new Text(composite, 2052);
        this.fNameText.setLayoutData((Object)gd);
        this.fNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateProfileDialog.this.doValidation();
            }
        });
        gd = new GridData();
        gd.horizontalSpan = 2;
        Label profileLabel = new Label(composite, 64);
        profileLabel.setText("Choose a base profile (for initialize settings):");
        profileLabel.setLayoutData((Object)gd);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fProfileCombo = new Combo(composite, 12);
        this.fProfileCombo.setLayoutData((Object)gd);
        this.fProfileCombo.setItems(this.fSortedNames);
        this.fProfileCombo.setText(this.fProfileManager.getDefaultProfile().getName());
        this.updateStatus((IStatus)fEmpty);
        CreateProfileDialog.applyDialogFont((Control)composite);
        this.fNameText.setFocus();
        return composite;
    }

    protected void doValidation() {
        String name = this.fNameText.getText().trim();
        if (this.fProfileManager.containsName(name)) {
            this.updateStatus((IStatus)fDuplicate);
            return;
        }
        if (name.length() == 0) {
            this.updateStatus((IStatus)fEmpty);
            return;
        }
        this.updateStatus((IStatus)fOk);
    }

    protected void okPressed() {
        if (!this.getStatus().isOK()) {
            return;
        }
        HashMap<String, String> baseSettings = new HashMap<String, String>(this.fSortedProfiles.get(this.fProfileCombo.getSelectionIndex()).getSettings());
        String profileName = this.fNameText.getText();
        this.fCreatedProfile = new ProfileManager.CustomProfile(profileName, baseSettings);
        this.fProfileManager.addProfile(this.fCreatedProfile);
        super.okPressed();
    }
}

