/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.oslc4j.provider.jena;

import java.lang.annotation.Annotation;
import java.util.Collection;
import org.eclipse.lyo.oslc4j.core.annotation.OslcNotQueryResult;
import org.eclipse.lyo.oslc4j.core.annotation.OslcQueryCapability;
import org.eclipse.lyo.oslc4j.core.annotation.OslcResourceShape;
import org.eclipse.lyo.oslc4j.core.model.Compact;
import org.eclipse.lyo.oslc4j.core.model.IResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ProviderHelper {
    private static final Logger log = LoggerFactory.getLogger(ProviderHelper.class);
    static final int CANNOT_BE_DETERMINED_IN_ADVANCE = -1;

    ProviderHelper() {
    }

    static boolean hasNotQueryResultTypeAnnot(Class<?> type) {
        OslcNotQueryResult notQueryResult;
        Class<?> annotatedType = type;
        Class<?> componentType = type.getComponentType();
        if (componentType != null) {
            annotatedType = componentType;
        }
        return (notQueryResult = annotatedType.getAnnotation(OslcNotQueryResult.class)) != null && notQueryResult.value();
    }

    static boolean hasOslcQueryCapabilityMethodAnnot(Annotation[] annotations) {
        if (annotations != null) {
            for (Annotation annotation : annotations) {
                if (annotation == null || !(annotation instanceof OslcQueryCapability)) continue;
                return true;
            }
        }
        return false;
    }

    static boolean isQueryResult(Class<?> type, Annotation[] annotations) {
        return ProviderHelper.hasOslcQueryCapabilityMethodAnnot(annotations) && !ProviderHelper.hasNotQueryResultTypeAnnot(type);
    }

    static boolean isSingleLyoResourceType(Class<?> type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        if (type.isArray()) {
            return false;
        }
        if (Collection.class.isAssignableFrom(type)) {
            return false;
        }
        if (ProviderHelper.hasShapeAnnotation(type)) {
            return true;
        }
        if (IResource.class.isAssignableFrom(type)) {
            log.error("{} is missing @OslcResourceShape annotation", (Object)type.getName());
        }
        return false;
    }

    static boolean isSingleResourceType(Class<?> type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        if (type.isArray()) {
            return false;
        }
        return !Collection.class.isAssignableFrom(type);
    }

    private static boolean hasShapeAnnotation(Class<?> type) {
        return type.getAnnotation(OslcResourceShape.class) != null;
    }

    static boolean isCompactResource(Class<?> type) {
        return Compact.class.isAssignableFrom(type);
    }

    protected static boolean isOslcQuery(String parmString) {
        boolean containsOslcParm = false;
        String[] uriParts = parmString.toLowerCase().split("oslc\\.", 2);
        if (uriParts.length > 1) {
            containsOslcParm = true;
        }
        return containsOslcParm;
    }
}

