/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.test.jaxrs;

import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4jakarta.commons.JakartaJavaCodeActionParams;
import org.eclipse.lsp4jakarta.commons.JakartaJavaDiagnosticsParams;
import org.eclipse.lsp4jakarta.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4jakarta.jdt.internal.core.ls.JDTUtilsLSImpl;
import org.eclipse.lsp4jakarta.jdt.test.core.BaseJakartaTest;
import org.eclipse.lsp4jakarta.jdt.test.core.JakartaForJavaAssert;
import org.junit.Test;

public class ResourceClassConstructorTest
extends BaseJakartaTest {
    protected static IJDTUtils IJDT_UTILS = JDTUtilsLSImpl.getInstance();

    @Test
    public void MultipleConstructorsWithEqualParams() throws Exception {
        IJavaProject javaProject = ResourceClassConstructorTest.loadJavaProject("jakarta-sample", "");
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/io/openliberty/sample/jakarta/jaxrs/RootResourceClassConstructorsEqualLen.java"));
        String uri = javaFile.getLocation().toFile().toURI().toString();
        JakartaJavaDiagnosticsParams diagnosticsParams = new JakartaJavaDiagnosticsParams();
        diagnosticsParams.setUris(Arrays.asList(uri));
        Diagnostic d1 = JakartaForJavaAssert.d(7, 8, 45, "Multiple constructors have the same number of parameters, it might be ambiguous which constructor is used.", DiagnosticSeverity.Warning, "jakarta-jaxrs", "AmbiguousConstructors");
        Diagnostic d2 = JakartaForJavaAssert.d(11, 8, 45, "Multiple constructors have the same number of parameters, it might be ambiguous which constructor is used.", DiagnosticSeverity.Warning, "jakarta-jaxrs", "AmbiguousConstructors");
        JakartaForJavaAssert.assertJavaDiagnostics(diagnosticsParams, IJDT_UTILS, d1, d2);
    }

    @Test
    public void MultipleConstructorsWithDifferentLength() throws Exception {
        IJavaProject javaProject = ResourceClassConstructorTest.loadJavaProject("jakarta-sample", "");
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/io/openliberty/sample/jakarta/jaxrs/RootResourceClassConstructorsDiffLen.java"));
        String uri = javaFile.getLocation().toFile().toURI().toString();
        JakartaJavaDiagnosticsParams diagnosticsParams = new JakartaJavaDiagnosticsParams();
        diagnosticsParams.setUris(Arrays.asList(uri));
        Diagnostic d = JakartaForJavaAssert.d(7, 8, 44, "This constructor is unused, as root resource classes will only use the constructor with the most parameters.", DiagnosticSeverity.Warning, "jakarta-jaxrs", "UnusedConstructor");
        JakartaForJavaAssert.assertJavaDiagnostics(diagnosticsParams, IJDT_UTILS, d);
    }

    @Test
    public void NoPublicConstructor() throws Exception {
        IJavaProject javaProject = ResourceClassConstructorTest.loadJavaProject("jakarta-sample", "");
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/io/openliberty/sample/jakarta/jaxrs/NoPublicConstructorClass.java"));
        String uri = javaFile.getLocation().toFile().toURI().toString();
        JakartaJavaDiagnosticsParams diagnosticsParams = new JakartaJavaDiagnosticsParams();
        diagnosticsParams.setUris(Arrays.asList(uri));
        Diagnostic d1 = JakartaForJavaAssert.d(7, 12, 36, "Root resource classes are instantiated by the JAX-RS runtime and MUST have a public constructor.", DiagnosticSeverity.Error, "jakarta-jaxrs", "NoPublicConstructors");
        Diagnostic d2 = JakartaForJavaAssert.d(11, 14, 38, "Root resource classes are instantiated by the JAX-RS runtime and MUST have a public constructor.", DiagnosticSeverity.Error, "jakarta-jaxrs", "NoPublicConstructors");
        JakartaForJavaAssert.assertJavaDiagnostics(diagnosticsParams, IJDT_UTILS, d1, d2);
        String newText1 = "public NoPublicConstructorClass() {\n\t}\n\n\t";
        String newText2 = "public";
        JakartaJavaCodeActionParams codeActionParams1 = JakartaForJavaAssert.createCodeActionParams(uri, d1);
        TextEdit te1 = JakartaForJavaAssert.te(7, 4, 7, 4, newText1);
        TextEdit te2 = JakartaForJavaAssert.te(7, 4, 7, 11, newText2);
        CodeAction ca1 = JakartaForJavaAssert.ca(uri, "Add a default 'public' constructor to this class", d1, te1);
        CodeAction ca2 = JakartaForJavaAssert.ca(uri, "Make constructor public", d1, te2);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams1, IJDT_UTILS, ca1, ca2);
        JakartaJavaCodeActionParams codeActionParams2 = JakartaForJavaAssert.createCodeActionParams(uri, d2);
        TextEdit te3 = JakartaForJavaAssert.te(7, 4, 7, 4, newText1);
        TextEdit te4 = JakartaForJavaAssert.te(11, 4, 11, 13, newText2);
        CodeAction ca3 = JakartaForJavaAssert.ca(uri, "Add a default 'public' constructor to this class", d2, te3);
        CodeAction ca4 = JakartaForJavaAssert.ca(uri, "Make constructor public", d2, te4);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams2, IJDT_UTILS, ca3, ca4);
    }

    @Test
    public void NoPublicConstructorProviderClass() throws Exception {
        IJavaProject javaProject = ResourceClassConstructorTest.loadJavaProject("jakarta-sample", "");
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/io/openliberty/sample/jakarta/jaxrs/NoPublicConstructorProviderClass.java"));
        String uri = javaFile.getLocation().toFile().toURI().toString();
        JakartaJavaDiagnosticsParams diagnosticsParams = new JakartaJavaDiagnosticsParams();
        diagnosticsParams.setUris(Arrays.asList(uri));
        Diagnostic d1 = JakartaForJavaAssert.d(19, 12, 44, "Provider classes are instantiated by the JAX-RS runtime and MUST have a public constructor.", DiagnosticSeverity.Error, "jakarta-jaxrs", "NoPublicConstructors");
        Diagnostic d2 = JakartaForJavaAssert.d(23, 14, 46, "Provider classes are instantiated by the JAX-RS runtime and MUST have a public constructor.", DiagnosticSeverity.Error, "jakarta-jaxrs", "NoPublicConstructors");
        JakartaForJavaAssert.assertJavaDiagnostics(diagnosticsParams, IJDT_UTILS, d1, d2);
        String newText1 = "public NoPublicConstructorProviderClass() {\n\t}\n\n\t";
        String newText2 = "public";
        JakartaJavaCodeActionParams codeActionParams = JakartaForJavaAssert.createCodeActionParams(uri, d1);
        TextEdit te1 = JakartaForJavaAssert.te(19, 4, 19, 4, newText1);
        TextEdit te2 = JakartaForJavaAssert.te(19, 4, 19, 11, newText2);
        CodeAction ca1 = JakartaForJavaAssert.ca(uri, "Add a default 'public' constructor to this class", d1, te1);
        CodeAction ca2 = JakartaForJavaAssert.ca(uri, "Make constructor public", d1, te2);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams, IJDT_UTILS, ca1, ca2);
        JakartaJavaCodeActionParams codeActionParams2 = JakartaForJavaAssert.createCodeActionParams(uri, d2);
        TextEdit te3 = JakartaForJavaAssert.te(19, 4, 19, 4, newText1);
        TextEdit te4 = JakartaForJavaAssert.te(23, 4, 23, 13, newText2);
        CodeAction ca3 = JakartaForJavaAssert.ca(uri, "Add a default 'public' constructor to this class", d2, te3);
        CodeAction ca4 = JakartaForJavaAssert.ca(uri, "Make constructor public", d2, te4);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams2, IJDT_UTILS, ca3, ca4);
    }
}

