/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.completion;

import com.google.gson.JsonPrimitive;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.operations.completion.LSCompletionProposal;
import org.eclipse.lsp4e.test.completion.AbstractCompletionTest;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockConnectionProvider;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4e.ui.UI;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.InsertTextMode;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.FieldSource;

public class CompleteCompletionTest
extends AbstractCompletionTest {
    public static List<Arguments> testComplexSnippets = List.of(Arguments.arguments((Object[])new Object[]{"$TM_LINE_NUMBER - \\$TM_LINE_NUMBER - ${TM_LINE_NUMBER} - \\${TM_LINE_NUMBER}", "1 - $TM_LINE_NUMBER - 1 - ${TM_LINE_NUMBER}", "", 0, 0}), Arguments.arguments((Object[])new Object[]{"${TM_SELECTED_TEXT:defaultval}", "defaultval", "", 0, 0}), Arguments.arguments((Object[])new Object[]{"\\$1 and \\$", "$1 and $", "", 0, 0}), Arguments.arguments((Object[])new Object[]{"\\\\$1 and ${3:foo}", "\\ and foo", "", 0, 0}), Arguments.arguments((Object[])new Object[]{"${2|a\\,b\\},c|}", "a,b}", "", 0, 0}), Arguments.arguments((Object[])new Object[]{"${1:$TM_CURRENT_WORD}", "xx abcabc yy", "xx abc yy", 3, 0}), Arguments.arguments((Object[])new Object[]{"${1:$TM_CURRENT_WORD}", "xx aabcbc yy", "xx abc yy", 4, 0}), Arguments.arguments((Object[])new Object[]{"${1:$TM_CURRENT_WORD}", "xx aabc yy", "xx abc yy", 4, 2}), Arguments.arguments((Object[])new Object[]{"$", "$", "", 0, 0}), Arguments.arguments((Object[])new Object[]{"${", "${", "", 0, 0}), Arguments.arguments((Object[])new Object[]{"$$", "$$", "", 0, 0}), Arguments.arguments((Object[])new Object[]{"$$TM_LINE_NUMBER", "$1", "", 0, 0}), Arguments.arguments((Object[])new Object[]{"${VARIABLE", "${VARIABLE", "", 0, 0}), Arguments.arguments((Object[])new Object[]{"${VARIABLE:", "${VARIABLE:", "", 0, 0}), Arguments.arguments((Object[])new Object[]{"${VARIABLE:foo", "${VARIABLE:foo", "", 0, 0}), Arguments.arguments((Object[])new Object[]{"${1|a", "${1|a", "", 0, 0}), Arguments.arguments((Object[])new Object[]{"${1|a,}", "${1|a,}", "", 0, 0}));

    @Test
    public void testAssistForUnknownButConnectedType() throws CoreException {
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        items.add(this.createCompletionItem("FirstClass", CompletionItemKind.Class));
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(false, items));
        IFile testFile = TestUtils.createUniqueTestFileOfUnknownType(this.project, "");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        LanguageServersRegistry.LanguageServerDefinition serverDefinition = LanguageServersRegistry.getInstance().getDefinition("org.eclipse.lsp4e.test.server");
        Assertions.assertNotNull((Object)serverDefinition);
        LanguageServerWrapper lsWrapper = LanguageServiceAccessor.getLSWrapper((IProject)testFile.getProject(), (LanguageServersRegistry.LanguageServerDefinition)serverDefinition);
        URI fileLocation = testFile.getLocationURI();
        lsWrapper.connect(null, testFile);
        TestUtils.waitForAndAssertCondition(3000, () -> lsWrapper.isConnectedTo(fileLocation));
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, 0);
        Assertions.assertEquals((int)items.size(), (int)proposals.length);
        LSCompletionProposal lsCompletionProposal = (LSCompletionProposal)proposals[0];
        lsCompletionProposal.apply(viewer, '\n', 0, 0);
        Assertions.assertEquals((Object)new Point("FirstClass".length(), 0), (Object)lsCompletionProposal.getSelection(viewer.getDocument()));
    }

    @Test
    public void testNoPrefix() throws CoreException {
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        items.add(this.createCompletionItem("FirstClass", CompletionItemKind.Class));
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(false, items));
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, 0);
        Assertions.assertEquals((int)items.size(), (int)proposals.length);
        LSCompletionProposal lsCompletionProposal = (LSCompletionProposal)proposals[0];
        lsCompletionProposal.apply(viewer, '\n', 0, 0);
        Assertions.assertEquals((Object)new Point("FirstClass".length(), 0), (Object)lsCompletionProposal.getSelection(viewer.getDocument()));
    }

    @Test
    public void testPrefix() throws CoreException {
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        items.add(this.createCompletionItem("FirstClass", CompletionItemKind.Class));
        items.add(this.createCompletionItem("SecondClass", CompletionItemKind.Class));
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(false, items));
        String content = "First";
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, "First"));
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, "First".length());
        Assertions.assertEquals((int)1, (int)proposals.length);
        LSCompletionProposal lsCompletionProposal = (LSCompletionProposal)proposals[0];
        lsCompletionProposal.apply(viewer, '\n', 0, 0);
        Assertions.assertEquals((Object)new Point("FirstClass".length(), 0), (Object)lsCompletionProposal.getSelection(viewer.getDocument()));
    }

    @Test
    public void testCommandExecution() throws CoreException, InterruptedException, ExecutionException, TimeoutException {
        CompletionItem completionItem = this.createCompletionItem("Bla", CompletionItemKind.Class);
        String expectedParameter = "command execution parameter";
        List<String> commandArguments = List.of("command execution parameter");
        completionItem.setCommand(new Command("TestCommand", "mock.command", commandArguments));
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(false, List.of(completionItem)));
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, ""));
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, 0);
        Assertions.assertEquals((int)1, (int)proposals.length);
        LSCompletionProposal lsCompletionProposal = (LSCompletionProposal)proposals[0];
        lsCompletionProposal.apply(viewer, '\n', 0, 0);
        ExecuteCommandParams executedCommand = (ExecuteCommandParams)MockLanguageServer.INSTANCE.getWorkspaceService().getExecutedCommand().get(2L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)"mock.command", (Object)executedCommand.getCommand());
        List<JsonPrimitive> expectedParameterList = List.of(new JsonPrimitive("command execution parameter"));
        Assertions.assertEquals(expectedParameterList, (Object)executedCommand.getArguments());
    }

    @Test
    public void testPrefixCaseSensitivity() throws CoreException {
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        items.add(this.createCompletionItem("FirstClass", CompletionItemKind.Class));
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(false, items));
        String content = "FIRST";
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, "FIRST"));
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, "FIRST".length());
        Assertions.assertEquals((int)1, (int)proposals.length);
        LSCompletionProposal lsCompletionProposal = (LSCompletionProposal)proposals[0];
        lsCompletionProposal.apply(viewer, '\n', 0, 0);
        Assertions.assertEquals((Object)new Point("FirstClass".length(), 0), (Object)lsCompletionProposal.getSelection(viewer.getDocument()));
    }

    @Test
    public void testPrefixCaseSensitivityWithoutTextEdit() throws CoreException {
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        items.add(this.createCompletionItemWithoutTextEdit("FirstClass", CompletionItemKind.Class));
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(false, items));
        String content = "FIRST";
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, "FIRST"));
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, "FIRST".length());
        Assertions.assertEquals((int)1, (int)proposals.length);
        LSCompletionProposal lsCompletionProposal = (LSCompletionProposal)proposals[0];
        lsCompletionProposal.apply(viewer, '\n', 0, 0);
        Assertions.assertEquals((Object)new Point("FirstClass".length(), 0), (Object)lsCompletionProposal.getSelection(viewer.getDocument()));
        Assertions.assertEquals((Object)"FirstClass", (Object)viewer.getDocument().get());
    }

    @Test
    public void testPrefixCaseSensitivityWithoutTextEditAtOffset() throws CoreException {
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        items.add(this.createCompletionItemWithoutTextEdit("FirstClass", CompletionItemKind.Class));
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(false, items));
        String content = "FIRST";
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, "FIRST"));
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, "FIRST".length());
        Assertions.assertEquals((int)1, (int)proposals.length);
        LSCompletionProposal lsCompletionProposal = (LSCompletionProposal)proposals[0];
        lsCompletionProposal.apply(viewer, '\n', 0, 4);
        Assertions.assertEquals((Object)new Point("FirstClass".length(), 0), (Object)lsCompletionProposal.getSelection(viewer.getDocument()));
        Assertions.assertEquals((Object)"FirstClass", (Object)viewer.getDocument().get());
    }

    @Test
    public void testCompleteOnFileEnd() throws CoreException {
        CompletionItem item = new CompletionItem();
        item.setLabel("1024M");
        item.setKind(CompletionItemKind.Value);
        item.setTextEdit(Either.forLeft((Object)new TextEdit(new Range(new Position(2, 10), new Position(2, 10)), "1024M")));
        CompletionList completionList = new CompletionList(false, List.of(item));
        MockLanguageServer.INSTANCE.setCompletionList(completionList);
        String content = "applications:\n- name: hello\n  memory: ";
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, "applications:\n- name: hello\n  memory: "));
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, "applications:\n- name: hello\n  memory: ".length());
        Assertions.assertEquals((int)1, (int)proposals.length);
        LSCompletionProposal lsCompletionProposal = (LSCompletionProposal)proposals[0];
        lsCompletionProposal.apply(viewer, '\n', 0, "applications:\n- name: hello\n  memory: ".length());
        Assertions.assertEquals((Object)"applications:\n- name: hello\n  memory: 1024M", (Object)viewer.getDocument().get());
        Assertions.assertEquals((Object)new Point(viewer.getDocument().getLength(), 0), (Object)lsCompletionProposal.getSelection(viewer.getDocument()));
    }

    @Test
    public void testTriggerCharsWithoutPreliminaryCompletion() throws CoreException {
        Set<String> triggers = Set.of("a", "b");
        MockLanguageServer.INSTANCE.setCompletionTriggerChars(triggers);
        String content = "First";
        TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, "First"));
        TestUtils.waitForAndAssertCondition(3000, () -> Arrays.equals(new char[]{'a', 'b'}, this.contentAssistProcessor.getCompletionProposalAutoActivationCharacters()));
    }

    @Test
    public void testTriggerCharsNullList() throws CoreException {
        MockLanguageServer.INSTANCE.setCompletionTriggerChars(null);
        TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, "First"));
        Assertions.assertArrayEquals((char[])new char[0], (char[])this.contentAssistProcessor.getCompletionProposalAutoActivationCharacters());
    }

    @Test
    public void testApplyCompletionWithPrefix() throws CoreException {
        Range range = new Range(new Position(0, 0), new Position(0, 5));
        List<CompletionItem> items = List.of(this.createCompletionItem("FirstClass", CompletionItemKind.Class, range));
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(false, items));
        String content = "First";
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, "First"));
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, "First".length());
        LSCompletionProposal lsCompletionProposal = (LSCompletionProposal)proposals[0];
        lsCompletionProposal.apply(viewer, '\n', 0, "First".length());
        Assertions.assertEquals((Object)true, (Object)viewer.getDocument().get().equals("FirstClass"));
        Assertions.assertEquals((Object)new Point(viewer.getDocument().getLength(), 0), (Object)lsCompletionProposal.getSelection(viewer.getDocument()));
    }

    @Test
    public void testApplyCompletionReplace() throws CoreException {
        Range range = new Range(new Position(0, 0), new Position(0, 20));
        List<CompletionItem> items = List.of(this.createCompletionItem("FirstClass", CompletionItemKind.Class, range));
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(false, items));
        String content = "FirstNotMatchedLabel";
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, "FirstNotMatchedLabel"));
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, 5);
        LSCompletionProposal lsCompletionProposal = (LSCompletionProposal)proposals[0];
        lsCompletionProposal.apply(viewer, '\n', 0, 5);
        Assertions.assertEquals((Object)"FirstClass", (Object)viewer.getDocument().get());
        Assertions.assertEquals((Object)new Point("FirstClass".length(), 0), (Object)lsCompletionProposal.getSelection(viewer.getDocument()));
    }

    @Test
    public void testApplyCompletionReplaceAndTypingWithTextEdit() throws CoreException, BadLocationException {
        Range range = new Range(new Position(0, 0), new Position(0, 20));
        List<CompletionItem> items = List.of(this.createCompletionItem("FirstClass", CompletionItemKind.Class, range));
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(false, items));
        String content = "FirstNotMatchedLabel";
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, "FirstNotMatchedLabel"));
        int invokeOffset = 5;
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, invokeOffset);
        LSCompletionProposal lsCompletionProposal = (LSCompletionProposal)proposals[0];
        viewer.getDocument().replace(5, 0, "No");
        lsCompletionProposal.apply(viewer, '\n', 0, invokeOffset + "No".length());
        Assertions.assertEquals((Object)"FirstClass", (Object)viewer.getDocument().get());
        Assertions.assertEquals((Object)new Point("FirstClass".length(), 0), (Object)lsCompletionProposal.getSelection(viewer.getDocument()));
    }

    @Test
    public void testApplyCompletionReplaceAndTyping() throws CoreException, BadLocationException {
        CompletionItem item = new CompletionItem("strncasecmp");
        item.setKind(CompletionItemKind.Function);
        item.setInsertText("strncasecmp()");
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(false, List.of(item)));
        String content = "str";
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, "str"));
        int invokeOffset = "str".length();
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, invokeOffset);
        Assertions.assertEquals((int)1, (int)proposals.length);
        LSCompletionProposal lsCompletionProposal = (LSCompletionProposal)proposals[0];
        viewer.getDocument().replace("str".length(), 0, "nc");
        lsCompletionProposal.apply(viewer, '\u0000', 0, invokeOffset + "nc".length());
        Assertions.assertEquals((Object)item.getInsertText(), (Object)viewer.getDocument().get());
        Assertions.assertEquals((Object)new Point(item.getInsertText().length(), 0), (Object)lsCompletionProposal.getSelection(viewer.getDocument()));
    }

    @Test
    public void testCompletionReplace() throws CoreException {
        IFile file = TestUtils.createUniqueTestFile(this.project, "line1\nlineInsertHere");
        ITextViewer viewer = TestUtils.openTextViewer(file);
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(false, List.of(this.createCompletionItem("Inserted", CompletionItemKind.Text, new Range(new Position(1, 4), new Position(1, 4 + "InsertHere".length()))))));
        int invokeOffset = viewer.getDocument().getLength() - "InsertHere".length();
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, invokeOffset);
        LSCompletionProposal lsCompletionProposal = (LSCompletionProposal)proposals[0];
        lsCompletionProposal.apply(viewer, '\n', 0, invokeOffset);
        Assertions.assertEquals((Object)"line1\nlineInserted", (Object)viewer.getDocument().get());
        Assertions.assertEquals((Object)new Point(viewer.getDocument().getLength(), 0), (Object)lsCompletionProposal.getSelection(viewer.getDocument()));
    }

    @Test
    public void testItemOrdering() throws Exception {
        Range range = new Range(new Position(0, 0), new Position(0, 1));
        List<CompletionItem> items = List.of(this.createCompletionItem("AA", CompletionItemKind.Class, range), this.createCompletionItem("AB", CompletionItemKind.Class, range), this.createCompletionItem("BA", CompletionItemKind.Class, range), this.createCompletionItem("BB", CompletionItemKind.Class, range), this.createCompletionItem("CB", CompletionItemKind.Class, range), this.createCompletionItem("CC", CompletionItemKind.Class, range));
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(false, items));
        String content = "B";
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, "B"));
        int invokeOffset = 1;
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, invokeOffset);
        Assertions.assertEquals((int)4, (int)proposals.length);
        Assertions.assertEquals((Object)"BA", (Object)proposals[0].getDisplayString());
        Assertions.assertEquals((Object)"BB", (Object)proposals[1].getDisplayString());
        Assertions.assertEquals((Object)"AB", (Object)proposals[2].getDisplayString());
        Assertions.assertEquals((Object)"CB", (Object)proposals[3].getDisplayString());
        ((LSCompletionProposal)proposals[0]).apply(viewer, '\n', 0, invokeOffset);
        Assertions.assertEquals((Object)"BA", (Object)viewer.getDocument().get());
    }

    @Test
    public void testBasicSnippet() throws CoreException {
        CompletionItem completionItem = this.createCompletionItem("$1 and ${2:foo}", CompletionItemKind.Class, new Range(new Position(0, 0), new Position(0, 1)));
        completionItem.setInsertTextFormat(InsertTextFormat.Snippet);
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(false, List.of(completionItem)));
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, ""));
        int invokeOffset = 0;
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, invokeOffset);
        Assertions.assertEquals((int)1, (int)proposals.length);
        ((LSCompletionProposal)proposals[0]).apply(viewer, '\n', 0, invokeOffset);
        Assertions.assertEquals((Object)" and foo", (Object)viewer.getDocument().get());
    }

    @Test
    public void testChoiceSnippet() throws CoreException {
        CompletionItem completionItem = this.createCompletionItem("1${1|a,b|}2", CompletionItemKind.Class);
        completionItem.setInsertTextFormat(InsertTextFormat.Snippet);
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(false, List.of(completionItem)));
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, ""));
        int invokeOffset = 0;
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, invokeOffset);
        Assertions.assertEquals((int)1, (int)proposals.length);
        Set<Shell> shellsBefore = Set.of(viewer.getTextWidget().getDisplay().getShells());
        ((LSCompletionProposal)proposals[0]).apply(viewer, '\n', 0, invokeOffset);
        Assertions.assertEquals((Object)"1a2", (Object)viewer.getDocument().get());
        Set<Shell> shellsAfter = Set.of(viewer.getTextWidget().getDisplay().getShells());
        List<Shell> shellsAdded = shellsAfter.stream().filter(shell -> !shellsBefore.contains(shell)).toList();
        Assertions.assertFalse((boolean)shellsAdded.isEmpty());
        Table proposalList = (Table)shellsAdded.iterator().next().getChildren()[0];
        Object[] itemLabels = (String[])Arrays.stream(proposalList.getItems()).map(TableItem::getText).toArray(String[]::new);
        Assertions.assertArrayEquals((Object[])new String[]{"a", "b"}, (Object[])itemLabels);
    }

    @Test
    public void testDuplicateVariable() throws CoreException {
        CompletionItem completionItem = this.createCompletionItem("${1:foo} and ${1:foo}", CompletionItemKind.Class, new Range(new Position(0, 0), new Position(0, 1)));
        completionItem.setInsertTextFormat(InsertTextFormat.Snippet);
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(false, List.of(completionItem)));
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, ""));
        int invokeOffset = 0;
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, invokeOffset);
        Assertions.assertEquals((int)1, (int)proposals.length);
        ((LSCompletionProposal)proposals[0]).apply(viewer, '\n', 0, invokeOffset);
        Assertions.assertEquals((Object)"foo and foo", (Object)viewer.getDocument().get());
        viewer.getTextWidget().insert("a");
        Assertions.assertEquals((Object)"a and a", (Object)viewer.getDocument().get());
    }

    @ParameterizedTest
    @FieldSource
    public void testComplexSnippets(String completion, String expected, String fileContent, int caretPos, int selectionLen) throws CoreException {
        CompletionItem completionItem = this.createCompletionItem(completion, CompletionItemKind.Snippet, new Range(new Position(0, caretPos), new Position(0, caretPos + selectionLen)));
        completionItem.setInsertTextFormat(InsertTextFormat.Snippet);
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(false, List.of(completionItem)));
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, fileContent));
        viewer.setSelectedRange(caretPos, selectionLen);
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, caretPos);
        Assertions.assertEquals((int)1, (int)proposals.length, (String)"Unexpected proposals length");
        ((LSCompletionProposal)proposals[0]).apply(viewer, '\n', 0, caretPos);
        Assertions.assertEquals((Object)expected, (Object)viewer.getDocument().get(), (String)"Unexpected result");
    }

    @Test
    public void testSnippetTabStops() throws CoreException {
        CompletionItem completionItem = this.createCompletionItem("sum(${1:x}, ${2:y})", CompletionItemKind.Method, new Range(new Position(0, 0), new Position(0, 1)));
        completionItem.setInsertTextFormat(InsertTextFormat.Snippet);
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(false, List.of(completionItem)));
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, ""));
        int invokeOffset = 0;
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, invokeOffset);
        Assertions.assertEquals((int)1, (int)proposals.length);
        ((LSCompletionProposal)proposals[0]).apply(viewer, '\n', 0, invokeOffset);
        Assertions.assertEquals((Object)"sum(x, y)", (Object)viewer.getDocument().get());
        Point range = proposals[0].getSelection(viewer.getDocument());
        Assertions.assertEquals((int)4, (int)range.x);
        Assertions.assertEquals((int)1, (int)range.y);
        Event event = new Event();
        event.character = (char)9;
        viewer.getTextWidget().notifyListeners(3005, event);
        range = viewer.getSelectedRange();
        Assertions.assertEquals((int)7, (int)range.x);
        Assertions.assertEquals((int)1, (int)range.y);
    }

    @Test
    public void testMultipleLS() throws Exception {
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        items.add(this.createCompletionItem("FirstClass", CompletionItemKind.Class));
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(false, items));
        IFile testFile = TestUtils.createUniqueTestFileMultiLS(this.project, "");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, 0);
        Assertions.assertEquals((long)(2L * (long)items.size()), (long)proposals.length);
    }

    @Test
    public void testReopeningFileAndReusingContentAssist() throws CoreException {
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        items.add(this.createCompletionItem("FirstClass", CompletionItemKind.Class));
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(false, items));
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, 0);
        Assertions.assertEquals((int)items.size(), (int)proposals.length);
        LSCompletionProposal lsCompletionProposal = (LSCompletionProposal)proposals[0];
        lsCompletionProposal.apply(viewer, '\n', 0, 0);
        Assertions.assertEquals((Object)new Point("FirstClass".length(), 0), (Object)lsCompletionProposal.getSelection(viewer.getDocument()));
        UI.getActivePage().closeAllEditors(false);
        MockLanguageServer.reset();
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(false, items));
        viewer = TestUtils.openTextViewer(testFile);
        proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, 0);
        Assertions.assertEquals((int)items.size(), (int)proposals.length);
        lsCompletionProposal = (LSCompletionProposal)proposals[0];
        lsCompletionProposal.apply(viewer, '\n', 0, 0);
        Assertions.assertEquals((Object)new Point("FirstClass".length(), 0), (Object)lsCompletionProposal.getSelection(viewer.getDocument()));
    }

    @Test
    public void testFilterNonmatchingCompletions() throws Exception {
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        CompletionItem item = new CompletionItem("server.web");
        item.setFilterText("server.web");
        item.setTextEdit(Either.forLeft((Object)new TextEdit(new Range(new Position(0, 0), new Position(0, 10)), item.getFilterText())));
        items.add(item);
        item = new CompletionItem("soup");
        item.setFilterText("soup");
        item.setTextEdit(Either.forLeft((Object)new TextEdit(new Range(new Position(0, 3), new Position(0, 7)), item.getFilterText())));
        items.add(item);
        items.add(new CompletionItem(": 1.0.1"));
        items.add(new CompletionItem("s.Status"));
        this.confirmCompletionResults(items, "server", (Integer)6, new String[]{"server.web", ": 1.0.1", "s.Status"});
    }

    @Test
    public void testFilterNonmatchingCompletionsMovieOffset() throws Exception {
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "servers");
        IDocument document = TestUtils.openTextViewer(testFile).getDocument();
        LanguageServerWrapper wrapper = (LanguageServerWrapper)LanguageServiceAccessor.getLSWrappers((IFile)testFile, capabilities -> capabilities.getCompletionProvider() != null || capabilities.getSignatureHelpProvider() != null).get(0);
        LSCompletionProposal completionProposal = new LSCompletionProposal(document, 0, new CompletionItem(": 1.0.1"), wrapper);
        Assertions.assertTrue((boolean)completionProposal.isValidFor(document, 6));
        Assertions.assertFalse((boolean)completionProposal.isValidFor(document, 7));
    }

    @Test
    public void testAdjustIndentation() throws Exception {
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, "a\n\tb\n\t\nc"));
        CompletionItem item = new CompletionItem("line1\nline2");
        item.setInsertTextMode(InsertTextMode.AdjustIndentation);
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(false, List.of(item)));
        int invokeOffset = 6;
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, invokeOffset);
        Assertions.assertEquals((int)1, (int)proposals.length);
        ((LSCompletionProposal)proposals[0]).apply(viewer, '\n', 0, invokeOffset);
        Assertions.assertEquals((Object)"a\n\tb\n\tline1\n\tline2\nc", (Object)viewer.getDocument().get());
    }

    @Test
    public void testAdjustIndentationIsDefault() throws Exception {
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, "a\n\tb\n\t\nc"));
        CompletionItem item = new CompletionItem("line1\nline2");
        item.setInsertTextMode(null);
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(false, List.of(item)));
        int invokeOffset = 6;
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, invokeOffset);
        Assertions.assertEquals((int)1, (int)proposals.length);
        ((LSCompletionProposal)proposals[0]).apply(viewer, '\n', 0, invokeOffset);
        Assertions.assertEquals((Object)"a\n\tb\n\tline1\n\tline2\nc", (Object)viewer.getDocument().get());
    }

    @Test
    public void testAdjustIndentationWithPrefixInLine() throws Exception {
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, "a\n\tb\n\tprefix\nc"));
        CompletionItem item = new CompletionItem("line1\n\tline2\nline3");
        item.setInsertTextMode(InsertTextMode.AdjustIndentation);
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(false, List.of(item)));
        int invokeOffset = 12;
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, invokeOffset);
        Assertions.assertEquals((int)1, (int)proposals.length);
        ((LSCompletionProposal)proposals[0]).apply(viewer, '\n', 0, invokeOffset);
        Assertions.assertEquals((Object)"a\n\tb\n\tprefixline1\n\t\tline2\n\tline3\nc", (Object)viewer.getDocument().get());
    }

    @Test
    public void testCancellation() throws Exception {
        MockConnectionProvider.cancellations.clear();
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, "a\n\tb\n\t\nc"));
        CompletionItem item = new CompletionItem("a");
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(false, List.of(item)));
        MockLanguageServer.INSTANCE.setTimeToProceedQueries(10000L);
        CompletableFuture.runAsync(() -> {
            ICompletionProposal[] iCompletionProposalArray = this.contentAssistProcessor.computeCompletionProposals(viewer, 1);
        });
        Thread.sleep(500L);
        CompletableFuture.runAsync(() -> {
            ICompletionProposal[] iCompletionProposalArray = this.contentAssistProcessor.computeCompletionProposals(viewer, 1);
        });
        DisplayHelper.waitAndAssertCondition((Display)viewer.getTextWidget().getDisplay(), () -> Assertions.assertEquals((int)1, (int)MockConnectionProvider.cancellations.size()));
    }

    @Test
    public void testContextInformationPositionUsesEditRangeStart() throws CoreException {
        int editOffset = 2;
        CompletionItem completionItem = this.createCompletionItem("hello", CompletionItemKind.Text, new Range(new Position(0, 2), new Position(0, 3)));
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(true, List.of(completionItem)));
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, "ABCDE"));
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, 2);
        Assertions.assertEquals((int)1, (int)proposals.length);
        int pos = ((LSCompletionProposal)proposals[0]).getContextInformationPosition();
        Assertions.assertEquals((int)2, (int)pos);
    }

    @Test
    public void testVariablesUseViewerLineNotEditRange() throws CoreException {
        CompletionItem completionItem = this.createCompletionItem("$TM_LINE_INDEX $TM_LINE_NUMBER $TM_CURRENT_LINE", CompletionItemKind.Snippet, new Range(new Position(2, 0), new Position(2, 5)));
        completionItem.setInsertTextFormat(InsertTextFormat.Snippet);
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(true, List.of(completionItem)));
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, "line0\nline1\nline2"));
        viewer.setSelectedRange(0, 0);
        int editOffset = viewer.getDocument().get().indexOf("line2");
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, editOffset);
        Assertions.assertEquals((int)1, (int)proposals.length);
        ((LSCompletionProposal)proposals[0]).apply(viewer, '\n', 0, editOffset);
        Assertions.assertEquals((Object)"0 1 line0", (Object)viewer.getDocument().get().split("\n")[2]);
    }
}

