/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.debug.breakpoints;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.LineBreakpoint;

public class DSPLineBreakpoint
extends LineBreakpoint {
    public static final String ID = "org.eclipse.lsp4e.debug.breakpoints.markerType.lineBreakpoint";

    public DSPLineBreakpoint() {
    }

    public DSPLineBreakpoint(IResource resource, int lineNumber) throws CoreException {
        this.run(this.getMarkerRule(resource), monitor -> {
            IMarker marker = resource.createMarker(ID);
            this.setMarker(marker);
            marker.setAttribute("org.eclipse.debug.core.enabled", (Object)Boolean.TRUE);
            marker.setAttribute("lineNumber", lineNumber);
            marker.setAttribute("org.eclipse.debug.core.id", (Object)this.getModelIdentifier());
            marker.setAttribute("message", (Object)(resource.getName() + " [line: " + lineNumber + "]"));
        });
    }

    public DSPLineBreakpoint(IResource resource, String fileName, int lineNumber) throws CoreException {
        this.run(this.getMarkerRule(resource), monitor -> {
            IMarker marker = resource.createMarker(ID);
            this.setMarker(marker);
            marker.setAttribute("org.eclipse.debug.core.enabled", (Object)Boolean.TRUE);
            marker.setAttribute("lineNumber", lineNumber);
            marker.setAttribute("org.eclipse.debug.core.id", (Object)this.getModelIdentifier());
            marker.setAttribute("message", (Object)(resource.getName() + " [line: " + lineNumber + "]"));
        });
    }

    public String getModelIdentifier() {
        return "org.eclipse.lsp4e.debug.model";
    }
}

