/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.highlight;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.test.utils.AbstractTestWithProject;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentHighlightKind;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class HighlightTest
extends AbstractTestWithProject {
    @Test
    public void testHighlight() throws CoreException {
        this.checkGenericEditorVersion();
        MockLanguageServer.INSTANCE.setDocumentHighlights(Map.ofEntries(Map.entry(new Position(0, 1), List.of(new DocumentHighlight(new Range(new Position(0, 2), new Position(0, 6)), DocumentHighlightKind.Read), new DocumentHighlight(new Range(new Position(0, 7), new Position(0, 12)), DocumentHighlightKind.Write), new DocumentHighlight(new Range(new Position(0, 13), new Position(0, 17)), DocumentHighlightKind.Text)))));
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "  READ WRITE TEXT");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        if (viewer instanceof ISourceViewer) {
            ISourceViewer sourceViewer = (ISourceViewer)viewer;
            IAnnotationModel annotationModel = sourceViewer.getAnnotationModel();
            sourceViewer.getTextWidget().setCaretOffset(1);
            TestUtils.waitForAndAssertCondition(3000, () -> {
                this.assertAnnotationExists(annotationModel, "org.eclipse.lsp4e.read", 2, 4);
                this.assertAnnotationExists(annotationModel, "org.eclipse.lsp4e.write", 7, 5);
                this.assertAnnotationExists(annotationModel, "org.eclipse.lsp4e.text", 13, 4);
                return true;
            });
        } else {
            Assert.fail((String)("ISourceViewer expected but got: " + String.valueOf(viewer)));
        }
    }

    @Test
    public void testCheckIfOtherAnnotationsRemains() throws CoreException {
        this.checkGenericEditorVersion();
        MockLanguageServer.INSTANCE.setDocumentHighlights(Map.ofEntries(Map.entry(new Position(0, 1), List.of(new DocumentHighlight(new Range(new Position(0, 2), new Position(0, 6)), DocumentHighlightKind.Read)))));
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "  READ WRITE TEXT");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        if (viewer instanceof ISourceViewer) {
            ISourceViewer sourceViewer = (ISourceViewer)viewer;
            IAnnotationModel annotationModel = sourceViewer.getAnnotationModel();
            String fakeAnnotationType = "FAKE_TYPE";
            Annotation fakeAnnotation = new Annotation("FAKE_TYPE", false, null);
            org.eclipse.jface.text.Position fakeAnnotationPosition = new org.eclipse.jface.text.Position(0, 10);
            annotationModel.addAnnotation(fakeAnnotation, fakeAnnotationPosition);
            viewer.getTextWidget().setCaretOffset(1);
            TestUtils.waitForAndAssertCondition(3000, () -> {
                this.assertAnnotationExists(annotationModel, "org.eclipse.lsp4e.read", 2, 4);
                this.assertAnnotationExists(annotationModel, "FAKE_TYPE", position.offset, position.length);
                return true;
            });
        }
    }

    @Test
    public void testHighlightsInMultipleViewersForOneSource() throws CoreException {
        this.checkGenericEditorVersion();
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "ONE\nTWO");
        MockLanguageServer.INSTANCE.setDocumentHighlights(Map.ofEntries(Map.entry(new Position(0, 1), List.of(new DocumentHighlight(new Range(new Position(0, 0), new Position(0, 3)), DocumentHighlightKind.Write))), Map.entry(new Position(1, 1), List.of(new DocumentHighlight(new Range(new Position(1, 0), new Position(1, 3)), DocumentHighlightKind.Write)))));
        ISourceViewer viewer1 = (ISourceViewer)TestUtils.openTextViewer(testFile);
        IAnnotationModel annotationModel1 = viewer1.getAnnotationModel();
        viewer1.getTextWidget().setCaretOffset(1);
        TestUtils.waitForAndAssertCondition(3000, () -> {
            this.assertAnnotationExists(annotationModel1, "org.eclipse.lsp4e.write", 0, 3);
            return true;
        });
        List<IEditorReference> editorReferences = TestUtils.splitActiveEditor();
        ISourceViewer viewer2 = null;
        IEditorReference editorToClose = null;
        for (IEditorReference editorReference : editorReferences) {
            ISourceViewer viewer = (ISourceViewer)LSPEclipseUtils.getTextViewer((IEditorPart)editorReference.getEditor(false));
            if (viewer == viewer1) continue;
            editorToClose = editorReference;
            viewer2 = viewer;
            break;
        }
        Assert.assertNotNull(viewer2);
        Assert.assertNotNull(editorToClose);
        IAnnotationModel annotationModel2 = viewer2.getAnnotationModel();
        viewer2.getTextWidget().setCaretOffset(5);
        TestUtils.waitForAndAssertCondition(3000, () -> {
            this.assertAnnotationExists(annotationModel1, "org.eclipse.lsp4e.write", 0, 3);
            this.assertAnnotationExists(annotationModel1, "org.eclipse.lsp4e.write", 4, 3);
            this.assertAnnotationExists(annotationModel2, "org.eclipse.lsp4e.write", 0, 3);
            this.assertAnnotationExists(annotationModel2, "org.eclipse.lsp4e.write", 4, 3);
            return true;
        });
        TestUtils.closeEditor(editorToClose.getEditor(false), false);
        TestUtils.waitForAndAssertCondition(3000, () -> {
            this.assertAnnotationExists(annotationModel1, "org.eclipse.lsp4e.write", 0, 3);
            this.assertAnnotationDoesNotExist(annotationModel1, "org.eclipse.lsp4e.write", 4, 3);
            this.assertAnnotationExists(annotationModel2, "org.eclipse.lsp4e.write", 0, 3);
            this.assertAnnotationDoesNotExist(annotationModel2, "org.eclipse.lsp4e.write", 4, 3);
            return true;
        });
    }

    private void assertAnnotationExists(IAnnotationModel annotationModel, String annotationType, int posOffset, int posLen) {
        boolean[] hasAnnotation = new boolean[1];
        ArrayList annotations = new ArrayList();
        annotationModel.getAnnotationIterator().forEachRemaining(anno -> {
            org.eclipse.jface.text.Position annoPos = annotationModel.getPosition(anno);
            if (anno.getType().equals(annotationType) && annoPos.offset == posOffset && annoPos.length == posLen) {
                blArray[0] = true;
            }
            annotations.add("Annotation[type=" + anno.getType() + ", text=" + anno.getText() + ", offset=" + annoPos.offset + ", length=" + annoPos.length + "]");
        });
        if (!hasAnnotation[0]) {
            Assert.fail((String)("Annotation of type [" + annotationType + "] not found at position {offset=" + posOffset + " length=" + posLen + "}. Annotations found: " + String.valueOf(annotations)));
        }
    }

    private void assertAnnotationDoesNotExist(IAnnotationModel annotationModel, String annotationType, int posOffset, int posLen) {
        boolean[] hasAnnotation = new boolean[1];
        ArrayList annotations = new ArrayList();
        annotationModel.getAnnotationIterator().forEachRemaining(anno -> {
            org.eclipse.jface.text.Position annoPos = annotationModel.getPosition(anno);
            if (anno.getType().equals(annotationType) && annoPos.offset == posOffset && annoPos.length == posLen) {
                blArray[0] = true;
            }
            annotations.add("Annotation[type=" + anno.getType() + ", text=" + anno.getText() + ", offset=" + annoPos.offset + ", length=" + annoPos.length + "]");
        });
        if (hasAnnotation[0]) {
            Assert.fail((String)("Unexpected annotation of type [" + annotationType + "] found at position {offset=" + posOffset + " length=" + posLen + "}. Annotations found: " + String.valueOf(annotations)));
        }
    }

    private void checkGenericEditorVersion() {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.ui.genericeditor");
        Assume.assumeTrue((bundle.getVersion().compareTo(new Version(1, 1, 0)) >= 0 ? 1 : 0) != 0);
    }
}

