/**
 * Copyright (c) 2021, 2026 Contributors to the Eclipse Foundation
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.lsat.setting.teditor.ui.hover;

import distributions.EnumeratedDistribution;
import distributions.NormalDistribution;
import distributions.PertDistribution;
import distributions.TriangularDistribution;
import expressions.Declaration;
import expressions.Expression;
import java.math.BigDecimal;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.ui.editor.hover.html.DefaultEObjectHoverProvider;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import setting.PhysicalLocation;
import setting.impl.LocationSettingsMapEntryImpl;
import setting.impl.MotionArgumentsMapEntryImpl;
import setting.impl.MotionSettingsMapEntryImpl;
import timing.Array;
import timing.Scalar;

/**
 * Provides labels for a EObjects.
 * 
 * see http://www.eclipse.org/Xtext/documentation.html#labelProvider
 */
@SuppressWarnings("all")
public class SettingHoverProvider extends DefaultEObjectHoverProvider {
  @Override
  public String getFirstLine(final EObject o) {
    final EObject parent = o.eContainer();
    String _switchResult = null;
    boolean _matched = false;
    if (parent instanceof LocationSettingsMapEntryImpl) {
      _matched=true;
      _switchResult = ((LocationSettingsMapEntryImpl)parent).getKey().getName();
    }
    if (!_matched) {
      if (parent instanceof MotionSettingsMapEntryImpl) {
        _matched=true;
        _switchResult = ((MotionSettingsMapEntryImpl)parent).getKey().getName();
      }
    }
    if (!_matched) {
      if (parent instanceof MotionArgumentsMapEntryImpl) {
        _matched=true;
        _switchResult = ((MotionArgumentsMapEntryImpl)parent).getKey();
      }
    }
    if (!_matched) {
      _switchResult = super.getFirstLine(o);
    }
    final String def = _switchResult;
    final String value = this.toString(o);
    if ((value != null)) {
      return ((def + " = ") + value);
    }
    return def;
  }

  @Override
  public boolean hasHover(final EObject o) {
    return ((this.toString(o) != null) || super.hasHover(o));
  }

  private String toString(final EObject o) {
    String _switchResult = null;
    boolean _matched = false;
    if (o instanceof Declaration) {
      _matched=true;
      Expression _expression = ((Declaration)o).getExpression();
      String _string = null;
      if (_expression!=null) {
        _string=_expression.toString();
      }
      _switchResult = _string;
    }
    if (!_matched) {
      if (o instanceof PhysicalLocation) {
        _matched=true;
        BigDecimal _default = ((PhysicalLocation)o).getDefault();
        String _string = null;
        if (_default!=null) {
          _string=_default.toString();
        }
        _switchResult = _string;
      }
    }
    if (!_matched) {
      if (o instanceof Scalar) {
        _matched=true;
        _switchResult = ((Scalar)o).getValueExp().toString();
      }
    }
    if (!_matched) {
      if (o instanceof Array) {
        _matched=true;
        final Function1<Expression, String> _function = (Expression it) -> {
          return it.toString();
        };
        _switchResult = IterableExtensions.join(ListExtensions.<Expression, String>map(((Array)o).getValuesExp(), _function), (("[" + ",") + "]"));
      }
    }
    if (!_matched) {
      if (o instanceof TriangularDistribution) {
        _matched=true;
        BigDecimal _default = ((TriangularDistribution)o).getDefault();
        String _string = null;
        if (_default!=null) {
          _string=_default.toString();
        }
        _switchResult = _string;
      }
    }
    if (!_matched) {
      if (o instanceof PertDistribution) {
        _matched=true;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("{min=");
        BigDecimal _min = ((PertDistribution)o).getMin();
        _builder.append(_min);
        _builder.append(", max=");
        BigDecimal _max = ((PertDistribution)o).getMax();
        _builder.append(_max);
        _builder.append(", mode=");
        BigDecimal _mode = ((PertDistribution)o).getMode();
        _builder.append(_mode);
        _builder.append(", gamma=");
        BigDecimal _gamma = ((PertDistribution)o).getGamma();
        _builder.append(_gamma);
        _builder.append(", default=");
        BigDecimal _default = ((PertDistribution)o).getDefault();
        _builder.append(_default);
        _builder.append("}");
        _switchResult = _builder.toString();
      }
    }
    if (!_matched) {
      if (o instanceof NormalDistribution) {
        _matched=true;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("{mean=");
        BigDecimal _mean = ((NormalDistribution)o).getMean();
        _builder.append(_mean);
        _builder.append(", sd=");
        BigDecimal _sd = ((NormalDistribution)o).getSd();
        _builder.append(_sd);
        _builder.append(", default=");
        BigDecimal _default = ((NormalDistribution)o).getDefault();
        _builder.append(_default);
        _builder.append("}");
        _switchResult = _builder.toString();
      }
    }
    if (!_matched) {
      if (o instanceof EnumeratedDistribution) {
        _matched=true;
        final Function1<Expression, String> _function = (Expression it) -> {
          return it.toString();
        };
        _switchResult = IterableExtensions.join(ListExtensions.<Expression, String>map(((EnumeratedDistribution)o).getValuesExp(), _function), (("[" + ",") + "]"));
      }
    }
    if (!_matched) {
      if (o instanceof Expression) {
        _matched=true;
        BigDecimal _evaluate = ((Expression)o).evaluate();
        String _string = null;
        if (_evaluate!=null) {
          _string=_evaluate.toString();
        }
        _switchResult = _string;
      }
    }
    if (!_matched) {
      if (o instanceof EObject) {
        _matched=true;
        _switchResult = null;
      }
    }
    return _switchResult;
  }
}
