/**
 */
package trigonometry.util;

import expressions.AbstractElement;
import expressions.BigDecimalConstant;
import expressions.Expression;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;

import org.eclipse.emf.ecore.EObject;

import trigonometry.*;

/**
 * <!-- begin-user-doc -->
 * The <b>Adapter Factory</b> for the model.
 * It provides an adapter <code>createXXX</code> method for each class of the model.
 * <!-- end-user-doc -->
 * @see trigonometry.TrigonometryPackage
 * @generated
 */
public class TrigonometryAdapterFactory extends AdapterFactoryImpl
{
    /**
     * The cached model package.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected static TrigonometryPackage modelPackage;

    /**
     * Creates an instance of the adapter factory.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public TrigonometryAdapterFactory()
    {
        if (modelPackage == null)
        {
            modelPackage = TrigonometryPackage.eINSTANCE;
        }
    }

    /**
     * Returns whether this factory is applicable for the type of the object.
     * <!-- begin-user-doc -->
     * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
     * <!-- end-user-doc -->
     * @return whether this factory is applicable for the type of the object.
     * @generated
     */
    @Override
    public boolean isFactoryForType(Object object)
    {
        if (object == modelPackage)
        {
            return true;
        }
        if (object instanceof EObject)
        {
            return ((EObject)object).eClass().getEPackage() == modelPackage;
        }
        return false;
    }

    /**
     * The switch that delegates to the <code>createXXX</code> methods.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected TrigonometrySwitch<Adapter> modelSwitch =
        new TrigonometrySwitch<Adapter>()
        {
            @Override
            public Adapter caseTrigonometry(Trigonometry object)
            {
                return createTrigonometryAdapter();
            }
            @Override
            public Adapter caseTrigonometryOneInput(TrigonometryOneInput object)
            {
                return createTrigonometryOneInputAdapter();
            }
            @Override
            public Adapter caseTrigonometryTwoInputs(TrigonometryTwoInputs object)
            {
                return createTrigonometryTwoInputsAdapter();
            }
            @Override
            public Adapter caseSinExpression(SinExpression object)
            {
                return createSinExpressionAdapter();
            }
            @Override
            public Adapter caseCosExpression(CosExpression object)
            {
                return createCosExpressionAdapter();
            }
            @Override
            public Adapter caseTanExpression(TanExpression object)
            {
                return createTanExpressionAdapter();
            }
            @Override
            public Adapter caseAsinExpression(AsinExpression object)
            {
                return createAsinExpressionAdapter();
            }
            @Override
            public Adapter caseAcosExpression(AcosExpression object)
            {
                return createAcosExpressionAdapter();
            }
            @Override
            public Adapter caseAtanExpression(AtanExpression object)
            {
                return createAtanExpressionAdapter();
            }
            @Override
            public Adapter caseAtan2Expression(Atan2Expression object)
            {
                return createAtan2ExpressionAdapter();
            }
            @Override
            public Adapter casePiConstant(PiConstant object)
            {
                return createPiConstantAdapter();
            }
            @Override
            public Adapter caseAbstractElement(AbstractElement object)
            {
                return createAbstractElementAdapter();
            }
            @Override
            public Adapter caseExpression(Expression object)
            {
                return createExpressionAdapter();
            }
            @Override
            public Adapter caseBigDecimalConstant(BigDecimalConstant object)
            {
                return createBigDecimalConstantAdapter();
            }
            @Override
            public Adapter defaultCase(EObject object)
            {
                return createEObjectAdapter();
            }
        };

    /**
     * Creates an adapter for the <code>target</code>.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param target the object to adapt.
     * @return the adapter for the <code>target</code>.
     * @generated
     */
    @Override
    public Adapter createAdapter(Notifier target)
    {
        return modelSwitch.doSwitch((EObject)target);
    }


    /**
     * Creates a new adapter for an object of class '{@link trigonometry.Trigonometry <em>Trigonometry</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see trigonometry.Trigonometry
     * @generated
     */
    public Adapter createTrigonometryAdapter()
    {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link trigonometry.TrigonometryOneInput <em>One Input</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see trigonometry.TrigonometryOneInput
     * @generated
     */
    public Adapter createTrigonometryOneInputAdapter()
    {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link trigonometry.TrigonometryTwoInputs <em>Two Inputs</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see trigonometry.TrigonometryTwoInputs
     * @generated
     */
    public Adapter createTrigonometryTwoInputsAdapter()
    {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link trigonometry.SinExpression <em>Sin Expression</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see trigonometry.SinExpression
     * @generated
     */
    public Adapter createSinExpressionAdapter()
    {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link trigonometry.CosExpression <em>Cos Expression</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see trigonometry.CosExpression
     * @generated
     */
    public Adapter createCosExpressionAdapter()
    {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link trigonometry.TanExpression <em>Tan Expression</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see trigonometry.TanExpression
     * @generated
     */
    public Adapter createTanExpressionAdapter()
    {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link trigonometry.AsinExpression <em>Asin Expression</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see trigonometry.AsinExpression
     * @generated
     */
    public Adapter createAsinExpressionAdapter()
    {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link trigonometry.AcosExpression <em>Acos Expression</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see trigonometry.AcosExpression
     * @generated
     */
    public Adapter createAcosExpressionAdapter()
    {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link trigonometry.AtanExpression <em>Atan Expression</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see trigonometry.AtanExpression
     * @generated
     */
    public Adapter createAtanExpressionAdapter()
    {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link trigonometry.Atan2Expression <em>Atan2 Expression</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see trigonometry.Atan2Expression
     * @generated
     */
    public Adapter createAtan2ExpressionAdapter()
    {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link trigonometry.PiConstant <em>Pi Constant</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see trigonometry.PiConstant
     * @generated
     */
    public Adapter createPiConstantAdapter()
    {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link expressions.AbstractElement <em>Abstract Element</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see expressions.AbstractElement
     * @generated
     */
    public Adapter createAbstractElementAdapter()
    {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link expressions.Expression <em>Expression</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see expressions.Expression
     * @generated
     */
    public Adapter createExpressionAdapter()
    {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link expressions.BigDecimalConstant <em>Big Decimal Constant</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see expressions.BigDecimalConstant
     * @generated
     */
    public Adapter createBigDecimalConstantAdapter()
    {
        return null;
    }

    /**
     * Creates a new adapter for the default case.
     * <!-- begin-user-doc -->
     * This default implementation returns null.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @generated
     */
    public Adapter createEObjectAdapter()
    {
        return null;
    }

} //TrigonometryAdapterFactory
