/*
 * Copyright (c) 2021, 2026 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.lsat.external.api;

import org.eclipse.lsat.external.api.model.LsatData;

import com.google.gson.GsonBuilder;

public class ParseFromOpenApiFormat {

    private ParseFromOpenApiFormat() {
    }

    public static LsatData parse(String json) {
        var builder = new GsonBuilder();
        var gson = builder.create();
        var lsatData = gson.fromJson(json, LsatData.class);
        lsatData.resolveReferences(lsatData);
        return lsatData;
    }
}
