/**
 */
package trigonometry.util;

import expressions.AbstractElement;
import expressions.BigDecimalConstant;
import expressions.Expression;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.util.Switch;

import trigonometry.*;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see trigonometry.TrigonometryPackage
 * @generated
 */
public class TrigonometrySwitch<T> extends Switch<T>
{
    /**
     * The cached model package
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected static TrigonometryPackage modelPackage;

    /**
     * Creates an instance of the switch.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public TrigonometrySwitch()
    {
        if (modelPackage == null)
        {
            modelPackage = TrigonometryPackage.eINSTANCE;
        }
    }

    /**
     * Checks whether this is a switch for the given package.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param ePackage the package in question.
     * @return whether this is a switch for the given package.
     * @generated
     */
    @Override
    protected boolean isSwitchFor(EPackage ePackage)
    {
        return ePackage == modelPackage;
    }

    /**
     * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the first non-null result returned by a <code>caseXXX</code> call.
     * @generated
     */
    @Override
    protected T doSwitch(int classifierID, EObject theEObject)
    {
        switch (classifierID)
        {
            case TrigonometryPackage.TRIGONOMETRY:
            {
                Trigonometry trigonometry = (Trigonometry)theEObject;
                T result = caseTrigonometry(trigonometry);
                if (result == null) result = caseExpression(trigonometry);
                if (result == null) result = caseAbstractElement(trigonometry);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case TrigonometryPackage.TRIGONOMETRY_ONE_INPUT:
            {
                TrigonometryOneInput trigonometryOneInput = (TrigonometryOneInput)theEObject;
                T result = caseTrigonometryOneInput(trigonometryOneInput);
                if (result == null) result = caseTrigonometry(trigonometryOneInput);
                if (result == null) result = caseExpression(trigonometryOneInput);
                if (result == null) result = caseAbstractElement(trigonometryOneInput);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case TrigonometryPackage.TRIGONOMETRY_TWO_INPUTS:
            {
                TrigonometryTwoInputs trigonometryTwoInputs = (TrigonometryTwoInputs)theEObject;
                T result = caseTrigonometryTwoInputs(trigonometryTwoInputs);
                if (result == null) result = caseTrigonometry(trigonometryTwoInputs);
                if (result == null) result = caseExpression(trigonometryTwoInputs);
                if (result == null) result = caseAbstractElement(trigonometryTwoInputs);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case TrigonometryPackage.SIN_EXPRESSION:
            {
                SinExpression sinExpression = (SinExpression)theEObject;
                T result = caseSinExpression(sinExpression);
                if (result == null) result = caseTrigonometryOneInput(sinExpression);
                if (result == null) result = caseTrigonometry(sinExpression);
                if (result == null) result = caseExpression(sinExpression);
                if (result == null) result = caseAbstractElement(sinExpression);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case TrigonometryPackage.COS_EXPRESSION:
            {
                CosExpression cosExpression = (CosExpression)theEObject;
                T result = caseCosExpression(cosExpression);
                if (result == null) result = caseTrigonometryOneInput(cosExpression);
                if (result == null) result = caseTrigonometry(cosExpression);
                if (result == null) result = caseExpression(cosExpression);
                if (result == null) result = caseAbstractElement(cosExpression);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case TrigonometryPackage.TAN_EXPRESSION:
            {
                TanExpression tanExpression = (TanExpression)theEObject;
                T result = caseTanExpression(tanExpression);
                if (result == null) result = caseTrigonometryOneInput(tanExpression);
                if (result == null) result = caseTrigonometry(tanExpression);
                if (result == null) result = caseExpression(tanExpression);
                if (result == null) result = caseAbstractElement(tanExpression);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case TrigonometryPackage.ASIN_EXPRESSION:
            {
                AsinExpression asinExpression = (AsinExpression)theEObject;
                T result = caseAsinExpression(asinExpression);
                if (result == null) result = caseTrigonometryOneInput(asinExpression);
                if (result == null) result = caseTrigonometry(asinExpression);
                if (result == null) result = caseExpression(asinExpression);
                if (result == null) result = caseAbstractElement(asinExpression);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case TrigonometryPackage.ACOS_EXPRESSION:
            {
                AcosExpression acosExpression = (AcosExpression)theEObject;
                T result = caseAcosExpression(acosExpression);
                if (result == null) result = caseTrigonometryOneInput(acosExpression);
                if (result == null) result = caseTrigonometry(acosExpression);
                if (result == null) result = caseExpression(acosExpression);
                if (result == null) result = caseAbstractElement(acosExpression);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case TrigonometryPackage.ATAN_EXPRESSION:
            {
                AtanExpression atanExpression = (AtanExpression)theEObject;
                T result = caseAtanExpression(atanExpression);
                if (result == null) result = caseTrigonometryOneInput(atanExpression);
                if (result == null) result = caseTrigonometry(atanExpression);
                if (result == null) result = caseExpression(atanExpression);
                if (result == null) result = caseAbstractElement(atanExpression);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case TrigonometryPackage.ATAN2_EXPRESSION:
            {
                Atan2Expression atan2Expression = (Atan2Expression)theEObject;
                T result = caseAtan2Expression(atan2Expression);
                if (result == null) result = caseTrigonometryTwoInputs(atan2Expression);
                if (result == null) result = caseTrigonometry(atan2Expression);
                if (result == null) result = caseExpression(atan2Expression);
                if (result == null) result = caseAbstractElement(atan2Expression);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case TrigonometryPackage.PI_CONSTANT:
            {
                PiConstant piConstant = (PiConstant)theEObject;
                T result = casePiConstant(piConstant);
                if (result == null) result = caseBigDecimalConstant(piConstant);
                if (result == null) result = caseExpression(piConstant);
                if (result == null) result = caseAbstractElement(piConstant);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            default: return defaultCase(theEObject);
        }
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Trigonometry</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Trigonometry</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseTrigonometry(Trigonometry object)
    {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>One Input</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>One Input</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseTrigonometryOneInput(TrigonometryOneInput object)
    {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Two Inputs</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Two Inputs</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseTrigonometryTwoInputs(TrigonometryTwoInputs object)
    {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Sin Expression</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Sin Expression</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseSinExpression(SinExpression object)
    {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Cos Expression</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Cos Expression</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseCosExpression(CosExpression object)
    {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Tan Expression</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Tan Expression</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseTanExpression(TanExpression object)
    {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Asin Expression</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Asin Expression</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseAsinExpression(AsinExpression object)
    {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Acos Expression</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Acos Expression</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseAcosExpression(AcosExpression object)
    {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Atan Expression</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Atan Expression</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseAtanExpression(AtanExpression object)
    {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Atan2 Expression</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Atan2 Expression</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseAtan2Expression(Atan2Expression object)
    {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Pi Constant</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Pi Constant</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T casePiConstant(PiConstant object)
    {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Abstract Element</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Abstract Element</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseAbstractElement(AbstractElement object)
    {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Expression</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Expression</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseExpression(Expression object)
    {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Big Decimal Constant</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Big Decimal Constant</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseBigDecimalConstant(BigDecimalConstant object)
    {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch, but this is the last case anyway.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject)
     * @generated
     */
    @Override
    public T defaultCase(EObject object)
    {
        return null;
    }

} //TrigonometrySwitch
