/*
 * Decompiled with CFR 0.152.
 */
package org.knowhowlab.osgi.monitoradmin.job;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.knowhowlab.osgi.monitoradmin.LogVisitor;
import org.knowhowlab.osgi.monitoradmin.job.MonitoringJobVisitor;
import org.osgi.service.monitor.MonitoringJob;
import org.osgi.service.monitor.StatusVariable;

public abstract class AbstractMonitoringJob
implements MonitoringJob {
    protected MonitoringJobVisitor visitor;
    protected LogVisitor logVisitor;
    private String initiator;
    protected Set<String> statusVariablePaths = new HashSet<String>();
    protected boolean isRunning;
    protected int schedule = 0;
    protected int count = 0;

    protected AbstractMonitoringJob(MonitoringJobVisitor visitor, LogVisitor logVisitor, String initiator, String[] statusVariablePaths, int schedule, int count) {
        this.visitor = visitor;
        this.logVisitor = logVisitor;
        this.initiator = initiator;
        this.statusVariablePaths.addAll(Arrays.asList(statusVariablePaths));
        this.schedule = schedule;
        this.count = count;
        this.isRunning = true;
    }

    protected AbstractMonitoringJob(MonitoringJobVisitor visitor, LogVisitor logVisitor, String initiator, String[] statusVariablePaths, int count) {
        this.visitor = visitor;
        this.logVisitor = logVisitor;
        this.initiator = initiator;
        this.statusVariablePaths.addAll(Arrays.asList(statusVariablePaths));
        this.count = count;
        this.isRunning = true;
    }

    public synchronized void stop() {
        if (this.isRunning) {
            this.isRunning = false;
            this.visitor.cancelJob(this);
        }
    }

    public String getInitiator() {
        return this.initiator;
    }

    public String[] getStatusVariableNames() {
        return this.statusVariablePaths.toArray(new String[this.statusVariablePaths.size()]);
    }

    public int getSchedule() {
        return this.schedule;
    }

    public int getReportCount() {
        return this.count;
    }

    public boolean isLocal() {
        return true;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public abstract void cancel();

    public abstract boolean isHandleUpdateEvent(String var1);

    public abstract void handleUpdateEvent(String var1, StatusVariable var2);

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("{initiator='").append(this.initiator).append('\'');
        sb.append(", statusVariablePaths=").append(this.statusVariablePaths);
        sb.append(", schedule=").append(this.schedule);
        sb.append(", count=").append(this.count);
        sb.append('}');
        return sb.toString();
    }
}

