/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.ai.triton.server;

import com.google.protobuf.ByteString;
import com.google.protobuf.ProtocolStringList;
import inference.GRPCInferenceServiceGrpc;
import inference.GrpcService;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.KuraIOException;
import org.eclipse.kura.ai.inference.InferenceEngineService;
import org.eclipse.kura.ai.inference.ModelInfo;
import org.eclipse.kura.ai.inference.ModelInfoBuilder;
import org.eclipse.kura.ai.inference.Tensor;
import org.eclipse.kura.ai.inference.TensorDescriptor;
import org.eclipse.kura.ai.inference.TensorDescriptorBuilder;
import org.eclipse.kura.ai.triton.server.DataType;
import org.eclipse.kura.ai.triton.server.TritonServerEncryptionUtils;
import org.eclipse.kura.ai.triton.server.TritonServerInstanceManager;
import org.eclipse.kura.ai.triton.server.TritonServerServiceOptions;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.container.orchestration.ContainerOrchestrationService;
import org.eclipse.kura.crypto.CryptoService;
import org.eclipse.kura.executor.CommandExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TritonServerServiceAbs
implements InferenceEngineService,
ConfigurableComponent {
    private static final Logger logger = LoggerFactory.getLogger(TritonServerServiceAbs.class);
    private static final String TEMP_DIRECTORY_PREFIX = "decrypted_models";
    private CommandExecutorService commandExecutorService;
    private ContainerOrchestrationService containerOrchestrationService;
    private CryptoService cryptoService;
    protected TritonServerServiceOptions options;
    private TritonServerInstanceManager tritonServerInstanceManager;
    private ManagedChannel grpcChannel;
    private GRPCInferenceServiceGrpc.GRPCInferenceServiceBlockingStub grpcStub;
    private String decryptionFolderPath = "";
    private boolean decryptionFolderNeedsCleanup = false;

    public void setCommandExecutorService(CommandExecutorService executorService) {
        this.commandExecutorService = executorService;
    }

    public void setContainerOrchestrationService(ContainerOrchestrationService containerOrchestrationService) {
        this.containerOrchestrationService = containerOrchestrationService;
    }

    public void setCryptoService(CryptoService cryptoService) {
        this.cryptoService = cryptoService;
    }

    abstract TritonServerInstanceManager createInstanceManager(TritonServerServiceOptions var1, CommandExecutorService var2, ContainerOrchestrationService var3, String var4);

    abstract boolean isConfigurationValid();

    abstract boolean isModelEncryptionEnabled();

    abstract String getServerAddress();

    protected void activate(Map<String, Object> properties) {
        logger.info("Activate TritonServerService...");
        this.updated(properties);
    }

    public void updated(Map<String, Object> properties) {
        logger.info("Update TritonServerService...");
        TritonServerServiceOptions newOptions = new TritonServerServiceOptions(properties);
        if (newOptions.equals(this.options)) {
            return;
        }
        this.options = newOptions;
        if (Objects.nonNull(this.tritonServerInstanceManager)) {
            this.stopManagedInstance();
        }
        if (this.isConfigurationValid()) {
            this.setGrpcResources();
            this.startManagedInstance();
            this.loadModels();
        } else {
            logger.warn("The provided configuration is not valid");
        }
    }

    protected void deactivate() {
        logger.info("Deactivate TritonServerService...");
        this.stopManagedInstance();
        this.grpcChannel.shutdownNow();
        try {
            boolean isTerminated = this.grpcChannel.awaitTermination(5L, TimeUnit.SECONDS);
            if (!isTerminated) {
                logger.warn("Unable to terminate grpc channel gracefully");
            }
        }
        catch (InterruptedException e) {
            logger.warn("Unable to terminate grpc channel gracefully", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    private void startManagedInstance() {
        if (this.isModelEncryptionEnabled()) {
            try {
                this.decryptionFolderPath = TritonServerEncryptionUtils.createDecryptionFolder(TEMP_DIRECTORY_PREFIX);
                this.decryptionFolderNeedsCleanup = true;
            }
            catch (IOException e) {
                logger.warn("Failed to create decryption model directory", (Throwable)e);
            }
            logger.info("Using decryption model directory at path {}", (Object)this.decryptionFolderPath);
        }
        this.tritonServerInstanceManager = this.createInstanceManager(this.options, this.commandExecutorService, this.containerOrchestrationService, this.decryptionFolderPath);
        logger.info("Created {} type", (Object)this.tritonServerInstanceManager.getClass().getSimpleName());
        this.tritonServerInstanceManager.start();
    }

    private void stopManagedInstance() {
        this.tritonServerInstanceManager.stop();
        int counter = 0;
        while (this.tritonServerInstanceManager.isServerRunning()) {
            if (counter++ >= this.options.getNRetries()) {
                logger.warn("Cannot stop local server instance. Killing it.");
                this.tritonServerInstanceManager.kill();
            }
            TritonServerServiceAbs.sleepFor(this.options.getRetryInterval());
        }
        if (this.decryptionFolderNeedsCleanup) {
            TritonServerEncryptionUtils.cleanRepository(this.decryptionFolderPath);
            try {
                Files.delete(Paths.get(this.decryptionFolderPath, new String[0]));
            }
            catch (IOException e) {
                logger.warn("Could not delete decryption folder {}", (Object)this.decryptionFolderPath, (Object)e);
            }
            this.decryptionFolderNeedsCleanup = false;
        }
    }

    private void setGrpcResources() {
        this.grpcChannel = ManagedChannelBuilder.forAddress((String)this.getServerAddress(), (int)this.options.getGrpcPort()).usePlaintext().maxInboundMessageSize(this.options.getGrpcMaxMessageSize()).maxInboundMetadataSize(Integer.MAX_VALUE).build();
        this.setGrpcStub(GRPCInferenceServiceGrpc.newBlockingStub((Channel)this.grpcChannel));
    }

    protected void setGrpcStub(GRPCInferenceServiceGrpc.GRPCInferenceServiceBlockingStub grpcStub) {
        this.grpcStub = grpcStub;
    }

    protected boolean isNullOrEmpty(String property) {
        return Objects.isNull(property) || property.isEmpty();
    }

    protected void loadModels() {
        if (this.options.getModels().isEmpty()) {
            return;
        }
        int counter = 0;
        while (!this.isEngineReady()) {
            if (counter++ >= this.options.getNRetries()) {
                logger.warn("Cannot load models since server is not ready.");
                return;
            }
            TritonServerServiceAbs.sleepFor(this.options.getRetryInterval());
        }
        this.options.getModels().forEach(modelName -> {
            try {
                this.loadModel((String)modelName, Optional.empty());
            }
            catch (KuraException e) {
                logger.error("Cannot load model " + modelName, (Throwable)e);
            }
        });
    }

    public void loadModel(String modelName, Optional<String> modelPath) throws KuraException {
        if (this.isModelEncryptionEnabled()) {
            String password = this.options.getModelRepositoryPassword();
            String plainPassword = String.valueOf(this.cryptoService.decryptAes(password.toCharArray()));
            String encryptedModelPath = TritonServerEncryptionUtils.getEncryptedModelPath(modelName, this.options.getModelRepositoryPath());
            String decryptedModelPath = Paths.get(this.decryptionFolderPath, String.valueOf(modelName) + ".zip").toString();
            logger.info("Model decryption password detected. Decrypting model {} at {} into {}", new Object[]{modelName, encryptedModelPath, decryptedModelPath});
            try {
                TritonServerEncryptionUtils.decryptModel(plainPassword, encryptedModelPath, decryptedModelPath);
                TritonServerEncryptionUtils.unzipModel(decryptedModelPath, this.decryptionFolderPath);
            }
            catch (IOException | KuraIOException e) {
                throw new KuraIOException(e, (Object)("Cannot decrypt the model " + modelName));
            }
        }
        GrpcService.RepositoryModelLoadRequest.Builder builder = GrpcService.RepositoryModelLoadRequest.newBuilder();
        builder.setModelName(modelName);
        try {
            this.grpcStub.repositoryModelLoad(builder.build());
        }
        catch (StatusRuntimeException e) {
            if (this.isModelEncryptionEnabled()) {
                TritonServerEncryptionUtils.cleanRepository(this.decryptionFolderPath);
            }
            throw new KuraIOException((Throwable)e, (Object)("Cannot load the model " + modelName));
        }
        if (this.isModelEncryptionEnabled()) {
            int counter = 0;
            while (!this.isModelLoaded(modelName)) {
                if (counter++ >= this.options.getNRetries()) {
                    logger.warn("Cannot check if model was correctly loaded. Wiping decrypted model anyway");
                    break;
                }
                TritonServerServiceAbs.sleepFor(this.options.getRetryInterval());
            }
            TritonServerEncryptionUtils.cleanRepository(this.decryptionFolderPath);
        }
    }

    public void unloadModel(String modelName) throws KuraException {
        GrpcService.RepositoryModelUnloadRequest.Builder builder = GrpcService.RepositoryModelUnloadRequest.newBuilder();
        builder.setModelName(modelName);
        try {
            this.grpcStub.repositoryModelUnload(builder.build());
        }
        catch (StatusRuntimeException e) {
            throw new KuraIOException((Throwable)e, (Object)("Cannot unload the model " + modelName));
        }
    }

    public boolean isModelLoaded(String modelName) throws KuraException {
        boolean isLoaded = false;
        GrpcService.ModelReadyRequest.Builder builder = GrpcService.ModelReadyRequest.newBuilder();
        builder.setName(modelName);
        try {
            GrpcService.ModelReadyResponse modelReadyResponse = this.grpcStub.modelReady(builder.build());
            isLoaded = modelReadyResponse.getReady();
        }
        catch (StatusRuntimeException e) {
            throw new KuraIOException((Throwable)e, (Object)("Cannot check if the model " + modelName + " is loaded"));
        }
        return isLoaded;
    }

    public List<String> getModelNames() throws KuraException {
        ArrayList<String> modelNames = new ArrayList<String>();
        GrpcService.RepositoryIndexRequest repositoryIndexRequest = GrpcService.RepositoryIndexRequest.getDefaultInstance();
        try {
            GrpcService.RepositoryIndexResponse repositoryIndexResponse = this.grpcStub.repositoryIndex(repositoryIndexRequest);
            List<GrpcService.RepositoryIndexResponse.ModelIndex> models = repositoryIndexResponse.getModelsList();
            models.forEach(model -> {
                boolean bl = modelNames.add(model.getName());
            });
        }
        catch (StatusRuntimeException e) {
            throw new KuraIOException((Throwable)e, (Object)"Cannot get the list of model names from server");
        }
        return modelNames;
    }

    public Optional<ModelInfo> getModelInfo(String modelName) throws KuraException {
        Optional<ModelInfo> modelInfo = Optional.empty();
        GrpcService.ModelMetadataRequest.Builder builder = GrpcService.ModelMetadataRequest.newBuilder();
        builder.setName(modelName);
        try {
            ProtocolStringList versions;
            GrpcService.ModelMetadataResponse modelMetadataResponse = this.grpcStub.modelMetadata(builder.build());
            ModelInfoBuilder infoBuilder = ModelInfo.builder((String)modelMetadataResponse.getName());
            String modelPlatform = modelMetadataResponse.getPlatform();
            if (Objects.nonNull(modelPlatform) && !modelPlatform.isEmpty()) {
                infoBuilder.platform(modelPlatform);
            }
            if (Objects.nonNull(versions = modelMetadataResponse.getVersionsList()) && !versions.isEmpty()) {
                infoBuilder.version((String)versions.get(versions.size() - 1));
            }
            modelMetadataResponse.getInputsList().forEach(tensor -> {
                ModelInfoBuilder modelInfoBuilder2 = infoBuilder.addInputDescriptor(TensorDescriptor.builder((String)tensor.getName(), (String)tensor.getDatatype(), tensor.getShapeList()).build());
            });
            modelMetadataResponse.getOutputsList().forEach(tensor -> {
                ModelInfoBuilder modelInfoBuilder2 = infoBuilder.addOutputDescriptor(TensorDescriptor.builder((String)tensor.getName(), (String)tensor.getDatatype(), tensor.getShapeList()).build());
            });
            modelInfo = Optional.of(infoBuilder.build());
        }
        catch (StatusRuntimeException | IllegalArgumentException e) {
            throw new KuraIOException(e, (Object)("Cannot get info for " + modelName + " from server"));
        }
        return modelInfo;
    }

    public boolean isEngineReady() {
        boolean isAlive = false;
        GrpcService.ServerLiveRequest serverLiveRequest = GrpcService.ServerLiveRequest.getDefaultInstance();
        try {
            GrpcService.ServerLiveResponse serverLiveResponse = this.grpcStub.serverLive(serverLiveRequest);
            isAlive = serverLiveResponse.getLive();
        }
        catch (StatusRuntimeException e) {
            logger.debug("Cannot get the status of the server: ", (Throwable)e);
            return false;
        }
        return isAlive;
    }

    public List<Tensor> infer(ModelInfo modelInfo, List<Tensor> inputData) throws KuraException {
        List<Tensor> inferenceResults = new ArrayList<Tensor>();
        GrpcService.ModelInferRequest.Builder inferRequest = GrpcService.ModelInferRequest.newBuilder();
        inferRequest.setModelName(modelInfo.getName());
        try {
            if (!modelInfo.getParameters().isEmpty()) {
                inferRequest.putAllParameters(this.getInferParameters(modelInfo.getParameters()));
            }
            inputData.forEach(input -> {
                GrpcService.ModelInferRequest.Builder builder2 = inferRequest.addInputs(this.createInputDataBuilder((Tensor)input));
            });
            modelInfo.getOutputs().forEach(outputDescriptor -> {
                GrpcService.ModelInferRequest.Builder builder2 = inferRequest.addOutputs(this.createRequestedOutputBuilder((TensorDescriptor)outputDescriptor));
            });
            GrpcService.ModelInferResponse inferResponse = this.grpcStub.modelInfer(inferRequest.build());
            inferenceResults = this.createOutputInferenceData(inferResponse);
        }
        catch (StatusRuntimeException | IllegalArgumentException e) {
            logger.warn("Cannot infer outputs for " + modelInfo.getName() + " model", e);
        }
        return inferenceResults;
    }

    private Map<String, GrpcService.InferParameter> getInferParameters(Map<String, Object> parameters) {
        HashMap<String, GrpcService.InferParameter> inferParameters = new HashMap<String, GrpcService.InferParameter>();
        parameters.forEach((key, value) -> {
            GrpcService.InferParameter.Builder parameterBuilder = GrpcService.InferParameter.newBuilder();
            if (value instanceof Boolean) {
                parameterBuilder.setBoolParam((Boolean)value);
            } else if (value instanceof Long) {
                parameterBuilder.setInt64Param((Long)value);
            } else if (value instanceof String) {
                parameterBuilder.setStringParam((String)value);
            } else {
                throw new IllegalArgumentException("Parameter value type " + value.getClass() + " not valid. Only string, long and boolean are allowed.");
            }
            inferParameters.put((String)key, parameterBuilder.build());
        });
        return inferParameters;
    }

    private Map<String, Object> getParameters(Map<String, GrpcService.InferParameter> inferParameters) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        inferParameters.forEach((key, value) -> {
            switch (value.getParameterChoiceCase()) {
                case BOOL_PARAM: {
                    parameters.put((String)key, value.getBoolParam());
                    break;
                }
                case INT64_PARAM: {
                    parameters.put((String)key, value.getInt64Param());
                    break;
                }
                case STRING_PARAM: {
                    parameters.put((String)key, value.getStringParam());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Parameter value type unrecognized.");
                }
            }
        });
        return parameters;
    }

    private GrpcService.ModelInferRequest.InferRequestedOutputTensor.Builder createRequestedOutputBuilder(TensorDescriptor outputDescriptor) {
        GrpcService.ModelInferRequest.InferRequestedOutputTensor.Builder output = GrpcService.ModelInferRequest.InferRequestedOutputTensor.newBuilder();
        output.setName(outputDescriptor.getName());
        if (!outputDescriptor.getParameters().isEmpty()) {
            output.putAllParameters(this.getInferParameters(outputDescriptor.getParameters()));
        }
        return output;
    }

    private GrpcService.ModelInferRequest.InferInputTensor.Builder createInputDataBuilder(Tensor input) {
        GrpcService.InferTensorContents.Builder inputDataBuilder = GrpcService.InferTensorContents.newBuilder();
        DataType modelInputType = DataType.valueOf(input.getDescriptor().getType());
        switch (modelInputType) {
            case BOOL: {
                this.addDataTypeInputData(input, Boolean.class, inputDataBuilder::addAllBoolContents);
                break;
            }
            case UINT8: {
                this.addUint8InputData(input, inputDataBuilder);
                break;
            }
            case INT8: {
                this.addInt8InputData(input, inputDataBuilder);
                break;
            }
            case UINT16: {
                this.addUint16InputData(input, inputDataBuilder);
                break;
            }
            case INT16: {
                this.addInt16InputData(input, inputDataBuilder);
                break;
            }
            case UINT32: {
                this.addDataTypeInputData(input, Integer.class, inputDataBuilder::addAllUintContents);
                break;
            }
            case INT32: {
                this.addDataTypeInputData(input, Integer.class, inputDataBuilder::addAllIntContents);
                break;
            }
            case UINT64: {
                this.addDataTypeInputData(input, Long.class, inputDataBuilder::addAllUint64Contents);
                break;
            }
            case INT64: {
                this.addDataTypeInputData(input, Long.class, inputDataBuilder::addAllInt64Contents);
                break;
            }
            case FP32: {
                this.addDataTypeInputData(input, Float.class, inputDataBuilder::addAllFp32Contents);
                break;
            }
            case FP64: {
                this.addDataTypeInputData(input, Double.class, inputDataBuilder::addAllFp64Contents);
                break;
            }
            case BYTES: {
                this.addBytesInputData(input, inputDataBuilder);
                break;
            }
            default: {
                throw new IllegalArgumentException("Date type " + (Object)((Object)modelInputType) + " not supported");
            }
        }
        GrpcService.ModelInferRequest.InferInputTensor.Builder inputBuilder = GrpcService.ModelInferRequest.InferInputTensor.newBuilder();
        inputBuilder.setName(input.getDescriptor().getName());
        inputBuilder.setDatatype(input.getDescriptor().getType());
        input.getDescriptor().getShape().forEach(inputBuilder::addShape);
        inputBuilder.setContents(inputDataBuilder);
        if (!input.getDescriptor().getParameters().isEmpty()) {
            inputBuilder.putAllParameters(this.getInferParameters(input.getDescriptor().getParameters()));
        }
        return inputBuilder;
    }

    private <T> void addDataTypeInputData(Tensor input, Class<T> clazz, Consumer<List<T>> dataConsumer) {
        dataConsumer.accept((List)input.getData(clazz).orElseThrow(() -> new IllegalArgumentException("Expected a list of " + clazz.getSimpleName() + " but got a list of " + input.getType())));
    }

    private void addBytesInputData(Tensor input, GrpcService.InferTensorContents.Builder inputDataBuilder) {
        if (!input.getType().isAssignableFrom(Byte.class)) {
            throw new IllegalArgumentException("Expected a list of bytes but got a list of " + input.getType());
        }
        Optional inputData = input.getData(Byte.class);
        inputData.ifPresent(bytes -> {
            byte[] byteArray = new byte[bytes.size()];
            int i = 0;
            while (i < bytes.size()) {
                byteArray[i] = (Byte)bytes.get(i);
                ++i;
            }
            inputDataBuilder.addBytesContents(ByteString.copyFrom((byte[])byteArray));
        });
    }

    private void addInt16InputData(Tensor input, GrpcService.InferTensorContents.Builder inputDataBuilder) {
        if (input.getType().isAssignableFrom(Short.class)) {
            Optional inputData = input.getData(Short.class);
            inputData.ifPresent(shortList -> {
                ArrayList integerList = new ArrayList();
                shortList.forEach(shortValue -> {
                    boolean bl = integerList.add(shortValue.intValue());
                });
                inputDataBuilder.addAllIntContents(integerList);
            });
        } else if (input.getType().isAssignableFrom(Integer.class)) {
            Optional inputData = input.getData(Integer.class);
            inputData.ifPresent(inputDataBuilder::addAllIntContents);
        } else {
            throw new IllegalArgumentException("Expected a list of shorts or integers but got a list of " + input.getType());
        }
    }

    private void addUint16InputData(Tensor input, GrpcService.InferTensorContents.Builder inputDataBuilder) {
        if (input.getType().isAssignableFrom(Short.class)) {
            Optional inputData = input.getData(Short.class);
            inputData.ifPresent(shortList -> {
                ArrayList integerList = new ArrayList();
                shortList.forEach(shortValue -> {
                    boolean bl = integerList.add(shortValue.intValue());
                });
                inputDataBuilder.addAllUintContents(integerList);
            });
        } else if (input.getType().isAssignableFrom(Integer.class)) {
            Optional inputData = input.getData(Integer.class);
            inputData.ifPresent(inputDataBuilder::addAllUintContents);
        } else {
            throw new IllegalArgumentException("Expected a list of shorts or integers but got a list of " + input.getType());
        }
    }

    private void addInt8InputData(Tensor input, GrpcService.InferTensorContents.Builder inputDataBuilder) {
        if (input.getType().isAssignableFrom(Byte.class)) {
            Optional inputData = input.getData(Byte.class);
            inputData.ifPresent(byteList -> {
                ArrayList integerList = new ArrayList();
                byteList.forEach(byteValue -> {
                    boolean bl = integerList.add(byteValue.intValue());
                });
                inputDataBuilder.addAllIntContents(integerList);
            });
        } else if (input.getType().isAssignableFrom(Integer.class)) {
            Optional inputData = input.getData(Integer.class);
            inputData.ifPresent(inputDataBuilder::addAllIntContents);
        } else {
            throw new IllegalArgumentException("Expected a list of bytes or integers but got a list of " + input.getType());
        }
    }

    private void addUint8InputData(Tensor input, GrpcService.InferTensorContents.Builder inputDataBuilder) {
        if (input.getType().isAssignableFrom(Byte.class)) {
            Optional inputData = input.getData(Byte.class);
            inputData.ifPresent(byteList -> {
                ArrayList integerList = new ArrayList();
                byteList.forEach(byteValue -> {
                    boolean bl = integerList.add(byteValue.intValue());
                });
                inputDataBuilder.addAllUintContents(integerList);
            });
        } else if (input.getType().isAssignableFrom(Integer.class)) {
            Optional inputData = input.getData(Integer.class);
            inputData.ifPresent(inputDataBuilder::addAllUintContents);
        } else {
            throw new IllegalArgumentException("Expected a list of bytes or integers but got a list of " + input.getType());
        }
    }

    private List<Tensor> createOutputInferenceData(GrpcService.ModelInferResponse inferResponse) {
        ArrayList<Tensor> results = new ArrayList<Tensor>();
        int index = 0;
        while (index < inferResponse.getOutputsCount()) {
            GrpcService.ModelInferResponse.InferOutputTensor inferOutputTensor = inferResponse.getOutputs(index);
            ByteString byteStringResponse = inferResponse.getRawOutputContentsList().get(index);
            if (Objects.nonNull(inferOutputTensor)) {
                DataType outputType = DataType.valueOf(inferOutputTensor.getDatatype());
                TensorDescriptorBuilder outputDescriptorBuilder = TensorDescriptor.builder((String)inferOutputTensor.getName(), (String)outputType.toString(), inferOutputTensor.getShapeList());
                if (!inferOutputTensor.getParametersMap().isEmpty()) {
                    this.getParameters(inferOutputTensor.getParametersMap()).forEach((arg_0, arg_1) -> ((TensorDescriptorBuilder)outputDescriptorBuilder).addParameter(arg_0, arg_1));
                }
                TensorDescriptor outputDescriptor = outputDescriptorBuilder.build();
                switch (outputType) {
                    case BOOL: {
                        List<Boolean> booleanList = this.bufferToBooleanList(byteStringResponse.asReadOnlyByteBuffer().order(ByteOrder.LITTLE_ENDIAN));
                        results.add(new Tensor(Boolean.class, outputDescriptor, booleanList));
                        break;
                    }
                    case INT8: 
                    case UINT8: {
                        List<Byte> byteList = this.bufferToByteList(byteStringResponse.asReadOnlyByteBuffer().order(ByteOrder.LITTLE_ENDIAN));
                        results.add(new Tensor(Byte.class, outputDescriptor, byteList));
                        break;
                    }
                    case INT16: 
                    case UINT16: {
                        List<Short> shortList = this.bufferToShortList(byteStringResponse.asReadOnlyByteBuffer().order(ByteOrder.LITTLE_ENDIAN).asShortBuffer());
                        results.add(new Tensor(Short.class, outputDescriptor, shortList));
                        break;
                    }
                    case INT32: 
                    case UINT32: {
                        List<Integer> integerList = this.bufferToIntList(byteStringResponse.asReadOnlyByteBuffer().order(ByteOrder.LITTLE_ENDIAN).asIntBuffer());
                        results.add(new Tensor(Integer.class, outputDescriptor, integerList));
                        break;
                    }
                    case INT64: 
                    case UINT64: {
                        List<Long> longList = this.bufferToLongList(byteStringResponse.asReadOnlyByteBuffer().order(ByteOrder.LITTLE_ENDIAN).asLongBuffer());
                        results.add(new Tensor(Long.class, outputDescriptor, longList));
                        break;
                    }
                    case FP32: {
                        List<Float> floatList = this.bufferToFloatList(byteStringResponse.asReadOnlyByteBuffer().order(ByteOrder.LITTLE_ENDIAN).asFloatBuffer());
                        results.add(new Tensor(Float.class, outputDescriptor, floatList));
                        break;
                    }
                    case FP64: {
                        List<Double> doubleList = this.bufferToDoubleList(byteStringResponse.asReadOnlyByteBuffer().order(ByteOrder.LITTLE_ENDIAN).asDoubleBuffer());
                        results.add(new Tensor(Double.class, outputDescriptor, doubleList));
                        break;
                    }
                    case BYTES: {
                        List<Byte> bytesList = this.bufferToBytes(byteStringResponse.asReadOnlyByteBuffer().order(ByteOrder.LITTLE_ENDIAN));
                        results.add(new Tensor(Byte.class, outputDescriptor, bytesList));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Date type " + (Object)((Object)outputType) + " not supported");
                    }
                }
            }
            ++index;
        }
        return results;
    }

    private List<Byte> bufferToBytes(ByteBuffer buffer) {
        ArrayList<Byte> byteList = new ArrayList<Byte>();
        if (buffer.capacity() < 4) {
            throw new IllegalArgumentException("Too few bytes in buffer; cannot read array length");
        }
        buffer.getInt();
        while (buffer.hasRemaining()) {
            byteList.add(buffer.get());
        }
        return byteList;
    }

    private List<Float> bufferToFloatList(FloatBuffer buffer) {
        float[] floatArray;
        ArrayList<Float> floatList = new ArrayList<Float>();
        if (buffer.hasArray()) {
            floatArray = buffer.arrayOffset() == 0 ? buffer.array() : Arrays.copyOfRange(buffer.array(), buffer.arrayOffset(), buffer.array().length);
        } else {
            buffer.rewind();
            floatArray = new float[buffer.remaining()];
            buffer.get(floatArray);
        }
        float[] fArray = floatArray;
        int n = floatArray.length;
        int n2 = 0;
        while (n2 < n) {
            float floatValue = fArray[n2];
            floatList.add(Float.valueOf(floatValue));
            ++n2;
        }
        return floatList;
    }

    private List<Double> bufferToDoubleList(DoubleBuffer buffer) {
        double[] doubleArray;
        ArrayList<Double> doubleList = new ArrayList<Double>();
        if (buffer.hasArray()) {
            doubleArray = buffer.arrayOffset() == 0 ? buffer.array() : Arrays.copyOfRange(buffer.array(), buffer.arrayOffset(), buffer.array().length);
        } else {
            buffer.rewind();
            doubleArray = new double[buffer.remaining()];
            buffer.get(doubleArray);
        }
        double[] dArray = doubleArray;
        int n = doubleArray.length;
        int n2 = 0;
        while (n2 < n) {
            double doubleValue = dArray[n2];
            doubleList.add(doubleValue);
            ++n2;
        }
        return doubleList;
    }

    private List<Long> bufferToLongList(LongBuffer buffer) {
        long[] longArray;
        ArrayList<Long> longList = new ArrayList<Long>();
        if (buffer.hasArray()) {
            longArray = buffer.arrayOffset() == 0 ? buffer.array() : Arrays.copyOfRange(buffer.array(), buffer.arrayOffset(), buffer.array().length);
        } else {
            buffer.rewind();
            longArray = new long[buffer.remaining()];
            buffer.get(longArray);
        }
        long[] lArray = longArray;
        int n = longArray.length;
        int n2 = 0;
        while (n2 < n) {
            long longValue = lArray[n2];
            longList.add(longValue);
            ++n2;
        }
        return longList;
    }

    private List<Integer> bufferToIntList(IntBuffer buffer) {
        int[] intArray;
        ArrayList<Integer> intList = new ArrayList<Integer>();
        if (buffer.hasArray()) {
            intArray = buffer.arrayOffset() == 0 ? buffer.array() : Arrays.copyOfRange(buffer.array(), buffer.arrayOffset(), buffer.array().length);
        } else {
            buffer.rewind();
            intArray = new int[buffer.remaining()];
            buffer.get(intArray);
        }
        int[] nArray = intArray;
        int n = intArray.length;
        int n2 = 0;
        while (n2 < n) {
            int intValue = nArray[n2];
            intList.add(intValue);
            ++n2;
        }
        return intList;
    }

    private List<Short> bufferToShortList(ShortBuffer buffer) {
        short[] shortArray;
        ArrayList<Short> shortList = new ArrayList<Short>();
        if (buffer.hasArray()) {
            shortArray = buffer.arrayOffset() == 0 ? buffer.array() : Arrays.copyOfRange(buffer.array(), buffer.arrayOffset(), buffer.array().length);
        } else {
            buffer.rewind();
            shortArray = new short[buffer.remaining()];
            buffer.get(shortArray);
        }
        short[] sArray = shortArray;
        int n = shortArray.length;
        int n2 = 0;
        while (n2 < n) {
            short shortValue = sArray[n2];
            shortList.add(shortValue);
            ++n2;
        }
        return shortList;
    }

    private List<Byte> bufferToByteList(ByteBuffer buffer) {
        byte[] byteArray;
        ArrayList<Byte> byteList = new ArrayList<Byte>();
        if (buffer.hasArray()) {
            byteArray = buffer.arrayOffset() == 0 ? buffer.array() : Arrays.copyOfRange(buffer.array(), buffer.arrayOffset(), buffer.array().length);
        } else {
            buffer.rewind();
            byteArray = new byte[buffer.remaining()];
            buffer.get(byteArray);
        }
        byte[] byArray = byteArray;
        int n = byteArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte byteValue = byArray[n2];
            byteList.add(byteValue);
            ++n2;
        }
        return byteList;
    }

    private List<Boolean> bufferToBooleanList(ByteBuffer buffer) {
        byte[] byteArray;
        ArrayList<Boolean> booleanList = new ArrayList<Boolean>();
        if (buffer.hasArray()) {
            byteArray = buffer.arrayOffset() == 0 ? buffer.array() : Arrays.copyOfRange(buffer.array(), buffer.arrayOffset(), buffer.array().length);
        } else {
            buffer.rewind();
            byteArray = new byte[buffer.remaining()];
            buffer.get(byteArray);
        }
        byte[] byArray = byteArray;
        int n = byteArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte byteValue = byArray[n2];
            booleanList.add(byteValue == 1);
            ++n2;
        }
        return booleanList;
    }

    private static void sleepFor(long timeout) {
        try {
            Thread.sleep(timeout);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.debug(e.getMessage(), (Throwable)e);
        }
    }
}

