/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.wire.helper;

import java.util.Objects;
import org.eclipse.kura.internal.wire.helper.WireSupportImpl;
import org.eclipse.kura.util.service.ServiceUtil;
import org.eclipse.kura.wire.WireComponent;
import org.eclipse.kura.wire.WireEmitter;
import org.eclipse.kura.wire.WireHelperService;
import org.eclipse.kura.wire.WireReceiver;
import org.eclipse.kura.wire.WireSupport;
import org.eclipse.kura.wire.graph.Constants;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public final class WireHelperServiceImpl
implements WireHelperService {
    public String getPid(WireComponent wireComponent) {
        Objects.requireNonNull(wireComponent, "Wire Component cannot be null");
        BundleContext context = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        ServiceReference[] refs = ServiceUtil.getServiceReferences((BundleContext)context, WireComponent.class, null);
        try {
            ServiceReference[] serviceReferenceArray = refs;
            int n = refs.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceReference ref = serviceReferenceArray[n2];
                WireComponent wc = (WireComponent)context.getService(ref);
                if (wc == wireComponent) {
                    String string = String.valueOf(ref.getProperty("kura.service.pid"));
                    return string;
                }
                ++n2;
            }
        }
        finally {
            ServiceUtil.ungetServiceReferences((BundleContext)context, (ServiceReference[])refs);
        }
        return null;
    }

    public String getServicePid(String wireComponentPid) {
        Objects.requireNonNull(wireComponentPid, "Wire Component PID cannot be null");
        BundleContext context = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        ServiceReference[] refs = ServiceUtil.getServiceReferences((BundleContext)context, WireComponent.class, null);
        try {
            ServiceReference[] serviceReferenceArray = refs;
            int n = refs.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceReference ref = serviceReferenceArray[n2];
                if (ref.getProperty("kura.service.pid").equals(wireComponentPid)) {
                    String string = String.valueOf(ref.getProperty("service.pid"));
                    return string;
                }
                ++n2;
            }
        }
        finally {
            ServiceUtil.ungetServiceReferences((BundleContext)context, (ServiceReference[])refs);
        }
        return null;
    }

    public String getServicePid(WireComponent wireComponent) {
        Objects.requireNonNull(wireComponent, "Wire Component cannot be null");
        BundleContext context = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        ServiceReference[] refs = ServiceUtil.getServiceReferences((BundleContext)context, WireComponent.class, null);
        try {
            ServiceReference[] serviceReferenceArray = refs;
            int n = refs.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceReference ref = serviceReferenceArray[n2];
                WireComponent wc = (WireComponent)context.getService(ref);
                if (wc == wireComponent) {
                    String string = String.valueOf(ref.getProperty("service.pid"));
                    return string;
                }
                ++n2;
            }
        }
        finally {
            ServiceUtil.ungetServiceReferences((BundleContext)context, (ServiceReference[])refs);
        }
        return null;
    }

    public boolean isEmitter(String wireComponentPid) {
        Objects.requireNonNull(wireComponentPid, "Wire Component PID cannot be null");
        BundleContext context = FrameworkUtil.getBundle(WireHelperServiceImpl.class).getBundleContext();
        ServiceReference[] refs = ServiceUtil.getServiceReferences((BundleContext)context, WireComponent.class, null);
        try {
            ServiceReference[] serviceReferenceArray = refs;
            int n = refs.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceReference ref = serviceReferenceArray[n2];
                if (ref.getProperty("kura.service.pid").equals(wireComponentPid) && context.getService(ref) instanceof WireEmitter) {
                    return true;
                }
                ++n2;
            }
        }
        finally {
            ServiceUtil.ungetServiceReferences((BundleContext)context, (ServiceReference[])refs);
        }
        return false;
    }

    public boolean isReceiver(String wireComponentPid) {
        Objects.requireNonNull(wireComponentPid, "Wire Component PID cannot be null");
        BundleContext context = FrameworkUtil.getBundle(WireHelperServiceImpl.class).getBundleContext();
        ServiceReference[] refs = ServiceUtil.getServiceReferences((BundleContext)context, WireComponent.class, null);
        try {
            ServiceReference[] serviceReferenceArray = refs;
            int n = refs.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceReference ref = serviceReferenceArray[n2];
                if (ref.getProperty("kura.service.pid").equals(wireComponentPid) && context.getService(ref) instanceof WireReceiver) {
                    return true;
                }
                ++n2;
            }
        }
        finally {
            ServiceUtil.ungetServiceReferences((BundleContext)context, (ServiceReference[])refs);
        }
        return false;
    }

    private int getIntOrDefault(Object portCount, int defaultValue) {
        if (portCount instanceof Integer) {
            return (Integer)portCount;
        }
        return defaultValue;
    }

    public WireSupport newWireSupport(WireComponent wireComponent, ServiceReference<WireComponent> wireComponentRef) {
        if (wireComponentRef == null) {
            return null;
        }
        String servicePid = (String)wireComponentRef.getProperty("service.pid");
        String kuraServicePid = (String)wireComponentRef.getProperty("kura.service.pid");
        int receiverPortCount = this.getIntOrDefault(wireComponentRef.getProperty(Constants.RECEIVER_PORT_COUNT_PROP_NAME.value()), wireComponent instanceof WireReceiver ? 1 : 0);
        int emitterPortCount = this.getIntOrDefault(wireComponentRef.getProperty(Constants.EMITTER_PORT_COUNT_PROP_NAME.value()), wireComponent instanceof WireEmitter ? 1 : 0);
        return new WireSupportImpl(wireComponent, servicePid, kuraServicePid, receiverPortCount, emitterPortCount);
    }
}

