/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.client.ui.packages;

import com.google.gwt.core.client.GWT;
import com.google.gwt.regexp.shared.RegExp;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FileUpload;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Hidden;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.SingleSelectionModel;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.kura.web.client.messages.Messages;
import org.eclipse.kura.web.client.messages.ValidationMessages;
import org.eclipse.kura.web.client.ui.AlertDialog;
import org.eclipse.kura.web.client.ui.EntryClassUi;
import org.eclipse.kura.web.client.util.DropSupport;
import org.eclipse.kura.web.client.util.EventService;
import org.eclipse.kura.web.client.util.FailureHandler;
import org.eclipse.kura.web.shared.ForwardedEventTopic;
import org.eclipse.kura.web.shared.model.GwtDeploymentPackage;
import org.eclipse.kura.web.shared.model.GwtMarketplacePackageDescriptor;
import org.eclipse.kura.web.shared.model.GwtSession;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;
import org.eclipse.kura.web.shared.service.GwtPackageService;
import org.eclipse.kura.web.shared.service.GwtPackageServiceAsync;
import org.eclipse.kura.web.shared.service.GwtSecurityTokenService;
import org.eclipse.kura.web.shared.service.GwtSecurityTokenServiceAsync;
import org.gwtbootstrap3.client.ui.Alert;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.Modal;
import org.gwtbootstrap3.client.ui.ModalBody;
import org.gwtbootstrap3.client.ui.ModalFooter;
import org.gwtbootstrap3.client.ui.Panel;
import org.gwtbootstrap3.client.ui.TabListItem;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.Well;
import org.gwtbootstrap3.client.ui.gwt.CellTable;
import org.gwtbootstrap3.client.ui.html.Paragraph;
import org.gwtbootstrap3.client.ui.html.Span;
import org.gwtbootstrap3.client.ui.html.Text;

public class PackagesPanelUi
extends Composite {
    private static final String XSRF_TOKEN = "xsrfToken";
    private static final String DROPZONE_ACTIVE_STYLE_NAME = "active";
    private static RegExp marketplaceUrlRegexp = RegExp.compile((String)"http[s]?:\\/\\/marketplace.eclipse.org/marketplace-client-intro\\?mpc_install=.*");
    private static PackagesPanelUiUiBinder uiBinder = (PackagesPanelUiUiBinder)GWT.create(PackagesPanelUiUiBinder.class);
    private static final Logger logger = Logger.getLogger(PackagesPanelUi.class.getSimpleName());
    private final GwtSecurityTokenServiceAsync gwtXSRFService = (GwtSecurityTokenServiceAsync)GWT.create(GwtSecurityTokenService.class);
    private final GwtPackageServiceAsync gwtPackageService = (GwtPackageServiceAsync)GWT.create(GwtPackageService.class);
    private static final String SERVLET_URL = "/" + GWT.getModuleName() + "/file/deploy";
    private static final Messages MSGS = (Messages)GWT.create(Messages.class);
    private static final ValidationMessages VMSGS = (ValidationMessages)GWT.create(ValidationMessages.class);
    private boolean isRefreshPending;
    private EntryClassUi entryClassUi;
    private final ListDataProvider<GwtDeploymentPackage> packagesDataProvider = new ListDataProvider();
    private final SingleSelectionModel<GwtDeploymentPackage> selectionModel = new SingleSelectionModel();
    private GwtSession gwtSession;
    private GwtDeploymentPackage selected;
    @UiField
    Modal uploadModal;
    @UiField
    FormPanel packagesFormFile;
    @UiField
    FormPanel packagesFormUrl;
    @UiField
    Button fileCancel;
    @UiField
    Button fileSubmit;
    @UiField
    Button urlCancel;
    @UiField
    Button urlSubmit;
    @UiField
    Button packagesRefresh;
    @UiField
    Button packagesInstall;
    @UiField
    Button packagesUninstall;
    @UiField
    TabListItem fileLabel;
    @UiField
    Alert notification;
    @UiField
    Modal uploadErrorModal;
    @UiField
    Text uploadErrorText;
    @UiField
    CellTable<GwtDeploymentPackage> packagesGrid = new CellTable(10);
    @UiField
    FileUpload filePath;
    @UiField
    TextBox formUrl;
    @UiField
    Hidden xsrfTokenFieldFile;
    @UiField
    Hidden xsrfTokenFieldUrl;
    @UiField
    Well marketplaceInstallWell;
    @UiField
    Modal versionCheckModal;
    @UiField
    Paragraph versionMismatchErrorText;
    @UiField
    Paragraph maxKuraVersionLabel;
    @UiField
    Paragraph minKuraVersionLabel;
    @UiField
    Paragraph currentKuraVersionLabel;
    @UiField
    Button btnCancelMarketplaceInstall;
    @UiField
    Button btnConfirmMarketplaceInstall;
    @UiField
    HTMLPanel packagesIntro;
    @UiField
    Panel packagesDropzone;
    @UiField
    AlertDialog confirmDialog;
    private GwtMarketplacePackageDescriptor marketplaceDescriptor;

    public PackagesPanelUi() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        Paragraph description = new Paragraph();
        description.setText(MSGS.packagesIntro());
        this.packagesIntro.add((Widget)description);
        this.packagesGrid.setSelectionModel(this.selectionModel);
        this.initTable();
        this.initTabButtons();
        this.initModalHandlers();
        this.initUploadErrorModal();
        this.initMarketplaceVersionCheckModal();
        this.initDragDrop();
        EventService.Handler onPackagesUpdatedHandler = eventInfo -> {
            if (!this.isVisible() || !this.isAttached()) {
                return;
            }
            if (eventInfo.get("exception") != null) {
                this.uploadErrorText.setText("Failed to " + (eventInfo.getTopic().indexOf("UNINSTALL") != -1 ? "uninstall" : "install") + " deployment package");
                this.uploadModal.hide();
                this.uploadErrorModal.show();
                return;
            }
            this.refresh();
        };
        EventService.subscribe(ForwardedEventTopic.DEPLOYMENT_PACKAGE_INSTALLED, onPackagesUpdatedHandler);
        EventService.subscribe(ForwardedEventTopic.DEPLOYMENT_PACKAGE_UNINSTALLED, onPackagesUpdatedHandler);
    }

    public void setSession(GwtSession currentSession) {
        this.gwtSession = currentSession;
    }

    public void setMainUi(EntryClassUi entryClassUi) {
        this.entryClassUi = entryClassUi;
    }

    public void refresh() {
        this.refresh(100);
    }

    private void initTabButtons() {
        this.packagesRefresh.setText(MSGS.refreshButton());
        this.packagesRefresh.addClickHandler(event -> this.refresh());
        this.packagesInstall.setText(MSGS.packageAddButton());
        this.packagesInstall.addClickHandler(event -> this.upload());
        this.packagesUninstall.setText(MSGS.packageDeleteButton());
        this.packagesUninstall.addClickHandler(event -> {
            this.selected = (GwtDeploymentPackage)this.selectionModel.getSelectedObject();
            if (this.selected != null && this.selected.getVersion() != null) {
                Modal modal = new Modal();
                ModalBody modalBody = new ModalBody();
                ModalFooter modalFooter = new ModalFooter();
                modal.setClosable(true);
                modal.setTitle(MSGS.confirm());
                modalBody.add((Widget)new Span(MSGS.deviceUninstallPackage(this.selected.getName())));
                modalFooter.add((Widget)new Button("No", event11 -> modal.hide()));
                modalFooter.add((Widget)new Button("Yes", event12 -> {
                    modal.hide();
                    this.uninstall(this.selected);
                }));
                modal.add((Widget)modalBody);
                modal.add((Widget)modalFooter);
                modal.show();
            }
        });
    }

    private void initModalHandlers() {
        this.fileSubmit.addClickHandler(event -> this.gwtXSRFService.generateSecurityToken(new AsyncCallback<GwtXSRFToken>(){

            public void onFailure(Throwable ex) {
                FailureHandler.handle(ex);
            }

            public void onSuccess(GwtXSRFToken token) {
                PackagesPanelUi.this.xsrfTokenFieldFile.setValue(token.getToken());
                if (!"".equals(PackagesPanelUi.this.filePath.getFilename())) {
                    PackagesPanelUi.this.packagesFormFile.submit();
                } else {
                    PackagesPanelUi.this.uploadModal.hide();
                    PackagesPanelUi.this.uploadErrorModal.show();
                }
            }
        }));
        this.fileCancel.addClickHandler(event -> this.uploadModal.hide());
        this.urlSubmit.addClickHandler(event -> this.gwtXSRFService.generateSecurityToken(new AsyncCallback<GwtXSRFToken>(){

            public void onFailure(Throwable ex) {
                FailureHandler.handle(ex);
            }

            public void onSuccess(GwtXSRFToken token) {
                if (!"".equals(PackagesPanelUi.this.formUrl.getValue())) {
                    PackagesPanelUi.this.xsrfTokenFieldUrl.setValue(token.getToken());
                    PackagesPanelUi.this.packagesFormUrl.submit();
                } else {
                    PackagesPanelUi.this.uploadModal.hide();
                    PackagesPanelUi.this.uploadErrorModal.show();
                }
            }
        }));
        this.urlCancel.addClickHandler(event -> this.uploadModal.hide());
        this.btnConfirmMarketplaceInstall.addClickHandler(event -> {
            if (this.marketplaceDescriptor != null) {
                this.installMarketplaceDp(this.marketplaceDescriptor);
                this.marketplaceDescriptor = null;
            }
        });
    }

    private void refresh(int delay) {
        Timer timer = new Timer(){

            public void run() {
                PackagesPanelUi.this.loadPackagesData();
            }
        };
        timer.schedule(delay);
    }

    private void upload() {
        this.uploadModal.show();
        this.fileLabel.setText(MSGS.fileLabel());
        this.filePath.setName("uploadedFile");
        this.xsrfTokenFieldFile.setID(XSRF_TOKEN);
        this.xsrfTokenFieldFile.setName(XSRF_TOKEN);
        this.xsrfTokenFieldFile.setValue("");
        this.packagesFormFile.setAction(String.valueOf(SERVLET_URL) + "/upload");
        this.packagesFormFile.setEncoding("multipart/form-data");
        this.packagesFormFile.setMethod("post");
        this.packagesFormFile.addSubmitCompleteHandler(event -> {
            String result = event.getResults();
            if (result == null || result.isEmpty()) {
                this.uploadModal.hide();
            } else {
                logger.log(Level.SEVERE, "Error uploading package!");
            }
        });
        this.formUrl.setName("packageUrl");
        this.xsrfTokenFieldUrl.setID(XSRF_TOKEN);
        this.xsrfTokenFieldUrl.setName(XSRF_TOKEN);
        this.xsrfTokenFieldUrl.setValue("");
        this.packagesFormUrl.setAction(String.valueOf(SERVLET_URL) + "/url");
        this.packagesFormUrl.setMethod("post");
        this.packagesFormUrl.addSubmitCompleteHandler(event -> {
            String result = event.getResults();
            if (result == null || result.isEmpty()) {
                this.uploadModal.hide();
            } else {
                String errMsg = result;
                int startIdx = result.indexOf("<pre>");
                int endIndex = result.indexOf("</pre>");
                if (startIdx != -1 && endIndex != -1) {
                    errMsg = result.substring(startIdx + 5, endIndex);
                }
                logger.log(Level.SEVERE, String.valueOf(MSGS.error()) + ": " + MSGS.fileDownloadFailure() + ": " + errMsg);
            }
        });
    }

    private void uninstall(final GwtDeploymentPackage selected) {
        EntryClassUi.showWaitModal();
        this.gwtXSRFService.generateSecurityToken(new AsyncCallback<GwtXSRFToken>(){

            public void onFailure(Throwable ex) {
                EntryClassUi.hideWaitModal();
                FailureHandler.handle(ex);
            }

            public void onSuccess(GwtXSRFToken token) {
                PackagesPanelUi.this.gwtPackageService.uninstallDeploymentPackage(token, selected.getName(), new AsyncCallback<Void>(){

                    public void onFailure(Throwable caught) {
                        EntryClassUi.hideWaitModal();
                        FailureHandler.handle(caught);
                    }

                    public void onSuccess(Void result) {
                        EntryClassUi.hideWaitModal();
                    }
                });
            }
        });
    }

    private void initTable() {
        TextColumn<GwtDeploymentPackage> col1 = new TextColumn<GwtDeploymentPackage>(){

            public String getValue(GwtDeploymentPackage object) {
                return object.getName();
            }
        };
        col1.setCellStyleNames("status-table-row");
        this.packagesGrid.addColumn((Column)col1, "Name");
        TextColumn<GwtDeploymentPackage> col2 = new TextColumn<GwtDeploymentPackage>(){

            public String getValue(GwtDeploymentPackage object) {
                return object.getVersion();
            }
        };
        col2.setCellStyleNames("status-table-row");
        this.packagesGrid.addColumn((Column)col2, "Version");
        this.packagesDataProvider.addDataDisplay(this.packagesGrid);
    }

    private void loadPackagesData() {
        if (this.isRefreshPending) {
            return;
        }
        this.isRefreshPending = true;
        EntryClassUi.showWaitModal();
        this.packagesDataProvider.getList().clear();
        this.gwtXSRFService.generateSecurityToken(new AsyncCallback<GwtXSRFToken>(){

            public void onFailure(Throwable ex) {
                PackagesPanelUi.this.isRefreshPending = false;
                EntryClassUi.hideWaitModal();
                FailureHandler.handle(ex);
            }

            public void onSuccess(GwtXSRFToken token) {
                PackagesPanelUi.this.gwtPackageService.findDeviceDeploymentPackages(token, new AsyncCallback<List<GwtDeploymentPackage>>(){

                    public void onFailure(Throwable caught) {
                        PackagesPanelUi.this.isRefreshPending = false;
                        EntryClassUi.hideWaitModal();
                        GwtDeploymentPackage pkg = new GwtDeploymentPackage();
                        pkg.setName("Unavailable! Please click refresh");
                        pkg.setVersion(caught.getLocalizedMessage());
                        PackagesPanelUi.this.packagesDataProvider.getList().add(pkg);
                    }

                    public void onSuccess(List<GwtDeploymentPackage> result) {
                        PackagesPanelUi.this.isRefreshPending = false;
                        EntryClassUi.hideWaitModal();
                        for (GwtDeploymentPackage pair : result) {
                            PackagesPanelUi.this.packagesDataProvider.getList().add(pair);
                        }
                        int size = PackagesPanelUi.this.packagesDataProvider.getList().size();
                        (this).PackagesPanelUi.this.packagesGrid.setVisibleRange(0, size);
                        PackagesPanelUi.this.packagesDataProvider.flush();
                        if (PackagesPanelUi.this.packagesDataProvider.getList().isEmpty()) {
                            (this).PackagesPanelUi.this.packagesGrid.setVisible(false);
                            (this).PackagesPanelUi.this.notification.setVisible(true);
                            (this).PackagesPanelUi.this.notification.setText(MSGS.devicePackagesNone());
                        } else {
                            (this).PackagesPanelUi.this.packagesGrid.setVisible(true);
                            (this).PackagesPanelUi.this.notification.setVisible(false);
                        }
                        if (PackagesPanelUi.this.entryClassUi != null) {
                            PackagesPanelUi.this.entryClassUi.fetchAvailableServices(null);
                        }
                    }
                });
            }
        });
    }

    private void initUploadErrorModal() {
        this.uploadErrorModal.setTitle(MSGS.warning());
        this.uploadErrorText.setText(MSGS.missingFileUpload());
    }

    private void initMarketplaceVersionCheckModal() {
        this.versionCheckModal.setTitle(VMSGS.marketplaceInstallDpVersionMismatch());
        this.versionMismatchErrorText.setText(VMSGS.marketplaceInstallDpVersionDoesNotMatch());
        this.currentKuraVersionLabel.setText(VMSGS.marketplaceInstallCurrentKuraVersion());
        this.minKuraVersionLabel.setText(VMSGS.marketplaceInstallMinKuraVersion());
        this.maxKuraVersionLabel.setText(VMSGS.marketplaceInstallMaxKuraVersion());
        this.btnCancelMarketplaceInstall.setText(VMSGS.marketplaceInstallDpVersionMismatchCancel());
        this.btnConfirmMarketplaceInstall.setText(VMSGS.marketplaceInstallDpVersionMismatchInstall());
    }

    private void eclipseMarketplaceInstall(String url) {
        final String nodeId = url.split("=")[1];
        EntryClassUi.showWaitModal();
        this.gwtXSRFService.generateSecurityToken(new AsyncCallback<GwtXSRFToken>(){

            public void onFailure(Throwable ex) {
                EntryClassUi.hideWaitModal();
                FailureHandler.handle(ex, EntryClassUi.class.getName());
            }

            public void onSuccess(GwtXSRFToken token) {
                PackagesPanelUi.this.gwtPackageService.getMarketplacePackageDescriptor(token, nodeId, new AsyncCallback<GwtMarketplacePackageDescriptor>(){

                    public void onFailure(Throwable ex) {
                        EntryClassUi.hideWaitModal();
                        logger.log(Level.SEVERE, ex.getMessage(), ex);
                        FailureHandler.handle(ex, EntryClassUi.class.getName());
                    }

                    public void onSuccess(GwtMarketplacePackageDescriptor descriptor) {
                        if (!descriptor.isCompatible()) {
                            EntryClassUi.hideWaitModal();
                            PackagesPanelUi.this.showVersionMismatchDialog(descriptor);
                        } else {
                            PackagesPanelUi.this.installMarketplaceDp(descriptor);
                        }
                    }
                });
            }
        });
    }

    private void installMarketplaceDp(final GwtMarketplacePackageDescriptor descriptor) {
        this.gwtXSRFService.generateSecurityToken(new AsyncCallback<GwtXSRFToken>(){

            public void onFailure(Throwable ex) {
                EntryClassUi.hideWaitModal();
                FailureHandler.handle(ex, EntryClassUi.class.getName());
            }

            public void onSuccess(GwtXSRFToken token) {
                PackagesPanelUi.this.gwtPackageService.installPackageFromMarketplace(token, descriptor, new AsyncCallback<Void>(){

                    public void onSuccess(Void result) {
                        EntryClassUi.hideWaitModal();
                    }

                    public void onFailure(Throwable ex) {
                        EntryClassUi.hideWaitModal();
                        FailureHandler.handle(ex, EntryClassUi.class.getName());
                    }
                });
            }
        });
    }

    private boolean isEclipseMarketplaceUrl(String url) {
        return url != null && !url.isEmpty() && marketplaceUrlRegexp.test(url);
    }

    private void initDragDrop() {
        DropSupport drop = DropSupport.addIfSupported((Widget)this);
        if (drop != null) {
            drop.setListener(new DropSupport.Listener(){

                @Override
                public boolean onDrop(DropSupport.DropEvent event) {
                    String url = event.getAsText();
                    PackagesPanelUi.this.packagesDropzone.removeStyleName(PackagesPanelUi.DROPZONE_ACTIVE_STYLE_NAME);
                    if (PackagesPanelUi.this.isEclipseMarketplaceUrl(url)) {
                        PackagesPanelUi.this.confirmDialog.show(MSGS.packagesMarketplaceInstallConfirmMessage(), () -> PackagesPanelUi.this.eclipseMarketplaceInstall(url));
                    }
                    return true;
                }

                @Override
                public boolean onDragOver(DropSupport.DropEvent event) {
                    PackagesPanelUi.this.packagesDropzone.addStyleName(PackagesPanelUi.DROPZONE_ACTIVE_STYLE_NAME);
                    return true;
                }

                @Override
                public void onDragExit(DropSupport.DropEvent event) {
                    PackagesPanelUi.this.packagesDropzone.removeStyleName(PackagesPanelUi.DROPZONE_ACTIVE_STYLE_NAME);
                }
            });
        } else {
            this.marketplaceInstallWell.setVisible(false);
        }
    }

    private void showVersionMismatchDialog(GwtMarketplacePackageDescriptor descriptor) {
        this.marketplaceDescriptor = descriptor;
        String minKuraVersion = descriptor.getMinKuraVersion();
        String maxKuraVersion = descriptor.getMaxKuraVersion();
        if (minKuraVersion == null || minKuraVersion.isEmpty()) {
            minKuraVersion = "unspecified";
        }
        if (maxKuraVersion == null || maxKuraVersion.isEmpty()) {
            maxKuraVersion = "unspecified";
        }
        this.currentKuraVersionLabel.setText(String.valueOf(VMSGS.marketplaceInstallCurrentKuraVersion()) + " " + descriptor.getCurrentKuraVersion());
        this.minKuraVersionLabel.setText(String.valueOf(VMSGS.marketplaceInstallMinKuraVersion()) + " " + minKuraVersion);
        this.maxKuraVersionLabel.setText(String.valueOf(VMSGS.marketplaceInstallMaxKuraVersion()) + " " + maxKuraVersion);
        this.versionCheckModal.show();
    }

    static interface PackagesPanelUiUiBinder
    extends UiBinder<Widget, PackagesPanelUi> {
    }
}

