/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.deployment.download;

import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.KuraInvalidMessageException;
import org.eclipse.kura.core.deployment.hook.DeploymentHookManager;
import org.eclipse.kura.core.deployment.install.DeploymentPackageInstallOptions;
import org.eclipse.kura.message.KuraPayload;

public class DeploymentPackageDownloadOptions
extends DeploymentPackageInstallOptions {
    public static final String METRIC_DP_DOWNLOAD_URI = "dp.uri";
    public static final String METRIC_DP_DOWNLOAD_PROTOCOL = "dp.download.protocol";
    public static final String METRIC_DP_DOWNLOAD_BLOCK_SIZE = "dp.download.block.size";
    public static final String METRIC_DP_DOWNLOAD_BLOCK_DELAY = "dp.download.block.delay";
    public static final String METRIC_DP_DOWNLOAD_TIMEOUT = "dp.download.timeout";
    public static final String METRIC_DP_DOWNLOAD_RESUME = "dp.download.resume";
    public static final String METRIC_DP_DOWNLOAD_USER = "dp.download.username";
    public static final String METRIC_DP_DOWNLOAD_PASSWORD = "dp.download.password";
    public static final String METRIC_DP_DOWNLOAD_NOTIFY_BLOCK_SIZE = "dp.download.notify.block.size";
    public static final String METRIC_DP_DOWNLOAD_FORCE_DOWNLOAD = "dp.download.force";
    public static final String METRIC_DP_DOWNLOAD_HASH = "dp.download.hash";
    public static final String METRIC_DP_INSTALL = "dp.install";
    private String deployUri;
    private String downloadProtocol;
    private int blockSize;
    private int notifyBlockSize;
    private int blockDelay = 0;
    private int timeout = 4000;
    private String username = null;
    private String password = null;
    private boolean forceDownload = false;
    private String hash;

    public DeploymentPackageDownloadOptions(String deployUri, String dpName, String dpVersion) {
        super(dpName, dpVersion);
        this.setDeployUri(deployUri);
    }

    public DeploymentPackageDownloadOptions(KuraPayload request, DeploymentHookManager hookManager, String downloadDirectory) throws KuraException {
        super(null, null);
        this.setDownloadDirectory(downloadDirectory);
        this.setDeployUri((String)request.getMetric(METRIC_DP_DOWNLOAD_URI));
        if (this.getDeployUri() == null) {
            throw new KuraInvalidMessageException((Object)"Missing deployment package URL!");
        }
        super.setDpName((String)request.getMetric("dp.name"));
        if (super.getDpName() == null) {
            throw new KuraInvalidMessageException((Object)"Missing deployment package name!");
        }
        super.setDpVersion((String)request.getMetric("dp.version"));
        if (super.getDpVersion() == null) {
            throw new KuraInvalidMessageException((Object)"Missing deployment package version!");
        }
        this.setDownloadProtocol((String)request.getMetric(METRIC_DP_DOWNLOAD_PROTOCOL));
        if (this.getDownloadProtocol() == null) {
            throw new KuraInvalidMessageException((Object)"Missing download protocol!");
        }
        Long jobId = (Long)request.getMetric("job.id");
        if (jobId != null) {
            super.setJobId(jobId);
        }
        if (super.getJobId() == null) {
            throw new KuraInvalidMessageException((Object)"Missing jobId!");
        }
        super.setSystemUpdate((Boolean)request.getMetric("dp.install.system.update"));
        if (super.getSystemUpdate() == null) {
            throw new KuraInvalidMessageException((Object)"Missing SystemUpdate!");
        }
        try {
            Object metric = request.getMetric(METRIC_DP_DOWNLOAD_BLOCK_SIZE);
            if (metric != null) {
                this.blockSize = (Integer)metric;
            }
            if ((metric = request.getMetric(METRIC_DP_DOWNLOAD_BLOCK_DELAY)) != null) {
                this.blockDelay = (Integer)metric;
            }
            if ((metric = request.getMetric(METRIC_DP_DOWNLOAD_TIMEOUT)) != null) {
                this.timeout = (Integer)metric;
            }
            if ((metric = request.getMetric(METRIC_DP_DOWNLOAD_RESUME)) != null) {
                super.setResume((Boolean)metric);
            }
            if ((metric = request.getMetric(METRIC_DP_DOWNLOAD_USER)) != null) {
                this.username = (String)metric;
            }
            if ((metric = request.getMetric(METRIC_DP_DOWNLOAD_PASSWORD)) != null) {
                this.password = (String)metric;
            }
            if ((metric = request.getMetric(METRIC_DP_DOWNLOAD_HASH)) != null) {
                this.hash = (String)metric;
            }
            if ((metric = request.getMetric(METRIC_DP_INSTALL)) != null) {
                super.setInstall((Boolean)metric);
            }
            if ((metric = request.getMetric("dp.reboot")) != null) {
                super.setReboot((Boolean)metric);
            }
            if ((metric = request.getMetric("dp.reboot.delay")) != null) {
                super.setRebootDelay((Integer)metric);
            }
            if ((metric = request.getMetric(METRIC_DP_DOWNLOAD_FORCE_DOWNLOAD)) != null) {
                this.forceDownload = (Boolean)metric;
            }
            if ((metric = request.getMetric(METRIC_DP_DOWNLOAD_NOTIFY_BLOCK_SIZE)) != null) {
                this.notifyBlockSize = (Integer)metric;
            }
            if ((metric = request.getMetric("requester.client.id")) != null) {
                super.setRequestClientId((String)metric);
            }
            if ((metric = request.getMetric("dp.install.verifier.uri")) != null) {
                super.setVerifierURI((String)metric);
            }
            this.parseHookRelatedOptions(request, hookManager);
        }
        catch (Exception ex) {
            throw new KuraException(KuraErrorCode.INTERNAL_ERROR, (Throwable)ex, new Object[0]);
        }
    }

    public int getNotifyBlockSize() {
        return this.notifyBlockSize;
    }

    public void setNotifyBlockSize(int notifyBlockSize) {
        this.notifyBlockSize = notifyBlockSize;
    }

    public String getDeployUri() {
        return this.deployUri;
    }

    public void setDeployUri(String deployUri) {
        this.deployUri = deployUri;
    }

    public String getDownloadProtocol() {
        return this.downloadProtocol;
    }

    public void setDownloadProtocol(String downloadProtocol) {
        this.downloadProtocol = downloadProtocol;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(int blockSize) {
        this.blockSize = blockSize;
    }

    public int getBlockDelay() {
        return this.blockDelay;
    }

    public void setBlockDelay(int blockDelay) {
        this.blockDelay = blockDelay;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean isDownloadForced() {
        return this.forceDownload;
    }

    public void setDownloadForced(boolean forceDownload) {
        this.forceDownload = forceDownload;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }
}

