/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.emf;

import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.hawk.core.model.IHawkDataType;
import org.eclipse.hawk.emf.EMFModelElement;
import org.eclipse.hawk.emf.EMFWrapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EMFDataType
extends EMFModelElement
implements IHawkDataType {
    private static final Logger LOGGER = LoggerFactory.getLogger(EMFDataType.class);
    private EDataType eDataType;

    public EMFDataType(EDataType eDataType, EMFWrapperFactory wf) {
        super((EModelElement)eDataType, wf);
        this.eDataType = eDataType;
    }

    public EDataType getEObject() {
        return this.eDataType;
    }

    public String getName() {
        return this.eDataType.getName();
    }

    public String getInstanceType() {
        String it = this.eDataType.getInstanceClassName();
        switch (it = it == null ? "NULL_INSTANCE_TYPE" : it) {
            case "long": {
                return Long.class.getName();
            }
            case "int": {
                return Integer.class.getName();
            }
            case "float": {
                return Float.class.getName();
            }
            case "double": {
                return Double.class.getName();
            }
            case "boolean": {
                return Boolean.class.getName();
            }
        }
        return it;
    }

    public String getPackageNSURI() {
        EPackage ePackage = this.eDataType.getEPackage();
        if (ePackage == null) {
            LOGGER.warn("Data type {} is not associated with an EPackage: returning null", (Object)this.eDataType);
            return null;
        }
        return ePackage.getNsURI();
    }

    @Override
    public int hashCode() {
        return this.eDataType.hashCode();
    }
}

