/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.service.server.cli;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.NoSuchElementException;
import org.eclipse.hawk.core.IModelIndexer;
import org.eclipse.hawk.osgiserver.HManager;
import org.eclipse.hawk.osgiserver.HModel;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;

public class ServerCommandProvider
implements CommandProvider {
    public static final String HSERVER_HELP_CMD = "hserverHelp";
    private HManager hawkManager;

    public Object _hserverHelp(CommandInterpreter intp) throws Exception {
        return this.getHelp();
    }

    public Object _hawkListInstances(CommandInterpreter intp) throws Exception {
        this.checkConnected();
        ArrayList instances = new ArrayList(this.hawkManager.getHawks());
        Collections.sort(instances, new Comparator<HModel>(){

            @Override
            public int compare(HModel o1, HModel o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        if (instances.isEmpty()) {
            return "No instances exist";
        }
        StringBuffer sbuf = new StringBuffer();
        for (HModel i : instances) {
            sbuf.append(String.format("%s (%s)\n", i.getName(), i.getStatus().toString()));
        }
        return sbuf.toString();
    }

    private void checkConnected() {
        if (this.hawkManager == null) {
            this.hawkManager = HManager.getInstance();
        }
    }

    public Object _hawkRemoveInstance(CommandInterpreter intp) throws Exception {
        this.checkConnected();
        boolean hardDeletion = this.requiredArgument(intp, "mode").toLowerCase().equals("hard");
        String name = this.requiredArgument(intp, "name");
        HModel hmodel = this.hawkManager.getHawkByName(name);
        if (hmodel == null) {
            throw new NoSuchElementException("No Hawk instance exists with name '" + name + "'");
        }
        this.hawkManager.delete(hmodel, hmodel.exists());
        if (hardDeletion) {
            ServerCommandProvider.removeRecursive(Paths.get(hmodel.getFolder(), new String[0]));
        }
        return String.format("Removed instance %s (%s)", name, hardDeletion ? "hard deletion" : "soft deletion");
    }

    public Object _hawkStartInstance(CommandInterpreter intp) throws Exception {
        this.checkConnected();
        String name = this.requiredArgument(intp, "name");
        HModel hi = this.hawkManager.getHawkByName(name);
        if (hi.isRunning()) {
            return String.format("Instance %s was already running", name);
        }
        hi.start(this.hawkManager);
        return String.format("Started instance %s", name);
    }

    public Object _hawkStopInstance(CommandInterpreter intp) throws Exception {
        this.checkConnected();
        String name = this.requiredArgument(intp, "name");
        HModel hi = this.hawkManager.getHawkByName(name);
        if (hi.isRunning()) {
            hi.stop(IModelIndexer.ShutdownRequestType.ALWAYS);
            return String.format("Stopped instance %s", name);
        }
        return String.format("Instance %s was already stopped", name);
    }

    public Object _hawkSyncInstance(CommandInterpreter intp) throws Exception {
        this.checkConnected();
        String name = this.requiredArgument(intp, "name");
        HModel hi = this.hawkManager.getHawkByName(name);
        if (hi.isRunning()) {
            hi.sync();
            return String.format("Requested immediate sync on instance %s", name);
        }
        return String.format("Instance %s is not running", name);
    }

    public String getHelp() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("---HAWK SERVER (commands are case insensitive, <> means required, [] means optional)---\n\t");
        sbuf.append("hserverHelp - lists all the available commands for the server\n");
        sbuf.append("--Instances--\n\t");
        sbuf.append("hawkListInstances - lists the available Hawk instances\n\t");
        sbuf.append("hawkRemoveInstance soft|hard <name> - removes an instance with the provided name, if it exists (soft deletion deregisters, hard deletion also removes storage folder)\n\t");
        sbuf.append("hawkStartInstance <name> - starts the instance with the provided name\n\t");
        sbuf.append("hawkStopInstance <name> - stops the instance with the provided name\n\t");
        sbuf.append("hawkSyncInstance <name> - forces an immediate sync on the instance with the provided name\n");
        return sbuf.toString();
    }

    private String requiredArgument(CommandInterpreter intp, String argumentName) {
        String value = intp.nextArgument();
        if (value == null) {
            throw new IllegalArgumentException(String.format("Required argument '%s' has not been provided", argumentName));
        }
        return value;
    }

    private static void removeRecursive(Path path) throws IOException {
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                if (exc == null) {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
                throw exc;
            }
        });
    }
}

