/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.runtime.ode;

import java.util.Collections;
import java.util.List;
import org.eclipse.escet.cif.simulator.runtime.CifSimulatorException;
import org.eclipse.escet.cif.simulator.runtime.CifSimulatorMath;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Pair;
import org.eclipse.escet.common.java.Strings;

public class Trajectories {
    private final List<Double> times = Lists.list();
    private final List<double[]> values = Lists.list();

    public List<Double> getTimes() {
        return this.times;
    }

    public void add(double time, double[] y) {
        Assert.check((time >= 0.0 ? 1 : 0) != 0);
        if (this.getCount() > 0) {
            double tLast = (Double)Lists.last(this.times);
            Assert.check((time > tLast ? 1 : 0) != 0);
        }
        double[] y2 = new double[y.length];
        System.arraycopy(y, 0, y2, 0, y.length);
        this.times.add(time);
        this.values.add(y2);
    }

    public int getCount() {
        return this.times.size();
    }

    public double getLastTime() {
        if (this.times.isEmpty()) {
            return -1.0;
        }
        return (Double)Lists.last(this.times);
    }

    public double getMaxDelay() {
        Assert.check((this.getCount() >= 2 ? 1 : 0) != 0);
        double t0 = (Double)Lists.first(this.times);
        double tLast = (Double)Lists.last(this.times);
        return tLast - t0;
    }

    public double[] getValuesForIndex(int idx) {
        return this.values.get(idx);
    }

    public Pair<Double, double[]> getValuesForTime(double reqTime, boolean strict, int tolerance) {
        int closestIdx;
        double closestDelta;
        double closestTime;
        Double afterDelta;
        Assert.check((this.getCount() >= 2 ? 1 : 0) != 0);
        double firstTime = (Double)Lists.first(this.times);
        double lastTime = (Double)Lists.last(this.times);
        if (reqTime == lastTime) {
            return Pair.pair((Object)reqTime, (Object)((double[])Lists.last(this.values)));
        }
        Assert.check((firstTime <= reqTime ? 1 : 0) != 0);
        int idx = Collections.binarySearch(this.times, reqTime);
        if (idx < 0) {
            idx = -(idx + 1);
        }
        if (idx < this.times.size() && this.times.get(idx) == reqTime) {
            return Pair.pair((Object)reqTime, (Object)this.values.get(idx));
        }
        double beforeTime = this.times.get(idx - 1);
        Double afterTime = idx == this.times.size() ? null : this.times.get(idx);
        double beforeDelta = reqTime - beforeTime;
        Double d = afterDelta = afterTime == null ? null : Double.valueOf(afterTime - reqTime);
        if (afterDelta == null) {
            closestTime = beforeTime;
            closestDelta = beforeDelta;
            closestIdx = idx - 1;
        } else if (beforeDelta < afterDelta) {
            closestTime = beforeTime;
            closestDelta = beforeDelta;
            closestIdx = idx - 1;
        } else {
            closestTime = afterTime;
            closestDelta = afterDelta;
            closestIdx = idx;
        }
        double reqTimeUlp = Math.ulp(reqTime);
        double deltaUlps = closestDelta / reqTimeUlp;
        if (deltaUlps > (double)tolerance) {
            if (!strict) {
                return null;
            }
            String msg = Strings.fmt((String)"Requested time point \"%s\" is \"%s\" ulps (1 ulp = %s) away from the closest time point in the trajectories \"%s\", which is farther away than the maximum tolerance of \"%d\" ulps. You can try increasing the value of the maximum time point tolerance option. Please also contact the development team.", (Object[])new Object[]{CifSimulatorMath.realToStr(reqTime), CifSimulatorMath.realToStr(deltaUlps), CifSimulatorMath.realToStr(reqTimeUlp), CifSimulatorMath.realToStr(closestTime), tolerance});
            throw new CifSimulatorException(msg);
        }
        return Pair.pair((Object)closestTime, (Object)this.values.get(closestIdx));
    }
}

