/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.setext.runtime.exceptions;

import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.TextPosition;
import org.eclipse.escet.setext.runtime.exceptions.SyntaxException;

public class ParseException
extends SyntaxException {
    private final String tokenText;
    private final String foundTermText;
    private final String expectedTermsText;

    public ParseException(String tokenText, TextPosition position) {
        this(tokenText, position, null, null);
    }

    public ParseException(String tokenText, TextPosition position, String foundTermText, String expectedTermsText) {
        super(position);
        this.tokenText = tokenText;
        this.foundTermText = foundTermText;
        this.expectedTermsText = expectedTermsText;
        Assert.check((foundTermText == null == (expectedTermsText == null) ? 1 : 0) != 0);
    }

    public String getTokenText() {
        return this.tokenText;
    }

    @Override
    public String getMessage() {
        String src = this.getPosition().source;
        if (src == null) {
            src = "";
        }
        String postToken = this.tokenText == null ? ", most likely due to premature end of input" : Strings.fmt((String)", at or near \"%s\"", (Object[])new Object[]{this.tokenText});
        String postTerms = this.foundTermText == null ? "" : Strings.fmt((String)" (found %s, expected %s)", (Object[])new Object[]{this.foundTermText, this.expectedTermsText});
        return Strings.fmt((String)"%sParsing failed at line %d, column %d%s%s.", (Object[])new Object[]{src, this.getPosition().startLine, this.getPosition().startColumn, postToken, postTerms});
    }
}

