/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.output.plotviz;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.escet.cif.simulator.output.plotviz.PlotVisualizerCanvas;
import org.eclipse.escet.cif.simulator.output.plotviz.PlotVisualizerRange;
import org.eclipse.escet.cif.simulator.output.plotviz.PlotVisualizerUpdateData;
import org.eclipse.escet.cif.simulator.output.plotviz.PlotVisualizerUpdateDataEntry;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.swt.widgets.Display;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.style.XYStyler;

public class PlotVisualizerUpdateThread
extends Thread {
    private final XYChart chart;
    private final PlotVisualizerCanvas canvas;
    public final AtomicReference<PlotVisualizerUpdateData> updateData = new AtomicReference();
    public final AtomicReference<PlotVisualizerRange> updateRangeX = new AtomicReference();
    public final AtomicBoolean updateRequested = new AtomicBoolean();

    public PlotVisualizerUpdateThread(XYChart chart, PlotVisualizerCanvas canvas) {
        this.chart = chart;
        this.canvas = canvas;
        this.setName(this.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            AtomicBoolean canvasDisposed = new AtomicBoolean(false);
            PlotVisualizerUpdateData data = null;
            PlotVisualizerRange rangeX = null;
            AtomicBoolean atomicBoolean = this.updateRequested;
            synchronized (atomicBoolean) {
                if (!this.updateRequested.get()) {
                    try {
                        this.updateRequested.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    Display.getDefault().syncExec(() -> canvasDisposed.set(this.canvas.isDisposed()));
                    if (canvasDisposed.get()) {
                        return;
                    }
                    continue;
                }
                data = this.updateData.get();
                rangeX = this.updateRangeX.get();
                this.updateData.set(null);
                this.updateRangeX.set(null);
                this.updateRequested.set(false);
            }
            PlotVisualizerUpdateData data2 = data;
            PlotVisualizerRange rangeX2 = rangeX;
            Assert.check((data2 != null || rangeX2 != null ? 1 : 0) != 0);
            Display.getDefault().syncExec(() -> {
                boolean disposed = this.canvas.isDisposed();
                canvasDisposed.set(disposed);
                if (disposed) {
                    return;
                }
                if (data2 != null) {
                    if (this.chart.getSeriesMap().isEmpty()) {
                        for (PlotVisualizerUpdateDataEntry entry : plotVisualizerUpdateData.entries) {
                            this.chart.addSeries(entry.name, entry.xValues, entry.yValues);
                        }
                    } else {
                        for (PlotVisualizerUpdateDataEntry entry : plotVisualizerUpdateData.entries) {
                            this.chart.updateXYSeries(entry.name, entry.xValues, entry.yValues, null);
                        }
                    }
                }
                if (rangeX2 != null) {
                    ((XYStyler)this.chart.getStyler()).setXAxisMin(Double.valueOf(plotVisualizerRange.lower));
                    ((XYStyler)this.chart.getStyler()).setXAxisMax(Double.valueOf(plotVisualizerRange.upper));
                }
                if (data2 != null && !Double.isInfinite(plotVisualizerUpdateData.minY) && !Double.isInfinite(plotVisualizerUpdateData.maxY)) {
                    double yRange = Math.abs(plotVisualizerUpdateData.maxY - plotVisualizerUpdateData.minY);
                    double yOffset = yRange * 0.05;
                    ((XYStyler)this.chart.getStyler()).setYAxisMin(Double.valueOf(plotVisualizerUpdateData.minY - yOffset));
                    ((XYStyler)this.chart.getStyler()).setYAxisMax(Double.valueOf(plotVisualizerUpdateData.maxY + yOffset));
                }
            });
            if (canvasDisposed.get()) {
                return;
            }
            this.canvas.updatePixels();
            Display.getDefault().syncExec(() -> {
                boolean disposed = this.canvas.isDisposed();
                canvasDisposed.set(disposed);
                if (disposed) {
                    return;
                }
                this.canvas.redraw();
            });
            if (canvasDisposed.get()) break;
        }
    }
}

