/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.device;

import org.eclipse.equinox.device.Activator;
import org.eclipse.equinox.device.DeviceMsg;
import org.eclipse.equinox.device.LogTracker;
import org.eclipse.equinox.device.Match;
import org.osgi.framework.ServiceReference;
import org.osgi.service.device.DriverSelector;
import org.osgi.util.tracker.ServiceTracker;

public class DriverSelectorTracker
extends ServiceTracker {
    protected static final String clazz = "org.osgi.service.device.DriverSelector";
    protected LogTracker log;
    protected Activator manager;

    public DriverSelectorTracker(Activator manager) {
        super(manager.context, clazz, null);
        this.manager = manager;
        this.log = manager.log;
        this.log.debug("DriverSelectorTracker constructor");
        this.open();
    }

    public ServiceReference select(ServiceReference device, Match[] matches) {
        ServiceReference selector = this.getServiceReference();
        if (selector != null) {
            int index;
            block4: {
                DriverSelector service = (DriverSelector)this.getService(selector);
                index = service.select(device, (org.osgi.service.device.Match[])matches);
                if (index != -1) break block4;
                return null;
            }
            try {
                return matches[index].getDriver();
            }
            catch (Throwable t) {
                this.log.error(selector, DeviceMsg.DriverSelector_error_during_match, t);
            }
        }
        return this.defaultSelection(matches);
    }

    public ServiceReference defaultSelection(Match[] matches) {
        int size = matches.length;
        int max = 0;
        ServiceReference reference = null;
        int i = 0;
        while (i < size) {
            Match driver = matches[i];
            int match = driver.getMatchValue();
            if (match >= max) {
                if (match == max) {
                    reference = this.breakTie(reference, driver.getDriver());
                } else {
                    max = match;
                    reference = driver.getDriver();
                }
            }
            ++i;
        }
        return reference;
    }

    public ServiceReference breakTie(ServiceReference ref1, ServiceReference ref2) {
        long ref2ID;
        int ref2Ranking;
        int n;
        Object property = ref1.getProperty("service.ranking");
        if (property instanceof Integer) {
            Integer i = (Integer)property;
            n = i;
        } else {
            n = 0;
        }
        int ref1Ranking = n;
        property = ref2.getProperty("service.ranking");
        if (property instanceof Integer) {
            Integer i = (Integer)property;
            v1 = i;
        } else {
            v1 = ref2Ranking = 0;
        }
        if (ref1Ranking > ref2Ranking) {
            return ref1;
        }
        if (ref2Ranking > ref1Ranking) {
            return ref2;
        }
        long ref1ID = (Long)ref1.getProperty("service.id");
        if (ref1ID < (ref2ID = ((Long)ref2.getProperty("service.id")).longValue())) {
            return ref1;
        }
        return ref2;
    }
}

