/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.store;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Closeable;

class IteratorCheckNotConcurrent<T>
implements Iterator<T>,
Closeable {
    private Iterator<T> iter;
    private AtomicLong eCount;
    private boolean finished = false;
    private long startEpoch;

    IteratorCheckNotConcurrent(Iterator<T> iter, AtomicLong eCount) {
        this.iter = iter;
        this.eCount = eCount;
        this.startEpoch = eCount.get();
    }

    private void checkConcurrentModification() {
        if (this.finished) {
            return;
        }
        long now2 = this.eCount.get();
        if (now2 != this.startEpoch) {
            IteratorCheckNotConcurrent.policyError(String.format("Iterator: started at %d, now %d", this.startEpoch, now2));
        }
    }

    private static void policyError(String message) {
        throw new ConcurrentModificationException(message);
    }

    @Override
    public boolean hasNext() {
        this.checkConcurrentModification();
        boolean b = this.iter.hasNext();
        if (!b) {
            this.close();
        }
        return b;
    }

    @Override
    public T next() {
        this.checkConcurrentModification();
        try {
            return this.iter.next();
        }
        catch (NoSuchElementException ex) {
            this.close();
            throw ex;
        }
    }

    @Override
    public void forEachRemaining(Consumer<? super T> action) {
        this.iter.forEachRemaining(action);
        this.close();
        this.checkConcurrentModification();
    }

    @Override
    public void remove() {
        this.checkConcurrentModification();
        this.iter.remove();
        this.startEpoch = this.eCount.get();
    }

    @Override
    public void close() {
        this.finished = true;
        Iter.close(this.iter);
    }
}

